// Copyright 1995 Barbara Liskov


#include "parse.h"
#include "cg.h"
#include "string.h"

//	This file handles inlining of a limited number of for statements.
//	Currently these invoke the
//		the "to" iterator of "int"
//		the "elements" and "indexes" iterators of vector
//		the "indexes" iterator of "array"
//
//	It seems that "to_by" of "int" is a little tricky in terms
//		of suppressing wrap around.
//
//	It seems that "elements" of "array" is huge, in terms of code space.
//

static string int_str = NULL;
extern void handle_body(Body *body);
enum iter_type {INT_TO = 1, INT_TO_BY, ARRAY_ELTS, ARRAY_INDX,
		VECTOR_ELTS, VECTOR_INDX};
bool opt_inv(Invoc *inv, iter_type *which);
Expr *opt_inv_get_prim(Invoc *inv, Id **id);
bool opt_for(iter_type which, Id *id, Invoc *inv, Body* body);


//	Do decls for temps necessary for inlined iterators

void opt_inv_temps(Invoc *inv)
{
iter_type which;

	if (!int_str) {
		int_str = string_new("int");
		}
	bool ok = opt_inv(inv, &which);
	if (!ok) return;
	switch (which) {
		case INT_TO: {
			save_temp(int_str);
			return;
			}
		case INT_TO_BY: {
			// save_temp(int_str);
			// save_temp(int_str);
			return;
			}
		case ARRAY_ELTS: {
			// save_temp(int_str);
			// save_temp(int_str);
			return;
			}
		case ARRAY_INDX: {
			save_temp(int_str);
			return;
			}
		case VECTOR_ELTS: {
			save_temp(int_str);
			save_temp(int_str);
			return;
			}
		case VECTOR_INDX: {
			save_temp(int_str);
			return;
			}
		}
	}

// emit code for inlined iterator for declforstmt

bool opt_declforstmt(DeclForStmt *declforstmt)
{
Invoc *inv = declforstmt->get_invoc();  
iter_type which;
ParseNodeList *ids = NULL;

	// Is this an inlineable iterator?
	// (Need to decide if it's inlineable *before* any code is emitted...)

	bool ok = opt_inv(inv, &which);
	if (!ok) return FALSE;

	// fish out the decl and its id

	ParseNodeList *decls = declforstmt->get_decls();
	if (!decls || decls->length() != 1) {
			cmp_err("Inlining is incorrect.",
				inv->get_line());
			return FALSE;
			}
	Decl *d = (Decl *)(decls->front());
   	switch (d->tag()) {
       		 case Decl::ImplDeclT:
		 case Decl::VarArgsDeclT: {
       		         cmp_err("Improper decl in declforstmt.", 
       		                 declforstmt->get_line());
       		         return FALSE;
       		         }
       		 case Decl::RegDeclT: {
       		         RegDecl *rd = (RegDecl *)(d);
       		         ids = rd->get_ids();
       		         }
       		 }

	if (!ids || ids->length() != 1) {
			cmp_err("Inlining is incorrect.",
				inv->get_line());
			return FALSE;
			}
	Id *id = (Id *)(ids->front());

	Body *body = declforstmt->get_body();

	return opt_for(which, id, inv, body);
	}

bool opt_for(iter_type which, Id *id, Invoc *inv, Body* body)
{
Id *mid;
ParseNodeList *exprs;

	// do preprocessing
	ParseNode *new_pn = inv_preprocess(inv);
	if (new_pn->tag() != ParseNode::InvocT) {
			cmp_err("Inlining is incorrect.",
				inv->get_line());
			return FALSE;
			}
	Invoc *new_inv = (Invoc *)new_pn;

	// now get the primary
	Expr *prim = opt_inv_get_prim(new_inv, &mid);
	exprs = new_inv->get_exprs();


	// do the code

	string nm = id->get_id();
	switch (which) {
		case INT_TO: {
   			ind();
			string dest_str = get_next_temp();
			pstr(dest_str);
			ps(" = ");
			expr_emit((Expr *)(exprs->front()));
			ps(";\n");
   			ind();

   			ps("for (");
			pstr(nm);
			ps(" = ");
			expr_emit(prim);
			ps("; ");
			pstr(nm);
			ps(" <= ");
			pstr(dest_str);
			ps("; ");
			pstr(nm);
			ps("++)");

			ps(" {\n");
			handle_body(body);
			ind();
			ps("}\n");
			return TRUE;
			}

		case ARRAY_INDX: {
			ind();
			ps("FIX(");
			expr_emit(prim);
			ps(", array);\n");
   			ind();
			ps("FIXUPREAD(&((array_C)");
			expr_emit(prim);
			ps(")->hdr.inh);\n");
   			ind();
			string limit_str = get_next_temp();
			pstr(limit_str);
			ps(" = ((array_C)");
			expr_emit(prim);
			ps(")->user_low + ((array_C)");
			expr_emit(prim);
			ps(")->user_size - 1");
			ps(";\n");
   			ind();

   			ps("for (");
			pstr(nm);
			ps(" = ((array_C)");
			expr_emit(prim);
			ps(")->user_low; ");
			pstr(nm);
			ps(" <= ");
			pstr(limit_str);
			ps("; ");
			pstr(nm);
			ps("++)");

			ps(" {\n");
			handle_body(body);
			ind();
			ps("}\n");
			return TRUE;
			}

		case VECTOR_ELTS: {
			TypeInterface *ti = inv->get_type();
			vec v = ti->get_mult();
			if (!v || vec_length(v) != 1) {
				cmp_err("Optimization failed", inv->get_line());
				return FALSE;
				}
			type t = UNPV(type, vec_fetch(v, 0));
			string type_str = simple_type_name(type_name(t));

			ind();
			ps("FIX(");
			expr_emit(prim);
			ps(", vector);\n");
   			ind();
			ps("FIXUPREAD(&((vector_C)");
			expr_emit(prim);
			ps(")->hdr.inh);\n");
   			ind();
			string index_str = get_next_temp();
			string limit_str = get_next_temp();
			pstr(limit_str);
			ps(" = ((vector_C)");
			expr_emit(prim);
			ps(")->hdr.inh.size;\n");
   			ind();

   			ps("for (");
			pstr(index_str);
			ps(" = 0; ");
			pstr(index_str);
			ps(" < ");
			pstr(limit_str);
			ps("; ");
			pstr(index_str);
			ps("++)");


			ps(" {\n");
			ind();
			ps("DISCOVER(((vector_C)");
			expr_emit(prim);
			ps(")->items[");
			pstr(index_str);
			ps("], pval);\n");
			ind();
			pstr(nm);
			ps(" = UNPV(");
			pstr(type_str);
			ps(", ((vector_C)");
			expr_emit(prim);
			ps(")->items[");
			pstr(index_str);
			ps("]);\n");
			
			handle_body(body);
			ind();
			ps("}\n");
			return TRUE;
			}

		case VECTOR_INDX: {
			ind();
			ps("FIX(");
			expr_emit(prim);
			ps(", vector);\n");
   			ind();
			ps("FIXUPREAD(&((vector_C)");
			expr_emit(prim);
			ps(")->hdr.inh);\n");
   			ind();
			string limit_str = get_next_temp();
			pstr(limit_str);
			ps(" = ((vector_C)");
			expr_emit(prim);
			ps(")->hdr.inh.size;\n");
   			ind();

   			ps("for (");
			pstr(nm);
			ps(" = 1; ");
			pstr(nm);
			ps(" <= ");
			pstr(limit_str);
			ps("; ");
			pstr(nm);
			ps("++)");

			ps(" {\n");
			handle_body(body);
			ind();
			ps("}\n");
			return TRUE;
			}
		}
	return FALSE;
	}

// Decide if this invoc is an inlinable iterator
// 	and, if so, indicate which one

bool opt_inv(Invoc *inv, iter_type *which)
{
Id *id;

	Expr *prim = opt_inv_get_prim(inv, &id);
	if (!prim) return FALSE;
	TypeInterface *ti = prim->get_type();
	type t = get_one_type(ti, prim->get_line());
	if (!t) return FALSE;
	const char *tname = string_charp(simple_type_name(type_name(t)));
	const char *mname = string_charp(id->get_id());
	if (!strcmp(tname, "int") && !strcmp(mname, "to")) {
		*which = INT_TO;
		return TRUE;
		}
	if (!strcmp(tname, "int") && !strcmp(mname, "to_by")) {
		*which = INT_TO_BY;
		return FALSE;
		}
	if (!strcmp(tname, "array") && !strcmp(mname, "elements")) {
		*which = ARRAY_ELTS;
		return FALSE;
		}
	if (!strcmp(tname, "array") && !strcmp(mname, "indexes")) {
		*which = ARRAY_INDX;
		return TRUE;
		}
	if (!strcmp(tname, "vector") && !strcmp(mname, "elements")) {
		*which = VECTOR_ELTS;
		return TRUE;
		}
	if (!strcmp(tname, "vector") && !strcmp(mname, "indexes")) {
		*which = VECTOR_INDX;
		return TRUE;
		}
	return FALSE;
	}

// Assuming that this invoc has a dot expr for its routineid, return
// 	the primary of the dot expr and the id of the dot expr.
// Returns a NULL pointer if this is not the case.

Expr *opt_inv_get_prim(Invoc *inv, Id **id)
{
Expr *ex;

	RoutineId *rid = inv->get_routineId();
	TypeInterface *ti = rid->get_type();
	method m = ti->get_method();
	if (!m) return NULL;
	switch (rid->tag()) {
		case RoutineId::SimpleRoutineIdT: {
			SimpleRoutineId *srid = (SimpleRoutineId *)rid;
			ex = srid->get_primary();
			break;
			}
		default: {
			return NULL;
			}
		}
	switch (ex->tag()) {
		case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			*id = de->get_id();
			return de->get_primary();
			}
		default: {
			return NULL;
			}
		}
	return NULL;
	}

bool opt_forstmt(ForStmt *forstmt)
{
iter_type which;

	Invoc *inv = forstmt->get_invoc();

	// Is this an inlineable iterator?
	// (Need to decide if it's inlineable *before* any code is emitted...)

	bool ok = opt_inv(inv, &which);
	if (!ok) return FALSE;

	// fish out the id

	ParseNodeList *ids = forstmt->get_ids();
	if (!ids || ids->length() != 1) {
			cmp_err("Inlining is incorrect.",
				inv->get_line());
			return FALSE;
			}
	Id *id = (Id *)(ids->front());

	Body *body = forstmt->get_body();

	return opt_for(which, id, inv, body);
	}
