// Copyright 1995 Barbara Liskov

#include "parse.h"
#include <stdio.h>
#include "string.h"
#include "my_string.h"
#include <unistd.h>
#include <ctype.h>
#include "types/objtype_class.h"
#include "types/vec.h"
#include "types/method.h"
#include "types/ptype.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/vec_instns.h"

#include "cg.h"

extern void do_supers_meth_incls(objtype t);
extern int count_lhs(ParseNodeList *lp);
extern void methods_emit(objtype ot);
extern string ts2nm(TypeSpec *ts, int line);

static FILE *f;
static const char *tname;
static const char *cname;
static const char *rname;
static const char *th_name;
static char *opt_name;
objtype the_obj;
method the_method;

/*
	Various routines to create files and do file i/o
*/

// fopen's need more error checking........

void do_type_file(string filename, string Tname, objtype t, ParseNode *pn)
{

    tname = string_charp(Tname);
    the_obj = t;
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
        string bakfile = string_concat(filename2, string_new("~"));
        if (0>rename(string_charp(filename2),
                     string_charp(bakfile))) {
            perror(string_charp(filename2));

        };
    }
    f = fopen(string_charp(filename2), "w");
    ps("\n/* This file was automatically generated by the Theta compiler */\n");
    ps("/*     from input file: ");
    psc(th_name);
    ps(" */\n\n");
    ps("#include \"common/basic.h\"\n");
    ps("#include \"types/type.h\"\n");
    ps("#include \"types/class.h\"\n");
    ps("#include \"runtime/except.h\"\n");
    ps("#include \"types/string_class.h\"\n");
    ps("#include \"types/pclass_class.h\"\n");
    ps("#include \"runtime/alloc.h\"\n");

    clear_types();
    clear_pts();
    do_supers_meth_incls(the_obj);
    srch_pn_for_types(pn);
    output_types();

    ps("#include \"");
    ptname();
    ps("_meth.h\"\n");
    ps("\n");

    ps("type ");
    ptname();
    ps("V;\n");

/*
    May not need this stuff back and dummy stub routines to
	do dispatches as well
	(implies splitting this routine into begin/end)

    ps("struct ");
    ptname();
    ps("dv_s ");
    ptname();
    ps("_methods;\n");
    ps("_methods = {\n");
    do_supers(the_obj, "{");
    ps("  { 0, 0, STD_FOFFSET, 0, 0,\n");
    ps("    normal_get_address, normal_get_class },\n");
    methods_emit(the_obj);
    ps("};\n\n");
	
    ps("\n#include \"types/class_class.h\"\n\n");
    ps("DV ");
    ptname();
    ps("_DH[] = { (DV)&");
    ptname();
    ps("_methods };\n");

    ps("void init");
    ptname();
    ps("()\n{\n");
    ptname();
    ps("V->dh = ");
    ptname();
    ps("_DH;\n");
    ptname();
    ps("V->dhsize = 1;\n");
    ptname();
    ps("_methods");
    do_supers(the_obj, ".super");
    ps(".c = ");
    ptname();
    ps("V;\n");
    ps("}\n");
*/

    fclose(f);
}

void begin_class_file(string filename, string Tname, string Cname,
		objtype t, ParseNode *pn)
{

    if (Tname) tname = string_charp(Tname);
    else tname = 0;
    cname = string_charp(Cname);
    the_obj = t;
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
        string bakfile = string_concat(filename2, string_new("~"));
        if (0>rename(string_charp(filename2),
                     string_charp(bakfile))) {
            perror(string_charp(filename2));

        };
    }
    f = fopen(string_charp(filename2), "w");
    ps("#include \"common/basic.h\"\n");
    ps("#include \"types/type.h\"\n");
    ps("#include \"types/class.h\"\n");
    ps("#include \"types/class_instn.h\"\n");
    ps("#include \"runtime/except.h\"\n");
    ps("#include \"types/string_class.h\"\n");
    ps("#include \"types/pclass_class.h\"\n");
    ps("#include \"runtime/alloc.h\"\n");
    clear_types();
    clear_pts();
    do_supers_meth_incls(the_obj);
    srch_pn_for_types(pn);
    output_types();
    output_pts_externs();
    if (tname) {
    	ps("#include \"");
    	ptname();
    	ps("_meth.h\"\n");
	}
    ps("#include \"");
    pcname();
    ps("_class.h\"\n");
    ps("\n\n");
    ps("\n#include \"types/class_class.h\"\n\n");
    ps("DV ");
    pcname();
    ps("_DH[] = { (DV)&");
    pcname();
    ps("_methods };\n");
    ps("void init");
    pcname();
    ps("()\n{\n");
    pcname();
    ps("V->dh = ");
    pcname();
    ps("_DH;\n");
    pcname();
    ps("V->dhsize = 1;\n");
    pcname();
    ps("_methods");
    ps(".super");
    do_supers(the_obj, ".super");
    ps(".c = ");
    pcname();
    ps("V;\n");
    output_pts_instns();
    ps("}\n");
}


void do_supers_meth_incls(objtype t)
{
    int nst = t && t->supertypes_ ? vec_length(t->supertypes_) : 0;
    for (int j = nst-1 ; j > -1 ; j--) {
	type st = UNPV(type, vec_fetch(t->supertypes_, j));
	do_supers_meth_incls(type_as_objtype(st));
	const char *tn = string_charp(simple_type_name(type_name(st)));
	if (!strcmp(tn, "any")) continue;
	if (!strcmp(tn, "vec")) continue;
    	fputs("#include \"", f);
    	fputs(tn, f);
    	fputs("_meth.h\"\n", f);
	}
    }

/* Not used
void make_rtn_include(string filename, ParseNode *rd);
{
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
        string bakfile = string_concat(filename2, string_new("~"));
        if (0>rename(string_charp(filename2),
                     string_charp(bakfile))) {
            perror(string_charp(filename2));

        };
    }
    f = fopen(string_charp(filename2), "w");
   }
*/

void begin_rtn_file(string filename, ParseNode *pn, string nm, method m)
{
    the_method = m;
    rname = string_charp(nm);
    char const *fn = string_charp(filename);
    string filename2 = string_concat(filename, string_new("-th"));
    if (0 == access(string_charp(filename2), F_OK)) {
        string bakfile = string_concat(filename2, string_new("~"));
        if (0>rename(string_charp(filename2),
                     string_charp(bakfile))) {
            perror(string_charp(filename2));

        };
    }
    f = fopen(string_charp(filename2), "w");
    ps("#include \"common/basic.h\"\n");
    ps("#include \"types/type.h\"\n");
    ps("#include \"types/class.h\"\n");
    ps("#include \"types/class_instn.h\"\n");
    ps("#include \"runtime/except.h\"\n");
    ps("#include \"types/string_class.h\"\n");
    ps("#include \"types/pclass_class.h\"\n");
    ps("#include \"runtime/alloc.h\"\n");
    clear_types();
    clear_pts();
    srch_pn_for_types(pn);
    output_types();
    output_pts_externs();
    ps("class_ ");
    pstr(nm);
    ps("_rtn_classV;\n");
}

void ps(char *s)
{
	fputs(s, f);
	}

void psc(const char *s)
{
	fputs(s, f);
	}

void pstr(string s)
{
	fputs(string_charp(s), f);
	}

void pint(int i)
{
char buf[20];

	sprintf(buf, "%d", i);
	fputs(buf, f);
	}

void ptname()
{
	fputs(tname, f);
	}

void pcname()
{
	fputs(cname, f);
	}

void prname()
{
	fputs(rname, f);
	}

void popt()
{
	fputs(opt_name, f);
	}

void pmsig(method m)
{
int i;

   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   pcname();
   ps("_");
   pstr(m->name);
   ps("_ (");
   // if (m->parameterized) ps("void *pblock, ");
   pcname();
   ps(" self");
   if (vec_length(m->returns) > 1) ps(", fevalue *__retvals");
   if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n");
   }

void prsig(method m)
{
int i;

   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   pstr(m->name);
   ps("(");
   // if (m->parameterized) ps("void *pblock, ");
   ps("obj dummy");
   if (vec_length(m->returns) > 1) ps(", fevalue *__retvals");
   if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")\n");
   }

void ptsig(method m)
{
int i, j;

   ind();
   pstr(m->name);
   ps("(");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        pstr(f->name);
        ps(": ");
        pstr(type_name(f->t));
	if (i != vec_length(m->arguments)-1) ps(", ");
        }
   ps(")");
   if (vec_length(m->returns) > 0) {
   	if (m->iter) ps("yields (");
   	else ps(" returns (");
	}
   for (i = 0; i < vec_length(m->returns); i++ ) {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(type_name(t));
	if (i != vec_length(m->returns)-1) ps(", ");
	}
   if (vec_length(m->returns) > 0)  ps(")");
   if (vec_length(m->signals) > 0) {
	ps(" signals (");
	for (i = 0; i < vec_length(m->signals); i++) {
		signal_ s = UNPV(signal_, vec_fetch(m->signals, i));
		pstr(s->name);
		if (vec_length(s->returns)) {
			ps("(");
			for (j = 0; j < vec_length(s->returns); j++) {
				type t = UNPV(type, vec_fetch(s->returns, 0));
        			pstr(type_name(t));
				if (j != vec_length(s->returns)-1) ps(", ");
				}
			ps(")");
			}
		if (i != vec_length(m->signals)-1) ps(", ");
		}
	ps(")\n");
	}
   ps("\n");
   }

void ptivar(type t, string name)
{
   ind();
   pstr(name);
   ps(": ");
   pstr(type_name(t));
   }

void ptgetsig(type gt, string name, string gname, bool parmd)
{
int i;

   ind();
   pstr(gname);
   ps("() returns (");
   pstr(type_name(gt));
   ps(")\n");
   }

void ptsetsig(type st, string name, string sname, bool parmd)
{
int i;

   ind();
   pstr(sname);
   ps("(");
   pstr(name);
   ps(": ");
   pstr(type_name(st));
   ps(")\n");
   }

void pmsigcast(method m, const char *name)
{
int i;

   ps("(");
   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   // ptname();
   // ps("_");
   // pstr(m->name);
   // ps("_ (");
   ps("(*)(");
   // if (m->parameterized) ps("void *pblock, ");
   ps((char *)name);
   ps(" self");
   if (vec_length(m->returns) > 1) ps(", fevalue *__retvals");
   if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(")) ");
   }

void pmsigtype(method m, const char *name)
{
int i;

   ind();
   if (vec_length(m->returns) == 0) ps("void ");
   else {
        type t = UNPV(type, vec_fetch(m->returns, 0));
        pstr(simple_type_name(type_name(t))); ps(" ");}
   ps("(*");
   pstr(m->name);
   ps(")(");
   ps((char *)name);
   ps(" self");
   if (vec_length(m->returns) > 1) ps(", fevalue *__retvals");
   if (m->iter) ps(", struct closure cl");
   int nargs = vec_length(m->arguments);
   for (i=0; i<nargs; i++) {
        formal f = UNPV(formal, vec_fetch(m->arguments, i));
        ps(", ");
        pstr(simple_type_name(type_name(f->t)));
        ps(" ");
        pstr(f->name);
        }
   ps(");\n");
   }


static int indent_sp = 0;
static char spaces[120] = "                                       "
	"                                        "
	"                                        ";

void inc_ind()
{
	indent_sp += 3;
	}
void dec_ind()
{
	indent_sp -= 3;
	}

void ind()
{
//int i;
//
//  for (i = 0 ; i < indent_sp; i++) {
//	ps(" ");
//	}
   spaces[indent_sp] = '\0';
   ps(spaces);
   spaces[indent_sp] = ' ';
   }

void method_emit(method m, const char *cast_nm, const char *def_nm)
{
    const char *m_name = string_charp(method_name(m));
    if (!strcmp(m_name, "getClass")) return;
    ps("    ");
    pmsigcast(m, cast_nm);
    if (def_nm) {psc(def_nm); ps("_");}
    psc(m_name);
    if (def_nm) ps("_ ");
   }

void do_supers_meths_emit(objtype t)
{
    int nst = t && t->supertypes_ ? vec_length(t->supertypes_) : 0;
    for (int j = nst-1 ; j > -1 ; j--) {
	type st = UNPV(type, vec_fetch(t->supertypes_, j));
	do_supers_meths_emit(type_as_objtype(st));
        int n = vec_length(type_as_objtype(st)->methods_);
	string st_name = type_name(st);
        for(int i = 0; i < n; i++) {
             method m = UNPV(method, 
				vec_fetch(type_as_objtype(st)->methods_, i));
             const char *m_name = string_charp(method_name(m));
	     if (!strcmp(m_name, "getClass")) continue;
	     method_emit(m, string_charp(st_name), cname);
      	     if (i == n-1) fputs("},\n", f);
	     else fputs(",\n", f);
	     }
        }
   }

void methods_emit(objtype ot)
{
    // add supertypes' methods
    do_supers_meths_emit(the_obj);

    // bool need_comma = FALSE;
    // add type's methods
        int n = the_obj ? vec_length(the_obj->methods_) : 0;
        for(int i = 0; i < n; i++) {
             method m = UNPV(method, 
				vec_fetch(the_obj->methods_, i));
	     method_emit(m, tname, cname);
      	     if (i != n-1) fputs(",\n", f);
	     }
      	 if (the_obj) fputs("    }", f); // need_comma = TRUE; 

    // add methods private to the class...
    if (!save_stripped_class) return;
    n = vec_length(class_as_objtype(save_stripped_class)->methods_);
    // if (n && need_comma) fputs(",\n", f);
    if (the_obj) fputs(",\n", f);
    for(i = 0; i < n; i++) {
         method m = UNPV(method, vec_fetch(
			class_as_objtype(save_stripped_class)->methods_, i));
         const char *m_name = string_charp(method_name(m));
	 method_emit(m, cname, cname);
      	 if (i == n-1) fputs("\n", f);
      	 else fputs(",\n", f);
	}
   }

void do_supers(objtype ot, char *ditty)
{
    int nst = 0;
    if (ot && ot->supertypes_) nst = vec_length(ot->supertypes_);
    for (int i = 0 ; i < nst ; i++) {
	fputs(ditty, f);
	do_supers(type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, i))),
			ditty);
	}
    }

void do_supersm1(objtype ot, char *ditty)
{
    int nst = 0;
    if (ot->supertypes_) {
	objtype t = type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, 0)));
	if (t == Any) return;
	fputs(ditty, f);
	do_supers(t, ditty);
	}
    }

void end_class_file()
{

    ps("class_ ");
    pcname();
    ps("V;\n");
    ps("struct ");
    pcname();
    ps("dv_s ");
    pcname();
    ps("_methods = {\n");
    do_supers(the_obj, "{");
    ps("  { 0, 0, STD_FOFFSET, 0, 0,\n");
    ps("    normal_get_address, normal_get_class },\n");
    methods_emit(the_obj);
    
    ps("};\n\n");
	
    fclose(f);
    cname = 0;
}

void end_rtn_file()
{
    ps("struct ");
    prname();
    ps("_rtn_classdv_s {\n");
    inc_ind();
    ind();
    ps("struct dv_s super;\n");
    pmsigtype(the_method, "obj");
    dec_ind();
    ps("};\n");
    ps("class_ ");
    prname();
    ps("_rtn_classV;\n");
    ps("struct ");
    prname();
    ps("_rtn_classdv_s ");
    prname();
    ps("_rtn_class_methods = {\n");
    ps("  { 0, 0, STD_FOFFSET, 0, 0,\n");
    ps("    normal_get_address, normal_get_class },\n");
    method_emit(the_method, "obj", 0);
    
    ps("};\n\n");
	
    ps("\n#include \"types/class_class.h\"\n\n");
    ps("DV ");
    prname();
    ps("_rtn_class_DH[] = { (DV)&");
    prname();
    ps("_rtn_class_methods };\n");
    ps("void init");
    prname();
    ps("_rtn_class()\n{\n");
    prname();
    ps("_rtn_classV->dh = ");
    prname();
    ps("_rtn_class_DH;\n");
    prname();
    ps("_rtn_classV->dhsize = 1;\n");
    prname();
    ps("_rtn_class_methods");
    ps(".super");
    // do_supers(the_obj, ".super");
    ps(".c = ");
    prname();
    ps("_rtn_classV;\n");
    output_pts_instns();
    ps("}\n");
    fclose(f);
    rname = 0;
}

void begin_pth_file(string nm);
void begin_data_file(string nm);
void begin_extern_file(string nm);
void end_pth_file();
void end_data_file();
void end_extern_file();

void begin_support_files(string nm)
{
	th_name = string_charp(nm);

	char *slash_ind = rindex(th_name, '/');
	char *dot_ind = rindex(th_name, '.');
	if (slash_ind > dot_ind) dot_ind = 0;
	int opt_len = 0;
	if (slash_ind) {
		if (dot_ind) opt_len = dot_ind - slash_ind - 1;
		else opt_len = th_name + strlen(th_name) - slash_ind - 1;
		slash_ind++;
		}
	else {
		slash_ind = (char *)th_name;
		if (dot_ind) opt_len = dot_ind - th_name;
		else opt_len = strlen(th_name);
		}

	opt_name = (char *)malloc(opt_len+1);
	strncpy(opt_name, slash_ind, opt_len);
	opt_name[opt_len] = '\0';
	for (int i = 0; i < opt_len; i++) {
		opt_name[i] = toupper(opt_name[i]);
		}
	
	begin_pth_file(nm);
	begin_data_file(nm);
	begin_extern_file(nm);
}

extern void pth_type(TypeIntf *tin);
extern void pth_rtn(RoutineDef *rd, bool viz);
extern void pth_class(ClassDef *cd);
extern void data_type(TypeIntf *tin);
extern void data_rtn(RoutineDef *rd);
extern void data_class(ClassDef *cd);
extern void extern_type(TypeIntf *tin);
extern void extern_rtn(RoutineDef *rd);
extern void extern_class(ClassDef *cd);

void extend_support_files(ParseNode *pn)
{
	switch (pn->tag()) {
		case ParseNode::SpecEltT: {
		    SpecElt *spec = (SpecElt *)pn;
		    switch (spec->tag()) {
			case SpecElt::TypeIntfT: {
               	             TypeIntf *tin = (TypeIntf*)spec;
                      	     pth_type(tin);
                      	     data_type(tin);
                      	     extern_type(tin);
		             break;
               		     }
                	case SpecElt::RoutineSpecT: {
                       	     RoutineSpec *rs = (RoutineSpec *)spec;
		             // handle_routine_spec(rs);
               		     break;
                       	     }
			   }
			break;
			}
		case ParseNode::ImplEltT: {
			ImplElt *ie = (ImplElt *)pn;
			switch (ie->tag()) {
		                case ImplElt::RoutineDefT:{
               		         RoutineDef *rd = (RoutineDef *)ie;
				 bool viz = mod_impls_member(rd);
                       		 pth_rtn(rd, viz);
                       		 data_rtn(rd);
                       		 extern_rtn(rd);
		                 break;
               		         }
		                case ImplElt::ClassDefT:{
               		         ClassDef *cd = (ClassDef *)ie;
                       		 pth_class(cd);
                       		 data_class(cd);
                       		 extern_class(cd);
		                 break;
				 }
			    }
			break;
			}
		}
}

void end_support_files()
{
	end_pth_file();
	end_data_file();
	end_extern_file();
}

void create_support_file(string nm, char *extension, char **fname)
{
int err;
char *old_fname;
char *new_fname;
int i,j;

	// Select file name etc. backup old one...
	// if file exists mv to name~
	int extlen = strlen(extension);
	char *slash_ind = rindex(th_name, '/');
	char *ind = rindex(th_name, '.');
	if (slash_ind > ind) ind = 0;
	int len = ind?ind-th_name:strlen(th_name);
	new_fname = (char *)malloc(len+extlen+2);	// len.extlen\0
	strncpy(new_fname, th_name, len);
	new_fname[len] = '.';
	for (i = len+1, j = 0 ; j < extlen; i++, j++) {
		new_fname[i] = extension[j];
		}
	new_fname[len+extlen+1] = '\0';
	old_fname = (char *)malloc(len+extlen+3);  // +~
	strcpy(old_fname, new_fname);
	old_fname[len+extlen+1] = '~';
	old_fname[len+extlen+2] = '\0';
	err = access(new_fname, F_OK);
	if (err == 0) {
		/* file exists */
		err = access(old_fname, F_OK);
		if (err == 0) {
			/* old file exists */
			unlink(old_fname);
			rename(new_fname, old_fname);
			}
		else {
			/* old file does not exist */
			rename(new_fname, old_fname);
			}
		}
	else {
		/* file does not exist */
		}
	*fname = new_fname;
}

static char *pth_name;

void begin_pth_file(string nm)
{
	create_support_file(nm, "pth", &pth_name);
}

void pth_type(TypeIntf *tin)
{
    	f = fopen(pth_name, "a");
	pstr(tin->get_id()->get_id());
	ps(" = ");
	ParseNodeList *sprs = tin->get_supers();
	if (sprs) for (Pix p = sprs->first(); p ; sprs->next(p)) {
		SuperInfo *si = (SuperInfo *)(*sprs)(p);
		TypeSpec *ts = si->get_typespec();
		if (ts) {
			string nm = 0;
			switch (ts->tag()) {
				case TypeSpec::SimpleTypeSpecT: {
					nm = ts2nm(ts, tin->get_line());
					break;
					}
				case TypeSpec::ParamTypeSpecT: {
					ParamTypeSpec *pts = (ParamTypeSpec *)ts;
					nm = pts->get_name()->get_name()->get_id();
					break;
					}
				}
			if (nm) pstr(nm);
			ps(" ");
			}
		}
	ps("type\n");
	inc_ind();
        ParseNodeList *ms = tin->get_methods();
	if (ms) for (Pix p = ms->first(); p ; ms->next(p)) {
		RoutineIntf *ri = (RoutineIntf *)(*ms)(p);
		TypeInterface *ti = ri->get_type();
		method m = ti->get_method();
		ptsig(m);
		}
        dec_ind();
	ps("end ");
	pstr(tin->get_id()->get_id());
	ps("\n\n");
	fclose(f);
}

void pth_rtn(RoutineDef *rd, bool viz)
{
    	f = fopen(pth_name, "a");
	RoutineIntf *ri = rd->get_routineIntf();
	string nm = ri->get_id()->get_id();
	pstr(nm);
	ps("_rtn_class = ");
	if (viz) ps (" VISIBLE ");
	ps("class ()\n");
	inc_ind();
	TypeInterface *ti = ri->get_type();
	method m = ti->get_method();
	string save = m->name;
	m->name = string_new("invoke");
	ptsig(m);
	m->name = save;
	dec_ind();
	ps("end ");
	pstr(nm);
	ps("_rtn_class\n\n");
	fclose(f);
}

void pth_class(ClassDef *cd)
{
int pass;
string mname;
fevalue tgm_ret[2];
type t;
objtype ot = 0;
bool doit;

    	f = fopen(pth_name, "a");
	pstr(cd->get_classId()->get_id());
	ps(" = ");
	TypeSpec *ts = cd->get_deftype();
	if (ts) {
		t = ts->get_type()->get_type();
		ot = type_as_objtype(t);
		string nm = 0;
		switch (ts->tag()) {
			case TypeSpec::SimpleTypeSpecT: {
				nm = ts2nm(ts, cd->get_line());
				break;
				}
			case TypeSpec::ParamTypeSpecT: {
				ParamTypeSpec *pts = (ParamTypeSpec *)ts;
				nm = pts->get_name()->get_name()->get_id();
				break;
				}
			}
		if (nm) pstr(nm);
		ps(" ");
		}
	ps("class (");
        ParseNodeList *decls = cd->get_decl();
	// pass0 does ivar decls, pass1 does get/set methods
	int n = 1;
	int last = count_lhs(decls);
        for (pass = 0; pass < 2; pass++) {
            if (pass == 1) inc_ind();
	    if (decls) for (Pix p = decls->first(); p ; decls->next(p)) {
		Decl *d = (Decl *)(*decls)(p);
		switch (d->tag()) {
			case Decl::RegDeclT: {
				if (pass == 1) break;
				RegDecl *rd = (RegDecl *)d;
				TypeInterface *ti = rd->get_type();
				type t = ti->get_type();
				ParseNodeList *ids = rd->get_ids();
				for (Pix p = ids->first(); p ; ids->next(p)) {
				    Id *id = (Id *)(*ids)(p);
				    string nm = id->get_id();
				    ptivar(t, nm);
				    if (n != last) {ps(", "); n++;}
				    }
				break;
				}
			case Decl::ImplDeclT: {
				ImplDecl *imd = (ImplDecl *)d;
				string nm = imd->get_id()->get_id();
				TypeInterface *ti = imd->get_type();
				type t = ti->get_type();
				if (pass == 0) {
				   ptivar(t, nm);
				   if (n != last) {ps(", "); n++;}
				   }
				if (pass == 1) {
				   if (imd->get_get()) {
				      mname = imd->get_get()->get_id();
				      doit = FALSE;
				      if (ot) {
				        RESET_EXC
					getMethod(ot, tgm_ret, mname);
				      	   CATCH {
						   RESET_EXC
						   doit = TRUE;
						   }
					}
				      else doit = TRUE;
				      if (doit) ptgetsig(t, nm, mname, FALSE);
				     }
				   if (imd->get_set()) {
				      mname = imd->get_set()->get_id();
				      doit = FALSE;
				      if (ot) {
				        RESET_EXC
				        getMethod(ot, tgm_ret, mname);
				      	   CATCH {
						   RESET_EXC
						   doit = TRUE;
						   }
					 }
				      else doit = TRUE;
				      if (doit) ptsetsig(t, nm, mname, FALSE);
				     }
				   }
				break;
				}
			}
		}
            if (pass == 0) ps(")\n");
	    }
        ParseNodeList *celts = cd->get_classElts();
	if (celts) for (Pix p = celts->first(); p ; celts->next(p)) {
		ParseNode *n = (*celts)(p);
		switch (n->tag()) {
			case ParseNode::MethodOrOpDefT:{
				// could decorate mop nodes directly in tc
				MethodOrOpDef *mopd = (MethodOrOpDef *)n;
				TypeInterface *ti = 
					mopd->get_routineDef()->get_type();
				method m = ti->get_method();
				mname = m->name;
				doit = FALSE;
				if (ot) {
				  RESET_EXC
				  getMethod(ot, tgm_ret, mname);
				      CATCH {
					   RESET_EXC
					   doit = TRUE;
					   }
				  }
				else doit = TRUE;
				if (doit) ptsig(m);
				}
			}
		}
        dec_ind();
	ps("end ");
	pstr(cd->get_classId()->get_id());
	ps("\n\n");
	fclose(f);
}

void end_pth_file()
{
	// Not sure there's much to do here...
}

/*	Emit file containing information for builtin data structures */

static char *data_name = 0;
void begin_data_file(string nm)
{
	create_support_file(nm, "data", &data_name);
    	f = fopen(data_name, "a");
	ps("\n");
/*
	ps("\n#include \"config/vdefs/");
	popt();
	ps(".h\"\n\n");
	ps("#if ");
	popt();
	ps("\n");
*/
	fclose(f);
}

void data_type(TypeIntf *tin)
{
	tname = string_charp(tin->get_id()->get_id());
    	f = fopen(data_name, "a");
	ptname();
	ps("\t");
	ptname();
	ps ("V\tFALSE\tWK_");
	ptname();
	ps("_OREF\t0\n");
	fclose(f);
}

void data_rtn(RoutineDef *rd)
{
    	f = fopen(data_name, "a");
	rname = string_charp(rd->get_routineIntf()->get_id()->get_id());
	prname();
	ps ("_rtn_class");
	ps("\t");
	prname();
	ps ("_rtn_class");
	ps ("V\tFALSE\tWK_");
	prname();
	ps ("_rtn_class");
	ps("_OREF\tinit");
	prname();
	ps ("_rtn_class");
	ps("\n");
	fclose(f);
}

void data_class(ClassDef *cd)
{
    	f = fopen(data_name, "a");
	cname = string_charp(cd->get_classId()->get_id());
	pcname();
	ps("\t");
	pcname();
	ps ("V\tFALSE\tWK_");
	pcname();
	ps("_OREF\tinit");
	pcname();
	ps("\n");
	fclose(f);
}


void end_data_file()
{
	f = fopen(data_name, "a");
	output_pts_data();
/*
	ps("#endif\n");
*/
	ps("\n");
	fclose(f);
}

/*	Emit file containing external declarations	*/

static char *extern_name = 0;
void begin_extern_file(string nm)
{
	create_support_file(nm, "externs.h", &extern_name);
    	f = fopen(extern_name, "a");
	ps("#ifndef _");
	popt();
	ps("_EXTERNS_H\n");
	ps("#define _");
	popt();
	ps("_EXTERNS_H\n\n");
	ps("#include \"types/type_def.h\"\n\n");
	fclose(f);
}

void extern_type(TypeIntf *tin)
{
    	f = fopen(extern_name, "a");
	ps ("extern type ");
	ptname();
	ps("V;\n");
	fclose(f);
}

void extern_rtn(RoutineDef *rd)
{
    	f = fopen(extern_name, "a");
	ps ("extern class_ ");
	prname();
	ps ("_rtn_class");
	ps("V;\n");
	ps ("extern void init");
	prname();
	ps ("_rtn_class");
	ps("();\n");
	fclose(f);
}

void extern_class(ClassDef *cd)
{
    	f = fopen(extern_name, "a");
	ps ("extern class_ ");
	pcname();
	ps("V;\n");
	ps ("extern void init");
	pcname();
	ps("();\n");
	fclose(f);
}

void end_extern_file()
{
    	f = fopen(extern_name, "a");
	output_pts_decls();
	ps("\n#endif /* _");
	popt();
	ps("_EXTERNS_H */\n");
	fclose(f);
}

static ImplModule *save_im = NULL;

void mod_impls_save(ImplModule *im)
{
	save_im = im;
	}

void mod_impls_clear()
{
	save_im = NULL;
	}

bool mod_impls_member(RoutineDef *rd)
{
	if (!save_im) return FALSE;
	RoutineIntf *ri = rd->get_routineIntf();
	Id *id = ri->get_id();
	const char *rinm = string_charp(id->get_id());
	ParseNodeList *exports = save_im->get_exports();
	if (exports) for (Pix p = exports->first() ; p ; exports->next(p)) {
		Id *ex_id = (Id *)(*exports)(p);
		const char *exnm = string_charp(ex_id->get_id());
		if (!strcmp(rinm, exnm)) return TRUE;
		}
	return FALSE;
	}
