// Copyright 1995 Barbara Liskov


#include "parse.h"
#include "string.h"
#include "my_string.h"
#include "cg.h"
extern "C" {
#include "types/objtype_class.h"
#include "types/ptype.h"
#include "types/ptype_class.h"
#include "types/class_instn.h"
}

/* Routines to manage temporary variables			*/

/* decl_temps is a top-level routine				*/

/* srch_pn* routines search parse nodes and parse node lists	*/
/*	 for places that need temporaries			*/
/* process_temp* routines look at expressions
/*	for temps						*/
/* see lower-level routines below				*/

void decl_temps(ParseNode *pn)
{
    clear_temps();
    srch_pn_for_temps(pn);
    output_temps();
    reset_temps();
	}

void srch_pnl_for_temps(ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	ParseNode *pn = (ParseNode *)(*pnl)(p);
	srch_pn_for_temps(pn);
	}
   }

static bool lhs = FALSE;
static bool save_lhs = FALSE;

void srch_pn_for_temps(ParseNode *pn)
{
   if (pn) switch (pn->tag()) {
	case ParseNode::ImplEltT: {
		ImplElt *ie = (ImplElt *)pn;
		switch (ie->tag()) {
			case ImplElt::RoutineDefT: {
				RoutineDef *rd = (RoutineDef *)pn;
				srch_pn_for_temps(rd->get_body());
				break;
				}
			case ImplElt::ClassDefT: {
				ClassDef *cd = (ClassDef *)pn;
				// srch_pnl_for_temps(cd->get_classElts());
				break;
				}
			}
		break;
		}
	case ParseNode::MethodOrOpDefT: {
		MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
		srch_pn_for_temps(mopd->get_routineDef());
		break;
		}
	case ParseNode::TagWhenArmT: {
		TagWhenArm *twa = (TagWhenArm *)pn;
		srch_pn_for_temps(twa->get_body());
		break;	
		}
	case ParseNode::TypeWhenArmT: {
		TypeWhenArm *twa = (TypeWhenArm *)pn;
		srch_pn_for_temps(twa->get_body());
		break;	
		}
	case ParseNode::ExWhenArmT: {
		ExWhenArm *ewa = (ExWhenArm *)pn;
		srch_pn_for_temps(ewa->get_body());
		break;	
		}
	case ParseNode::OthersHandlerT: {
		OthersHandler *oh = (OthersHandler *)pn;
		srch_pn_for_temps(oh->get_body());
		break;	
		}
	case ParseNode::ElseIfT: {
		ElseIf *els = (ElseIf *)pn;
		process_temp(els->get_expr());
		srch_pn_for_temps(els->get_body());
		break;	
		}
	case ParseNode::IdOrIvarT: {
		IdOrIvar *i = (IdOrIvar *)pn;
		if (i->get_primary()) process_temp(i->get_primary());
		break;	
		}
	case ParseNode::FieldInitT: {
		FieldInit *fi = (FieldInit *)pn;
		process_temp(fi->get_expr());
		break;	
		}
	case ParseNode::BodyT: {
		Body *b = (Body *)pn;
		srch_pnl_for_temps(b->get_statements());
		break;	
		}
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		srch_pn_for_temps(inv->get_routineId());
		srch_pnl_for_temps(inv->get_exprs());
		opt_inv_temps(inv);
		// need to add lastarg...
		type t;
		if((inv_signalling(inv, &t) || forced_prep()) && t)
				save_temp(type_name(t));
		break;	
		}
	case ParseNode::ExprT: {
		Expr *ex = (Expr *)pn;
		process_temp(ex);
		break;	
		}
	case ParseNode::RoutineIdT: {
		RoutineId *rid = (RoutineId *)pn;
		switch (rid->tag()) {
		   case RoutineId::SimpleRoutineIdT: {
			SimpleRoutineId *srid = (SimpleRoutineId *)rid;
			process_temp(srid->get_primary());
			break;	
			}
		   case RoutineId::ComplexRoutineIdT: {
			ComplexRoutineId *crid = (ComplexRoutineId *)rid;
			process_temp(crid->get_primary());
			break;	
			}
		   }
		break;	
		}
	case ParseNode::StmtT: {
		Stmt *stmt = (Stmt *)pn;
		switch (stmt->tag()) {
		   case Stmt::InitVarExprT: {
			InitVarExpr *ive = (InitVarExpr *)stmt;
			process_temp(ive->get_expr());
			break;
			}
		   case Stmt::AssignExprStmtT: {
			AssignExprStmt *aes = (AssignExprStmt *)stmt;
			lhs = TRUE;
			srch_pnl_for_temps(aes->get_ids());
			lhs = FALSE;
			srch_pnl_for_temps(aes->get_exprs());
			break;
			}
		   case Stmt::InitVarInvokeT: {
			InitVarInvoke *ivi = (InitVarInvoke *)stmt;
			srch_pn_for_temps(ivi->get_invoc());
			break;
			}
		   case Stmt::InvokeStmtT: {
			InvokeStmt *invs = (InvokeStmt *)stmt;
			srch_pn_for_temps(invs->get_invoc());
			break;
			}
		   case Stmt::WhileStmtT: {
			WhileStmt *wh = (WhileStmt *)stmt;
			process_temp(wh->get_expr());
			srch_pn_for_temps(wh->get_body());
			break;
			}
		   case Stmt::IfStmtT: {
			IfStmt *ifst = (IfStmt *)stmt;
			process_temp(ifst->get_expr());
			srch_pn_for_temps(ifst->get_body());
			srch_pnl_for_temps(ifst->get_elseifs());
			srch_pn_for_temps(ifst->get_elsebody());
			break;
			}
		   case Stmt::DeclForStmtT: {
			DeclForStmt *dfs = (DeclForStmt *)stmt;
			srch_pn_for_temps(dfs->get_invoc());
			srch_pn_for_temps(dfs->get_body());
			break;
			}
		   case Stmt::ForStmtT: {
			ForStmt *fs = (ForStmt *)stmt;
			srch_pn_for_temps(fs->get_invoc());
			srch_pn_for_temps(fs->get_body());
			break;
			}
		   case Stmt::TagcaseT: {
			Tagcase *tg = (Tagcase *)stmt;
			process_temp(tg->get_expr());
			srch_pnl_for_temps(tg->get_tagWhenArms());
			srch_pn_for_temps(tg->get_body());
			break;
			}
		   case Stmt::TypecaseT: {
			Typecase *tp = (Typecase *)stmt;
			process_temp(tp->get_expr());
			srch_pnl_for_temps(tp->get_typeWhenArms());
			srch_pn_for_temps(tp->get_body());
			break;
			}
		   case Stmt::ReturnStmtT: {
			ReturnStmt *rs = (ReturnStmt *)stmt;
			process_temps(rs->get_exprs());
			break;
			}
		   case Stmt::YieldT: {
			Yield *y = (Yield *)stmt;
			process_temps(y->get_exprs());
			break;
			}
		   case Stmt::SignalStmtT: {
			SignalStmt *s = (SignalStmt *)stmt;
			process_temps(s->get_exprs());
			break;
			}
		   case Stmt::ExitT: {
			Exit *et = (Exit *)stmt;
			process_temps(et->get_exprs());
			break;
			}
		   case Stmt::BlockStmtT: {
			BlockStmt *b = (BlockStmt *)stmt;
			srch_pn_for_temps(b->get_body());
			break;	
			}
		   case Stmt::ResignalStmtT: {
			ResignalStmt *rs = (ResignalStmt *)stmt;
			srch_pn_for_temps(rs->get_stmt());
			break;	
			}
		   case Stmt::ExceptStmtT: {
			ExceptStmt *exs = (ExceptStmt *)stmt;
			srch_pn_for_temps(exs->get_stmt());
			srch_pnl_for_temps(exs->get_exWhenArm());
			srch_pn_for_temps(exs->get_body());
			break;
			}
		   case Stmt::InitT: {
			Init *init = (Init *)stmt;
			srch_pnl_for_temps(init->get_fieldInits());
			srch_pn_for_temps(init->get_invoc());
			srch_pn_for_temps(init->get_body());
			break;
			}
		   }
		break;
		}
	}
   }

void process_temps(ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	Expr *ex = (Expr *)(*pnl)(p);
	process_temp(ex);
	}
   }

bool simple_expr(Expr *ex)
{
   switch (ex->tag()) {
	case Expr::LiteralT:
	case Expr::NilT:
	case Expr::SuperIdT:
	case Expr::SelfT:
	case Expr::NewT:
	case Expr::IdExprT:
		return TRUE;
	}
  return FALSE;
  }

void process_temp(Expr *ex)
{
   // Skip over exprs that don't need temps
   if (simple_expr(ex)) return;
   TypeInterface *ti = ex->get_type();
   type t = NULL;
   switch (ti->tag()) {
	case TypeInterface::SingleT: {
   		t = ti->get_type();
		break;
		}
	case TypeInterface::MultipleT: {
   		vec v = ti->get_mult();
		if (vec_length(v) > 0) {
			t = UNPV(type, vec_fetch(v, 0));
			}
		break;
		}
	}
   
   switch (ex->tag()) {
	case Expr::BracketRefT: {
		BracketRef *br = (BracketRef *)ex;
		save_lhs = lhs;
		lhs = FALSE;
		process_temp(br->get_primary());
		srch_pnl_for_temps(br->get_exprs());
		lhs = save_lhs;
		// this is a weird situation: no temp if on
		// lhs.  temp needed on rhs...
		// probably desugaring is the right thing.
   		if (t) {
			if (!lhs) save_temp(type_name(t));
			}
		else cmp_err("process_temp: brackref: type missing",1);
		break;
		}
	case Expr::BraceRefT: {
		BraceRef *br = (BraceRef *)ex;
		process_temp(br->get_primary());
		srch_pnl_for_temps(br->get_exprs());
		break;
		}
	case Expr::DotExprT: {
		DotExpr *de = (DotExpr *)ex;
		enter_forced_prep();
		process_temp(de->get_primary());
		leave_forced_prep();
		return;
		}
	case Expr::ArrayRefT: {
		ArrayRef *ar = (ArrayRef *)ex;
		process_temp(ar->get_primary());
		process_temp(ar->get_expr());
		// not sure we need another temp here
		break;
		}
	case Expr::InvocExprT: {
		InvocExpr *ie = (InvocExpr *)ex;
		srch_pn_for_temps(ie->get_invoc());
		return;
		}
	case Expr::SelectorConstrT: {
		SelectorConstr *sc = (SelectorConstr *)ex;
		if (t) save_temp(type_name(t));
		srch_pnl_for_temps(sc->get_fields());
		break;
		}
	case Expr::ArrayConstrT: {
		ArrayConstr *ac = (ArrayConstr *)ex;
		process_temp(ac->get_size());
		srch_pnl_for_temps(ac->get_exprs());
		// not sure we need another temp here
		break;
		}
	case Expr::BinaryT: {
		Binary *b = (Binary *)ex;
		process_temp(b->get_op1());
		if (!simple_expr(b->get_op2())) {
			if (t) save_temp(type_name(t));
			}
		process_temp(b->get_op2());
		return;
		}
	// need to consider binding, instantiation, unary
	//	also routine ids  (probably handled under Invoc above)
	}
   if (!t) { sprintf(cmp_err_buf, "Time to fix process_temp");
	     cmp_err(cmp_err_buf, ex->get_line());
	     return;
	}
   // omit for now to cause a more careful job
   // basically breaks above indicate work not done
   // save_temp(type_name(t));
   }

/* Low-Level Routines to manage temporary variables		*/

/* There are two phases of use:					*/
/* The first accumulates a list of all temporaries and then 	*/
/*	outputs their decls.  This phase uses			*/
/* 	1) save_temp saves a type for the temp			*/
/* 	2) output_temps outputs declarations for all temporaries*/
/* The second phase uses temporaries to compute intermediate	*/
/*	values for expression evaluation.  It uses		*/
/*	1) get_next_temp					*/


#define MAX_TEMPS 2000

static string temp_types[MAX_TEMPS];
static int temp_type_index = 0;
static int temp_index = 0;

void save_temp(string typ)
{
   if (temp_type_index >= MAX_TEMPS) {
	th_fail("cg_expr.cc: increase MAX_TEMPS");
	}
   temp_types[temp_type_index] = typ;
   temp_type_index++;
   }

void clear_temps()
{
   temp_type_index = 0;
   temp_index = 0;
   }

void reset_temps()
{
   temp_index = 0;
   }

void output_temps()
{
int i;
char temp_name[10];

   temp_name[0] = 'T';
   temp_name[1] = '_';
   for (i = 0; i < temp_type_index ; i++) {
	sprintf(&temp_name[2], "%d", i);
	output_temp(temp_types[i], temp_name);
	}
   if (temp_type_index > 0) ps("\n");
   }

void output_temp(string typ, char *id)
{
   pstr(simple_type_name(typ));
   ps(" ");
   ps(id);
   ps(";\n");
   }

string get_next_temp()
{
char temp_name[10];

   if (temp_type_index == 0 || temp_index > temp_type_index) {
	cmp_err("Losing in get_next_temp", 0);
	return string_new("ZZZ");
	}
   temp_name[0] = 'T';
   temp_name[1] = '_';
   sprintf(&temp_name[2], "%d", temp_index);
   temp_index++;
   return string_new(temp_name);
   }

string get_next_temp_and_type(string *tp)
{
char temp_name[10];

   if (temp_index > temp_type_index) {
	cmp_err("Losing in get_next_temp", 0);
	return string_new("ZZZ");
	}
   temp_name[0] = 'T';
   temp_name[1] = '_';
   sprintf(&temp_name[2], "%d", temp_index);
   *tp = temp_types[temp_index];
   temp_index++;
   return string_new(temp_name);
   }

string simple_type_name(string type_name)
{
const char *tn = string_charp(type_name);

   char *cptr = index(tn, '[');
   if (cptr) {
	string ret = string_newn(tn, cptr-tn);
	return ret;
	}
   else return type_name;
   }

/* This routine returns FALSE if inv does not signal.			*/
/* This routine returns TRUE if inv signals.				*/
/* If this inv has at least one return value, the type of that value is */
/*	inserted in tp, else tp points to NULL.				*/

/* note: may need to do something about fevalues for mult returns	*/

bool inv_signalling(Invoc *inv, type *tp)
{
RoutineId *rid = inv->get_routineId();
TypeInterface *ti = rid->get_type();
method m = ti->get_method();

	*tp = NULL;
	if (!m) { sprintf(cmp_err_buf, 
			"Time to fix inv_signalling");
     		cmp_err(cmp_err_buf, inv->get_line());
     		return FALSE;
		}

	if (m->returns && vec_length(m->returns) != 0) {
	// seems that t could be picked off m->returns,
	// 	rather than wander through iti...
		TypeInterface *iti = inv->get_type();
		if (iti->tag() == TypeInterface::MultipleT) {
			vec v = iti->get_mult();
			if (!v || vec_length(v) < 1) {
				return TRUE;
				}
			type t = UNPV(type, vec_fetch(v, 0));
			*tp = t;
			}
		}
   	if (m->signals && vec_length(m->signals) != 0) {
		return TRUE;
	   }
	// doesn't signal
	return FALSE;
   }

bool inv_result_parmd(ParseNode *pn)
{
    TypeInterface *ti = NULL;
    switch (pn->tag()) {
	case ParseNode::ExprT: {
		Expr *ex = (Expr *)pn;
    		switch(ex->tag()) {
			case Expr::BracketRefT: {
	    		BracketRef *br = (BracketRef *)ex;
	    		Expr *prim = br->get_primary();
    	    		ti = prim->get_type();
        		}
        	    }
		break;
		}
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		RoutineId *rid = inv->get_routineId();
		ti = rid->get_type();
		break;
		}
	default: {
		cmp_err("unexpected pn in inv_result_parmd", pn->get_line());
		}
	    }
	if (ti == NULL) return FALSE;
	type t = NULL;
	switch (ti->tag()) {
		case TypeInterface::SingleT: {
			t = ti->get_type();
			break;
			}
		case TypeInterface::MultipleT: {
			vec v = ti->get_mult();
			if (vec_length(v)) t = 
				UNPV(type, vec_fetch(v, 0));
			break;
			}
		case TypeInterface::MethodT: {
			// first check the 1st return value type, if any
			method m = ti->get_method();
			vec v = m->returns;
			if (vec_length(v)) t = 
				UNPV(type, vec_fetch(v, 0));
			if (t == NULL) return FALSE;
    			if (type_kind(t) == INSTN_KIND) return TRUE;
    			if (type_kind(t) == CLASS_INSTN_KIND) return TRUE;
    			if (type_kind(t) == PARAM_KIND) return TRUE;
			// we have a return value which appears to be simple
			// 	let's check if it came from an instantiation
        		type slft = m->self_type;
			if (slft == 0) return FALSE;
        		if (type_kind(slft) != INSTN_KIND &&
			    type_kind(slft) != CLASS_INSTN_KIND) return FALSE;
			instn ins;
			if (type_kind(slft) == INSTN_KIND) 
				ins = type_as_instn(slft);
			if (type_kind(slft) == CLASS_INSTN_KIND)
				ins = class_instn_as_instn(
					type_as_class_instn(slft));
        		ptype pt = ins->hdr.methods->get_ptype(ins);
        		string nm = m->name;
			fevalue tgm_ret[2];
        		RESET_EXC
        		getMethod(type_as_objtype(ptype_as_type(pt)),
                                tgm_ret, nm);
        		CATCH { return FALSE; }
        		method pm = (method)tgm_ret[0].o;
			v = pm->returns;
			if (vec_length(v)) t = 
				UNPV(type, vec_fetch(v, 0));
			break;
			}
		}
    // may need a better test for array[int] etc from copy
    if (t == NULL) return FALSE;
    if (type_kind(t) == INSTN_KIND) return TRUE;
    if (type_kind(t) == CLASS_INSTN_KIND) return TRUE;
    if (type_kind(t) == PARAM_KIND) return TRUE;
    return FALSE;
    }
//	    if (prim->tag() == Expr::DotExprT) {
//		DotExpr *de = (DotExpr *)prim;
//		Expr *deprim = de->get_primary();
//	    	//  could check that id is fetch...
//	    	Id *id = de->get_id();
//		}

bool inv_parmd(method m)
{
type slf = m->self_type;

    if (!slf) return FALSE;	// may be hiding bugs
    if (type_kind(slf) == INSTN_KIND) return TRUE;
    if (type_kind(slf) == CLASS_INSTN_KIND) return TRUE;
    return FALSE;
    }
