// Copyright 1995 Barbara Liskov

#include "parse.h"
#include <stdio.h>
#include "string.h"
#include "my_string.h"
#include <unistd.h>
#include <ctype.h>
#include "types/objtype_class.h"
#include "types/vec.h"
#include "types/method.h"
#include "types/ptype.h"
#include "types/class.h"
#include "types/class_class.h"
#include "types/vec_instns.h"
#include "types/textwr.h"

#include "cg.h"

class_ save_stripped_class = 0;
objtype stripped_class(objtype ot)
{
    class_ oc = objtype_as_class(ot);
    int nst = vec_length(ot->supertypes_);
    if (nst == 0) {
	save_stripped_class = oc;
	return class_as_objtype(oc);
	}
    objtype t = type_as_objtype(UNPV(type, vec_fetch(ot->supertypes_, 0)));
    // first count up how many private methods there are
    int ntm = vec_length(t->methods_);
    int ncm = vec_length(oc->hdr.inh.methods_);
    int npriv = 0;
    for (int i = 0; i < ncm; i++) {
	method cm = UNPV(method, vec_fetch(oc->hdr.inh.methods_, i));
	string cm_name = method_name(cm);
	fevalue tgm_ret[2];
	RESET_EXC;
	if (the_obj) getMethod(the_obj, tgm_ret, cm_name);
	else exc = &exc_not_found;
	CATCH { npriv++; exc = EXC_NONE;}
	}

    // now, find those private methods again and save them in the
    //	stripped class
    int index = 0;
    vec v = make_vec_Method(npriv, FALSE);
    for (i = 0; i < ncm; i++) {
	method cm = UNPV(method, vec_fetch(oc->hdr.inh.methods_, i));
	string cm_name = method_name(cm);
	fevalue tgm_ret[2];
	RESET_EXC;
	if (the_obj) getMethod(the_obj, tgm_ret, cm_name);
	else exc = &exc_not_found;
	CATCH {vec_store(v, index, PV(cm)); index++; exc = EXC_NONE;}
	}
    class_ c = new_class();
    c->hdr.inh.methods_ = v;
    c->fields = oc->fields;
    c->superclass = oc->superclass;
    c->hdr.inh.name = oc->hdr.inh.name;
    c->special = oc->special;
    c->specialText = oc->specialText;
    c->hdr.inh.supertypes_ = oc->hdr.inh.supertypes_;
    // maybe fill in some more fields...
    save_stripped_class = c;
    return class_as_objtype(c);
    }


/*
	"Cluster" to remember current class, especially
	to determine if a variable is the name of an ivar.

*/

static ClassDef *save_cd = 0;
static RoutineDef *saved_rdef = 0;
void save_class(ClassDef *cd)
{
	save_cd = cd;
	}

void clear_class()
{
	save_cd = 0;
	}

ClassDef *get_save_class()
{
	return save_cd;
	}

void save_rdef(RoutineDef *rdef)
{
	saved_rdef = rdef;
	}

void clear_rdef()
{
	saved_rdef = 0;
	}

/* This routine is still dumb about classes in the current module other
	than the current class... */
bool is_ivar(Expr *prim, string nm, const char **c_name)
{
    /* look at standalone id and see if it's an ivar of current class */
    if (!prim) {
	if (save_cd) {
		ParseNodeList *dls = save_cd->get_decl();
		Decl *d = find_ivar_in_dl(nm, dls);
		string cname = save_cd->get_classId()->get_id();
		if (d) { *c_name = string_charp(cname); return TRUE; }
		else return FALSE;
		}
	else return FALSE;
        }
    /* look at id from a dot expr and see if it's an ivar of
			de's prim's class */
   else {
	TypeInterface *ti = prim->get_type();
	type t = get_one_type(ti, prim->get_line());
	if (t) {
		const char *tname = string_charp(type_name(t));
		if (save_cd && string_equal(type_name(t), 
			type_name(save_cd->get_type()->get_type())))
			{ *c_name = tname; return TRUE; }
		else {
		     RESET_EXC
		     class_ c = type_as_class(t);
		     CATCH { return FALSE; }
		     else {
			*c_name = tname; return TRUE;
			}
		    }
		}
	return FALSE;
	}
   }

bool is_method(string nm)
{
	if (save_cd) {
		ParseNodeList *celts = save_cd->get_classElts();
		if (celts) for (Pix p = celts->first(); p; celts->next(p)) {
			ClassElt *celt = (ClassElt *)(*celts)(p);
			if (celt->tag() == ClassElt::EquateT) continue;
			MethodOrOpDef *mop = (MethodOrOpDef *)celt;
			if (mop->get_isOp()) continue;
			RoutineDef *rd = mop->get_routineDef();
			RoutineIntf *ri = rd->get_routineIntf();
			string mname = ri->get_id()->get_id();
			if (string_equal(nm, mname)) return TRUE;
			}
		}
	return FALSE;
	}

string current_return_type()
{
	if (saved_rdef) {
		TypeInterface *ti = saved_rdef->get_type();
		method m = ti->get_method();
		if (m->returns && vec_length(m->returns) > 0) {
			type t = UNPV(type, vec_fetch(m->returns, 0));
			return simple_type_name(type_name(t));
			}
		}
	return string_empty();
	}

/* Routines to keep track of nested loops 				*/

/*   loop_counter is used for goto targets in xlating Theta breaks	*/
/*	inside while clauses 						*/
/*   Thus the C language "break" statement can be saved			*/
/*   for use inside switch statements, if desired.			*/

static loop_nesting = 0;
static loop_counter = 0;

void loop_init()
{
   loop_counter = 0;
   loop_nesting = 0;
   }

void loop_enter()
{
   if (loop_nesting == 0) loop_counter++;
   loop_nesting++;
   }

void loop_exit()
{
   loop_nesting--;
   }

void loop_end_label()
{
   ps("loop_");
   pint(loop_counter);;
   ps("_");
   pint(loop_nesting);;
   ps("_end:;\n");
   }

void loop_goto_end()
{
   ind();
   ps("goto loop_");
   pint(loop_counter);;
   ps("_");
   pint(loop_nesting);;
   ps("_end;\n");
   }

/* Routines to keep track of exception handling scopes 			*/

/*   exc_counter is used for goto targets in xlating Theta breaks	*/
/*	inside except and resignal statements. 				*/
/*   Note: the value of 0 for exc_nesting indicates that there is no	*/
/*	exception scope.						*/

static exc_nesting = 0;
static exc_counter = 0;

void exc_init()
{
   exc_nesting = 0;
   exc_counter = 0;
   }

void exc_enter()
{
   if (exc_nesting == 0)exc_counter++;
   exc_nesting++;
   }

void exc_exit()
{
   exc_nesting--;
   }

bool exc_scope_exists()
{
   if (exc_nesting) return TRUE;
   else return FALSE;
   }

void exc_label()
{
   ps("exc_");
   pint(exc_counter);;
   ps("_");
   pint(exc_nesting);;
   ps(":;\n");
   }

void exc_end_label()
{
   ps("exc_");
   pint(exc_counter);;
   ps("_");
   pint(exc_nesting);;
   ps("_end:;\n");
   }

void exc_goto_exc(bool tab)
{
   if (tab) ind();
   if (exc_nesting) {
   	ps("goto exc_");
   	pint(exc_counter);;
   	ps("_");
   	pint(exc_nesting);;
   	ps(";\n");
	}
   else {
	ps("UNHANDLED_EXC;\n");
	// The following is probably correct...
	// 	need to test it and check in runtime stuff
	//	before everybody sees it
	// ps("signal_failure(exc->name);\n");
	}
   }

void exc_goto_end()
{
   ind();
   ps("goto exc_");
   pint(exc_counter);;
   ps("_");
   pint(exc_nesting);;
   ps("_end;\n");
   }

/*
	Routines to emit DISCOVER, FIXUPREAD, FIXUPWRITE
*/

/* needs to be smarter about self vs. some other object */

static fix_scope = 0;
static int fix_read_count = 0;
static const char *fix_read_names[200];
static int fix_write_count = 0;
static const char *fix_write_names[200];
static int fix_fix_count = 0;
static const char *fix_fix_names[200];

void fix_clear()
{
	fix_scope = 0;
	fix_read_count = 0;
	fix_write_count = 0;
	fix_fix_count = 0;
	}

void fix_new_scope()
{
	fix_scope += 1;
	}

void fix_end_scope()
{
	fix_scope -= 1;
	}

/* This is a simple algorithm... */
bool fixed_read(const char *nm)
{
int i;
	for (i = 0; i < fix_read_count; i++) {
		if (!strcmp(nm, fix_read_names[i])) return TRUE;
		}
	if (fix_scope == 1) {
		fix_read_names[i] = nm;
		fix_read_count++;
		}
	return FALSE;
	}

bool fixed_write(const char *nm)
{
int i;
	for (i = 0; i < fix_write_count; i++) {
		if (!strcmp(nm, fix_write_names[i])) return TRUE;
		}
	if (fix_scope == 1) {
		fix_write_names[i] = nm;
		fix_write_count++;
		}
	return FALSE;
	}

bool fixed_fix(const char *nm)
{
int i;
	for (i = 0; i < fix_fix_count; i++) {
		if (!strcmp(nm, fix_fix_names[i])) return TRUE;
		}
	if (fix_scope == 1) {
		fix_fix_names[i] = nm;
		fix_fix_count++;
		}
	return FALSE;
	}

/* so far, nm appears to be an ivar */
void fix_read(string nm, type t, char *c_name)
{
bool mutable = TRUE;

	if (save_cd && save_cd->get_immutable()) mutable = FALSE;
	if (!fixed_read(c_name) && mutable) {
		ind();
		ps("FIXUPREAD(&((");
		ps(c_name);
		/* self just doesn't seem right here... */
		ps("_C)self)->hdr.inh");
		// will need something like the following when
		//	exist superclasses (see also ImplDecls)
		// do_supers(the_obj, ".hdr.inh");
		ps(");\n");
		}
	if (!fixed_read(string_charp(nm))) {
		ind();
		/* self just doesn't seem right here... */
		ps("DISCOVER(((");
                pcname();
		ps("_C)self)->");
		pstr(nm);
		ps(", ");
		if (t) pstr(simple_type_name(type_name(t)));
		else ps("OOPS");
		ps(");\n");
		}
	}

bool is_object(ParseNode *pn)
{
    TypeInterface *ti = pn->get_type();
    type t = ti->get_type();
    if (t == 0) {
	vec v = ti->get_mult();
	if (v && vec_length(v)) t = UNPV(type, vec_fetch(v, 0));
	}
    if (t == 0) return TRUE;
    if (t == class_as_type(Int) || 
	t == class_as_type(Null) || 
	t == class_as_type(Bool) || 
	t == class_as_type(Char) ||
        t == class_as_type(Real)) 
		return FALSE;
    return TRUE;
    }

/* so far, pn is not necessarily an ivar */
/* this code seems pretty hosed.  it's correct for the cases it covers... */
void fix_write(ParseNode *pn)
{
const char *c_name = "";

	/* if (is_object(pn) && save_cd && !fixed_write("self")) { */
	if (save_cd && !fixed_write("self")) {
		bool ivar = FALSE;
		switch (pn->tag()) {
		    case ParseNode::ExprT: {
    			Expr *ex = (Expr *)pn;
		        switch (ex->tag()) {
			    case Expr::IdExprT: {
			        IdExpr *ide = (IdExpr *)ex;
				if (is_ivar(0, ide->get_id()->get_id(), &c_name))
					ivar = TRUE;
				break;
				}
			    case Expr::DotExprT: {
				DotExpr *de = (DotExpr *)ex;
				Expr *prim = de->get_primary();
				if (prim->tag() == Expr::SelfT) ivar = TRUE;
				break;
				}
			    default: {
				cmp_err("Unexpected expr in fix_write",
						pn->get_line());
				}
		 	     }
			 break;
			 }
		    default: {
			cmp_err("Unexpected pn in fix_write",
						pn->get_line());
			}
		    }
		if (!ivar) return;
		ind();
		ps("FIXUPWRITE(&((");
		psc(c_name);
		ps("_C)self)->hdr.inh");
		// will need something like the following when
		//	exist superclasses
		// do_supers(the_obj, ".hdr.inh");
		ps(");\n");
		}
	}

void fix_fix(DotExpr *de)
{
Expr *prim = de->get_primary();
TypeInterface *dti = de->get_type();
TypeInterface *pti = prim->get_type();
type t = get_one_type(pti, prim->get_line());
type dt = get_one_type(dti, de->get_line());
string tnm, dtnm;

	if (prim->tag() == Expr::SelfT) return;
	if (dti->tag() == TypeInterface::MethodT) return;
	if (!t) {
		cmp_err("compiler error: fix_fix: missing type info\n",
				de->get_line());
		return;
		}
	tnm = simple_type_name(type_name(t));
	if (!strcmp(string_charp(tnm), "int")
		|| !strcmp(string_charp(tnm), "bool")
		|| !strcmp(string_charp(tnm), "char")
		|| !strcmp(string_charp(tnm), "real")
		|| !strcmp(string_charp(tnm), "null")
		) return;
	if (prim->tag() != Expr::IdExprT) {
		cmp_err("compiler error: fix_fix: unexpected expr for prim\n",
				prim->get_line());
		return;
		}
	IdExpr *ide = (IdExpr *)prim;
	if (!fixed_fix(string_charp(ide->get_id()->get_id()))) {
		dtnm = simple_type_name(type_name(dt));
		ind();
		ps("FIX(");
		expr_emit(prim);
		ps(", ");
		pstr(tnm);
		ps(");\n");
		ind();
		ps("DISCOVER(((");
		pstr(tnm);
		ps("_C)");
		expr_emit(prim);
		ps(")->");
		pstr(de->get_id()->get_id());
		ps(", ");
		pstr(dtnm);
		ps(");\n");
		}
	}

string type2nm(type t)
{
string tname = type_name(t);
const char *tnm = string_charp(tname);

	textwr tw = textwr_new();
	wr w = textwr_as_wr(tw);
	int len = string_length(tname);
	for (int i = 0; i < len; i++) {
		char c = tnm[i];
		switch (c) {
			case '[': { wr_putChars(w, "_OF_"); break; }
			case ',': { wr_putChars(w, "_AND_"); break; }
			case ']': break;
			case ' ': break;
			default: { wr_putChar(w, c); break; }
			}
		}
	wr_close(w);
	return textwr_toString(tw);
	}

void do_closing(RoutineDef *rd)
{
	RoutineIntf *ri = rd->get_routineIntf();
	Signature *sig = ri->get_signature();
	ParseNodeList *rets = sig->get_returns();
	if (!rets || rets->length() == 0) return;
	inc_ind();
	ind();
	ps("signal_failure_no_return_values();\n");
	dec_ind();
	}

/* 	
	This cluster remembers whether preprocessing should be
	forced to happen.  Currently it is forced for primaries
	of Dot Expressions.
*/

// #define MAX_EXPR_DEPTH 100
// static bool nesting[MAX_EXPR_DEPTH];

static int prep_depth = 0;

bool forced_prep()
{
	if (prep_depth != 0) return TRUE;
	else return FALSE;
	}

void enter_forced_prep()
{
	prep_depth++;
	}

void leave_forced_prep()
{
	prep_depth--;
	}
