// Copyright 1995 Barbara Liskov


#include <string.h>
#include "parse.h"
#include "my_string.h"
#include "cg.h"
extern "C" {
#include "types/type.h"
#include "types/class_instn.h"
#include "types/array.h"
#include "types/maybe.h"
}

void srch_pnl_for_types(ParseNodeList *pnl);
void process_typespecl(ParseNodeList *pnl);
void process_typespec(TypeSpec *ts, bool class_too);
void process_ti(TypeInterface *ti, bool class_too);
void process_routine_id(RoutineId *rid);
void save_type(type t, string tn, bool class_too);
void save_rtn(method m, string mname);
void save_pts(type t);
void save_crid_pts(ComplexRoutineId *crid);
void output_def(string tn);
void output_type(string tn);
void output_class(string tn);
void output_rtn(string mn);
string ts2nm(TypeSpec *ts, int line);

/* 	
	Searches for types used in parse node(s) so 
	that appropriate #include lines can be generated
*/

/* Some recent changes that added consideration of equates
   appear unnecessary and aren't used. */




void srch_pnl_for_types(ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	ParseNode *pn = (ParseNode *)(*pnl)(p);
	srch_pn_for_types(pn);
	}
   }

void srch_pn_for_types(ParseNode *pn)
{
   if (pn) switch (pn->tag()) {
	case ParseNode::ImplEltT: {
		ImplElt *ie = (ImplElt *)pn;
		switch (ie->tag()) {
			case ImplElt::RoutineDefT: {
				RoutineDef *rd = (RoutineDef *)pn;
				srch_pn_for_types(rd->get_routineIntf());
				srch_pn_for_types(rd->get_body());
				break;
				}
			case ImplElt::ClassDefT: {
				ClassDef *cd = (ClassDef *)pn;
				srch_pnl_for_types(cd->get_decl());
				srch_pnl_for_types(cd->get_classElts());
				srch_pnl_for_types(cd->get_equates());
				break;
				}
			case ImplElt::ImplEquateT: {
				ImplEquate *ieq = (ImplEquate *)ie;
				srch_pn_for_types(ieq->get_equate());
				break;
				}
			}
		break;
		}
	case ParseNode::SpecEltT: {
		SpecElt *se = (SpecElt *)pn;
		switch (se->tag()) {
			case SpecElt::TypeIntfT: {
				TypeIntf *tin = (TypeIntf *)se;
				srch_pnl_for_types(tin->get_methods());
				break;
				}
			case SpecElt::SpecEquateT: {
				SpecEquate *seq = (SpecEquate *)se;
				srch_pn_for_types(seq->get_equate());
				break;
				}
			}
		break;
		}
	case ParseNode::MethodOrOpDefT: {
		MethodOrOpDef *mopd = (MethodOrOpDef *)pn;
		srch_pn_for_types(mopd->get_routineDef());
		break;
		}
	case ParseNode::RoutineIntfT: {
		RoutineIntf *ri = (RoutineIntf *)pn;
		srch_pn_for_types(ri->get_signature());
		break;
		}
	case ParseNode::SignatureT: {
		Signature *sig = (Signature *)pn;
		srch_pnl_for_types(sig->get_args());
		process_typespecl(sig->get_returns());
		srch_pnl_for_types(sig->get_signals());
		break;
		}
	case ParseNode::FormalT: {
		Formal *f = (Formal *)pn;
		process_typespec(f->get_typeSpec(), FALSE);
		break;
		}
	case ParseNode::ExceptionT: {
		Exception *ex = (Exception *)pn;
		process_typespecl(ex->get_typeSpec());
		break;
		}
	case ParseNode::DeclT: {
		Decl *d = (Decl *)pn;
		TypeSpec *ts;
		switch (d->tag()) {
			case Decl::RegDeclT: {
				RegDecl *rd = (RegDecl *)d;
				ts = rd->get_typeSpec();
				break;
				}
			case Decl::ImplDeclT: {
				ImplDecl *imd = (ImplDecl *)d;
				ts = imd->get_typeSpec();
				break;
				}
			case Decl::VarArgsDeclT: {
				VarArgsDecl *vd = (VarArgsDecl *)d;
				ts = vd->get_typeSpec();
				break;
				}
			}
		process_typespec(ts, FALSE);
		break;
		}
	case ParseNode::ActualParmT: {
		ActualParm *ap = (ActualParm *)pn;
		TypeSpec *ts = ap->get_typeSpec();
		process_typespec(ts, FALSE);
		break;
		}
	case ParseNode::TagWhenArmT: {
		TagWhenArm *twa = (TagWhenArm *)pn;
		srch_pn_for_types(twa->get_decl());
		srch_pn_for_types(twa->get_body());
		break;	
		}
	case ParseNode::TypeWhenArmT: {
		TypeWhenArm *twa = (TypeWhenArm *)pn;
		process_typespec(twa->get_typ(), FALSE);
		srch_pn_for_types(twa->get_body());
		break;	
		}
	case ParseNode::ExWhenArmT: {
		ExWhenArm *ewa = (ExWhenArm *)pn;
		srch_pnl_for_types(ewa->get_decls());
		srch_pn_for_types(ewa->get_body());
		break;	
		}
	case ParseNode::OthersHandlerT: {
		OthersHandler *oh = (OthersHandler *)pn;
		process_typespec(oh->get_typeSpec(), FALSE);
		srch_pn_for_types(oh->get_body());
		break;	
		}
	case ParseNode::ElseIfT: {
		ElseIf *els = (ElseIf *)pn;
		srch_pn_for_types(els->get_expr());
		srch_pn_for_types(els->get_body());
		break;	
		}
	case ParseNode::BodyT: {
		Body *b = (Body *)pn;
		srch_pnl_for_types(b->get_equates());
		srch_pnl_for_types(b->get_statements());
		break;	
		}
	case ParseNode::ExprT: {
		Expr *ex = (Expr *)pn;
		switch (ex->tag()) {
		   case Expr::SelectorConstrT: {
			SelectorConstr *sc = (SelectorConstr *)ex;
			process_typespec(sc->get_typeSpec(), TRUE);
			srch_pnl_for_types(sc->get_fields());
			break;
			}
		   case Expr::InvocExprT: {
			InvocExpr *inve = (InvocExpr *)ex;
			Invoc *inv = inve->get_invoc();
			srch_pn_for_types(inv);
			break;
			}
		   case Expr::DotExprT: {
			DotExpr *de = (DotExpr *)ex;
			Expr *prim = de->get_primary();
			srch_pn_for_types(prim);
			break;
			}
		   case Expr::ArrayRefT: {
			ArrayRef *ar = (ArrayRef *)ex;
			Expr *arex = ar->get_expr();
			srch_pn_for_types(arex);
			Expr *prim = ar->get_primary();
			srch_pn_for_types(prim);
			break;
			}
		   case Expr::UnaryT: {
			Unary *un = (Unary *)ex;
			Expr *op = un->get_op();
			srch_pn_for_types(op);
			break;
			}
		   case Expr::BinaryT: {
			Binary *bin = (Binary *)ex;
			Expr *op1 = bin->get_op1();
			srch_pn_for_types(op1);
			Expr *op2 = bin->get_op2();
			srch_pn_for_types(op2);
			break;
			}
		   case Expr::BracketRefT: {
			BracketRef *br = (BracketRef *)ex;
			ParseNodeList *brexprs = br->get_exprs();
			srch_pnl_for_types(brexprs);
			Expr *prim = br->get_primary();
			srch_pn_for_types(prim);
			break;
			}
		   case Expr::ArrayConstrT: {
			ArrayConstr *ac = (ArrayConstr *)ex;
			process_typespec(ac->get_typeSpec(), TRUE);
			srch_pn_for_types(ac->get_size());
			srch_pnl_for_types(ac->get_exprs());
			break;
			}
		   }
		// need to add brace arrayconstr, binding...  
		// to find invocations of stand-alone routines...
		break;
		}
	case ParseNode::FieldInitT: {
		FieldInit *fi = (FieldInit *)pn;
		srch_pn_for_types(fi->get_expr());
		break;
		}
	case ParseNode::FieldT: {
		Field *f = (Field *)pn;
		process_typespec(f->get_typeSpec(), TRUE);
		break;
		}
	case ParseNode::InvocT: {
		Invoc *inv = (Invoc *)pn;
		process_ti(inv->get_type(), TRUE);
		srch_pn_for_types(inv->get_routineId());
		srch_pnl_for_types(inv->get_exprs());
		srch_pnl_for_types(inv->get_lastarg());
		break;
		}
	case ParseNode::RoutineIdT: {
		RoutineId *rid = (RoutineId *)pn;
		process_routine_id(rid);
		switch (rid->tag()) {
			case RoutineId::SimpleRoutineIdT: {
				SimpleRoutineId *srid = (SimpleRoutineId *)rid;
				srch_pn_for_types(srid->get_primary());
				break;
				}
			case RoutineId::ComplexRoutineIdT: {
				ComplexRoutineId *crid = (ComplexRoutineId *)rid;
				srch_pn_for_types(crid->get_primary());
				srch_pnl_for_types(crid->get_parms());
				save_crid_pts(crid);
				break;
				}
			}
		break;
		}
	case ParseNode::StmtT: {
		Stmt *stmt = (Stmt *)pn;
		switch (stmt->tag()) {
		   case Stmt::DeclStmtT: {
			DeclStmt *d = (DeclStmt *)stmt;
			srch_pn_for_types(d->get_decl());
			break;
			}
		   case Stmt::InitVarExprT: {
			InitVarExpr *ive = (InitVarExpr *)stmt;
			srch_pn_for_types(ive->get_decl());
			srch_pn_for_types(ive->get_expr());
			break;
			}
		   case Stmt::InitVarInvokeT: {
			InitVarInvoke *ivi = (InitVarInvoke *)stmt;
			srch_pnl_for_types(ivi->get_decls());
			srch_pn_for_types(ivi->get_invoc());
			break;
			}
		   case Stmt::AssignExprStmtT: {
			AssignExprStmt *aes = (AssignExprStmt *)stmt;
			srch_pnl_for_types(aes->get_exprs());
			break;
			}
		   case Stmt::DeclForStmtT: {
			DeclForStmt *dfs = (DeclForStmt *)stmt;
			srch_pnl_for_types(dfs->get_decls());
			srch_pn_for_types(dfs->get_invoc());
			srch_pn_for_types(dfs->get_body());
			break;
			}
		   case Stmt::ForStmtT: {
			ForStmt *fs = (ForStmt *)stmt;
			srch_pn_for_types(fs->get_invoc());
			srch_pn_for_types(fs->get_body());
			break;
			}
		   case Stmt::ExceptStmtT: {
			ExceptStmt *exs = (ExceptStmt *)stmt;
			srch_pn_for_types(exs->get_stmt());
			srch_pnl_for_types(exs->get_exWhenArm());
			srch_pn_for_types(exs->get_decl());
			srch_pn_for_types(exs->get_body());
			}
		   case Stmt::InvokeStmtT: {
			InvokeStmt *invs = (InvokeStmt *)stmt;
			srch_pn_for_types(invs->get_invoc());
			break;
			}
		   case Stmt::WhileStmtT: {
			WhileStmt *wh = (WhileStmt *)stmt;
			srch_pn_for_types(wh->get_expr());
			srch_pn_for_types(wh->get_body());
			break;
			}
		   case Stmt::IfStmtT: {
			IfStmt *ifst = (IfStmt *)stmt;
			srch_pn_for_types(ifst->get_expr());
			srch_pn_for_types(ifst->get_body());
			srch_pnl_for_types(ifst->get_elseifs());
			srch_pn_for_types(ifst->get_elsebody());
			break;
			}
		   case Stmt::TypecaseT: {
			Typecase *tp = (Typecase *)stmt;
			srch_pn_for_types(tp->get_expr());
			srch_pnl_for_types(tp->get_typeWhenArms());
			srch_pn_for_types(tp->get_body());
			break;
			}
		   case Stmt::TagcaseT: {
			Tagcase *tg = (Tagcase *)stmt;
			srch_pn_for_types(tg->get_expr());
			srch_pnl_for_types(tg->get_tagWhenArms());
			srch_pn_for_types(tg->get_body());
			break;
			}
		   case Stmt::InitT: {
			Init *init = (Init *)stmt;
			srch_pnl_for_types(init->get_fieldInits());
			srch_pn_for_types(init->get_invoc());
			srch_pn_for_types(init->get_body());
			break;
			}
		   case Stmt::BlockStmtT: {
			BlockStmt *b = (BlockStmt *)stmt;
			srch_pn_for_types(b->get_body());
			break;	
			}
		   case Stmt::ResignalStmtT: {
			ResignalStmt *rs = (ResignalStmt *)stmt;
			srch_pn_for_types(rs->get_stmt());
			break;	
			}
		   case Stmt::ReturnStmtT: {
			ReturnStmt *rt = (ReturnStmt *)stmt;
			srch_pnl_for_types(rt->get_exprs());
			break;	
			}
		   case Stmt::YieldT: {
			Yield *y = (Yield *)stmt;
			srch_pnl_for_types(y->get_exprs());
			break;	
			}
		   case Stmt::SignalStmtT: {
			SignalStmt *s = (SignalStmt *)stmt;
			srch_pnl_for_types(s->get_exprs());
			break;	
			}
		   case Stmt::ExitT: {
			Exit *s = (Exit *)stmt;
			srch_pnl_for_types(s->get_exprs());
			break;	
			}
		   }
		break;
		}
	}
   }

void process_typespecl(ParseNodeList *pnl)
{
   if (pnl) for (Pix p = pnl->first(); p ; pnl->next(p)){
	TypeSpec *ts = (TypeSpec *)(*pnl)(p);
	process_typespec(ts, FALSE);
	}
   }

void process_type(type t, bool class_too)
{
   if (type_kind(t) == CLASS_INSTN_KIND) {
	// loop through parameters...
	class_instn ci = type_as_class_instn(t);
	vec pargs = class_instn_get_pargs(ci);
	int np = vec_length(pargs);
	for (int i = 0; i < np; i++) {
		process_type(UNPV(type, vec_fetch(pargs, i)), class_too);
		}
	save_type(t, simple_type_name(type_name(t)), class_too);
	save_pts(t);
	}
   else save_type(t, simple_type_name(type_name(t)), class_too);
   }

void process_ti(TypeInterface *ti, bool class_too)
{
   type t = get_one_type(ti, 101);
   if (t) process_type(t, class_too);
   }

void process_typespec(TypeSpec *ts, bool class_too)
{
   TypeInterface *ti = ts->get_type();
   type t = ti->get_type();
   switch (ts->tag()) {
	case TypeSpec::SimpleTypeSpecT: {
		SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
		save_type(t, simple_type_name(type_name(t)), class_too);
		if (type_kind(t) == CLASS_INSTN_KIND) {
			save_pts(t);
			}
		break;
		}
	case TypeSpec::ParamTypeSpecT: {
		ParamTypeSpec *pts = (ParamTypeSpec *)ts;
		ParseNodeList *apl = pts->get_actualParms();
                for (Pix p = apl->first(); p ; apl->next(p)) {
                        ActualParm *ap = (ActualParm *)(*apl)(p);
                        TypeSpec *apts = ap->get_typeSpec();
                        process_typespec(apts, class_too);
                        }
		save_type(t, simple_type_name(type_name(t)), class_too);
		save_pts(t);
		break;
		}
	case TypeSpec::TaggedTypeSpecT: {
		break;
		}
	case TypeSpec::RoutineTypeSpecT: {
		break;
		}
	}
   }

void process_routine_id(RoutineId *rid)
{
   switch (rid->tag()) {
	case RoutineId::SimpleRoutineIdT: {
		SimpleRoutineId *srid = (SimpleRoutineId *)rid;
		Expr *ex = srid->get_primary();
		switch (ex->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)ex;
				TypeInterface *ti = srid->get_type();
				method m = ti->get_method();
				save_rtn(m, method_name(m));
				break;
				}
			}
		break;
		}
	case RoutineId::ComplexRoutineIdT: {
		break;
		}
	case RoutineId::SuperClassRoutineIdT: {
		break;
		}
	}
   }

static int type_name_index = 0;
static int rtn_name_index = 0;
static string type_names[100];
static string rtn_names[100];
static type types[100];
static method rtns[100];
static bool class_names[100];

#include "types/class.h"
#include "types/objtype_class.h"

void save_type(type t, string tn, bool class_too)
{
int i;
class_ c;

   RESET_EXC
   c = type_as_class(t);
   CATCH { c = 0; }
   else {
	objtype ot = type_as_objtype(t);
	if (ot->supertypes_ && vec_length(ot->supertypes_)) {
		type st = UNPV(type, vec_fetch(ot->supertypes_, 0));
		save_type(st, type_name(st), FALSE);
		}
	}
   for (i = 0; i < type_name_index ; i++) {
	if (string_equal(type_names[i], tn)) return;
	}
   types[type_name_index] = t;
   type_names[type_name_index] = tn;
   class_names[type_name_index] = class_too;
   if (c) class_names[type_name_index] = TRUE;
	else class_names[type_name_index] = FALSE;
   type_name_index++;
   }

void save_rtn(method m, string mname)
{
int i;

   if (is_method(mname)) return;
   for (i = 0; i < rtn_name_index ; i++) {
	if (string_equal(rtn_names[i], mname)) return;
	}
   rtns[rtn_name_index] = m;
   rtn_names[rtn_name_index] = mname;
   rtn_name_index++;
  }

void clear_types()
{
   type_name_index = 0;
   rtn_name_index = 0;
   }

void output_types()
{
int i;

   for (i = 0; i < type_name_index ; i++) {
	output_def(type_names[i]);
	}
   for (i = 0; i < type_name_index ; i++) {
	output_type(type_names[i]);
	}
   for (i = 0; i < type_name_index ; i++) {
	if (class_names[i]) output_class(type_names[i]);
	}
   for (i = 0; i < rtn_name_index ; i++) {
	output_rtn(rtn_names[i]);
	}
   }

void output_def(string tn)
{
string stn = simple_type_name(tn);

   if (!string_equal(tn, string_new("int")) &&
       !string_equal(tn, string_new("bool")) &&
       !string_equal(tn, string_new("string")) &&
       !string_equal(tn, string_new("real")) &&
       !string_equal(tn, string_new("null")) &&
       !string_equal(tn, string_new("char")) &&
       !string_equal(tn, string_new("any"))
	) {
   	ps("#include \"");
   	pstr(stn);
   	ps("_def.h\"\n");
	}
   }

void output_rtn(string rn)
{
   if (!strcmp(string_charp(rn), "any_equal")) return;

   ps("#include \"");
   if (!strcmp(string_charp(rn), "same_object"))
	ps("runtime/");
   pstr(simple_type_name(rn));
   ps(".h\"\n");
   }

void output_type(string tn)
{
string stn = simple_type_name(tn);

   if (string_equal(stn, string_new("empty_maybe")))
	stn = string_new("maybe");

   if (string_equal(stn, string_new("int")) ||
       string_equal(stn, string_new("bool")) ||
       string_equal(stn, string_new("string")) ||
       string_equal(stn, string_new("real")) ||
       string_equal(stn, string_new("null")) ||
       string_equal(stn, string_new("char")) ||
       string_equal(stn, string_new("array")) ||
       string_equal(stn, string_new("vector")) ||
       string_equal(stn, string_new("sequence")) ||
       string_equal(stn, string_new("vec")) ||
       string_equal(stn, string_new("any")) ||
       string_equal(stn, string_new("maybe"))
        ) {
	if (string_equal(stn, string_new("string"))) 
				stn = string_new("str");
   	ps("#include \"types/");
   	pstr(stn);
   	ps(".h\"\n");
	}
   else {
   	ps("#include \"");
   	pstr(stn);
   	ps(".h\"\n");
   	ps("#include \"");
   	pstr(stn);
   	ps("_meth.h\"\n");
	}
   }

void output_class(string tn)
{
   if (string_equal(tn, string_new("int")) ||
       string_equal(tn, string_new("bool")) ||
       string_equal(tn, string_new("string")) ||
       string_equal(tn, string_new("real")) ||
       string_equal(tn, string_new("null")) ||
       string_equal(tn, string_new("char")) ||
       string_equal(tn, string_new("any"))) return;

   if (string_equal(tn, string_new("empty_maybe")))
	tn = string_new("maybe");

   if (string_equal(tn, string_new("array")) ||
	string_equal(tn, string_new("vector")) ||
	string_equal(tn, string_new("sequence")) ||
	string_equal(tn, string_new("maybe"))) {
   	ps("#include \"types/");
   	pstr(simple_type_name(tn));
   	ps("_class.h\"\n");
        return;
	}
   ps("#include \"");
   pstr(simple_type_name(tn));
   ps("_class.h\"\n");
   ps("extern class_ ");
   pstr(simple_type_name(tn));
   ps("V;\n");
   }

#define MAX_PTS 100
static type saved_global_pts[MAX_PTS];
static global_pts_index = 0;
static type saved_pts[MAX_PTS];
static pts_index = 0;

// Review vs. type equates...

void save_crid_pts(ComplexRoutineId *crid)
{
// Large Hack.......
	TypeInterface *cti = crid->get_type();
	method cm = cti->get_method();
	type crt = UNPV(type, vec_fetch(cm->returns, 0));
	save_pts(crt);

//	Expr *ex = crid->get_primary();
//	switch (ex->tag()) {
//		case Expr::IdExprT: {
//			IdExpr *ide = (IdExpr *)ex;
//			string nm = ide->get_id()->get_id();
//			string nm2 = 0;
//			if (string_equal(nm, string_new("array_new")))
//				nm2 = string_new("array");
//			if (string_equal(nm, string_new("vector_fill")))
//				nm2 = string_new("vector");
//			if (string_equal(nm, string_new("vector_create")))
//				nm2 = string_new("vector");
//			if (string_equal(nm, string_new("sequence_create"))) 
//				nm2 = string_new("sequence");
//			if (nm2) {
//				TypeInterface *ti = ex->get_type();
//				method m = ti->get_pmethod();
//				type rt = UNPV(type, vec_fetch(m->returns, 0));
//				save_pts(rt);
//				}
//			break;
//			}
//	        default: {
 //               	cmp_err("crid2instn: unexpected expr", crid->get_line());
  //              }
//
//	}
}

void save_pts(type t)
{
class_instn ci;
vec pargs;
int i, sz;

	if (pts_index >= MAX_PTS) {
		th_fail("save_pts: increase MAX_PTS and recompile\n");
		}
	if (t == 0 || type_kind(t) != CLASS_INSTN_KIND) {
		cmp_err("compiler error: save_pts: unexpected type", 1);
		return;
		}
	ci = type_as_class_instn(t);
	if (!ci) {
		cmp_err("compiler error: save_pts: not a class_instn", 1);
		return;
		}
	/* recurse on pargs, calling save_pts on any parameterized type */
	pargs = class_instn_get_pargs(ci);
	sz = vec_length(pargs);
	for (i = 0; i < sz; i++) {
		type pargt = UNPV(type, vec_fetch(pargs, i));
		save_type(pargt, simple_type_name(type_name(pargt)), FALSE);
		if (type_kind(pargt) == CLASS_INSTN_KIND) save_pts(pargt);
		}
		
	/* do save_pts for the vec needed for an array */
	string stn = simple_type_name(type_name(t));
	if (!strcmp(string_charp(stn), "array")) {
		class_instn vci = array_ci_get_vci(ci);
		type vt = class_as_type(class_instn_as_class(vci));
		save_pts(vt);
		}

	/* do save_pts for the empty_maybe class corresponding to a maybe */
	if (!strcmp(string_charp(stn), "maybe")) {
		class_instn emci = maybe_ci_get_emci(ci);
		type et = class_as_type(class_instn_as_class(emci));
		save_pts(et);
		}

	/* check if type has already been saved locally */
	for (i = 0; i < pts_index; i++) {
		// The following is a little overkill because isSubtype in ci's
		//	currently only tests equality.
		if (isSubtype(t, saved_pts[i]) && isSubtype(saved_pts[i], t)) return;
		// The following will be preferred when instantiations are unique
		// if (t->methods->equal(t, saved_pts[i])) return;
		}
	saved_pts[pts_index] = t;
	pts_index++;

	/* check if type has already been saved globally */
	for (i = 0; i < global_pts_index; i++) {
		// The following is a little overkill because isSubtype in ci's
		//	currently only tests equality.
		if (isSubtype(t, saved_global_pts[i]) 
				&& isSubtype(saved_global_pts[i], t)) return;
		// The following will be preferred when instantiations are unique
		// if (t->methods->equal(t, saved_global_pts[i])) return;
		}
	saved_global_pts[global_pts_index] = t;
	global_pts_index++;
}

void clear_pts()
{
	pts_index = 0;
}

void clear_global_pts()
{
	global_pts_index = 0;
}

void output_pts_decls()
{
	for (int i = 0; i < global_pts_index; i++) {
		string nm_basic = type2nm(saved_global_pts[i]);
		string nm = string_concat(nm_basic, string_new("_CIXXXX"));
		ps("#ifndef ");
		pstr(nm);
		ps("\n");
		ps("#define ");
		pstr(nm);
		ps("\n");
		ps("class_instn ");
		pstr(nm_basic);
		ps("V = 0;\n");
		ps("#endif\n");
		}
	}

void output_pts_externs()
{
	for (int i = 0; i < pts_index; i++) {
		string nm_basic = type2nm(saved_pts[i]);
		ps("extern class_instn ");
		pstr(nm_basic);
		ps("V;\n");
		}
	}

void output_pts_data()
{
	for (int i = 0; i < global_pts_index; i++) {
		string nm_basic = type2nm(saved_global_pts[i]);
		pstr(nm_basic);
		ps("\t");
		pstr(nm_basic);
		ps ("V\tFALSE\tWK_");
		pstr(nm_basic);
		ps("_OREF\t0\n");
		}
	}

void output_pts_instns()
{
	for (int i = 0; i < pts_index; i++) {
		ps("if (");
		pstr(type2nm(saved_pts[i]));
		ps("V == 0) {\n");
		inc_ind();
		type t = saved_pts[i];
		/* work on actuals via pargs */
		class_instn ci = type_as_class_instn(t);
		vec pargs = class_instn_get_pargs(ci);
		int sz = vec_length(pargs);
		for (int j = 0; j < sz ; j++) {
			type at = UNPV(type, vec_fetch(pargs, j));
			ind();
			ps("SET_PARAM(");
			pint(j);
			ps(", ");
			pstr(type2nm(at));
			ps("V);\n");
			}
		ind();
		string ptnm = simple_type_name(type_name(saved_pts[i]));
		pstr(type2nm(saved_pts[i]));
		ps("V = ");
		pstr(ptnm);
		ps("V->hdr.methods->instantiate(");
		pstr(ptnm);
		ps("V, PARAMS);\n}\n");
		dec_ind();
		}
	}

/* The following are currently unused */

bool pts_equal(ParamTypeSpec *pts1, ParamTypeSpec *pts2);

bool ts_equal(TypeSpec *ts1, TypeSpec *ts2)
{
	if (ts1 == ts2) return TRUE;
	switch (ts1->tag()) {
		case TypeSpec::SimpleTypeSpecT: {
			SimpleTypeSpec *sts1  = (SimpleTypeSpec *)ts1;
			if (ts2->tag() == TypeSpec::SimpleTypeSpecT) {
				SimpleTypeSpec *sts2  = (SimpleTypeSpec *)ts2;
				return string_equal(
					sts1->get_name()->get_name()->get_id(), 
					sts2->get_name()->get_name()->get_id());
				}
			break;
			}
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts1  = (ParamTypeSpec *)ts1;
			if (ts2->tag() == TypeSpec::ParamTypeSpecT) {
				ParamTypeSpec *pts2  = (ParamTypeSpec *)ts2;
				return pts_equal(pts1, pts2);
				}
			break;
			}
		}
	return FALSE;
	}

bool pts_equal(ParamTypeSpec *pts1, ParamTypeSpec *pts2)
{
	if (pts1 == pts2) return TRUE;
	if (!string_equal(pts1->get_name()->get_name()->get_id(),
		pts2->get_name()->get_name()->get_id())) return FALSE;
	ParseNodeList *apl1 = pts1->get_actualParms();
	ParseNodeList *apl2 = pts2->get_actualParms();
	Pix p, q;
	for (p = apl1->first(), q = apl2->first(); p; apl1->next(p),
			apl2->next(q)) {
		ActualParm *ap1 = (ActualParm *)(*apl1)(p);
		ActualParm *ap2 = (ActualParm *)(*apl2)(q);
		TypeSpec *ts1 = ap1->get_typeSpec();
		TypeSpec *ts2 = ap2->get_typeSpec();
		if (!ts_equal(ts1, ts2)) return FALSE;
		}
	return TRUE;
	}
