// Copyright 1995 Barbara Liskov

// #define YYDEBUG
extern "C" {

#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdio.h>

/*
#include "types/vec.h"
#include "types/string_class.h"
#include "gen-include.h"
#include "types/dict.h"
#include "types/any.h"
#include "types/vec_class.h"
#include "types/method.h"
#include "types/class.h"
#include "types/class_class.h"

#include "type_init.h"
#include "runtime/disphdr.h"
#include "runtime/alloc.h"
*/

#include <ctype.h>
#include <stdlib.h>

#include "lx_input.h"
}

#include "compiler.h"
#include "environment.h"
#include "desugar.h"
#include "type_replace.h"
#include "type_chk.h"

extern int cmpyy_debug;
extern void fix_class_supertypes(ParseNodeList *pnl);
extern void theta_env_init();

int match_ids(Id *i1, Id *i2)
{
    // printf("%lX %lX\n", (char*)i1, (char*)i2);
    string j = i1->get_id();
    string k = i2->get_id();
    // printf("%s %s\n", j->chars, k->chars);
    if (!string_equal(i1->get_id(), i2->get_id())) {
      cmpyy_error("Id's do not match.");
      return -1;
    }
    else return 0;
}

ParseNodeList *trav_null(ParseNodeList *lp)
{
	printf(" here in balmy trav_null\n");
	return(lp);
}

int phase = 0;
int lineno = 1;
static Environment *env = 0;

string theta_compile(FILE *src, string nm)
{
    if (!env) theta_env_init();
    file_parse(src);
    if (err_list != NULL) return err_list;

    do_phases(parse_tree, COMPILE, nm);
    exc = EXC_NONE;
    if (err_list != NULL) return err_list;
    else return string_new("ok");
   
}

string theta_check(FILE *src, string nm)
{
    if (!env) theta_env_init();
    file_parse(src);
    if (err_list != NULL) return err_list;

    do_phases(parse_tree, CHECK, nm);
    exc = EXC_NONE;
    if (err_list != NULL) return err_list;
    else return string_new("ok");
}

string theta_parse(FILE *src, string nm)
{
    file_parse(src);
    if (err_list != NULL) return err_list;
    else return string_new("ok");
}

string theta_show()
{

    exc = EXC_NONE;
    if (!env) return string_new("none");
    return env->unparse();
   
}

string theta_expunge()
{
    env = 0;
    exc = EXC_NONE;
    return string_new("ok");
   
}

void theta_env_init()
{
  /* Set up basic type environment */
  if (!env) {
	env = my_basic_env();
	string_parse(
		"array_new[t] () returns (array[t])"
		"print (message: string)"
		"vector_fill[t] (size: int, elem: t) returns (vector[t])"
		"any_equal (a1: any, a2: any) returns (bool)"
		);
    	if (err_list != NULL) th_fail("theta_env_init failure #1");
    	do_phases(parse_tree, CHECK, string_empty());
    	if (err_list != NULL) th_fail("theta_env_init failure #2");
	}
}

/* 
   yay for yacc... 
   The parse tree is in the global variable parse_tree.
   The errors are in err_list.
*/

void file_parse(FILE *src)
{

#ifdef YYDEBUG
    cmpyy_debug = TRUE;
#endif
    parse_tree = NULL;
    lineno = 1;
    cmp_start_lex_input_file(src, &lineno);
    if (cmpyy_parse() != 0) {}
    cmp_finish_lex_input();
    exc = EXC_NONE;
    if (err_list != NULL) return;
    if (parse_tree == NULL) cmp_err("no parse tree found", 1);
}

void string_parse(char *s)
{

#ifdef YYDEBUG
    cmpyy_debug = TRUE;
#endif
    parse_tree = NULL;
    lineno = 1;
    cmp_start_lex_input_string(s, &lineno);
    if (cmpyy_parse() != 0) {}
    cmp_finish_lex_input();
    exc = EXC_NONE;
    if (err_list != NULL) return;
    if (parse_tree == NULL) cmp_err("no parse tree found", 1);
}

void do_phases(ParseNodeList *pt, int stop, string nm)
{
  ParseNodeList *pnl;

  /* Sorting */
  pnl = collect_specs(pt);

  /* Desugaring */
  pnl = traverse_parsenode_list(pnl, new DesugarObj());
  if (err_list != NULL) return;

  /* Type Replacement (probably obsolete) */
  pnl = traverse_parsenode_list(pnl, 
	       new TypeReplaceObj(env, TypeReplaceObj::Replace));
  if (err_list != NULL) return;

  /* Theta 0 compliance check */
  v0_compliance(pnl);
  if (err_list != NULL) return;

  /* Type Checking */
  TypeCheckObj *tco = new TypeCheckObj(env, TypeCheckObj::Check);
  propagate_parsenode_list(pnl, tco);
  /* do a second pass if there are errors, but no redefinition errors */
  // 2nd pass moved into ImplMod in type_checker.cc (xmog)
  // if (err_list != 0 && tco->redef_count == 0) {
	/* allow redefinitions */
	// err_list = 0;
	// tco->allow_redefs = TRUE;
  	// propagate_parsenode_list(pnl, tco);
	// }
  env = tco->get_env();
  // fix_class_supertypes(pnl);
  if (stop == CHECK) return;
  if (err_list) return;

  /* Code Generation */
  code_generator(pnl, nm);

}

