/* Copyright 1995 Barbara Liskov */

#ifndef _COMPILER_H
#define _COMPILER_H

#include <stdio.h>
#include "parse.h"

extern ParseNodeList *parse_tree;
extern string err_list;

void do_phases(ParseNodeList *pt, int stop, string nm);
void v0_compliance(ParseNodeList*);
void code_generator(ParseNodeList*, string);
ParseNodeList *collect_specs(ParseNodeList *pnl);
void file_parse(FILE *src);
void string_parse(char *s);

/* definitions for stop */
#define CHECK 0
#define COMPILE 1

#ifdef __cplusplus
extern "C" {
#endif
  extern int cmpyy_parse();

  extern string theta_compile(FILE *src, string nm);
  extern string theta_parse(FILE *src, string nm);
  extern string theta_check(FILE *src, string nm);
  extern string theta_show();
  extern string theta_expunge();

  extern int linenumber; 

  extern int cmpyy_lex();
  extern void cmpyy_error(char *msg);
  extern char *alloca (int size );

  
extern int match_ids(Id *i1, Id *i2);

#ifdef __cplusplus
}
#endif

#endif /* _COMPILER_H */
