// Copyright 1995 Barbara Liskov

#include "assert.h"
#include "lex_input.h"

extern FILE *cmpyy_in;
static char (*prim_input)() = 0;
extern int cmpyy_lineno;
extern char *err_list;
     /* passed into reset_lex_input */


#define STACKDEPTH 100

static int lock = 0;

#ifdef STANDALONE
void start_lex_input(FILE *f, int *lineno)
#else
void cmp_start_lex_input(FILE *f, int *lineno)
#endif
{
    cmpyy_lineno = *lineno;
    cmpyy_in = f;
    cmpyy_lineno = 1;
    err_list = NULL;
    cmpyy_restart(f);
    assert(!lock);
    lock = 1;
}

#ifdef STANDALONE
void finish_lex_input()
#else
void cmp_finish_lex_input()
#endif
{
    assert(lock);
    lock = 0;
}


