// Copyright 1995 Barbara Liskov

#include "assert.h"
//    cmpyy_in = f;
#include "lx_input.h"

extern FILE *cmpyy_in;
static char (*prim_input)() = 0;
extern int cmpyy_lineno;
extern char *err_list;
extern void cmpyy_init();
     /* passed into reset_lex_input */


static int lock = 0;
static int cmp_file_source = 0;

void cmp_start_lex_input_file(FILE *f, int *lineno)
{
    cmp_file_source = 1;
    cmpyy_lineno = *lineno;
    cmpyy_in = f;
    cmpyy_lineno = 1;
    err_list = NULL;
    cmpyy_init();
#ifdef FLEX_SCANNER
    cmpyy_restart_file(f);
#endif
    assert(!lock);
    lock = 1;
}

static char *stack;
static int sp = 0;

void cmp_start_lex_input_string(char *s, int *lineno)
{
    cmp_file_source = 0;
    cmpyy_lineno = *lineno;
    stack = s;
    sp = 0;
    cmpyy_lineno = 1;
    err_list = NULL;
    cmpyy_init();
#ifdef FLEX_SCANNER
    cmpyy_restart_string(s);
#endif
    assert(!lock);
    lock = 1;
}

char cmp_lex_input()
{
        if (cmp_file_source) return cmp_file_input();
        else return cmp_string_input();
        }

void cmp_lex_unput(char c)
{
        if (cmp_file_source) cmp_file_unput(c);
        else cmp_string_unput(c);
        }

char cmp_string_input()
{
char c;
        c = stack[sp++];
        if (c == '\n') cmpyy_lineno++;
        return c;
        }

void cmp_string_unput(char c)
{
	sp--;
        // stack[++sp] = c;
        if (c == '\n') cmpyy_lineno--;
        }


void cmp_finish_lex_input()
{
    assert(lock);
    lock = 0;
}


