
// A Compiler Parse Tree Format, based on the reference grammar in the
// draft Theta Reference Manual

#include "xlist.h"
#include "my_string.h"
#include "traverse.h"
#include "environment.h"
#include <stdio.h>
extern int cmpyy_lineno;
// ========================= M4 stuff ===========================
//
// The TAG macro is used to add a tag to the class. The usage is
// TAG(CLASS, `tag1, tag2, tag3 ...'). The tag of an object of this
// class can be accessed using the "tag" method. The possible
// tag values are named "CLASS::tag1", "CLASS::tag2", etc.
// A constructor "CLASS(CLASS::Tag)" is also created. It initializes
// only the tag.

// This next bit looks like a comment, but m4 notices it just fine.
// It's commented to allow "grind" to do the right thing.
/* 
 
*/
    
// The "Node" macro is used to automatically _define a class for a 
// parse tree node with tags, a constructor, and fields.
//
// The usage is  "Node(CLASSNAME, SUPERCLASS, tag1, tag2, ...,
//		       TYPE1, FIELDNAME1,
//		       TYPE2, FIELDNAME2,
//		       ...
// (The SUPERCLASS, tags, and fields arguments can be left blank to omit them.)
//
// This expands to:
//
//   class CLASSNAME : SUPERCLASS {
//     public:	
//      [enum Tag {CLASS::tag1, ...};]   // here if tags are not empty
//	[tag() { return tag_;}]
//	
//      TYPE1 get_FIELDNAME1() {...}  	   		// get method
//      void set_FIELDNAME1(TYPE1 val) {...}		// set method
//      ...<the same thing for all of the other fields>...
//
//      CLASSNAME([Tag tag], TYPE1 FIELDNAME1, ...) :             // constructor
//	  [SUPERCLASS(SUPERCLASS::CLASSNAMET) ,]
//        [_tag(tag),]
//	  FIELDNAME1_(FIELDNAME1)
//	  ... {};
//
//      CLASSNAME(const CLASSNAME& o) : ...:  		          // copy constr.
//
//     private:
//	 Tag tag_;
//	 TYPE1 FIELDNAME1_;
//       ...;
//   };

// Pardon the grunge below... Nicely formatted m4 output requires weird m4
// macro formatting.



// VARS: declare instance variables for each (type,name) pair
 

// ACCESSORS: declare get and set methods for each (type,name) pair       












    






// CONSTARGS: declare  constructor arguments for each (type,name) pair	      


// CONSTBODY: the body of the constructor


// : the body of the copy constructor

    


// Normal Constructor Implementation


// Line-Number Preserving Constructor Implementation


// Copy Constructor Implementation

   
// Line Preserving Copy Constructor Implementation




// The end of the file must have END_NODES so that the print methods can be generated.    




// We first declare all of the node classes used in the parse tree

     class Module; 
      class SpecModule; 
      class RoutineSpec; 
      class ProcHeader; 
      class IterHeader; 
      class MakeHeader; 
      class EquateModule; 
      class Decl; 
      class Equate; 
      class TypeEquate; 
      class ConstEquate; 
      class ImplModule; 
      class Impl; 
      class RoutineDef; 
      class ClassDef; 
      class Renaming; 
      class Export; 
      class MethodOrOpDef; 
      class Parm; 
      class Formal; 
      class Exception; 
      class Restriction; 
      class TypeSpec; 
      class BasicTypeSpec; 
      class ComplexTypeSpec; 
      class ActualParm; 
      class ParmOp; 
      class Stmt; 
      class DeclStmt; 
      class InitVarExpr; 
      class InitVarInvoke; 
      class AssignInvoke; 
      class AssignExprStmt; 
      class AssignExpr; 
      class InvokeStmt; 
      class WhileStmt; 
      class IfStmt; 
      class Tagcase; 
      class Typecase; 
      class ReturnStmt; 
      class Yield; 
      class SignalStmt; 
      class Exit; 
      class BlockStmt; 
      class ResignalStmt; 
      class ExceptStmt; 
      class IdOrIvar; 
      class Body; 
      class ElseIf; 
      class TagWhenArm; 
      class ExWhenArm; 
      class OthersHandler; 
      class FieldInit; 
      class Expr; 
      class Binary; 
      class Unary; 
      class Literal; 
      class Instantiation; 
      class DotExpr; 
      class SuperId; 
      class ArrayRef; 
      class BracketRef; 
      class BraceRef; 
      class InvocExpr; 
      class BindingExpr; 
      class SelectorConstr; 
      class ArrayConstr; 
      class Invoc; 
      class RoutineId; 
      class SimpleRoutineId; 
      class ComplexRoutineId; 
      class Binding; 
      class BindingArg; 
      class Field; 
      class Id; 
      class Signature; 
      class TypeWhenArm; 
      class Inherit; 
      class RoutineSpecModule; 
      class SuperInfo; 
      class IntLiteral; 
      class CharLiteral; 
      class StringLiteral; 
      class RealLiteral; 
      class IdExpr; 
      class TypeExtModule; 
      class Id; 
 

// The "Node" macro is used to automatically create a class for a 
// parse tree node with tags, a constructor, and fields.
//
// See parseMacros.h for details of what node expands to.

// ParseNode is the superclass of all Parse node classes.  If the superclass
// argument in NODE is left blank, ParseNode will be used.


#define DEBUG_FLAG  0
// If debug_flag is nonzero, each object prints itself out after being created

class ParseNode {
  public:
    enum Tag { SignatureT, ImplEltT, InheritT, RenamingT, ExportT,
		   MethodOrOpDefT, ParmT, FormalT, ExceptionT,
		   RestrictionT, TypeSpecT, TypeNameT, ActualParmT,
		   ParmOpT, IdOrIvarT, BodyT, ElseIfT, TagWhenArmT,
		   ExWhenArmT, OthersHandlerT, FieldInitT, InvocT,
		   RoutineIdT, SuperInfoT, BindingT, BindingArgT,
		   FieldT, IdT, ModuleT, SpecEltT, RoutineIntfT, StmtT, ExprT,
		   EquateT, DeclT, TypeWhenArmT, TypeObjectT, ClassEltT};
    Tag tag_;
    TypeInterface *type_;
    int line;
    tag();
    TypeInterface *get_type();
    int get_line();

    ParseNode(Tag tag ) :  tag_(tag),  type_(new TypeInterface()),
		line(cmpyy_lineno) {} 

    ParseNode(int lineno, Tag tag) :  tag_(tag),  type_(new TypeInterface()),
		line(lineno) {} 

    virtual void print(int spaces)=0;
    virtual ParseNode* traverse(TraverseObj *tobj)=0;
    virtual ParseNode* propagate(TraverseObj *tobj)=0;
};

    ParseNode::tag() { return tag_; }
    TypeInterface *ParseNode::get_type() { return type_; }
    int ParseNode::get_line() { return line; }

typedef xlist<ParseNode*> ParseNodeList;


#define put_spaces(count) {int i=count; while (i--) putchar(' ');}
void print_parsenode_list(ParseNodeList *lp, int spaces)
{
    ParseNodeList l = *lp;	/* for readability */
    for (Pix p = l.first(); p; l.next(p)) {
	l(p)->print(spaces);
    }}


ParseNodeList* traverse_parsenode_list(ParseNodeList *lp, TraverseObj *tobj)
{
    ParseNodeList l = *lp;
    ParseNodeList *new_list = new ParseNodeList();
    
    for (Pix p = l.first(); p; l.next(p)) {
	ParseNode *new_node = l(p)->traverse(tobj);
	new_list->append(new_node);
    }

    return new_list;
}

ParseNodeList* propagate_parsenode_list(ParseNodeList *lp, TraverseObj *tobj)
{
    ParseNodeList l = *lp;
    
    for (Pix p = l.first(); p; l.next(p)) {
	l(p)->propagate(tobj);
    }

    return lp;
}

// ======================= Modules ==============================
class Module : public ParseNode {
   public:			 
    enum Tag { SpecModuleT, ImplModuleT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Module(Tag tag ); 

      Module(int lineno ,  Tag tag ); 

// Copy Constructors
      Module(const Module& o); 
      Module(int lineno, const Module& o); 
   
};

class SpecModule : public Module {
   
    private:
      ParseNodeList* specs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_specs();
      void set_specs(ParseNodeList* val);


// Constructors
      SpecModule(ParseNodeList* specs  ); 

      SpecModule(int lineno , ParseNodeList* specs  ); 

// Copy Constructors
      SpecModule(const SpecModule& o); 
      SpecModule(int lineno, const SpecModule& o); 
   
};

class SpecElt : public ParseNode {
   public:			 
    enum Tag { TypeIntfT, RoutineSpecT, SpecEquateT  };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      SpecElt(Tag tag ); 

      SpecElt(int lineno ,  Tag tag ); 

// Copy Constructors
      SpecElt(const SpecElt& o); 
      SpecElt(int lineno, const SpecElt& o); 
   
};

class TypeIntf : public SpecElt {
   
    private:
      Id* id_; 
      ParseNodeList* parms_; 
      ParseNodeList* supers_; 
      ParseNodeList* wheres_; 
      ParseNodeList* methods_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_supers();
      void set_supers(ParseNodeList* val);
      ParseNodeList* get_wheres();
      void set_wheres(ParseNodeList* val);
      ParseNodeList* get_methods();
      void set_methods(ParseNodeList* val);


// Constructors
      TypeIntf(Id* id , ParseNodeList* parms , ParseNodeList* supers , ParseNodeList* wheres , ParseNodeList* methods  ); 

      TypeIntf(int lineno , Id* id , ParseNodeList* parms , ParseNodeList* supers , ParseNodeList* wheres , ParseNodeList* methods  ); 

// Copy Constructors
      TypeIntf(const TypeIntf& o); 
      TypeIntf(int lineno, const TypeIntf& o); 
   
};

class RoutineIntf : public ParseNode {
   public:			 
    enum Tag { ProcHeaderT, IterHeaderT, MakeHeaderT };
    tag();
   private:		
    Tag tag_;
    private:
      Id* id_; 
      Signature* signature_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      Signature* get_signature();
      void set_signature(Signature* val);


// Constructors
      RoutineIntf(Tag tag ,Id* id , Signature* signature  ); 

      RoutineIntf(int lineno ,  Tag tag ,Id* id , Signature* signature  ); 

// Copy Constructors
      RoutineIntf(const RoutineIntf& o); 
      RoutineIntf(int lineno, const RoutineIntf& o); 
   
};

class Signature : public ParseNode {
   public:			 
    enum Tag { ProcSigT, IterSigT, MakeSigT };
    tag();
   private:		
    Tag tag_;
    private:
      ParseNodeList* parms_; 
      ParseNodeList* args_; 
      ParseNodeList* returns_; 
      ParseNodeList* signals_; 
      ParseNodeList* where_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_args();
      void set_args(ParseNodeList* val);
      ParseNodeList* get_returns();
      void set_returns(ParseNodeList* val);
      ParseNodeList* get_signals();
      void set_signals(ParseNodeList* val);
      ParseNodeList* get_where();
      void set_where(ParseNodeList* val);


// Constructors
      Signature(Tag tag ,ParseNodeList* parms , ParseNodeList* args , ParseNodeList* returns , ParseNodeList* signals , ParseNodeList* where  ); 

      Signature(int lineno ,  Tag tag ,ParseNodeList* parms , ParseNodeList* args , ParseNodeList* returns , ParseNodeList* signals , ParseNodeList* where  ); 

// Copy Constructors
      Signature(const Signature& o); 
      Signature(int lineno, const Signature& o); 
   
};

class RoutineSpec : public SpecElt {
   
    private:
      RoutineIntf* routine_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      RoutineIntf* get_routine();
      void set_routine(RoutineIntf* val);


// Constructors
      RoutineSpec(RoutineIntf* routine  ); 

      RoutineSpec(int lineno , RoutineIntf* routine  ); 

// Copy Constructors
      RoutineSpec(const RoutineSpec& o); 
      RoutineSpec(int lineno, const RoutineSpec& o); 
   
};

class SpecEquate : public SpecElt {
   
    private:
      Equate * equate_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Equate * get_equate();
      void set_equate(Equate * val);


// Constructors
      SpecEquate(Equate * equate  ); 

      SpecEquate(int lineno , Equate * equate  ); 

// Copy Constructors
      SpecEquate(const SpecEquate& o); 
      SpecEquate(int lineno, const SpecEquate& o); 
   
};

class Equate : public ParseNode {
   public:			 
    enum Tag { TypeEquateT, ExprEquateT  };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Equate(Tag tag ); 

      Equate(int lineno ,  Tag tag ); 

// Copy Constructors
      Equate(const Equate& o); 
      Equate(int lineno, const Equate& o); 
   
};

class ExprEquate : public Equate {
   
    private:
      Id* id_; 
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      ExprEquate(Id* id , Expr* expr  ); 

      ExprEquate(int lineno , Id* id , Expr* expr  ); 

// Copy Constructors
      ExprEquate(const ExprEquate& o); 
      ExprEquate(int lineno, const ExprEquate& o); 
   
};

class TypeEquate : public Equate {
   
    private:
      Id* id_; 
      TypeSpec* typ_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typ();
      void set_typ(TypeSpec* val);


// Constructors
      TypeEquate(Id* id , TypeSpec* typ  ); 

      TypeEquate(int lineno , Id* id , TypeSpec* typ  ); 

// Copy Constructors
      TypeEquate(const TypeEquate& o); 
      TypeEquate(int lineno, const TypeEquate& o); 
   
};

class ImplModule : public Module {
   
    private:
      ParseNodeList* exports_; 
      ParseNodeList* equates_; 
      ParseNodeList* impls_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_exports();
      void set_exports(ParseNodeList* val);
      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_impls();
      void set_impls(ParseNodeList* val);


// Constructors
      ImplModule(ParseNodeList* exports , ParseNodeList* equates , ParseNodeList* impls  ); 

      ImplModule(int lineno , ParseNodeList* exports , ParseNodeList* equates , ParseNodeList* impls  ); 

// Copy Constructors
      ImplModule(const ImplModule& o); 
      ImplModule(int lineno, const ImplModule& o); 
   
};

class ImplElt : public ParseNode {
   public:			 
    enum Tag { RoutineDefT, ClassDefT, ImplEquateT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      ImplElt(Tag tag ); 

      ImplElt(int lineno ,  Tag tag ); 

// Copy Constructors
      ImplElt(const ImplElt& o); 
      ImplElt(int lineno, const ImplElt& o); 
   
};

class RoutineDef : public ImplElt {
   
    private:
      RoutineIntf* routineIntf_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      RoutineIntf* get_routineIntf();
      void set_routineIntf(RoutineIntf* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      RoutineDef(RoutineIntf* routineIntf , Body* body  ); 

      RoutineDef(int lineno , RoutineIntf* routineIntf , Body* body  ); 

// Copy Constructors
      RoutineDef(const RoutineDef& o); 
      RoutineDef(int lineno, const RoutineDef& o); 
   
};

class ImplEquate : public ImplElt {
   
    private:
      Equate * equate_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Equate * get_equate();
      void set_equate(Equate * val);


// Constructors
      ImplEquate(Equate * equate  ); 

      ImplEquate(int lineno , Equate * equate  ); 

// Copy Constructors
      ImplEquate(const ImplEquate& o); 
      ImplEquate(int lineno, const ImplEquate& o); 
   
};

class ClassDef : public ImplElt {
   
    private:
      Id* classId_; 
      TypeSpec* deftype_; 
      ParseNodeList* parms_; 
      ParseNodeList* wheres_; 
      Inherit* inherits_; 
      Export* exports_; 
      ParseNodeList* hides_; 
      int immutable_; 
      ParseNodeList* equates_; 
      ParseNodeList* decl_; 
      ParseNodeList* classElts_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_classId();
      void set_classId(Id* val);
      TypeSpec* get_deftype();
      void set_deftype(TypeSpec* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_wheres();
      void set_wheres(ParseNodeList* val);
      Inherit* get_inherits();
      void set_inherits(Inherit* val);
      Export* get_exports();
      void set_exports(Export* val);
      ParseNodeList* get_hides();
      void set_hides(ParseNodeList* val);
      int get_immutable();
      void set_immutable(int val);
      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_decl();
      void set_decl(ParseNodeList* val);
      ParseNodeList* get_classElts();
      void set_classElts(ParseNodeList* val);


// Constructors
      ClassDef(Id* classId , TypeSpec* deftype , ParseNodeList* parms , ParseNodeList* wheres , Inherit* inherits , Export* exports , ParseNodeList* hides , int immutable , ParseNodeList* equates , ParseNodeList* decl , ParseNodeList* classElts  ); 

      ClassDef(int lineno , Id* classId , TypeSpec* deftype , ParseNodeList* parms , ParseNodeList* wheres , Inherit* inherits , Export* exports , ParseNodeList* hides , int immutable , ParseNodeList* equates , ParseNodeList* decl , ParseNodeList* classElts  ); 

// Copy Constructors
      ClassDef(const ClassDef& o); 
      ClassDef(int lineno, const ClassDef& o); 
   
};

class ClassElt : public ParseNode {
   public:			 
    enum Tag { MethodOrOpDefT, EquateT  };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      ClassElt(Tag tag ); 

      ClassElt(int lineno ,  Tag tag ); 

// Copy Constructors
      ClassElt(const ClassElt& o); 
      ClassElt(int lineno, const ClassElt& o); 
   
};

class Inherit : public ParseNode {
   
    private:
      TypeSpec* classSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_classSpec();
      void set_classSpec(TypeSpec* val);


// Constructors
      Inherit(TypeSpec* classSpec  ); 

      Inherit(int lineno , TypeSpec* classSpec  ); 

// Copy Constructors
      Inherit(const Inherit& o); 
      Inherit(int lineno, const Inherit& o); 
   
};

class Renaming : public ParseNode {
   
    private:
      Expr* from_; 
      Id* to_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_from();
      void set_from(Expr* val);
      Id* get_to();
      void set_to(Id* val);


// Constructors
      Renaming(Expr* from , Id* to  ); 

      Renaming(int lineno , Expr* from , Id* to  ); 

// Copy Constructors
      Renaming(const Renaming& o); 
      Renaming(int lineno, const Renaming& o); 
   
};

class Export : public ParseNode {
   
    private:
      ParseNodeList* exported_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_exported();
      void set_exported(ParseNodeList* val);


// Constructors
      Export(ParseNodeList* exported  ); 

      Export(int lineno , ParseNodeList* exported  ); 

// Copy Constructors
      Export(const Export& o); 
      Export(int lineno, const Export& o); 
   
};

class MethodOrOpDef : public ParseNode {
   
    private:
      int isOp_; 
      int IsConstr_; 
      RoutineDef* routineDef_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      int get_isOp();
      void set_isOp(int val);
      int get_IsConstr();
      void set_IsConstr(int val);
      RoutineDef* get_routineDef();
      void set_routineDef(RoutineDef* val);


// Constructors
      MethodOrOpDef(int isOp , int IsConstr , RoutineDef* routineDef  ); 

      MethodOrOpDef(int lineno , int isOp , int IsConstr , RoutineDef* routineDef  ); 

// Copy Constructors
      MethodOrOpDef(const MethodOrOpDef& o); 
      MethodOrOpDef(int lineno, const MethodOrOpDef& o); 
   
};

class Parm : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);


// Constructors
      Parm(ParseNodeList* ids  ); 

      Parm(int lineno , ParseNodeList* ids  ); 

// Copy Constructors
      Parm(const Parm& o); 
      Parm(int lineno, const Parm& o); 
   
};

// unused
class Formal : public ParseNode {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);


// Constructors
      Formal(Id* id , TypeSpec* typeSpec  ); 

      Formal(int lineno , Id* id , TypeSpec* typeSpec  ); 

// Copy Constructors
      Formal(const Formal& o); 
      Formal(int lineno, const Formal& o); 
   
};

class Exception : public ParseNode {
   
    private:
      Id* id_; 
      ParseNodeList* typeSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_typeSpec();
      void set_typeSpec(ParseNodeList* val);


// Constructors
      Exception(Id* id , ParseNodeList* typeSpec  ); 

      Exception(int lineno , Id* id , ParseNodeList* typeSpec  ); 

// Copy Constructors
      Exception(const Exception& o); 
      Exception(int lineno, const Exception& o); 
   
};

class Restriction : public ParseNode {
   
    private:
      Id* TypeId_; 
      ParseNodeList* operations_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_TypeId();
      void set_TypeId(Id* val);
      ParseNodeList* get_operations();
      void set_operations(ParseNodeList* val);


// Constructors
      Restriction(Id* TypeId , ParseNodeList* operations  ); 

      Restriction(int lineno , Id* TypeId , ParseNodeList* operations  ); 

// Copy Constructors
      Restriction(const Restriction& o); 
      Restriction(int lineno, const Restriction& o); 
   
};

class TypeSpec : public ParseNode {
   public:			 
    enum Tag { SimpleTypeSpecT, ParamTypeSpecT, TaggedTypeSpecT,
	RoutineTypeSpecT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      TypeSpec(Tag tag ); 

      TypeSpec(int lineno ,  Tag tag ); 

// Copy Constructors
      TypeSpec(const TypeSpec& o); 
      TypeSpec(int lineno, const TypeSpec& o); 
   
};

class TypeName : public ParseNode {
   
    private:
      Id* name_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_name();
      void set_name(Id* val);


// Constructors
      TypeName(Id* name  ); 

      TypeName(int lineno , Id* name  ); 

// Copy Constructors
      TypeName(const TypeName& o); 
      TypeName(int lineno, const TypeName& o); 
   
};
      
class TypeObject : public ParseNode {
   
    private:
      TypeInterface* leaf_type_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeInterface* get_leaf_type();
      void set_leaf_type(TypeInterface* val);


// Constructors
      TypeObject(TypeInterface* leaf_type  ); 

      TypeObject(int lineno , TypeInterface* leaf_type  ); 

// Copy Constructors
      TypeObject(const TypeObject& o); 
      TypeObject(int lineno, const TypeObject& o); 
   
};

class SimpleTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeName* get_name();
      void set_name(TypeName* val);


// Constructors
      SimpleTypeSpec(TypeName* name  ); 

      SimpleTypeSpec(int lineno , TypeName* name  ); 

// Copy Constructors
      SimpleTypeSpec(const SimpleTypeSpec& o); 
      SimpleTypeSpec(int lineno, const SimpleTypeSpec& o); 
   
};

class ParamTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
      ParseNodeList* actualParms_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeName* get_name();
      void set_name(TypeName* val);
      ParseNodeList* get_actualParms();
      void set_actualParms(ParseNodeList* val);


// Constructors
      ParamTypeSpec(TypeName* name , ParseNodeList* actualParms  ); 

      ParamTypeSpec(int lineno , TypeName* name , ParseNodeList* actualParms  ); 

// Copy Constructors
      ParamTypeSpec(const ParamTypeSpec& o); 
      ParamTypeSpec(int lineno, const ParamTypeSpec& o); 
   
};

class TaggedTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
      ParseNodeList* fields_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeName* get_name();
      void set_name(TypeName* val);
      ParseNodeList* get_fields();
      void set_fields(ParseNodeList* val);


// Constructors
      TaggedTypeSpec(TypeName* name , ParseNodeList* fields  ); 

      TaggedTypeSpec(int lineno , TypeName* name , ParseNodeList* fields  ); 

// Copy Constructors
      TaggedTypeSpec(const TaggedTypeSpec& o); 
      TaggedTypeSpec(int lineno, const TaggedTypeSpec& o); 
   
};

class RoutineTypeSpec : public TypeSpec {
   
    private:
      Signature* signature_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Signature* get_signature();
      void set_signature(Signature* val);


// Constructors
      RoutineTypeSpec(Signature* signature  ); 

      RoutineTypeSpec(int lineno , Signature* signature  ); 

// Copy Constructors
      RoutineTypeSpec(const RoutineTypeSpec& o); 
      RoutineTypeSpec(int lineno, const RoutineTypeSpec& o); 
   
};

class ActualParm : public ParseNode {
   
    private:
      TypeSpec* typeSpec_; 
      ParseNodeList* newNames_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      ParseNodeList* get_newNames();
      void set_newNames(ParseNodeList* val);


// Constructors
      ActualParm(TypeSpec* typeSpec , ParseNodeList* newNames  ); 

      ActualParm(int lineno , TypeSpec* typeSpec , ParseNodeList* newNames  ); 

// Copy Constructors
      ActualParm(const ActualParm& o); 
      ActualParm(int lineno, const ActualParm& o); 
   
};

class ParmOp : public ParseNode {
   
    private:
      Expr* primary_; 
      Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      Id* get_id();
      void set_id(Id* val);


// Constructors
      ParmOp(Expr* primary , Id* id  ); 

      ParmOp(int lineno , Expr* primary , Id* id  ); 

// Copy Constructors
      ParmOp(const ParmOp& o); 
      ParmOp(int lineno, const ParmOp& o); 
   
};

// ======================= Statements ===========================

/* Stmt */


// DeclT doesn't belong in the following list
class Stmt : public ParseNode {
   public:			 
    enum Tag { DeclStmtT, InitVarExprT, InitVarInvokeT, DeclT,
AssignInvokeT, AssignExprStmtT, AssignExprT, InvokeStmtT,
WhileStmtT, IfStmtT, TagcaseT, TypecaseT, ReturnStmtT,
YieldT, SignalStmtT, ExitT, BreakT, ContinueT, BlockStmtT,
ResignalStmtT, ExceptStmtT, InitT, DeclForStmtT, ForStmtT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Stmt(Tag tag ); 

      Stmt(int lineno ,  Tag tag ); 

// Copy Constructors
      Stmt(const Stmt& o); 
      Stmt(int lineno, const Stmt& o); 
   
};

class DeclStmt : public Stmt {
   
    private:
      Decl* decl_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Decl* get_decl();
      void set_decl(Decl* val);


// Constructors
      DeclStmt(Decl* decl  ); 

      DeclStmt(int lineno , Decl* decl  ); 

// Copy Constructors
      DeclStmt(const DeclStmt& o); 
      DeclStmt(int lineno, const DeclStmt& o); 
   
};

class Decl : public ParseNode {
   public:			 
    enum Tag { RegDeclT, ImplDeclT, VarArgsDeclT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Decl(Tag tag ); 

      Decl(int lineno ,  Tag tag ); 

// Copy Constructors
      Decl(const Decl& o); 
      Decl(int lineno, const Decl& o); 
   
};

class RegDecl : public Decl {
   
    private:
      ParseNodeList* ids_; 
      TypeSpec* typeSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);


// Constructors
      RegDecl(ParseNodeList* ids , TypeSpec* typeSpec  ); 

      RegDecl(int lineno , ParseNodeList* ids , TypeSpec* typeSpec  ); 

// Copy Constructors
      RegDecl(const RegDecl& o); 
      RegDecl(int lineno, const RegDecl& o); 
   
};

class VarArgsDecl : public Decl {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);


// Constructors
      VarArgsDecl(Id* id , TypeSpec* typeSpec  ); 

      VarArgsDecl(int lineno , Id* id , TypeSpec* typeSpec  ); 

// Copy Constructors
      VarArgsDecl(const VarArgsDecl& o); 
      VarArgsDecl(int lineno, const VarArgsDecl& o); 
   
};

class ImplDecl : public Decl {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
      Id* get_; 
      Id* set_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Id* get_get();
      void set_get(Id* val);
      Id* get_set();
      void set_set(Id* val);


// Constructors
      ImplDecl(Id* id , TypeSpec* typeSpec , Id* get , Id* set  ); 

      ImplDecl(int lineno , Id* id , TypeSpec* typeSpec , Id* get , Id* set  ); 

// Copy Constructors
      ImplDecl(const ImplDecl& o); 
      ImplDecl(int lineno, const ImplDecl& o); 
   
};

class InitVarExpr : public Stmt {
   
    private:
      Decl* decl_; 
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Decl* get_decl();
      void set_decl(Decl* val);
      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      InitVarExpr(Decl* decl , Expr* expr  ); 

      InitVarExpr(int lineno , Decl* decl , Expr* expr  ); 

// Copy Constructors
      InitVarExpr(const InitVarExpr& o); 
      InitVarExpr(int lineno, const InitVarExpr& o); 
   
};

class InitVarInvoke : public Stmt {
   
    private:
      ParseNodeList* decls_; 
      Invoc* invoc_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);


// Constructors
      InitVarInvoke(ParseNodeList* decls , Invoc* invoc  ); 

      InitVarInvoke(int lineno , ParseNodeList* decls , Invoc* invoc  ); 

// Copy Constructors
      InitVarInvoke(const InitVarInvoke& o); 
      InitVarInvoke(int lineno, const InitVarInvoke& o); 
   
};


// unused
class AssignInvoke : public Stmt {
   
    private:
      ParseNodeList* idOrIvars_; 
      Invoc* invoc_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_idOrIvars();
      void set_idOrIvars(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);


// Constructors
      AssignInvoke(ParseNodeList* idOrIvars , Invoc* invoc  ); 

      AssignInvoke(int lineno , ParseNodeList* idOrIvars , Invoc* invoc  ); 

// Copy Constructors
      AssignInvoke(const AssignInvoke& o); 
      AssignInvoke(int lineno, const AssignInvoke& o); 
   
};

class AssignExprStmt : public Stmt {
   
    private:
      ParseNodeList* ids_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      AssignExprStmt(ParseNodeList* ids , ParseNodeList* exprs  ); 

      AssignExprStmt(int lineno , ParseNodeList* ids , ParseNodeList* exprs  ); 

// Copy Constructors
      AssignExprStmt(const AssignExprStmt& o); 
      AssignExprStmt(int lineno, const AssignExprStmt& o); 
   
};


// unused
class AssignExpr : public Stmt {
   
    private:
      Expr* primary_; 
      Expr* primaryExpr_; 
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      Expr* get_primaryExpr();
      void set_primaryExpr(Expr* val);
      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      AssignExpr(Expr* primary , Expr* primaryExpr , Expr* expr  ); 

      AssignExpr(int lineno , Expr* primary , Expr* primaryExpr , Expr* expr  ); 

// Copy Constructors
      AssignExpr(const AssignExpr& o); 
      AssignExpr(int lineno, const AssignExpr& o); 
   
};

class InvokeStmt : public Stmt {
   
    private:
      Invoc* invoc_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Invoc* get_invoc();
      void set_invoc(Invoc* val);


// Constructors
      InvokeStmt(Invoc* invoc  ); 

      InvokeStmt(int lineno , Invoc* invoc  ); 

// Copy Constructors
      InvokeStmt(const InvokeStmt& o); 
      InvokeStmt(int lineno, const InvokeStmt& o); 
   
};

class WhileStmt : public Stmt {
   
    private:
      Expr* expr_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      WhileStmt(Expr* expr , Body* body  ); 

      WhileStmt(int lineno , Expr* expr , Body* body  ); 

// Copy Constructors
      WhileStmt(const WhileStmt& o); 
      WhileStmt(int lineno, const WhileStmt& o); 
   
};

class IfStmt : public Stmt {
   
    private:
      Expr* expr_; 
      Body* body_; 
      ParseNodeList* elseifs_; 
      Body* elsebody_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);
      ParseNodeList* get_elseifs();
      void set_elseifs(ParseNodeList* val);
      Body* get_elsebody();
      void set_elsebody(Body* val);


// Constructors
      IfStmt(Expr* expr , Body* body , ParseNodeList* elseifs , Body* elsebody  ); 

      IfStmt(int lineno , Expr* expr , Body* body , ParseNodeList* elseifs , Body* elsebody  ); 

// Copy Constructors
      IfStmt(const IfStmt& o); 
      IfStmt(int lineno, const IfStmt& o); 
   
};

class DeclForStmt : public Stmt {
   
    private:
      ParseNodeList* decls_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      DeclForStmt(ParseNodeList* decls , Invoc* invoc , Body* body  ); 

      DeclForStmt(int lineno , ParseNodeList* decls , Invoc* invoc , Body* body  ); 

// Copy Constructors
      DeclForStmt(const DeclForStmt& o); 
      DeclForStmt(int lineno, const DeclForStmt& o); 
   
};

class ForStmt : public Stmt {
   
    private:
      ParseNodeList* ids_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      ForStmt(ParseNodeList* ids , Invoc* invoc , Body* body  ); 

      ForStmt(int lineno , ParseNodeList* ids , Invoc* invoc , Body* body  ); 

// Copy Constructors
      ForStmt(const ForStmt& o); 
      ForStmt(int lineno, const ForStmt& o); 
   
};

class Tagcase : public Stmt {
   
    private:
      Expr* expr_; 
      ParseNodeList* tagWhenArms_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);
      ParseNodeList* get_tagWhenArms();
      void set_tagWhenArms(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      Tagcase(Expr* expr , ParseNodeList* tagWhenArms , Body* body  ); 

      Tagcase(int lineno , Expr* expr , ParseNodeList* tagWhenArms , Body* body  ); 

// Copy Constructors
      Tagcase(const Tagcase& o); 
      Tagcase(int lineno, const Tagcase& o); 
   
};


class Typecase : public Stmt {
   
    private:
      Expr* expr_; 
      ParseNodeList* typeWhenArms_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);
      ParseNodeList* get_typeWhenArms();
      void set_typeWhenArms(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      Typecase(Expr* expr , ParseNodeList* typeWhenArms , Body* body  ); 

      Typecase(int lineno , Expr* expr , ParseNodeList* typeWhenArms , Body* body  ); 

// Copy Constructors
      Typecase(const Typecase& o); 
      Typecase(int lineno, const Typecase& o); 
   
};

class TypeWhenArm : public ParseNode {
   
    private:
      TypeSpec* typ_; 
      Id* id_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_typ();
      void set_typ(TypeSpec* val);
      Id* get_id();
      void set_id(Id* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      TypeWhenArm(TypeSpec* typ , Id* id , Body* body  ); 

      TypeWhenArm(int lineno , TypeSpec* typ , Id* id , Body* body  ); 

// Copy Constructors
      TypeWhenArm(const TypeWhenArm& o); 
      TypeWhenArm(int lineno, const TypeWhenArm& o); 
   
};

class ReturnStmt : public Stmt {
   
    private:
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      ReturnStmt(ParseNodeList* exprs  ); 

      ReturnStmt(int lineno , ParseNodeList* exprs  ); 

// Copy Constructors
      ReturnStmt(const ReturnStmt& o); 
      ReturnStmt(int lineno, const ReturnStmt& o); 
   
};

class Yield : public Stmt {
   
    private:
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      Yield(ParseNodeList* exprs  ); 

      Yield(int lineno , ParseNodeList* exprs  ); 

// Copy Constructors
      Yield(const Yield& o); 
      Yield(int lineno, const Yield& o); 
   
};

class SignalStmt : public Stmt {
   
    private:
      Id* id_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      SignalStmt(Id* id , ParseNodeList* exprs  ); 

      SignalStmt(int lineno , Id* id , ParseNodeList* exprs  ); 

// Copy Constructors
      SignalStmt(const SignalStmt& o); 
      SignalStmt(int lineno, const SignalStmt& o); 
   
};

class Exit : public Stmt {
   
    private:
      Id* id_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      Exit(Id* id , ParseNodeList* exprs  ); 

      Exit(int lineno , Id* id , ParseNodeList* exprs  ); 

// Copy Constructors
      Exit(const Exit& o); 
      Exit(int lineno, const Exit& o); 
   
};

class BlockStmt : public Stmt {
   
    private:
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Body* get_body();
      void set_body(Body* val);


// Constructors
      BlockStmt(Body* body  ); 

      BlockStmt(int lineno , Body* body  ); 

// Copy Constructors
      BlockStmt(const BlockStmt& o); 
      BlockStmt(int lineno, const BlockStmt& o); 
   
};

class ResignalStmt : public Stmt {
   
    private:
      Stmt* stmt_; 
      ParseNodeList* ids_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Stmt* get_stmt();
      void set_stmt(Stmt* val);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);


// Constructors
      ResignalStmt(Stmt* stmt , ParseNodeList* ids  ); 

      ResignalStmt(int lineno , Stmt* stmt , ParseNodeList* ids  ); 

// Copy Constructors
      ResignalStmt(const ResignalStmt& o); 
      ResignalStmt(int lineno, const ResignalStmt& o); 
   
};

class ExceptStmt : public Stmt {
   
    private:
      Stmt* stmt_; 
      ParseNodeList* exWhenArm_; 
      Decl* decl_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Stmt* get_stmt();
      void set_stmt(Stmt* val);
      ParseNodeList* get_exWhenArm();
      void set_exWhenArm(ParseNodeList* val);
      Decl* get_decl();
      void set_decl(Decl* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      ExceptStmt(Stmt* stmt , ParseNodeList* exWhenArm , Decl* decl , Body* body  ); 

      ExceptStmt(int lineno , Stmt* stmt , ParseNodeList* exWhenArm , Decl* decl , Body* body  ); 

// Copy Constructors
      ExceptStmt(const ExceptStmt& o); 
      ExceptStmt(int lineno, const ExceptStmt& o); 
   
};

class Init : public Stmt {
   
    private:
      ParseNodeList* fieldInits_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_fieldInits();
      void set_fieldInits(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      Init(ParseNodeList* fieldInits , Invoc* invoc , Body* body  ); 

      Init(int lineno , ParseNodeList* fieldInits , Invoc* invoc , Body* body  ); 

// Copy Constructors
      Init(const Init& o); 
      Init(int lineno, const Init& o); 
   
};

class IdOrIvar : public ParseNode {
   
    private:
      Expr* primary_; 
      /* null if no primary */
     Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      /* null if no primary */
     Id* get_id();
      void set_id(/* null if no primary */
     Id* val);


// Constructors
      IdOrIvar(Expr* primary , /* null if no primary */
     Id* id  ); 

      IdOrIvar(int lineno , Expr* primary , /* null if no primary */
     Id* id  ); 

// Copy Constructors
      IdOrIvar(const IdOrIvar& o); 
      IdOrIvar(int lineno, const IdOrIvar& o); 
   
};

class Body : public ParseNode {
   
    private:
      ParseNodeList* equates_; 
      ParseNodeList* statements_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_statements();
      void set_statements(ParseNodeList* val);


// Constructors
      Body(ParseNodeList* equates , ParseNodeList* statements  ); 

      Body(int lineno , ParseNodeList* equates , ParseNodeList* statements  ); 

// Copy Constructors
      Body(const Body& o); 
      Body(int lineno, const Body& o); 
   
};

class ElseIf : public ParseNode {
   
    private:
      Expr* expr_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      ElseIf(Expr* expr , Body* body  ); 

      ElseIf(int lineno , Expr* expr , Body* body  ); 

// Copy Constructors
      ElseIf(const ElseIf& o); 
      ElseIf(int lineno, const ElseIf& o); 
   
};

class TagWhenArm : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
      Decl* decl_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      Decl* get_decl();
      void set_decl(Decl* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      TagWhenArm(ParseNodeList* ids , Decl* decl , Body* body  ); 

      TagWhenArm(int lineno , ParseNodeList* ids , Decl* decl , Body* body  ); 

// Copy Constructors
      TagWhenArm(const TagWhenArm& o); 
      TagWhenArm(int lineno, const TagWhenArm& o); 
   
};

class ExWhenArm : public ParseNode {
   
    private:
      ParseNodeList* names_; 
      ParseNodeList* decls_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_names();
      void set_names(ParseNodeList* val);
      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      ExWhenArm(ParseNodeList* names , ParseNodeList* decls , Body* body  ); 

      ExWhenArm(int lineno , ParseNodeList* names , ParseNodeList* decls , Body* body  ); 

// Copy Constructors
      ExWhenArm(const ExWhenArm& o); 
      ExWhenArm(int lineno, const ExWhenArm& o); 
   
};

// apparently unused
class OthersHandler : public ParseNode {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
      Body* body_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Body* get_body();
      void set_body(Body* val);


// Constructors
      OthersHandler(Id* id , TypeSpec* typeSpec , Body* body  ); 

      OthersHandler(int lineno , Id* id , TypeSpec* typeSpec , Body* body  ); 

// Copy Constructors
      OthersHandler(const OthersHandler& o); 
      OthersHandler(int lineno, const OthersHandler& o); 
   
};

class FieldInit : public ParseNode {
   
    private:
      Id* id_; 
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);
      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      FieldInit(Id* id , Expr* expr  ); 

      FieldInit(int lineno , Id* id , Expr* expr  ); 

// Copy Constructors
      FieldInit(const FieldInit& o); 
      FieldInit(int lineno, const FieldInit& o); 
   
};


// ======================= Expressions ==========================
class Expr : public ParseNode {
   public:			 
    enum Tag { NilT, LiteralT, InstantiationT,
      DotExprT, SuperIdT, SelfT, NewT, ArrayRefT, InvocExprT,
      BindingExprT, SelectorConstrT, ArrayConstrT, IdExprT, BinaryT,
      UnaryT, BracketRefT, BraceRefT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Expr(Tag tag ); 

      Expr(int lineno ,  Tag tag ); 

// Copy Constructors
      Expr(const Expr& o); 
      Expr(int lineno, const Expr& o); 
   
};

class BracketRef : public Expr {
   
    private:
      Expr* primary_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      BracketRef(Expr* primary , ParseNodeList* exprs  ); 

      BracketRef(int lineno , Expr* primary , ParseNodeList* exprs  ); 

// Copy Constructors
      BracketRef(const BracketRef& o); 
      BracketRef(int lineno, const BracketRef& o); 
   
};

class BraceRef : public Expr {
   
    private:
      Expr* primary_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      BraceRef(Expr* primary , ParseNodeList* exprs  ); 

      BraceRef(int lineno , Expr* primary , ParseNodeList* exprs  ); 

// Copy Constructors
      BraceRef(const BraceRef& o); 
      BraceRef(int lineno, const BraceRef& o); 
   
};

class Binary : public Expr {
   public:			 
    enum Tag { PlusT, MinusT, TimesT, DividesT, ModuloT, PowerT, AndT,
OrT, LTT, LTET, GTT, GTET, EqualT, ConcatT, NLTT, NLTET, NGTET, NGTT,
NotEqualT, EqualEqualT, NotEqualEqualT };
    tag();
   private:		
    Tag tag_;
    private:
      Expr* op1_; 
      Expr* op2_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_op1();
      void set_op1(Expr* val);
      Expr* get_op2();
      void set_op2(Expr* val);


// Constructors
      Binary(Tag tag ,Expr* op1 , Expr* op2  ); 

      Binary(int lineno ,  Tag tag ,Expr* op1 , Expr* op2  ); 

// Copy Constructors
      Binary(const Binary& o); 
      Binary(int lineno, const Binary& o); 
   
};

class Unary : public Expr {
   public:			 
    enum Tag { NotT, MinusT };
    tag();
   private:		
    Tag tag_;
    private:
      Expr* op_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_op();
      void set_op(Expr* val);


// Constructors
      Unary(Tag tag ,Expr* op  ); 

      Unary(int lineno ,  Tag tag ,Expr* op  ); 

// Copy Constructors
      Unary(const Unary& o); 
      Unary(int lineno, const Unary& o); 
   
};

class Literal : public Expr {
   public:			 
    enum Tag { IntLiteralT, BoolLiteralT, CharLiteralT, 
	StringLiteralT, RealLiteralT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      Literal(Tag tag ); 

      Literal(int lineno ,  Tag tag ); 

// Copy Constructors
      Literal(const Literal& o); 
      Literal(int lineno, const Literal& o); 
   
};

class IntLiteral : public Literal {
   
    private:
      int i_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      int get_i();
      void set_i(int val);


// Constructors
      IntLiteral(int i  ); 

      IntLiteral(int lineno , int i  ); 

// Copy Constructors
      IntLiteral(const IntLiteral& o); 
      IntLiteral(int lineno, const IntLiteral& o); 
   
};

class BoolLiteral : public Literal {
   
    private:
      int b_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      int get_b();
      void set_b(int val);


// Constructors
      BoolLiteral(int b  ); 

      BoolLiteral(int lineno , int b  ); 

// Copy Constructors
      BoolLiteral(const BoolLiteral& o); 
      BoolLiteral(int lineno, const BoolLiteral& o); 
   
};	/* Make proper boolean type! */

class CharLiteral : public Literal {
   
    private:
      char c_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      char get_c();
      void set_c(char val);


// Constructors
      CharLiteral(char c  ); 

      CharLiteral(int lineno , char c  ); 

// Copy Constructors
      CharLiteral(const CharLiteral& o); 
      CharLiteral(int lineno, const CharLiteral& o); 
   
};

class RealLiteral : public Literal {
   
    private:
      double r_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      double get_r();
      void set_r(double val);


// Constructors
      RealLiteral(double r  ); 

      RealLiteral(int lineno , double r  ); 

// Copy Constructors
      RealLiteral(const RealLiteral& o); 
      RealLiteral(int lineno, const RealLiteral& o); 
   
};

class StringLiteral : public Literal {
   
    private:
      string s_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      string get_s();
      void set_s(string val);


// Constructors
      StringLiteral(string s  ); 

      StringLiteral(int lineno , string s  ); 

// Copy Constructors
      StringLiteral(const StringLiteral& o); 
      StringLiteral(int lineno, const StringLiteral& o); 
   
};

class Instantiation : public Expr {
   
    private:
      TypeSpec* otypeSpec_; 
      Id* id_; 
      ParseNodeList* actualParms_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_otypeSpec();
      void set_otypeSpec(TypeSpec* val);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_actualParms();
      void set_actualParms(ParseNodeList* val);


// Constructors
      Instantiation(TypeSpec* otypeSpec , Id* id , ParseNodeList* actualParms  ); 

      Instantiation(int lineno , TypeSpec* otypeSpec , Id* id , ParseNodeList* actualParms  ); 

// Copy Constructors
      Instantiation(const Instantiation& o); 
      Instantiation(int lineno, const Instantiation& o); 
   
};

class DotExpr : public Expr {
   
    private:
      Expr* primary_; 
      Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      Id* get_id();
      void set_id(Id* val);


// Constructors
      DotExpr(Expr* primary , Id* id  ); 

      DotExpr(int lineno , Expr* primary , Id* id  ); 

// Copy Constructors
      DotExpr(const DotExpr& o); 
      DotExpr(int lineno, const DotExpr& o); 
   
};

class SuperId : public Expr {
   
    private:
      Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);


// Constructors
      SuperId(Id* id  ); 

      SuperId(int lineno , Id* id  ); 

// Copy Constructors
      SuperId(const SuperId& o); 
      SuperId(int lineno, const SuperId& o); 
   
};

class IdExpr : public Expr {
   
    private:
      Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);


// Constructors
      IdExpr(Id* id  ); 

      IdExpr(int lineno , Id* id  ); 

// Copy Constructors
      IdExpr(const IdExpr& o); 
      IdExpr(int lineno, const IdExpr& o); 
   
};

class ArrayRef : public Expr {
   
    private:
      Expr* primary_; 
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      ArrayRef(Expr* primary , Expr* expr  ); 

      ArrayRef(int lineno , Expr* primary , Expr* expr  ); 

// Copy Constructors
      ArrayRef(const ArrayRef& o); 
      ArrayRef(int lineno, const ArrayRef& o); 
   
};

class InvocExpr : public Expr {
   
    private:
      Invoc* invoc_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Invoc* get_invoc();
      void set_invoc(Invoc* val);


// Constructors
      InvocExpr(Invoc* invoc  ); 

      InvocExpr(int lineno , Invoc* invoc  ); 

// Copy Constructors
      InvocExpr(const InvocExpr& o); 
      InvocExpr(int lineno, const InvocExpr& o); 
   
};

class BindingExpr : public Expr {
   
    private:
      Binding* binding_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Binding* get_binding();
      void set_binding(Binding* val);


// Constructors
      BindingExpr(Binding* binding  ); 

      BindingExpr(int lineno , Binding* binding  ); 

// Copy Constructors
      BindingExpr(const BindingExpr& o); 
      BindingExpr(int lineno, const BindingExpr& o); 
   
};

class SelectorConstr : public Expr {
   
    private:
      TypeSpec* typeSpec_; 
      ParseNodeList* fields_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      ParseNodeList* get_fields();
      void set_fields(ParseNodeList* val);


// Constructors
      SelectorConstr(TypeSpec* typeSpec , ParseNodeList* fields  ); 

      SelectorConstr(int lineno , TypeSpec* typeSpec , ParseNodeList* fields  ); 

// Copy Constructors
      SelectorConstr(const SelectorConstr& o); 
      SelectorConstr(int lineno, const SelectorConstr& o); 
   
};

class ArrayConstr : public Expr {
   
    private:
      TypeSpec* typeSpec_; 
      Expr* size_; 
      ParseNodeList* exprs_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Expr* get_size();
      void set_size(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);


// Constructors
      ArrayConstr(TypeSpec* typeSpec , Expr* size , ParseNodeList* exprs  ); 

      ArrayConstr(int lineno , TypeSpec* typeSpec , Expr* size , ParseNodeList* exprs  ); 

// Copy Constructors
      ArrayConstr(const ArrayConstr& o); 
      ArrayConstr(int lineno, const ArrayConstr& o); 
   
};

class Invoc : public ParseNode {
   
    private:
      RoutineId* routineId_; 
      ParseNodeList* exprs_; 
      ParseNodeList* lastarg_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      RoutineId* get_routineId();
      void set_routineId(RoutineId* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);
      ParseNodeList* get_lastarg();
      void set_lastarg(ParseNodeList* val);


// Constructors
      Invoc(RoutineId* routineId , ParseNodeList* exprs , ParseNodeList* lastarg  ); 

      Invoc(int lineno , RoutineId* routineId , ParseNodeList* exprs , ParseNodeList* lastarg  ); 

// Copy Constructors
      Invoc(const Invoc& o); 
      Invoc(int lineno, const Invoc& o); 
   
};

class RoutineId : public ParseNode {
   public:			 
    enum Tag { SimpleRoutineIdT, ComplexRoutineIdT, SuperClassRoutineIdT };
    tag();
   private:		
    Tag tag_;
   
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Constructors
      RoutineId(Tag tag ); 

      RoutineId(int lineno ,  Tag tag ); 

// Copy Constructors
      RoutineId(const RoutineId& o); 
      RoutineId(int lineno, const RoutineId& o); 
   
};

class SimpleRoutineId : public RoutineId {
   
    private:
      Expr* primary_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);


// Constructors
      SimpleRoutineId(Expr* primary  ); 

      SimpleRoutineId(int lineno , Expr* primary  ); 

// Copy Constructors
      SimpleRoutineId(const SimpleRoutineId& o); 
      SimpleRoutineId(int lineno, const SimpleRoutineId& o); 
   
};

class ComplexRoutineId : public RoutineId {
   
    private:
      Expr* primary_; 
      ParseNodeList* parms_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);


// Constructors
      ComplexRoutineId(Expr* primary , ParseNodeList* parms  ); 

      ComplexRoutineId(int lineno , Expr* primary , ParseNodeList* parms  ); 

// Copy Constructors
      ComplexRoutineId(const ComplexRoutineId& o); 
      ComplexRoutineId(int lineno, const ComplexRoutineId& o); 
   
};

class SuperClassRoutineId : public RoutineId {
   
    private:
      Id* id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Id* get_id();
      void set_id(Id* val);


// Constructors
      SuperClassRoutineId(Id* id  ); 

      SuperClassRoutineId(int lineno , Id* id  ); 

// Copy Constructors
      SuperClassRoutineId(const SuperClassRoutineId& o); 
      SuperClassRoutineId(int lineno, const SuperClassRoutineId& o); 
   
};

class SuperInfo : public ParseNode {
   
    private:
      TypeSpec* typespec_; 
      ParseNodeList* renamings_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      TypeSpec* get_typespec();
      void set_typespec(TypeSpec* val);
      ParseNodeList* get_renamings();
      void set_renamings(ParseNodeList* val);


// Constructors
      SuperInfo(TypeSpec* typespec , ParseNodeList* renamings  ); 

      SuperInfo(int lineno , TypeSpec* typespec , ParseNodeList* renamings  ); 

// Copy Constructors
      SuperInfo(const SuperInfo& o); 
      SuperInfo(int lineno, const SuperInfo& o); 
   
};

class Binding : public ParseNode {
   
    private:
      Expr* proc_; 
      ParseNodeList* args_; 
      ParseNodeList* lastarg_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_proc();
      void set_proc(Expr* val);
      ParseNodeList* get_args();
      void set_args(ParseNodeList* val);
      ParseNodeList* get_lastarg();
      void set_lastarg(ParseNodeList* val);


// Constructors
      Binding(Expr* proc , ParseNodeList* args , ParseNodeList* lastarg  ); 

      Binding(int lineno , Expr* proc , ParseNodeList* args , ParseNodeList* lastarg  ); 

// Copy Constructors
      Binding(const Binding& o); 
      Binding(int lineno, const Binding& o); 
   
};

class BindingArg : public ParseNode {
   
    private:
      Expr* expr_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      Expr* get_expr();
      void set_expr(Expr* val);


// Constructors
      BindingArg(Expr* expr  ); 

      BindingArg(int lineno , Expr* expr  ); 

// Copy Constructors
      BindingArg(const BindingArg& o); 
      BindingArg(int lineno, const BindingArg& o); 
   
}; /* if expr is null, indicates "*" */

class Field : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
      TypeSpec* typeSpec_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);


// Constructors
      Field(ParseNodeList* ids , TypeSpec* typeSpec  ); 

      Field(int lineno , ParseNodeList* ids , TypeSpec* typeSpec  ); 

// Copy Constructors
      Field(const Field& o); 
      Field(int lineno, const Field& o); 
   
};

class Id : public ParseNode {
   
    private:
      string id_; 
 
    public: 
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

      string get_id();
      void set_id(string val);


// Constructors
      Id(string id  ); 

      Id(int lineno , string id  ); 

// Copy Constructors
      Id(const Id& o); 
      Id(int lineno, const Id& o); 
   
};

 Module::tag() {return tag_;} 
void Module::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Module:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Module::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Module* new_node = new Module(this->line, *this);

    return new_node;
}


ParseNode* Module::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Module::Module(Tag tag ) : ParseNode(ParseNode::ModuleT), tag_(tag)  
	{}

Module::Module(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::ModuleT), tag_(tag)  
	{line = lineno;}

Module::Module(const Module& o) : ParseNode(ParseNode::ModuleT), tag_(o.tag_)  
	{line = o.line;}

Module::Module(int lineno, const Module& o) : ParseNode(lineno, ParseNode::ModuleT), tag_(o.tag_)  
	{line = lineno;}

void SpecModule::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SpecModule:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (specs_) {print_parsenode_list(specs_, spaces+3);};

}

ParseNode* SpecModule::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SpecModule* new_node = new SpecModule(this->line, *this);
    new_node->specs_ = specs_ ? traverse_parsenode_list(specs_,tobj):0;

    return new_node;
}


ParseNode* SpecModule::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->specs_) propagate_parsenode_list(specs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* SpecModule::get_specs() {return specs_;}
void SpecModule::set_specs(ParseNodeList* val) {specs_ = val;}




// Constructor Implementations

SpecModule::SpecModule(ParseNodeList* specs  ) : Module(Module::SpecModuleT),  specs_(specs)  
	{}

SpecModule::SpecModule(int lineno , ParseNodeList* specs  ) : Module(lineno, Module::SpecModuleT),  specs_(specs)  
	{line = lineno;}

SpecModule::SpecModule(const SpecModule& o) : Module(Module::SpecModuleT),  specs_(o.specs_) 
	{line = o.line;}

SpecModule::SpecModule(int lineno, const SpecModule& o) : Module(lineno, Module::SpecModuleT),  specs_(o.specs_) 
	{line = lineno;}
 SpecElt::tag() {return tag_;} 
void SpecElt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SpecElt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* SpecElt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SpecElt* new_node = new SpecElt(this->line, *this);

    return new_node;
}


ParseNode* SpecElt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

SpecElt::SpecElt(Tag tag ) : ParseNode(ParseNode::SpecEltT), tag_(tag)  
	{}

SpecElt::SpecElt(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::SpecEltT), tag_(tag)  
	{line = lineno;}

SpecElt::SpecElt(const SpecElt& o) : ParseNode(ParseNode::SpecEltT), tag_(o.tag_)  
	{line = o.line;}

SpecElt::SpecElt(int lineno, const SpecElt& o) : ParseNode(lineno, ParseNode::SpecEltT), tag_(o.tag_)  
	{line = lineno;}

void TypeIntf::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeIntf:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (parms_) {print_parsenode_list(parms_, spaces+3);};
   if (supers_) {print_parsenode_list(supers_, spaces+3);};
   if (wheres_) {print_parsenode_list(wheres_, spaces+3);};
   if (methods_) {print_parsenode_list(methods_, spaces+3);};

}

ParseNode* TypeIntf::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeIntf* new_node = new TypeIntf(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->parms_ = parms_ ? traverse_parsenode_list(parms_,tobj):0;
    new_node->supers_ = supers_ ? traverse_parsenode_list(supers_,tobj):0;
    new_node->wheres_ = wheres_ ? traverse_parsenode_list(wheres_,tobj):0;
    new_node->methods_ = methods_ ? traverse_parsenode_list(methods_,tobj):0;

    return new_node;
}


ParseNode* TypeIntf::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->parms_) propagate_parsenode_list(parms_,tobj);
    if (this->supers_) propagate_parsenode_list(supers_,tobj);
    if (this->wheres_) propagate_parsenode_list(wheres_,tobj);
    if (this->methods_) propagate_parsenode_list(methods_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* TypeIntf::get_id() {return id_;}
void TypeIntf::set_id(Id* val) {id_ = val;}

ParseNodeList* TypeIntf::get_parms() {return parms_;}
void TypeIntf::set_parms(ParseNodeList* val) {parms_ = val;}

ParseNodeList* TypeIntf::get_supers() {return supers_;}
void TypeIntf::set_supers(ParseNodeList* val) {supers_ = val;}

ParseNodeList* TypeIntf::get_wheres() {return wheres_;}
void TypeIntf::set_wheres(ParseNodeList* val) {wheres_ = val;}

ParseNodeList* TypeIntf::get_methods() {return methods_;}
void TypeIntf::set_methods(ParseNodeList* val) {methods_ = val;}








// Constructor Implementations

TypeIntf::TypeIntf(Id* id , ParseNodeList* parms , ParseNodeList* supers , ParseNodeList* wheres , ParseNodeList* methods  ) : SpecElt(SpecElt::TypeIntfT),  id_(id), parms_(parms), supers_(supers), wheres_(wheres), methods_(methods)  
	{}

TypeIntf::TypeIntf(int lineno , Id* id , ParseNodeList* parms , ParseNodeList* supers , ParseNodeList* wheres , ParseNodeList* methods  ) : SpecElt(lineno, SpecElt::TypeIntfT),  id_(id), parms_(parms), supers_(supers), wheres_(wheres), methods_(methods)  
	{line = lineno;}

TypeIntf::TypeIntf(const TypeIntf& o) : SpecElt(SpecElt::TypeIntfT),  id_(o.id_), parms_(o.parms_), supers_(o.supers_), wheres_(o.wheres_), methods_(o.methods_) 
	{line = o.line;}

TypeIntf::TypeIntf(int lineno, const TypeIntf& o) : SpecElt(lineno, SpecElt::TypeIntfT),  id_(o.id_), parms_(o.parms_), supers_(o.supers_), wheres_(o.wheres_), methods_(o.methods_) 
	{line = lineno;}
 RoutineIntf::tag() {return tag_;} 
void RoutineIntf::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RoutineIntf:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (signature_) {signature_->print(spaces+3);}; 

}

ParseNode* RoutineIntf::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RoutineIntf* new_node = new RoutineIntf(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->signature_ = signature_ ? (Signature*)signature_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* RoutineIntf::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->signature_) (Signature*)signature_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* RoutineIntf::get_id() {return id_;}
void RoutineIntf::set_id(Id* val) {id_ = val;}

Signature* RoutineIntf::get_signature() {return signature_;}
void RoutineIntf::set_signature(Signature* val) {signature_ = val;}





// Constructor Implementations

RoutineIntf::RoutineIntf(Tag tag ,Id* id , Signature* signature  ) : ParseNode(ParseNode::RoutineIntfT), tag_(tag), id_(id), signature_(signature)  
	{}

RoutineIntf::RoutineIntf(int lineno ,  Tag tag ,Id* id , Signature* signature  ) : ParseNode(lineno, ParseNode::RoutineIntfT), tag_(tag), id_(id), signature_(signature)  
	{line = lineno;}

RoutineIntf::RoutineIntf(const RoutineIntf& o) : ParseNode(ParseNode::RoutineIntfT), tag_(o.tag_) , id_(o.id_), signature_(o.signature_) 
	{line = o.line;}

RoutineIntf::RoutineIntf(int lineno, const RoutineIntf& o) : ParseNode(lineno, ParseNode::RoutineIntfT), tag_(o.tag_) , id_(o.id_), signature_(o.signature_) 
	{line = lineno;}
 Signature::tag() {return tag_;} 
void Signature::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Signature:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (parms_) {print_parsenode_list(parms_, spaces+3);};
   if (args_) {print_parsenode_list(args_, spaces+3);};
   if (returns_) {print_parsenode_list(returns_, spaces+3);};
   if (signals_) {print_parsenode_list(signals_, spaces+3);};
   if (where_) {print_parsenode_list(where_, spaces+3);};

}

ParseNode* Signature::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Signature* new_node = new Signature(this->line, *this);
    new_node->parms_ = parms_ ? traverse_parsenode_list(parms_,tobj):0;
    new_node->args_ = args_ ? traverse_parsenode_list(args_,tobj):0;
    new_node->returns_ = returns_ ? traverse_parsenode_list(returns_,tobj):0;
    new_node->signals_ = signals_ ? traverse_parsenode_list(signals_,tobj):0;
    new_node->where_ = where_ ? traverse_parsenode_list(where_,tobj):0;

    return new_node;
}


ParseNode* Signature::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->parms_) propagate_parsenode_list(parms_,tobj);
    if (this->args_) propagate_parsenode_list(args_,tobj);
    if (this->returns_) propagate_parsenode_list(returns_,tobj);
    if (this->signals_) propagate_parsenode_list(signals_,tobj);
    if (this->where_) propagate_parsenode_list(where_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Signature::get_parms() {return parms_;}
void Signature::set_parms(ParseNodeList* val) {parms_ = val;}

ParseNodeList* Signature::get_args() {return args_;}
void Signature::set_args(ParseNodeList* val) {args_ = val;}

ParseNodeList* Signature::get_returns() {return returns_;}
void Signature::set_returns(ParseNodeList* val) {returns_ = val;}

ParseNodeList* Signature::get_signals() {return signals_;}
void Signature::set_signals(ParseNodeList* val) {signals_ = val;}

ParseNodeList* Signature::get_where() {return where_;}
void Signature::set_where(ParseNodeList* val) {where_ = val;}








// Constructor Implementations

Signature::Signature(Tag tag ,ParseNodeList* parms , ParseNodeList* args , ParseNodeList* returns , ParseNodeList* signals , ParseNodeList* where  ) : ParseNode(ParseNode::SignatureT), tag_(tag), parms_(parms), args_(args), returns_(returns), signals_(signals), where_(where)  
	{}

Signature::Signature(int lineno ,  Tag tag ,ParseNodeList* parms , ParseNodeList* args , ParseNodeList* returns , ParseNodeList* signals , ParseNodeList* where  ) : ParseNode(lineno, ParseNode::SignatureT), tag_(tag), parms_(parms), args_(args), returns_(returns), signals_(signals), where_(where)  
	{line = lineno;}

Signature::Signature(const Signature& o) : ParseNode(ParseNode::SignatureT), tag_(o.tag_) , parms_(o.parms_), args_(o.args_), returns_(o.returns_), signals_(o.signals_), where_(o.where_) 
	{line = o.line;}

Signature::Signature(int lineno, const Signature& o) : ParseNode(lineno, ParseNode::SignatureT), tag_(o.tag_) , parms_(o.parms_), args_(o.args_), returns_(o.returns_), signals_(o.signals_), where_(o.where_) 
	{line = lineno;}

void RoutineSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RoutineSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (routine_) {routine_->print(spaces+3);}; 

}

ParseNode* RoutineSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RoutineSpec* new_node = new RoutineSpec(this->line, *this);
    new_node->routine_ = routine_ ? (RoutineIntf*)routine_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* RoutineSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->routine_) (RoutineIntf*)routine_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

RoutineIntf* RoutineSpec::get_routine() {return routine_;}
void RoutineSpec::set_routine(RoutineIntf* val) {routine_ = val;}




// Constructor Implementations

RoutineSpec::RoutineSpec(RoutineIntf* routine  ) : SpecElt(SpecElt::RoutineSpecT),  routine_(routine)  
	{}

RoutineSpec::RoutineSpec(int lineno , RoutineIntf* routine  ) : SpecElt(lineno, SpecElt::RoutineSpecT),  routine_(routine)  
	{line = lineno;}

RoutineSpec::RoutineSpec(const RoutineSpec& o) : SpecElt(SpecElt::RoutineSpecT),  routine_(o.routine_) 
	{line = o.line;}

RoutineSpec::RoutineSpec(int lineno, const RoutineSpec& o) : SpecElt(lineno, SpecElt::RoutineSpecT),  routine_(o.routine_) 
	{line = lineno;}

void SpecEquate::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SpecEquate:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (equate_) {equate_->print(spaces+3);}; 

}

ParseNode* SpecEquate::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SpecEquate* new_node = new SpecEquate(this->line, *this);
    new_node->equate_ = equate_ ? (Equate *)equate_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* SpecEquate::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->equate_) (Equate *)equate_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Equate * SpecEquate::get_equate() {return equate_;}
void SpecEquate::set_equate(Equate * val) {equate_ = val;}




// Constructor Implementations

SpecEquate::SpecEquate(Equate * equate  ) : SpecElt(SpecElt::SpecEquateT),  equate_(equate)  
	{}

SpecEquate::SpecEquate(int lineno , Equate * equate  ) : SpecElt(lineno, SpecElt::SpecEquateT),  equate_(equate)  
	{line = lineno;}

SpecEquate::SpecEquate(const SpecEquate& o) : SpecElt(SpecElt::SpecEquateT),  equate_(o.equate_) 
	{line = o.line;}

SpecEquate::SpecEquate(int lineno, const SpecEquate& o) : SpecElt(lineno, SpecElt::SpecEquateT),  equate_(o.equate_) 
	{line = lineno;}
 Equate::tag() {return tag_;} 
void Equate::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Equate:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Equate::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Equate* new_node = new Equate(this->line, *this);

    return new_node;
}


ParseNode* Equate::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Equate::Equate(Tag tag ) : ParseNode(ParseNode::EquateT), tag_(tag)  
	{}

Equate::Equate(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::EquateT), tag_(tag)  
	{line = lineno;}

Equate::Equate(const Equate& o) : ParseNode(ParseNode::EquateT), tag_(o.tag_)  
	{line = o.line;}

Equate::Equate(int lineno, const Equate& o) : ParseNode(lineno, ParseNode::EquateT), tag_(o.tag_)  
	{line = lineno;}

void ExprEquate::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ExprEquate:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* ExprEquate::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ExprEquate* new_node = new ExprEquate(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ExprEquate::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* ExprEquate::get_id() {return id_;}
void ExprEquate::set_id(Id* val) {id_ = val;}

Expr* ExprEquate::get_expr() {return expr_;}
void ExprEquate::set_expr(Expr* val) {expr_ = val;}





// Constructor Implementations

ExprEquate::ExprEquate(Id* id , Expr* expr  ) : Equate(Equate::ExprEquateT),  id_(id), expr_(expr)  
	{}

ExprEquate::ExprEquate(int lineno , Id* id , Expr* expr  ) : Equate(lineno, Equate::ExprEquateT),  id_(id), expr_(expr)  
	{line = lineno;}

ExprEquate::ExprEquate(const ExprEquate& o) : Equate(Equate::ExprEquateT),  id_(o.id_), expr_(o.expr_) 
	{line = o.line;}

ExprEquate::ExprEquate(int lineno, const ExprEquate& o) : Equate(lineno, Equate::ExprEquateT),  id_(o.id_), expr_(o.expr_) 
	{line = lineno;}

void TypeEquate::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeEquate:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typ_) {typ_->print(spaces+3);}; 

}

ParseNode* TypeEquate::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeEquate* new_node = new TypeEquate(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typ_ = typ_ ? (TypeSpec*)typ_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* TypeEquate::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typ_) (TypeSpec*)typ_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* TypeEquate::get_id() {return id_;}
void TypeEquate::set_id(Id* val) {id_ = val;}

TypeSpec* TypeEquate::get_typ() {return typ_;}
void TypeEquate::set_typ(TypeSpec* val) {typ_ = val;}





// Constructor Implementations

TypeEquate::TypeEquate(Id* id , TypeSpec* typ  ) : Equate(Equate::TypeEquateT),  id_(id), typ_(typ)  
	{}

TypeEquate::TypeEquate(int lineno , Id* id , TypeSpec* typ  ) : Equate(lineno, Equate::TypeEquateT),  id_(id), typ_(typ)  
	{line = lineno;}

TypeEquate::TypeEquate(const TypeEquate& o) : Equate(Equate::TypeEquateT),  id_(o.id_), typ_(o.typ_) 
	{line = o.line;}

TypeEquate::TypeEquate(int lineno, const TypeEquate& o) : Equate(lineno, Equate::TypeEquateT),  id_(o.id_), typ_(o.typ_) 
	{line = lineno;}

void ImplModule::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ImplModule:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (exports_) {print_parsenode_list(exports_, spaces+3);};
   if (equates_) {print_parsenode_list(equates_, spaces+3);};
   if (impls_) {print_parsenode_list(impls_, spaces+3);};

}

ParseNode* ImplModule::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ImplModule* new_node = new ImplModule(this->line, *this);
    new_node->exports_ = exports_ ? traverse_parsenode_list(exports_,tobj):0;
    new_node->equates_ = equates_ ? traverse_parsenode_list(equates_,tobj):0;
    new_node->impls_ = impls_ ? traverse_parsenode_list(impls_,tobj):0;

    return new_node;
}


ParseNode* ImplModule::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->exports_) propagate_parsenode_list(exports_,tobj);
    if (this->equates_) propagate_parsenode_list(equates_,tobj);
    if (this->impls_) propagate_parsenode_list(impls_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* ImplModule::get_exports() {return exports_;}
void ImplModule::set_exports(ParseNodeList* val) {exports_ = val;}

ParseNodeList* ImplModule::get_equates() {return equates_;}
void ImplModule::set_equates(ParseNodeList* val) {equates_ = val;}

ParseNodeList* ImplModule::get_impls() {return impls_;}
void ImplModule::set_impls(ParseNodeList* val) {impls_ = val;}






// Constructor Implementations

ImplModule::ImplModule(ParseNodeList* exports , ParseNodeList* equates , ParseNodeList* impls  ) : Module(Module::ImplModuleT),  exports_(exports), equates_(equates), impls_(impls)  
	{}

ImplModule::ImplModule(int lineno , ParseNodeList* exports , ParseNodeList* equates , ParseNodeList* impls  ) : Module(lineno, Module::ImplModuleT),  exports_(exports), equates_(equates), impls_(impls)  
	{line = lineno;}

ImplModule::ImplModule(const ImplModule& o) : Module(Module::ImplModuleT),  exports_(o.exports_), equates_(o.equates_), impls_(o.impls_) 
	{line = o.line;}

ImplModule::ImplModule(int lineno, const ImplModule& o) : Module(lineno, Module::ImplModuleT),  exports_(o.exports_), equates_(o.equates_), impls_(o.impls_) 
	{line = lineno;}
 ImplElt::tag() {return tag_;} 
void ImplElt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ImplElt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* ImplElt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ImplElt* new_node = new ImplElt(this->line, *this);

    return new_node;
}


ParseNode* ImplElt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

ImplElt::ImplElt(Tag tag ) : ParseNode(ParseNode::ImplEltT), tag_(tag)  
	{}

ImplElt::ImplElt(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::ImplEltT), tag_(tag)  
	{line = lineno;}

ImplElt::ImplElt(const ImplElt& o) : ParseNode(ParseNode::ImplEltT), tag_(o.tag_)  
	{line = o.line;}

ImplElt::ImplElt(int lineno, const ImplElt& o) : ParseNode(lineno, ParseNode::ImplEltT), tag_(o.tag_)  
	{line = lineno;}

void RoutineDef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RoutineDef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (routineIntf_) {routineIntf_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* RoutineDef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RoutineDef* new_node = new RoutineDef(this->line, *this);
    new_node->routineIntf_ = routineIntf_ ? (RoutineIntf*)routineIntf_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* RoutineDef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->routineIntf_) (RoutineIntf*)routineIntf_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

RoutineIntf* RoutineDef::get_routineIntf() {return routineIntf_;}
void RoutineDef::set_routineIntf(RoutineIntf* val) {routineIntf_ = val;}

Body* RoutineDef::get_body() {return body_;}
void RoutineDef::set_body(Body* val) {body_ = val;}





// Constructor Implementations

RoutineDef::RoutineDef(RoutineIntf* routineIntf , Body* body  ) : ImplElt(ImplElt::RoutineDefT),  routineIntf_(routineIntf), body_(body)  
	{}

RoutineDef::RoutineDef(int lineno , RoutineIntf* routineIntf , Body* body  ) : ImplElt(lineno, ImplElt::RoutineDefT),  routineIntf_(routineIntf), body_(body)  
	{line = lineno;}

RoutineDef::RoutineDef(const RoutineDef& o) : ImplElt(ImplElt::RoutineDefT),  routineIntf_(o.routineIntf_), body_(o.body_) 
	{line = o.line;}

RoutineDef::RoutineDef(int lineno, const RoutineDef& o) : ImplElt(lineno, ImplElt::RoutineDefT),  routineIntf_(o.routineIntf_), body_(o.body_) 
	{line = lineno;}

void ImplEquate::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ImplEquate:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (equate_) {equate_->print(spaces+3);}; 

}

ParseNode* ImplEquate::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ImplEquate* new_node = new ImplEquate(this->line, *this);
    new_node->equate_ = equate_ ? (Equate *)equate_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ImplEquate::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->equate_) (Equate *)equate_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Equate * ImplEquate::get_equate() {return equate_;}
void ImplEquate::set_equate(Equate * val) {equate_ = val;}




// Constructor Implementations

ImplEquate::ImplEquate(Equate * equate  ) : ImplElt(ImplElt::ImplEquateT),  equate_(equate)  
	{}

ImplEquate::ImplEquate(int lineno , Equate * equate  ) : ImplElt(lineno, ImplElt::ImplEquateT),  equate_(equate)  
	{line = lineno;}

ImplEquate::ImplEquate(const ImplEquate& o) : ImplElt(ImplElt::ImplEquateT),  equate_(o.equate_) 
	{line = o.line;}

ImplEquate::ImplEquate(int lineno, const ImplEquate& o) : ImplElt(lineno, ImplElt::ImplEquateT),  equate_(o.equate_) 
	{line = lineno;}

void ClassDef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ClassDef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (classId_) {classId_->print(spaces+3);}; 
   if (deftype_) {deftype_->print(spaces+3);}; 
   if (parms_) {print_parsenode_list(parms_, spaces+3);};
   if (wheres_) {print_parsenode_list(wheres_, spaces+3);};
   if (inherits_) {inherits_->print(spaces+3);}; 
   if (exports_) {exports_->print(spaces+3);}; 
   if (hides_) {print_parsenode_list(hides_, spaces+3);};
  put_spaces(spaces+11); printf("int:%d\n",immutable_);
   if (equates_) {print_parsenode_list(equates_, spaces+3);};
   if (decl_) {print_parsenode_list(decl_, spaces+3);};
   if (classElts_) {print_parsenode_list(classElts_, spaces+3);};

}

ParseNode* ClassDef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ClassDef* new_node = new ClassDef(this->line, *this);
    new_node->classId_ = classId_ ? (Id*)classId_->traverse(tobj) : 0; 
    new_node->deftype_ = deftype_ ? (TypeSpec*)deftype_->traverse(tobj) : 0; 
    new_node->parms_ = parms_ ? traverse_parsenode_list(parms_,tobj):0;
    new_node->wheres_ = wheres_ ? traverse_parsenode_list(wheres_,tobj):0;
    new_node->inherits_ = inherits_ ? (Inherit*)inherits_->traverse(tobj) : 0; 
    new_node->exports_ = exports_ ? (Export*)exports_->traverse(tobj) : 0; 
    new_node->hides_ = hides_ ? traverse_parsenode_list(hides_,tobj):0;
   new_node->immutable_ = immutable_;
    new_node->equates_ = equates_ ? traverse_parsenode_list(equates_,tobj):0;
    new_node->decl_ = decl_ ? traverse_parsenode_list(decl_,tobj):0;
    new_node->classElts_ = classElts_ ? traverse_parsenode_list(classElts_,tobj):0;

    return new_node;
}


ParseNode* ClassDef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->classId_) (Id*)classId_->propagate(tobj); 
    if (this->deftype_) (TypeSpec*)deftype_->propagate(tobj); 
    if (this->parms_) propagate_parsenode_list(parms_,tobj);
    if (this->wheres_) propagate_parsenode_list(wheres_,tobj);
    if (this->inherits_) (Inherit*)inherits_->propagate(tobj); 
    if (this->exports_) (Export*)exports_->propagate(tobj); 
    if (this->hides_) propagate_parsenode_list(hides_,tobj);
   this->immutable_ = immutable_;
    if (this->equates_) propagate_parsenode_list(equates_,tobj);
    if (this->decl_) propagate_parsenode_list(decl_,tobj);
    if (this->classElts_) propagate_parsenode_list(classElts_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* ClassDef::get_classId() {return classId_;}
void ClassDef::set_classId(Id* val) {classId_ = val;}

TypeSpec* ClassDef::get_deftype() {return deftype_;}
void ClassDef::set_deftype(TypeSpec* val) {deftype_ = val;}

ParseNodeList* ClassDef::get_parms() {return parms_;}
void ClassDef::set_parms(ParseNodeList* val) {parms_ = val;}

ParseNodeList* ClassDef::get_wheres() {return wheres_;}
void ClassDef::set_wheres(ParseNodeList* val) {wheres_ = val;}

Inherit* ClassDef::get_inherits() {return inherits_;}
void ClassDef::set_inherits(Inherit* val) {inherits_ = val;}

Export* ClassDef::get_exports() {return exports_;}
void ClassDef::set_exports(Export* val) {exports_ = val;}

ParseNodeList* ClassDef::get_hides() {return hides_;}
void ClassDef::set_hides(ParseNodeList* val) {hides_ = val;}

int ClassDef::get_immutable() {return immutable_;}
void ClassDef::set_immutable(int val) {immutable_ = val;}

ParseNodeList* ClassDef::get_equates() {return equates_;}
void ClassDef::set_equates(ParseNodeList* val) {equates_ = val;}

ParseNodeList* ClassDef::get_decl() {return decl_;}
void ClassDef::set_decl(ParseNodeList* val) {decl_ = val;}

ParseNodeList* ClassDef::get_classElts() {return classElts_;}
void ClassDef::set_classElts(ParseNodeList* val) {classElts_ = val;}














// Constructor Implementations

ClassDef::ClassDef(Id* classId , TypeSpec* deftype , ParseNodeList* parms , ParseNodeList* wheres , Inherit* inherits , Export* exports , ParseNodeList* hides , int immutable , ParseNodeList* equates , ParseNodeList* decl , ParseNodeList* classElts  ) : ImplElt(ImplElt::ClassDefT),  classId_(classId), deftype_(deftype), parms_(parms), wheres_(wheres), inherits_(inherits), exports_(exports), hides_(hides), immutable_(immutable), equates_(equates), decl_(decl), classElts_(classElts)  
	{}

ClassDef::ClassDef(int lineno , Id* classId , TypeSpec* deftype , ParseNodeList* parms , ParseNodeList* wheres , Inherit* inherits , Export* exports , ParseNodeList* hides , int immutable , ParseNodeList* equates , ParseNodeList* decl , ParseNodeList* classElts  ) : ImplElt(lineno, ImplElt::ClassDefT),  classId_(classId), deftype_(deftype), parms_(parms), wheres_(wheres), inherits_(inherits), exports_(exports), hides_(hides), immutable_(immutable), equates_(equates), decl_(decl), classElts_(classElts)  
	{line = lineno;}

ClassDef::ClassDef(const ClassDef& o) : ImplElt(ImplElt::ClassDefT),  classId_(o.classId_), deftype_(o.deftype_), parms_(o.parms_), wheres_(o.wheres_), inherits_(o.inherits_), exports_(o.exports_), hides_(o.hides_), immutable_(o.immutable_), equates_(o.equates_), decl_(o.decl_), classElts_(o.classElts_) 
	{line = o.line;}

ClassDef::ClassDef(int lineno, const ClassDef& o) : ImplElt(lineno, ImplElt::ClassDefT),  classId_(o.classId_), deftype_(o.deftype_), parms_(o.parms_), wheres_(o.wheres_), inherits_(o.inherits_), exports_(o.exports_), hides_(o.hides_), immutable_(o.immutable_), equates_(o.equates_), decl_(o.decl_), classElts_(o.classElts_) 
	{line = lineno;}
 ClassElt::tag() {return tag_;} 
void ClassElt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ClassElt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* ClassElt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ClassElt* new_node = new ClassElt(this->line, *this);

    return new_node;
}


ParseNode* ClassElt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

ClassElt::ClassElt(Tag tag ) : ParseNode(ParseNode::ClassEltT), tag_(tag)  
	{}

ClassElt::ClassElt(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::ClassEltT), tag_(tag)  
	{line = lineno;}

ClassElt::ClassElt(const ClassElt& o) : ParseNode(ParseNode::ClassEltT), tag_(o.tag_)  
	{line = o.line;}

ClassElt::ClassElt(int lineno, const ClassElt& o) : ParseNode(lineno, ParseNode::ClassEltT), tag_(o.tag_)  
	{line = lineno;}

void Inherit::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Inherit:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (classSpec_) {classSpec_->print(spaces+3);}; 

}

ParseNode* Inherit::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Inherit* new_node = new Inherit(this->line, *this);
    new_node->classSpec_ = classSpec_ ? (TypeSpec*)classSpec_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Inherit::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->classSpec_) (TypeSpec*)classSpec_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* Inherit::get_classSpec() {return classSpec_;}
void Inherit::set_classSpec(TypeSpec* val) {classSpec_ = val;}




// Constructor Implementations

Inherit::Inherit(TypeSpec* classSpec  ) : ParseNode(ParseNode::InheritT),  classSpec_(classSpec)  
	{}

Inherit::Inherit(int lineno , TypeSpec* classSpec  ) : ParseNode(lineno, ParseNode::InheritT),  classSpec_(classSpec)  
	{line = lineno;}

Inherit::Inherit(const Inherit& o) : ParseNode(ParseNode::InheritT),  classSpec_(o.classSpec_) 
	{line = o.line;}

Inherit::Inherit(int lineno, const Inherit& o) : ParseNode(lineno, ParseNode::InheritT),  classSpec_(o.classSpec_) 
	{line = lineno;}

void Renaming::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Renaming:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (from_) {from_->print(spaces+3);}; 
   if (to_) {to_->print(spaces+3);}; 

}

ParseNode* Renaming::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Renaming* new_node = new Renaming(this->line, *this);
    new_node->from_ = from_ ? (Expr*)from_->traverse(tobj) : 0; 
    new_node->to_ = to_ ? (Id*)to_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Renaming::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->from_) (Expr*)from_->propagate(tobj); 
    if (this->to_) (Id*)to_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Renaming::get_from() {return from_;}
void Renaming::set_from(Expr* val) {from_ = val;}

Id* Renaming::get_to() {return to_;}
void Renaming::set_to(Id* val) {to_ = val;}





// Constructor Implementations

Renaming::Renaming(Expr* from , Id* to  ) : ParseNode(ParseNode::RenamingT),  from_(from), to_(to)  
	{}

Renaming::Renaming(int lineno , Expr* from , Id* to  ) : ParseNode(lineno, ParseNode::RenamingT),  from_(from), to_(to)  
	{line = lineno;}

Renaming::Renaming(const Renaming& o) : ParseNode(ParseNode::RenamingT),  from_(o.from_), to_(o.to_) 
	{line = o.line;}

Renaming::Renaming(int lineno, const Renaming& o) : ParseNode(lineno, ParseNode::RenamingT),  from_(o.from_), to_(o.to_) 
	{line = lineno;}

void Export::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Export:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (exported_) {print_parsenode_list(exported_, spaces+3);};

}

ParseNode* Export::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Export* new_node = new Export(this->line, *this);
    new_node->exported_ = exported_ ? traverse_parsenode_list(exported_,tobj):0;

    return new_node;
}


ParseNode* Export::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->exported_) propagate_parsenode_list(exported_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Export::get_exported() {return exported_;}
void Export::set_exported(ParseNodeList* val) {exported_ = val;}




// Constructor Implementations

Export::Export(ParseNodeList* exported  ) : ParseNode(ParseNode::ExportT),  exported_(exported)  
	{}

Export::Export(int lineno , ParseNodeList* exported  ) : ParseNode(lineno, ParseNode::ExportT),  exported_(exported)  
	{line = lineno;}

Export::Export(const Export& o) : ParseNode(ParseNode::ExportT),  exported_(o.exported_) 
	{line = o.line;}

Export::Export(int lineno, const Export& o) : ParseNode(lineno, ParseNode::ExportT),  exported_(o.exported_) 
	{line = lineno;}

void MethodOrOpDef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("MethodOrOpDef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("int:%d\n",isOp_);
  put_spaces(spaces+11); printf("int:%d\n",IsConstr_);
   if (routineDef_) {routineDef_->print(spaces+3);}; 

}

ParseNode* MethodOrOpDef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    MethodOrOpDef* new_node = new MethodOrOpDef(this->line, *this);
   new_node->isOp_ = isOp_;
   new_node->IsConstr_ = IsConstr_;
    new_node->routineDef_ = routineDef_ ? (RoutineDef*)routineDef_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* MethodOrOpDef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->isOp_ = isOp_;
   this->IsConstr_ = IsConstr_;
    if (this->routineDef_) (RoutineDef*)routineDef_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

int MethodOrOpDef::get_isOp() {return isOp_;}
void MethodOrOpDef::set_isOp(int val) {isOp_ = val;}

int MethodOrOpDef::get_IsConstr() {return IsConstr_;}
void MethodOrOpDef::set_IsConstr(int val) {IsConstr_ = val;}

RoutineDef* MethodOrOpDef::get_routineDef() {return routineDef_;}
void MethodOrOpDef::set_routineDef(RoutineDef* val) {routineDef_ = val;}






// Constructor Implementations

MethodOrOpDef::MethodOrOpDef(int isOp , int IsConstr , RoutineDef* routineDef  ) : ParseNode(ParseNode::MethodOrOpDefT),  isOp_(isOp), IsConstr_(IsConstr), routineDef_(routineDef)  
	{}

MethodOrOpDef::MethodOrOpDef(int lineno , int isOp , int IsConstr , RoutineDef* routineDef  ) : ParseNode(lineno, ParseNode::MethodOrOpDefT),  isOp_(isOp), IsConstr_(IsConstr), routineDef_(routineDef)  
	{line = lineno;}

MethodOrOpDef::MethodOrOpDef(const MethodOrOpDef& o) : ParseNode(ParseNode::MethodOrOpDefT),  isOp_(o.isOp_), IsConstr_(o.IsConstr_), routineDef_(o.routineDef_) 
	{line = o.line;}

MethodOrOpDef::MethodOrOpDef(int lineno, const MethodOrOpDef& o) : ParseNode(lineno, ParseNode::MethodOrOpDefT),  isOp_(o.isOp_), IsConstr_(o.IsConstr_), routineDef_(o.routineDef_) 
	{line = lineno;}

void Parm::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Parm:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};

}

ParseNode* Parm::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Parm* new_node = new Parm(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;

    return new_node;
}


ParseNode* Parm::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Parm::get_ids() {return ids_;}
void Parm::set_ids(ParseNodeList* val) {ids_ = val;}




// Constructor Implementations

Parm::Parm(ParseNodeList* ids  ) : ParseNode(ParseNode::ParmT),  ids_(ids)  
	{}

Parm::Parm(int lineno , ParseNodeList* ids  ) : ParseNode(lineno, ParseNode::ParmT),  ids_(ids)  
	{line = lineno;}

Parm::Parm(const Parm& o) : ParseNode(ParseNode::ParmT),  ids_(o.ids_) 
	{line = o.line;}

Parm::Parm(int lineno, const Parm& o) : ParseNode(lineno, ParseNode::ParmT),  ids_(o.ids_) 
	{line = lineno;}

void Formal::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Formal:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 

}

ParseNode* Formal::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Formal* new_node = new Formal(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Formal::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* Formal::get_id() {return id_;}
void Formal::set_id(Id* val) {id_ = val;}

TypeSpec* Formal::get_typeSpec() {return typeSpec_;}
void Formal::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}





// Constructor Implementations

Formal::Formal(Id* id , TypeSpec* typeSpec  ) : ParseNode(ParseNode::FormalT),  id_(id), typeSpec_(typeSpec)  
	{}

Formal::Formal(int lineno , Id* id , TypeSpec* typeSpec  ) : ParseNode(lineno, ParseNode::FormalT),  id_(id), typeSpec_(typeSpec)  
	{line = lineno;}

Formal::Formal(const Formal& o) : ParseNode(ParseNode::FormalT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = o.line;}

Formal::Formal(int lineno, const Formal& o) : ParseNode(lineno, ParseNode::FormalT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = lineno;}

void Exception::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Exception:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typeSpec_) {print_parsenode_list(typeSpec_, spaces+3);};

}

ParseNode* Exception::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Exception* new_node = new Exception(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typeSpec_ = typeSpec_ ? traverse_parsenode_list(typeSpec_,tobj):0;

    return new_node;
}


ParseNode* Exception::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typeSpec_) propagate_parsenode_list(typeSpec_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* Exception::get_id() {return id_;}
void Exception::set_id(Id* val) {id_ = val;}

ParseNodeList* Exception::get_typeSpec() {return typeSpec_;}
void Exception::set_typeSpec(ParseNodeList* val) {typeSpec_ = val;}





// Constructor Implementations

Exception::Exception(Id* id , ParseNodeList* typeSpec  ) : ParseNode(ParseNode::ExceptionT),  id_(id), typeSpec_(typeSpec)  
	{}

Exception::Exception(int lineno , Id* id , ParseNodeList* typeSpec  ) : ParseNode(lineno, ParseNode::ExceptionT),  id_(id), typeSpec_(typeSpec)  
	{line = lineno;}

Exception::Exception(const Exception& o) : ParseNode(ParseNode::ExceptionT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = o.line;}

Exception::Exception(int lineno, const Exception& o) : ParseNode(lineno, ParseNode::ExceptionT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = lineno;}

void Restriction::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Restriction:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (TypeId_) {TypeId_->print(spaces+3);}; 
   if (operations_) {print_parsenode_list(operations_, spaces+3);};

}

ParseNode* Restriction::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Restriction* new_node = new Restriction(this->line, *this);
    new_node->TypeId_ = TypeId_ ? (Id*)TypeId_->traverse(tobj) : 0; 
    new_node->operations_ = operations_ ? traverse_parsenode_list(operations_,tobj):0;

    return new_node;
}


ParseNode* Restriction::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->TypeId_) (Id*)TypeId_->propagate(tobj); 
    if (this->operations_) propagate_parsenode_list(operations_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* Restriction::get_TypeId() {return TypeId_;}
void Restriction::set_TypeId(Id* val) {TypeId_ = val;}

ParseNodeList* Restriction::get_operations() {return operations_;}
void Restriction::set_operations(ParseNodeList* val) {operations_ = val;}





// Constructor Implementations

Restriction::Restriction(Id* TypeId , ParseNodeList* operations  ) : ParseNode(ParseNode::RestrictionT),  TypeId_(TypeId), operations_(operations)  
	{}

Restriction::Restriction(int lineno , Id* TypeId , ParseNodeList* operations  ) : ParseNode(lineno, ParseNode::RestrictionT),  TypeId_(TypeId), operations_(operations)  
	{line = lineno;}

Restriction::Restriction(const Restriction& o) : ParseNode(ParseNode::RestrictionT),  TypeId_(o.TypeId_), operations_(o.operations_) 
	{line = o.line;}

Restriction::Restriction(int lineno, const Restriction& o) : ParseNode(lineno, ParseNode::RestrictionT),  TypeId_(o.TypeId_), operations_(o.operations_) 
	{line = lineno;}
 TypeSpec::tag() {return tag_;} 
void TypeSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* TypeSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeSpec* new_node = new TypeSpec(this->line, *this);

    return new_node;
}


ParseNode* TypeSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

TypeSpec::TypeSpec(Tag tag ) : ParseNode(ParseNode::TypeSpecT), tag_(tag)  
	{}

TypeSpec::TypeSpec(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::TypeSpecT), tag_(tag)  
	{line = lineno;}

TypeSpec::TypeSpec(const TypeSpec& o) : ParseNode(ParseNode::TypeSpecT), tag_(o.tag_)  
	{line = o.line;}

TypeSpec::TypeSpec(int lineno, const TypeSpec& o) : ParseNode(lineno, ParseNode::TypeSpecT), tag_(o.tag_)  
	{line = lineno;}

void TypeName::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeName:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (name_) {name_->print(spaces+3);}; 

}

ParseNode* TypeName::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeName* new_node = new TypeName(this->line, *this);
    new_node->name_ = name_ ? (Id*)name_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* TypeName::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->name_) (Id*)name_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* TypeName::get_name() {return name_;}
void TypeName::set_name(Id* val) {name_ = val;}




// Constructor Implementations

TypeName::TypeName(Id* name  ) : ParseNode(ParseNode::TypeNameT),  name_(name)  
	{}

TypeName::TypeName(int lineno , Id* name  ) : ParseNode(lineno, ParseNode::TypeNameT),  name_(name)  
	{line = lineno;}

TypeName::TypeName(const TypeName& o) : ParseNode(ParseNode::TypeNameT),  name_(o.name_) 
	{line = o.line;}

TypeName::TypeName(int lineno, const TypeName& o) : ParseNode(lineno, ParseNode::TypeNameT),  name_(o.name_) 
	{line = lineno;}

void TypeObject::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeObject:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  

}

ParseNode* TypeObject::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeObject* new_node = new TypeObject(this->line, *this);
   

    return new_node;
}


ParseNode* TypeObject::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeInterface* TypeObject::get_leaf_type() {return leaf_type_;}
void TypeObject::set_leaf_type(TypeInterface* val) {leaf_type_ = val;}




// Constructor Implementations

TypeObject::TypeObject(TypeInterface* leaf_type  ) : ParseNode(ParseNode::TypeObjectT),  leaf_type_(leaf_type)  
	{}

TypeObject::TypeObject(int lineno , TypeInterface* leaf_type  ) : ParseNode(lineno, ParseNode::TypeObjectT),  leaf_type_(leaf_type)  
	{line = lineno;}

TypeObject::TypeObject(const TypeObject& o) : ParseNode(ParseNode::TypeObjectT),  leaf_type_(o.leaf_type_) 
	{line = o.line;}

TypeObject::TypeObject(int lineno, const TypeObject& o) : ParseNode(lineno, ParseNode::TypeObjectT),  leaf_type_(o.leaf_type_) 
	{line = lineno;}

void SimpleTypeSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SimpleTypeSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (name_) {name_->print(spaces+3);}; 

}

ParseNode* SimpleTypeSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SimpleTypeSpec* new_node = new SimpleTypeSpec(this->line, *this);
    new_node->name_ = name_ ? (TypeName*)name_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* SimpleTypeSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->name_) (TypeName*)name_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeName* SimpleTypeSpec::get_name() {return name_;}
void SimpleTypeSpec::set_name(TypeName* val) {name_ = val;}




// Constructor Implementations

SimpleTypeSpec::SimpleTypeSpec(TypeName* name  ) : TypeSpec(TypeSpec::SimpleTypeSpecT),  name_(name)  
	{}

SimpleTypeSpec::SimpleTypeSpec(int lineno , TypeName* name  ) : TypeSpec(lineno, TypeSpec::SimpleTypeSpecT),  name_(name)  
	{line = lineno;}

SimpleTypeSpec::SimpleTypeSpec(const SimpleTypeSpec& o) : TypeSpec(TypeSpec::SimpleTypeSpecT),  name_(o.name_) 
	{line = o.line;}

SimpleTypeSpec::SimpleTypeSpec(int lineno, const SimpleTypeSpec& o) : TypeSpec(lineno, TypeSpec::SimpleTypeSpecT),  name_(o.name_) 
	{line = lineno;}

void ParamTypeSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ParamTypeSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (name_) {name_->print(spaces+3);}; 
   if (actualParms_) {print_parsenode_list(actualParms_, spaces+3);};

}

ParseNode* ParamTypeSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ParamTypeSpec* new_node = new ParamTypeSpec(this->line, *this);
    new_node->name_ = name_ ? (TypeName*)name_->traverse(tobj) : 0; 
    new_node->actualParms_ = actualParms_ ? traverse_parsenode_list(actualParms_,tobj):0;

    return new_node;
}


ParseNode* ParamTypeSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->name_) (TypeName*)name_->propagate(tobj); 
    if (this->actualParms_) propagate_parsenode_list(actualParms_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeName* ParamTypeSpec::get_name() {return name_;}
void ParamTypeSpec::set_name(TypeName* val) {name_ = val;}

ParseNodeList* ParamTypeSpec::get_actualParms() {return actualParms_;}
void ParamTypeSpec::set_actualParms(ParseNodeList* val) {actualParms_ = val;}





// Constructor Implementations

ParamTypeSpec::ParamTypeSpec(TypeName* name , ParseNodeList* actualParms  ) : TypeSpec(TypeSpec::ParamTypeSpecT),  name_(name), actualParms_(actualParms)  
	{}

ParamTypeSpec::ParamTypeSpec(int lineno , TypeName* name , ParseNodeList* actualParms  ) : TypeSpec(lineno, TypeSpec::ParamTypeSpecT),  name_(name), actualParms_(actualParms)  
	{line = lineno;}

ParamTypeSpec::ParamTypeSpec(const ParamTypeSpec& o) : TypeSpec(TypeSpec::ParamTypeSpecT),  name_(o.name_), actualParms_(o.actualParms_) 
	{line = o.line;}

ParamTypeSpec::ParamTypeSpec(int lineno, const ParamTypeSpec& o) : TypeSpec(lineno, TypeSpec::ParamTypeSpecT),  name_(o.name_), actualParms_(o.actualParms_) 
	{line = lineno;}

void TaggedTypeSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TaggedTypeSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (name_) {name_->print(spaces+3);}; 
   if (fields_) {print_parsenode_list(fields_, spaces+3);};

}

ParseNode* TaggedTypeSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TaggedTypeSpec* new_node = new TaggedTypeSpec(this->line, *this);
    new_node->name_ = name_ ? (TypeName*)name_->traverse(tobj) : 0; 
    new_node->fields_ = fields_ ? traverse_parsenode_list(fields_,tobj):0;

    return new_node;
}


ParseNode* TaggedTypeSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->name_) (TypeName*)name_->propagate(tobj); 
    if (this->fields_) propagate_parsenode_list(fields_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeName* TaggedTypeSpec::get_name() {return name_;}
void TaggedTypeSpec::set_name(TypeName* val) {name_ = val;}

ParseNodeList* TaggedTypeSpec::get_fields() {return fields_;}
void TaggedTypeSpec::set_fields(ParseNodeList* val) {fields_ = val;}





// Constructor Implementations

TaggedTypeSpec::TaggedTypeSpec(TypeName* name , ParseNodeList* fields  ) : TypeSpec(TypeSpec::TaggedTypeSpecT),  name_(name), fields_(fields)  
	{}

TaggedTypeSpec::TaggedTypeSpec(int lineno , TypeName* name , ParseNodeList* fields  ) : TypeSpec(lineno, TypeSpec::TaggedTypeSpecT),  name_(name), fields_(fields)  
	{line = lineno;}

TaggedTypeSpec::TaggedTypeSpec(const TaggedTypeSpec& o) : TypeSpec(TypeSpec::TaggedTypeSpecT),  name_(o.name_), fields_(o.fields_) 
	{line = o.line;}

TaggedTypeSpec::TaggedTypeSpec(int lineno, const TaggedTypeSpec& o) : TypeSpec(lineno, TypeSpec::TaggedTypeSpecT),  name_(o.name_), fields_(o.fields_) 
	{line = lineno;}

void RoutineTypeSpec::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RoutineTypeSpec:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (signature_) {signature_->print(spaces+3);}; 

}

ParseNode* RoutineTypeSpec::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RoutineTypeSpec* new_node = new RoutineTypeSpec(this->line, *this);
    new_node->signature_ = signature_ ? (Signature*)signature_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* RoutineTypeSpec::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->signature_) (Signature*)signature_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Signature* RoutineTypeSpec::get_signature() {return signature_;}
void RoutineTypeSpec::set_signature(Signature* val) {signature_ = val;}




// Constructor Implementations

RoutineTypeSpec::RoutineTypeSpec(Signature* signature  ) : TypeSpec(TypeSpec::RoutineTypeSpecT),  signature_(signature)  
	{}

RoutineTypeSpec::RoutineTypeSpec(int lineno , Signature* signature  ) : TypeSpec(lineno, TypeSpec::RoutineTypeSpecT),  signature_(signature)  
	{line = lineno;}

RoutineTypeSpec::RoutineTypeSpec(const RoutineTypeSpec& o) : TypeSpec(TypeSpec::RoutineTypeSpecT),  signature_(o.signature_) 
	{line = o.line;}

RoutineTypeSpec::RoutineTypeSpec(int lineno, const RoutineTypeSpec& o) : TypeSpec(lineno, TypeSpec::RoutineTypeSpecT),  signature_(o.signature_) 
	{line = lineno;}

void ActualParm::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ActualParm:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 
   if (newNames_) {print_parsenode_list(newNames_, spaces+3);};

}

ParseNode* ActualParm::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ActualParm* new_node = new ActualParm(this->line, *this);
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 
    new_node->newNames_ = newNames_ ? traverse_parsenode_list(newNames_,tobj):0;

    return new_node;
}


ParseNode* ActualParm::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 
    if (this->newNames_) propagate_parsenode_list(newNames_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* ActualParm::get_typeSpec() {return typeSpec_;}
void ActualParm::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}

ParseNodeList* ActualParm::get_newNames() {return newNames_;}
void ActualParm::set_newNames(ParseNodeList* val) {newNames_ = val;}





// Constructor Implementations

ActualParm::ActualParm(TypeSpec* typeSpec , ParseNodeList* newNames  ) : ParseNode(ParseNode::ActualParmT),  typeSpec_(typeSpec), newNames_(newNames)  
	{}

ActualParm::ActualParm(int lineno , TypeSpec* typeSpec , ParseNodeList* newNames  ) : ParseNode(lineno, ParseNode::ActualParmT),  typeSpec_(typeSpec), newNames_(newNames)  
	{line = lineno;}

ActualParm::ActualParm(const ActualParm& o) : ParseNode(ParseNode::ActualParmT),  typeSpec_(o.typeSpec_), newNames_(o.newNames_) 
	{line = o.line;}

ActualParm::ActualParm(int lineno, const ActualParm& o) : ParseNode(lineno, ParseNode::ActualParmT),  typeSpec_(o.typeSpec_), newNames_(o.newNames_) 
	{line = lineno;}

void ParmOp::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ParmOp:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* ParmOp::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ParmOp* new_node = new ParmOp(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ParmOp::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->id_) (Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* ParmOp::get_primary() {return primary_;}
void ParmOp::set_primary(Expr* val) {primary_ = val;}

Id* ParmOp::get_id() {return id_;}
void ParmOp::set_id(Id* val) {id_ = val;}





// Constructor Implementations

ParmOp::ParmOp(Expr* primary , Id* id  ) : ParseNode(ParseNode::ParmOpT),  primary_(primary), id_(id)  
	{}

ParmOp::ParmOp(int lineno , Expr* primary , Id* id  ) : ParseNode(lineno, ParseNode::ParmOpT),  primary_(primary), id_(id)  
	{line = lineno;}

ParmOp::ParmOp(const ParmOp& o) : ParseNode(ParseNode::ParmOpT),  primary_(o.primary_), id_(o.id_) 
	{line = o.line;}

ParmOp::ParmOp(int lineno, const ParmOp& o) : ParseNode(lineno, ParseNode::ParmOpT),  primary_(o.primary_), id_(o.id_) 
	{line = lineno;}
 Stmt::tag() {return tag_;} 
void Stmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Stmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Stmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Stmt* new_node = new Stmt(this->line, *this);

    return new_node;
}


ParseNode* Stmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Stmt::Stmt(Tag tag ) : ParseNode(ParseNode::StmtT), tag_(tag)  
	{}

Stmt::Stmt(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::StmtT), tag_(tag)  
	{line = lineno;}

Stmt::Stmt(const Stmt& o) : ParseNode(ParseNode::StmtT), tag_(o.tag_)  
	{line = o.line;}

Stmt::Stmt(int lineno, const Stmt& o) : ParseNode(lineno, ParseNode::StmtT), tag_(o.tag_)  
	{line = lineno;}

void DeclStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("DeclStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (decl_) {decl_->print(spaces+3);}; 

}

ParseNode* DeclStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    DeclStmt* new_node = new DeclStmt(this->line, *this);
    new_node->decl_ = decl_ ? (Decl*)decl_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* DeclStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->decl_) (Decl*)decl_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Decl* DeclStmt::get_decl() {return decl_;}
void DeclStmt::set_decl(Decl* val) {decl_ = val;}




// Constructor Implementations

DeclStmt::DeclStmt(Decl* decl  ) : Stmt(Stmt::DeclStmtT),  decl_(decl)  
	{}

DeclStmt::DeclStmt(int lineno , Decl* decl  ) : Stmt(lineno, Stmt::DeclStmtT),  decl_(decl)  
	{line = lineno;}

DeclStmt::DeclStmt(const DeclStmt& o) : Stmt(Stmt::DeclStmtT),  decl_(o.decl_) 
	{line = o.line;}

DeclStmt::DeclStmt(int lineno, const DeclStmt& o) : Stmt(lineno, Stmt::DeclStmtT),  decl_(o.decl_) 
	{line = lineno;}
 Decl::tag() {return tag_;} 
void Decl::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Decl:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Decl::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Decl* new_node = new Decl(this->line, *this);

    return new_node;
}


ParseNode* Decl::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Decl::Decl(Tag tag ) : ParseNode(ParseNode::DeclT), tag_(tag)  
	{}

Decl::Decl(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::DeclT), tag_(tag)  
	{line = lineno;}

Decl::Decl(const Decl& o) : ParseNode(ParseNode::DeclT), tag_(o.tag_)  
	{line = o.line;}

Decl::Decl(int lineno, const Decl& o) : ParseNode(lineno, ParseNode::DeclT), tag_(o.tag_)  
	{line = lineno;}

void RegDecl::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RegDecl:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 

}

ParseNode* RegDecl::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RegDecl* new_node = new RegDecl(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* RegDecl::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* RegDecl::get_ids() {return ids_;}
void RegDecl::set_ids(ParseNodeList* val) {ids_ = val;}

TypeSpec* RegDecl::get_typeSpec() {return typeSpec_;}
void RegDecl::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}





// Constructor Implementations

RegDecl::RegDecl(ParseNodeList* ids , TypeSpec* typeSpec  ) : Decl(Decl::RegDeclT),  ids_(ids), typeSpec_(typeSpec)  
	{}

RegDecl::RegDecl(int lineno , ParseNodeList* ids , TypeSpec* typeSpec  ) : Decl(lineno, Decl::RegDeclT),  ids_(ids), typeSpec_(typeSpec)  
	{line = lineno;}

RegDecl::RegDecl(const RegDecl& o) : Decl(Decl::RegDeclT),  ids_(o.ids_), typeSpec_(o.typeSpec_) 
	{line = o.line;}

RegDecl::RegDecl(int lineno, const RegDecl& o) : Decl(lineno, Decl::RegDeclT),  ids_(o.ids_), typeSpec_(o.typeSpec_) 
	{line = lineno;}

void VarArgsDecl::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("VarArgsDecl:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 

}

ParseNode* VarArgsDecl::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    VarArgsDecl* new_node = new VarArgsDecl(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* VarArgsDecl::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* VarArgsDecl::get_id() {return id_;}
void VarArgsDecl::set_id(Id* val) {id_ = val;}

TypeSpec* VarArgsDecl::get_typeSpec() {return typeSpec_;}
void VarArgsDecl::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}





// Constructor Implementations

VarArgsDecl::VarArgsDecl(Id* id , TypeSpec* typeSpec  ) : Decl(Decl::VarArgsDeclT),  id_(id), typeSpec_(typeSpec)  
	{}

VarArgsDecl::VarArgsDecl(int lineno , Id* id , TypeSpec* typeSpec  ) : Decl(lineno, Decl::VarArgsDeclT),  id_(id), typeSpec_(typeSpec)  
	{line = lineno;}

VarArgsDecl::VarArgsDecl(const VarArgsDecl& o) : Decl(Decl::VarArgsDeclT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = o.line;}

VarArgsDecl::VarArgsDecl(int lineno, const VarArgsDecl& o) : Decl(lineno, Decl::VarArgsDeclT),  id_(o.id_), typeSpec_(o.typeSpec_) 
	{line = lineno;}

void ImplDecl::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ImplDecl:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 
   if (get_) {get_->print(spaces+3);}; 
   if (set_) {set_->print(spaces+3);}; 

}

ParseNode* ImplDecl::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ImplDecl* new_node = new ImplDecl(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 
    new_node->get_ = get_ ? (Id*)get_->traverse(tobj) : 0; 
    new_node->set_ = set_ ? (Id*)set_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ImplDecl::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 
    if (this->get_) (Id*)get_->propagate(tobj); 
    if (this->set_) (Id*)set_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* ImplDecl::get_id() {return id_;}
void ImplDecl::set_id(Id* val) {id_ = val;}

TypeSpec* ImplDecl::get_typeSpec() {return typeSpec_;}
void ImplDecl::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}

Id* ImplDecl::get_get() {return get_;}
void ImplDecl::set_get(Id* val) {get_ = val;}

Id* ImplDecl::get_set() {return set_;}
void ImplDecl::set_set(Id* val) {set_ = val;}







// Constructor Implementations

ImplDecl::ImplDecl(Id* id , TypeSpec* typeSpec , Id* get , Id* set  ) : Decl(Decl::ImplDeclT),  id_(id), typeSpec_(typeSpec), get_(get), set_(set)  
	{}

ImplDecl::ImplDecl(int lineno , Id* id , TypeSpec* typeSpec , Id* get , Id* set  ) : Decl(lineno, Decl::ImplDeclT),  id_(id), typeSpec_(typeSpec), get_(get), set_(set)  
	{line = lineno;}

ImplDecl::ImplDecl(const ImplDecl& o) : Decl(Decl::ImplDeclT),  id_(o.id_), typeSpec_(o.typeSpec_), get_(o.get_), set_(o.set_) 
	{line = o.line;}

ImplDecl::ImplDecl(int lineno, const ImplDecl& o) : Decl(lineno, Decl::ImplDeclT),  id_(o.id_), typeSpec_(o.typeSpec_), get_(o.get_), set_(o.set_) 
	{line = lineno;}

void InitVarExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("InitVarExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (decl_) {decl_->print(spaces+3);}; 
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* InitVarExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    InitVarExpr* new_node = new InitVarExpr(this->line, *this);
    new_node->decl_ = decl_ ? (Decl*)decl_->traverse(tobj) : 0; 
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* InitVarExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->decl_) (Decl*)decl_->propagate(tobj); 
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Decl* InitVarExpr::get_decl() {return decl_;}
void InitVarExpr::set_decl(Decl* val) {decl_ = val;}

Expr* InitVarExpr::get_expr() {return expr_;}
void InitVarExpr::set_expr(Expr* val) {expr_ = val;}





// Constructor Implementations

InitVarExpr::InitVarExpr(Decl* decl , Expr* expr  ) : Stmt(Stmt::InitVarExprT),  decl_(decl), expr_(expr)  
	{}

InitVarExpr::InitVarExpr(int lineno , Decl* decl , Expr* expr  ) : Stmt(lineno, Stmt::InitVarExprT),  decl_(decl), expr_(expr)  
	{line = lineno;}

InitVarExpr::InitVarExpr(const InitVarExpr& o) : Stmt(Stmt::InitVarExprT),  decl_(o.decl_), expr_(o.expr_) 
	{line = o.line;}

InitVarExpr::InitVarExpr(int lineno, const InitVarExpr& o) : Stmt(lineno, Stmt::InitVarExprT),  decl_(o.decl_), expr_(o.expr_) 
	{line = lineno;}

void InitVarInvoke::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("InitVarInvoke:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (decls_) {print_parsenode_list(decls_, spaces+3);};
   if (invoc_) {invoc_->print(spaces+3);}; 

}

ParseNode* InitVarInvoke::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    InitVarInvoke* new_node = new InitVarInvoke(this->line, *this);
    new_node->decls_ = decls_ ? traverse_parsenode_list(decls_,tobj):0;
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* InitVarInvoke::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->decls_) propagate_parsenode_list(decls_,tobj);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* InitVarInvoke::get_decls() {return decls_;}
void InitVarInvoke::set_decls(ParseNodeList* val) {decls_ = val;}

Invoc* InitVarInvoke::get_invoc() {return invoc_;}
void InitVarInvoke::set_invoc(Invoc* val) {invoc_ = val;}





// Constructor Implementations

InitVarInvoke::InitVarInvoke(ParseNodeList* decls , Invoc* invoc  ) : Stmt(Stmt::InitVarInvokeT),  decls_(decls), invoc_(invoc)  
	{}

InitVarInvoke::InitVarInvoke(int lineno , ParseNodeList* decls , Invoc* invoc  ) : Stmt(lineno, Stmt::InitVarInvokeT),  decls_(decls), invoc_(invoc)  
	{line = lineno;}

InitVarInvoke::InitVarInvoke(const InitVarInvoke& o) : Stmt(Stmt::InitVarInvokeT),  decls_(o.decls_), invoc_(o.invoc_) 
	{line = o.line;}

InitVarInvoke::InitVarInvoke(int lineno, const InitVarInvoke& o) : Stmt(lineno, Stmt::InitVarInvokeT),  decls_(o.decls_), invoc_(o.invoc_) 
	{line = lineno;}

void AssignInvoke::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("AssignInvoke:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (idOrIvars_) {print_parsenode_list(idOrIvars_, spaces+3);};
   if (invoc_) {invoc_->print(spaces+3);}; 

}

ParseNode* AssignInvoke::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    AssignInvoke* new_node = new AssignInvoke(this->line, *this);
    new_node->idOrIvars_ = idOrIvars_ ? traverse_parsenode_list(idOrIvars_,tobj):0;
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* AssignInvoke::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->idOrIvars_) propagate_parsenode_list(idOrIvars_,tobj);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* AssignInvoke::get_idOrIvars() {return idOrIvars_;}
void AssignInvoke::set_idOrIvars(ParseNodeList* val) {idOrIvars_ = val;}

Invoc* AssignInvoke::get_invoc() {return invoc_;}
void AssignInvoke::set_invoc(Invoc* val) {invoc_ = val;}





// Constructor Implementations

AssignInvoke::AssignInvoke(ParseNodeList* idOrIvars , Invoc* invoc  ) : Stmt(Stmt::AssignInvokeT),  idOrIvars_(idOrIvars), invoc_(invoc)  
	{}

AssignInvoke::AssignInvoke(int lineno , ParseNodeList* idOrIvars , Invoc* invoc  ) : Stmt(lineno, Stmt::AssignInvokeT),  idOrIvars_(idOrIvars), invoc_(invoc)  
	{line = lineno;}

AssignInvoke::AssignInvoke(const AssignInvoke& o) : Stmt(Stmt::AssignInvokeT),  idOrIvars_(o.idOrIvars_), invoc_(o.invoc_) 
	{line = o.line;}

AssignInvoke::AssignInvoke(int lineno, const AssignInvoke& o) : Stmt(lineno, Stmt::AssignInvokeT),  idOrIvars_(o.idOrIvars_), invoc_(o.invoc_) 
	{line = lineno;}

void AssignExprStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("AssignExprStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* AssignExprStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    AssignExprStmt* new_node = new AssignExprStmt(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* AssignExprStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* AssignExprStmt::get_ids() {return ids_;}
void AssignExprStmt::set_ids(ParseNodeList* val) {ids_ = val;}

ParseNodeList* AssignExprStmt::get_exprs() {return exprs_;}
void AssignExprStmt::set_exprs(ParseNodeList* val) {exprs_ = val;}





// Constructor Implementations

AssignExprStmt::AssignExprStmt(ParseNodeList* ids , ParseNodeList* exprs  ) : Stmt(Stmt::AssignExprStmtT),  ids_(ids), exprs_(exprs)  
	{}

AssignExprStmt::AssignExprStmt(int lineno , ParseNodeList* ids , ParseNodeList* exprs  ) : Stmt(lineno, Stmt::AssignExprStmtT),  ids_(ids), exprs_(exprs)  
	{line = lineno;}

AssignExprStmt::AssignExprStmt(const AssignExprStmt& o) : Stmt(Stmt::AssignExprStmtT),  ids_(o.ids_), exprs_(o.exprs_) 
	{line = o.line;}

AssignExprStmt::AssignExprStmt(int lineno, const AssignExprStmt& o) : Stmt(lineno, Stmt::AssignExprStmtT),  ids_(o.ids_), exprs_(o.exprs_) 
	{line = lineno;}

void AssignExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("AssignExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (primaryExpr_) {primaryExpr_->print(spaces+3);}; 
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* AssignExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    AssignExpr* new_node = new AssignExpr(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->primaryExpr_ = primaryExpr_ ? (Expr*)primaryExpr_->traverse(tobj) : 0; 
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* AssignExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->primaryExpr_) (Expr*)primaryExpr_->propagate(tobj); 
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* AssignExpr::get_primary() {return primary_;}
void AssignExpr::set_primary(Expr* val) {primary_ = val;}

Expr* AssignExpr::get_primaryExpr() {return primaryExpr_;}
void AssignExpr::set_primaryExpr(Expr* val) {primaryExpr_ = val;}

Expr* AssignExpr::get_expr() {return expr_;}
void AssignExpr::set_expr(Expr* val) {expr_ = val;}






// Constructor Implementations

AssignExpr::AssignExpr(Expr* primary , Expr* primaryExpr , Expr* expr  ) : Stmt(Stmt::AssignExprT),  primary_(primary), primaryExpr_(primaryExpr), expr_(expr)  
	{}

AssignExpr::AssignExpr(int lineno , Expr* primary , Expr* primaryExpr , Expr* expr  ) : Stmt(lineno, Stmt::AssignExprT),  primary_(primary), primaryExpr_(primaryExpr), expr_(expr)  
	{line = lineno;}

AssignExpr::AssignExpr(const AssignExpr& o) : Stmt(Stmt::AssignExprT),  primary_(o.primary_), primaryExpr_(o.primaryExpr_), expr_(o.expr_) 
	{line = o.line;}

AssignExpr::AssignExpr(int lineno, const AssignExpr& o) : Stmt(lineno, Stmt::AssignExprT),  primary_(o.primary_), primaryExpr_(o.primaryExpr_), expr_(o.expr_) 
	{line = lineno;}

void InvokeStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("InvokeStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (invoc_) {invoc_->print(spaces+3);}; 

}

ParseNode* InvokeStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    InvokeStmt* new_node = new InvokeStmt(this->line, *this);
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* InvokeStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Invoc* InvokeStmt::get_invoc() {return invoc_;}
void InvokeStmt::set_invoc(Invoc* val) {invoc_ = val;}




// Constructor Implementations

InvokeStmt::InvokeStmt(Invoc* invoc  ) : Stmt(Stmt::InvokeStmtT),  invoc_(invoc)  
	{}

InvokeStmt::InvokeStmt(int lineno , Invoc* invoc  ) : Stmt(lineno, Stmt::InvokeStmtT),  invoc_(invoc)  
	{line = lineno;}

InvokeStmt::InvokeStmt(const InvokeStmt& o) : Stmt(Stmt::InvokeStmtT),  invoc_(o.invoc_) 
	{line = o.line;}

InvokeStmt::InvokeStmt(int lineno, const InvokeStmt& o) : Stmt(lineno, Stmt::InvokeStmtT),  invoc_(o.invoc_) 
	{line = lineno;}

void WhileStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("WhileStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* WhileStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    WhileStmt* new_node = new WhileStmt(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* WhileStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* WhileStmt::get_expr() {return expr_;}
void WhileStmt::set_expr(Expr* val) {expr_ = val;}

Body* WhileStmt::get_body() {return body_;}
void WhileStmt::set_body(Body* val) {body_ = val;}





// Constructor Implementations

WhileStmt::WhileStmt(Expr* expr , Body* body  ) : Stmt(Stmt::WhileStmtT),  expr_(expr), body_(body)  
	{}

WhileStmt::WhileStmt(int lineno , Expr* expr , Body* body  ) : Stmt(lineno, Stmt::WhileStmtT),  expr_(expr), body_(body)  
	{line = lineno;}

WhileStmt::WhileStmt(const WhileStmt& o) : Stmt(Stmt::WhileStmtT),  expr_(o.expr_), body_(o.body_) 
	{line = o.line;}

WhileStmt::WhileStmt(int lineno, const WhileStmt& o) : Stmt(lineno, Stmt::WhileStmtT),  expr_(o.expr_), body_(o.body_) 
	{line = lineno;}

void IfStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("IfStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 
   if (elseifs_) {print_parsenode_list(elseifs_, spaces+3);};
   if (elsebody_) {elsebody_->print(spaces+3);}; 

}

ParseNode* IfStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    IfStmt* new_node = new IfStmt(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 
    new_node->elseifs_ = elseifs_ ? traverse_parsenode_list(elseifs_,tobj):0;
    new_node->elsebody_ = elsebody_ ? (Body*)elsebody_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* IfStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 
    if (this->elseifs_) propagate_parsenode_list(elseifs_,tobj);
    if (this->elsebody_) (Body*)elsebody_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* IfStmt::get_expr() {return expr_;}
void IfStmt::set_expr(Expr* val) {expr_ = val;}

Body* IfStmt::get_body() {return body_;}
void IfStmt::set_body(Body* val) {body_ = val;}

ParseNodeList* IfStmt::get_elseifs() {return elseifs_;}
void IfStmt::set_elseifs(ParseNodeList* val) {elseifs_ = val;}

Body* IfStmt::get_elsebody() {return elsebody_;}
void IfStmt::set_elsebody(Body* val) {elsebody_ = val;}







// Constructor Implementations

IfStmt::IfStmt(Expr* expr , Body* body , ParseNodeList* elseifs , Body* elsebody  ) : Stmt(Stmt::IfStmtT),  expr_(expr), body_(body), elseifs_(elseifs), elsebody_(elsebody)  
	{}

IfStmt::IfStmt(int lineno , Expr* expr , Body* body , ParseNodeList* elseifs , Body* elsebody  ) : Stmt(lineno, Stmt::IfStmtT),  expr_(expr), body_(body), elseifs_(elseifs), elsebody_(elsebody)  
	{line = lineno;}

IfStmt::IfStmt(const IfStmt& o) : Stmt(Stmt::IfStmtT),  expr_(o.expr_), body_(o.body_), elseifs_(o.elseifs_), elsebody_(o.elsebody_) 
	{line = o.line;}

IfStmt::IfStmt(int lineno, const IfStmt& o) : Stmt(lineno, Stmt::IfStmtT),  expr_(o.expr_), body_(o.body_), elseifs_(o.elseifs_), elsebody_(o.elsebody_) 
	{line = lineno;}

void DeclForStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("DeclForStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (decls_) {print_parsenode_list(decls_, spaces+3);};
   if (invoc_) {invoc_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* DeclForStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    DeclForStmt* new_node = new DeclForStmt(this->line, *this);
    new_node->decls_ = decls_ ? traverse_parsenode_list(decls_,tobj):0;
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* DeclForStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->decls_) propagate_parsenode_list(decls_,tobj);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* DeclForStmt::get_decls() {return decls_;}
void DeclForStmt::set_decls(ParseNodeList* val) {decls_ = val;}

Invoc* DeclForStmt::get_invoc() {return invoc_;}
void DeclForStmt::set_invoc(Invoc* val) {invoc_ = val;}

Body* DeclForStmt::get_body() {return body_;}
void DeclForStmt::set_body(Body* val) {body_ = val;}






// Constructor Implementations

DeclForStmt::DeclForStmt(ParseNodeList* decls , Invoc* invoc , Body* body  ) : Stmt(Stmt::DeclForStmtT),  decls_(decls), invoc_(invoc), body_(body)  
	{}

DeclForStmt::DeclForStmt(int lineno , ParseNodeList* decls , Invoc* invoc , Body* body  ) : Stmt(lineno, Stmt::DeclForStmtT),  decls_(decls), invoc_(invoc), body_(body)  
	{line = lineno;}

DeclForStmt::DeclForStmt(const DeclForStmt& o) : Stmt(Stmt::DeclForStmtT),  decls_(o.decls_), invoc_(o.invoc_), body_(o.body_) 
	{line = o.line;}

DeclForStmt::DeclForStmt(int lineno, const DeclForStmt& o) : Stmt(lineno, Stmt::DeclForStmtT),  decls_(o.decls_), invoc_(o.invoc_), body_(o.body_) 
	{line = lineno;}

void ForStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ForStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};
   if (invoc_) {invoc_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* ForStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ForStmt* new_node = new ForStmt(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ForStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* ForStmt::get_ids() {return ids_;}
void ForStmt::set_ids(ParseNodeList* val) {ids_ = val;}

Invoc* ForStmt::get_invoc() {return invoc_;}
void ForStmt::set_invoc(Invoc* val) {invoc_ = val;}

Body* ForStmt::get_body() {return body_;}
void ForStmt::set_body(Body* val) {body_ = val;}






// Constructor Implementations

ForStmt::ForStmt(ParseNodeList* ids , Invoc* invoc , Body* body  ) : Stmt(Stmt::ForStmtT),  ids_(ids), invoc_(invoc), body_(body)  
	{}

ForStmt::ForStmt(int lineno , ParseNodeList* ids , Invoc* invoc , Body* body  ) : Stmt(lineno, Stmt::ForStmtT),  ids_(ids), invoc_(invoc), body_(body)  
	{line = lineno;}

ForStmt::ForStmt(const ForStmt& o) : Stmt(Stmt::ForStmtT),  ids_(o.ids_), invoc_(o.invoc_), body_(o.body_) 
	{line = o.line;}

ForStmt::ForStmt(int lineno, const ForStmt& o) : Stmt(lineno, Stmt::ForStmtT),  ids_(o.ids_), invoc_(o.invoc_), body_(o.body_) 
	{line = lineno;}

void Tagcase::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Tagcase:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 
   if (tagWhenArms_) {print_parsenode_list(tagWhenArms_, spaces+3);};
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* Tagcase::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Tagcase* new_node = new Tagcase(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 
    new_node->tagWhenArms_ = tagWhenArms_ ? traverse_parsenode_list(tagWhenArms_,tobj):0;
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Tagcase::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 
    if (this->tagWhenArms_) propagate_parsenode_list(tagWhenArms_,tobj);
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Tagcase::get_expr() {return expr_;}
void Tagcase::set_expr(Expr* val) {expr_ = val;}

ParseNodeList* Tagcase::get_tagWhenArms() {return tagWhenArms_;}
void Tagcase::set_tagWhenArms(ParseNodeList* val) {tagWhenArms_ = val;}

Body* Tagcase::get_body() {return body_;}
void Tagcase::set_body(Body* val) {body_ = val;}






// Constructor Implementations

Tagcase::Tagcase(Expr* expr , ParseNodeList* tagWhenArms , Body* body  ) : Stmt(Stmt::TagcaseT),  expr_(expr), tagWhenArms_(tagWhenArms), body_(body)  
	{}

Tagcase::Tagcase(int lineno , Expr* expr , ParseNodeList* tagWhenArms , Body* body  ) : Stmt(lineno, Stmt::TagcaseT),  expr_(expr), tagWhenArms_(tagWhenArms), body_(body)  
	{line = lineno;}

Tagcase::Tagcase(const Tagcase& o) : Stmt(Stmt::TagcaseT),  expr_(o.expr_), tagWhenArms_(o.tagWhenArms_), body_(o.body_) 
	{line = o.line;}

Tagcase::Tagcase(int lineno, const Tagcase& o) : Stmt(lineno, Stmt::TagcaseT),  expr_(o.expr_), tagWhenArms_(o.tagWhenArms_), body_(o.body_) 
	{line = lineno;}

void Typecase::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Typecase:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 
   if (typeWhenArms_) {print_parsenode_list(typeWhenArms_, spaces+3);};
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* Typecase::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Typecase* new_node = new Typecase(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 
    new_node->typeWhenArms_ = typeWhenArms_ ? traverse_parsenode_list(typeWhenArms_,tobj):0;
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Typecase::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 
    if (this->typeWhenArms_) propagate_parsenode_list(typeWhenArms_,tobj);
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Typecase::get_expr() {return expr_;}
void Typecase::set_expr(Expr* val) {expr_ = val;}

ParseNodeList* Typecase::get_typeWhenArms() {return typeWhenArms_;}
void Typecase::set_typeWhenArms(ParseNodeList* val) {typeWhenArms_ = val;}

Body* Typecase::get_body() {return body_;}
void Typecase::set_body(Body* val) {body_ = val;}






// Constructor Implementations

Typecase::Typecase(Expr* expr , ParseNodeList* typeWhenArms , Body* body  ) : Stmt(Stmt::TypecaseT),  expr_(expr), typeWhenArms_(typeWhenArms), body_(body)  
	{}

Typecase::Typecase(int lineno , Expr* expr , ParseNodeList* typeWhenArms , Body* body  ) : Stmt(lineno, Stmt::TypecaseT),  expr_(expr), typeWhenArms_(typeWhenArms), body_(body)  
	{line = lineno;}

Typecase::Typecase(const Typecase& o) : Stmt(Stmt::TypecaseT),  expr_(o.expr_), typeWhenArms_(o.typeWhenArms_), body_(o.body_) 
	{line = o.line;}

Typecase::Typecase(int lineno, const Typecase& o) : Stmt(lineno, Stmt::TypecaseT),  expr_(o.expr_), typeWhenArms_(o.typeWhenArms_), body_(o.body_) 
	{line = lineno;}

void TypeWhenArm::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TypeWhenArm:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (typ_) {typ_->print(spaces+3);}; 
   if (id_) {id_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* TypeWhenArm::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TypeWhenArm* new_node = new TypeWhenArm(this->line, *this);
    new_node->typ_ = typ_ ? (TypeSpec*)typ_->traverse(tobj) : 0; 
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* TypeWhenArm::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->typ_) (TypeSpec*)typ_->propagate(tobj); 
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* TypeWhenArm::get_typ() {return typ_;}
void TypeWhenArm::set_typ(TypeSpec* val) {typ_ = val;}

Id* TypeWhenArm::get_id() {return id_;}
void TypeWhenArm::set_id(Id* val) {id_ = val;}

Body* TypeWhenArm::get_body() {return body_;}
void TypeWhenArm::set_body(Body* val) {body_ = val;}






// Constructor Implementations

TypeWhenArm::TypeWhenArm(TypeSpec* typ , Id* id , Body* body  ) : ParseNode(ParseNode::TypeWhenArmT),  typ_(typ), id_(id), body_(body)  
	{}

TypeWhenArm::TypeWhenArm(int lineno , TypeSpec* typ , Id* id , Body* body  ) : ParseNode(lineno, ParseNode::TypeWhenArmT),  typ_(typ), id_(id), body_(body)  
	{line = lineno;}

TypeWhenArm::TypeWhenArm(const TypeWhenArm& o) : ParseNode(ParseNode::TypeWhenArmT),  typ_(o.typ_), id_(o.id_), body_(o.body_) 
	{line = o.line;}

TypeWhenArm::TypeWhenArm(int lineno, const TypeWhenArm& o) : ParseNode(lineno, ParseNode::TypeWhenArmT),  typ_(o.typ_), id_(o.id_), body_(o.body_) 
	{line = lineno;}

void ReturnStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ReturnStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* ReturnStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ReturnStmt* new_node = new ReturnStmt(this->line, *this);
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* ReturnStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* ReturnStmt::get_exprs() {return exprs_;}
void ReturnStmt::set_exprs(ParseNodeList* val) {exprs_ = val;}




// Constructor Implementations

ReturnStmt::ReturnStmt(ParseNodeList* exprs  ) : Stmt(Stmt::ReturnStmtT),  exprs_(exprs)  
	{}

ReturnStmt::ReturnStmt(int lineno , ParseNodeList* exprs  ) : Stmt(lineno, Stmt::ReturnStmtT),  exprs_(exprs)  
	{line = lineno;}

ReturnStmt::ReturnStmt(const ReturnStmt& o) : Stmt(Stmt::ReturnStmtT),  exprs_(o.exprs_) 
	{line = o.line;}

ReturnStmt::ReturnStmt(int lineno, const ReturnStmt& o) : Stmt(lineno, Stmt::ReturnStmtT),  exprs_(o.exprs_) 
	{line = lineno;}

void Yield::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Yield:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* Yield::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Yield* new_node = new Yield(this->line, *this);
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* Yield::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Yield::get_exprs() {return exprs_;}
void Yield::set_exprs(ParseNodeList* val) {exprs_ = val;}




// Constructor Implementations

Yield::Yield(ParseNodeList* exprs  ) : Stmt(Stmt::YieldT),  exprs_(exprs)  
	{}

Yield::Yield(int lineno , ParseNodeList* exprs  ) : Stmt(lineno, Stmt::YieldT),  exprs_(exprs)  
	{line = lineno;}

Yield::Yield(const Yield& o) : Stmt(Stmt::YieldT),  exprs_(o.exprs_) 
	{line = o.line;}

Yield::Yield(int lineno, const Yield& o) : Stmt(lineno, Stmt::YieldT),  exprs_(o.exprs_) 
	{line = lineno;}

void SignalStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SignalStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* SignalStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SignalStmt* new_node = new SignalStmt(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* SignalStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* SignalStmt::get_id() {return id_;}
void SignalStmt::set_id(Id* val) {id_ = val;}

ParseNodeList* SignalStmt::get_exprs() {return exprs_;}
void SignalStmt::set_exprs(ParseNodeList* val) {exprs_ = val;}





// Constructor Implementations

SignalStmt::SignalStmt(Id* id , ParseNodeList* exprs  ) : Stmt(Stmt::SignalStmtT),  id_(id), exprs_(exprs)  
	{}

SignalStmt::SignalStmt(int lineno , Id* id , ParseNodeList* exprs  ) : Stmt(lineno, Stmt::SignalStmtT),  id_(id), exprs_(exprs)  
	{line = lineno;}

SignalStmt::SignalStmt(const SignalStmt& o) : Stmt(Stmt::SignalStmtT),  id_(o.id_), exprs_(o.exprs_) 
	{line = o.line;}

SignalStmt::SignalStmt(int lineno, const SignalStmt& o) : Stmt(lineno, Stmt::SignalStmtT),  id_(o.id_), exprs_(o.exprs_) 
	{line = lineno;}

void Exit::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Exit:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* Exit::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Exit* new_node = new Exit(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* Exit::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* Exit::get_id() {return id_;}
void Exit::set_id(Id* val) {id_ = val;}

ParseNodeList* Exit::get_exprs() {return exprs_;}
void Exit::set_exprs(ParseNodeList* val) {exprs_ = val;}





// Constructor Implementations

Exit::Exit(Id* id , ParseNodeList* exprs  ) : Stmt(Stmt::ExitT),  id_(id), exprs_(exprs)  
	{}

Exit::Exit(int lineno , Id* id , ParseNodeList* exprs  ) : Stmt(lineno, Stmt::ExitT),  id_(id), exprs_(exprs)  
	{line = lineno;}

Exit::Exit(const Exit& o) : Stmt(Stmt::ExitT),  id_(o.id_), exprs_(o.exprs_) 
	{line = o.line;}

Exit::Exit(int lineno, const Exit& o) : Stmt(lineno, Stmt::ExitT),  id_(o.id_), exprs_(o.exprs_) 
	{line = lineno;}

void BlockStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BlockStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* BlockStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BlockStmt* new_node = new BlockStmt(this->line, *this);
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* BlockStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Body* BlockStmt::get_body() {return body_;}
void BlockStmt::set_body(Body* val) {body_ = val;}




// Constructor Implementations

BlockStmt::BlockStmt(Body* body  ) : Stmt(Stmt::BlockStmtT),  body_(body)  
	{}

BlockStmt::BlockStmt(int lineno , Body* body  ) : Stmt(lineno, Stmt::BlockStmtT),  body_(body)  
	{line = lineno;}

BlockStmt::BlockStmt(const BlockStmt& o) : Stmt(Stmt::BlockStmtT),  body_(o.body_) 
	{line = o.line;}

BlockStmt::BlockStmt(int lineno, const BlockStmt& o) : Stmt(lineno, Stmt::BlockStmtT),  body_(o.body_) 
	{line = lineno;}

void ResignalStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ResignalStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (stmt_) {stmt_->print(spaces+3);}; 
   if (ids_) {print_parsenode_list(ids_, spaces+3);};

}

ParseNode* ResignalStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ResignalStmt* new_node = new ResignalStmt(this->line, *this);
    new_node->stmt_ = stmt_ ? (Stmt*)stmt_->traverse(tobj) : 0; 
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;

    return new_node;
}


ParseNode* ResignalStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->stmt_) (Stmt*)stmt_->propagate(tobj); 
    if (this->ids_) propagate_parsenode_list(ids_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Stmt* ResignalStmt::get_stmt() {return stmt_;}
void ResignalStmt::set_stmt(Stmt* val) {stmt_ = val;}

ParseNodeList* ResignalStmt::get_ids() {return ids_;}
void ResignalStmt::set_ids(ParseNodeList* val) {ids_ = val;}





// Constructor Implementations

ResignalStmt::ResignalStmt(Stmt* stmt , ParseNodeList* ids  ) : Stmt(Stmt::ResignalStmtT),  stmt_(stmt), ids_(ids)  
	{}

ResignalStmt::ResignalStmt(int lineno , Stmt* stmt , ParseNodeList* ids  ) : Stmt(lineno, Stmt::ResignalStmtT),  stmt_(stmt), ids_(ids)  
	{line = lineno;}

ResignalStmt::ResignalStmt(const ResignalStmt& o) : Stmt(Stmt::ResignalStmtT),  stmt_(o.stmt_), ids_(o.ids_) 
	{line = o.line;}

ResignalStmt::ResignalStmt(int lineno, const ResignalStmt& o) : Stmt(lineno, Stmt::ResignalStmtT),  stmt_(o.stmt_), ids_(o.ids_) 
	{line = lineno;}

void ExceptStmt::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ExceptStmt:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (stmt_) {stmt_->print(spaces+3);}; 
   if (exWhenArm_) {print_parsenode_list(exWhenArm_, spaces+3);};
   if (decl_) {decl_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* ExceptStmt::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ExceptStmt* new_node = new ExceptStmt(this->line, *this);
    new_node->stmt_ = stmt_ ? (Stmt*)stmt_->traverse(tobj) : 0; 
    new_node->exWhenArm_ = exWhenArm_ ? traverse_parsenode_list(exWhenArm_,tobj):0;
    new_node->decl_ = decl_ ? (Decl*)decl_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ExceptStmt::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->stmt_) (Stmt*)stmt_->propagate(tobj); 
    if (this->exWhenArm_) propagate_parsenode_list(exWhenArm_,tobj);
    if (this->decl_) (Decl*)decl_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Stmt* ExceptStmt::get_stmt() {return stmt_;}
void ExceptStmt::set_stmt(Stmt* val) {stmt_ = val;}

ParseNodeList* ExceptStmt::get_exWhenArm() {return exWhenArm_;}
void ExceptStmt::set_exWhenArm(ParseNodeList* val) {exWhenArm_ = val;}

Decl* ExceptStmt::get_decl() {return decl_;}
void ExceptStmt::set_decl(Decl* val) {decl_ = val;}

Body* ExceptStmt::get_body() {return body_;}
void ExceptStmt::set_body(Body* val) {body_ = val;}







// Constructor Implementations

ExceptStmt::ExceptStmt(Stmt* stmt , ParseNodeList* exWhenArm , Decl* decl , Body* body  ) : Stmt(Stmt::ExceptStmtT),  stmt_(stmt), exWhenArm_(exWhenArm), decl_(decl), body_(body)  
	{}

ExceptStmt::ExceptStmt(int lineno , Stmt* stmt , ParseNodeList* exWhenArm , Decl* decl , Body* body  ) : Stmt(lineno, Stmt::ExceptStmtT),  stmt_(stmt), exWhenArm_(exWhenArm), decl_(decl), body_(body)  
	{line = lineno;}

ExceptStmt::ExceptStmt(const ExceptStmt& o) : Stmt(Stmt::ExceptStmtT),  stmt_(o.stmt_), exWhenArm_(o.exWhenArm_), decl_(o.decl_), body_(o.body_) 
	{line = o.line;}

ExceptStmt::ExceptStmt(int lineno, const ExceptStmt& o) : Stmt(lineno, Stmt::ExceptStmtT),  stmt_(o.stmt_), exWhenArm_(o.exWhenArm_), decl_(o.decl_), body_(o.body_) 
	{line = lineno;}

void Init::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Init:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (fieldInits_) {print_parsenode_list(fieldInits_, spaces+3);};
   if (invoc_) {invoc_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* Init::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Init* new_node = new Init(this->line, *this);
    new_node->fieldInits_ = fieldInits_ ? traverse_parsenode_list(fieldInits_,tobj):0;
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Init::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->fieldInits_) propagate_parsenode_list(fieldInits_,tobj);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Init::get_fieldInits() {return fieldInits_;}
void Init::set_fieldInits(ParseNodeList* val) {fieldInits_ = val;}

Invoc* Init::get_invoc() {return invoc_;}
void Init::set_invoc(Invoc* val) {invoc_ = val;}

Body* Init::get_body() {return body_;}
void Init::set_body(Body* val) {body_ = val;}






// Constructor Implementations

Init::Init(ParseNodeList* fieldInits , Invoc* invoc , Body* body  ) : Stmt(Stmt::InitT),  fieldInits_(fieldInits), invoc_(invoc), body_(body)  
	{}

Init::Init(int lineno , ParseNodeList* fieldInits , Invoc* invoc , Body* body  ) : Stmt(lineno, Stmt::InitT),  fieldInits_(fieldInits), invoc_(invoc), body_(body)  
	{line = lineno;}

Init::Init(const Init& o) : Stmt(Stmt::InitT),  fieldInits_(o.fieldInits_), invoc_(o.invoc_), body_(o.body_) 
	{line = o.line;}

Init::Init(int lineno, const Init& o) : Stmt(lineno, Stmt::InitT),  fieldInits_(o.fieldInits_), invoc_(o.invoc_), body_(o.body_) 
	{line = lineno;}

void IdOrIvar::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("IdOrIvar:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* IdOrIvar::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    IdOrIvar* new_node = new IdOrIvar(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->id_ = id_ ? (/* null if no primary */
     Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* IdOrIvar::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->id_) (/* null if no primary */
     Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* IdOrIvar::get_primary() {return primary_;}
void IdOrIvar::set_primary(Expr* val) {primary_ = val;}

/* null if no primary */
     Id* IdOrIvar::get_id() {return id_;}
void IdOrIvar::set_id(/* null if no primary */
     Id* val) {id_ = val;}





// Constructor Implementations

IdOrIvar::IdOrIvar(Expr* primary , /* null if no primary */
     Id* id  ) : ParseNode(ParseNode::IdOrIvarT),  primary_(primary), id_(id)  
	{}

IdOrIvar::IdOrIvar(int lineno , Expr* primary , /* null if no primary */
     Id* id  ) : ParseNode(lineno, ParseNode::IdOrIvarT),  primary_(primary), id_(id)  
	{line = lineno;}

IdOrIvar::IdOrIvar(const IdOrIvar& o) : ParseNode(ParseNode::IdOrIvarT),  primary_(o.primary_), id_(o.id_) 
	{line = o.line;}

IdOrIvar::IdOrIvar(int lineno, const IdOrIvar& o) : ParseNode(lineno, ParseNode::IdOrIvarT),  primary_(o.primary_), id_(o.id_) 
	{line = lineno;}

void Body::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Body:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (equates_) {print_parsenode_list(equates_, spaces+3);};
   if (statements_) {print_parsenode_list(statements_, spaces+3);};

}

ParseNode* Body::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Body* new_node = new Body(this->line, *this);
    new_node->equates_ = equates_ ? traverse_parsenode_list(equates_,tobj):0;
    new_node->statements_ = statements_ ? traverse_parsenode_list(statements_,tobj):0;

    return new_node;
}


ParseNode* Body::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->equates_) propagate_parsenode_list(equates_,tobj);
    if (this->statements_) propagate_parsenode_list(statements_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Body::get_equates() {return equates_;}
void Body::set_equates(ParseNodeList* val) {equates_ = val;}

ParseNodeList* Body::get_statements() {return statements_;}
void Body::set_statements(ParseNodeList* val) {statements_ = val;}





// Constructor Implementations

Body::Body(ParseNodeList* equates , ParseNodeList* statements  ) : ParseNode(ParseNode::BodyT),  equates_(equates), statements_(statements)  
	{}

Body::Body(int lineno , ParseNodeList* equates , ParseNodeList* statements  ) : ParseNode(lineno, ParseNode::BodyT),  equates_(equates), statements_(statements)  
	{line = lineno;}

Body::Body(const Body& o) : ParseNode(ParseNode::BodyT),  equates_(o.equates_), statements_(o.statements_) 
	{line = o.line;}

Body::Body(int lineno, const Body& o) : ParseNode(lineno, ParseNode::BodyT),  equates_(o.equates_), statements_(o.statements_) 
	{line = lineno;}

void ElseIf::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ElseIf:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* ElseIf::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ElseIf* new_node = new ElseIf(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ElseIf::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* ElseIf::get_expr() {return expr_;}
void ElseIf::set_expr(Expr* val) {expr_ = val;}

Body* ElseIf::get_body() {return body_;}
void ElseIf::set_body(Body* val) {body_ = val;}





// Constructor Implementations

ElseIf::ElseIf(Expr* expr , Body* body  ) : ParseNode(ParseNode::ElseIfT),  expr_(expr), body_(body)  
	{}

ElseIf::ElseIf(int lineno , Expr* expr , Body* body  ) : ParseNode(lineno, ParseNode::ElseIfT),  expr_(expr), body_(body)  
	{line = lineno;}

ElseIf::ElseIf(const ElseIf& o) : ParseNode(ParseNode::ElseIfT),  expr_(o.expr_), body_(o.body_) 
	{line = o.line;}

ElseIf::ElseIf(int lineno, const ElseIf& o) : ParseNode(lineno, ParseNode::ElseIfT),  expr_(o.expr_), body_(o.body_) 
	{line = lineno;}

void TagWhenArm::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("TagWhenArm:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};
   if (decl_) {decl_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* TagWhenArm::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    TagWhenArm* new_node = new TagWhenArm(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;
    new_node->decl_ = decl_ ? (Decl*)decl_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* TagWhenArm::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);
    if (this->decl_) (Decl*)decl_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* TagWhenArm::get_ids() {return ids_;}
void TagWhenArm::set_ids(ParseNodeList* val) {ids_ = val;}

Decl* TagWhenArm::get_decl() {return decl_;}
void TagWhenArm::set_decl(Decl* val) {decl_ = val;}

Body* TagWhenArm::get_body() {return body_;}
void TagWhenArm::set_body(Body* val) {body_ = val;}






// Constructor Implementations

TagWhenArm::TagWhenArm(ParseNodeList* ids , Decl* decl , Body* body  ) : ParseNode(ParseNode::TagWhenArmT),  ids_(ids), decl_(decl), body_(body)  
	{}

TagWhenArm::TagWhenArm(int lineno , ParseNodeList* ids , Decl* decl , Body* body  ) : ParseNode(lineno, ParseNode::TagWhenArmT),  ids_(ids), decl_(decl), body_(body)  
	{line = lineno;}

TagWhenArm::TagWhenArm(const TagWhenArm& o) : ParseNode(ParseNode::TagWhenArmT),  ids_(o.ids_), decl_(o.decl_), body_(o.body_) 
	{line = o.line;}

TagWhenArm::TagWhenArm(int lineno, const TagWhenArm& o) : ParseNode(lineno, ParseNode::TagWhenArmT),  ids_(o.ids_), decl_(o.decl_), body_(o.body_) 
	{line = lineno;}

void ExWhenArm::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ExWhenArm:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (names_) {print_parsenode_list(names_, spaces+3);};
   if (decls_) {print_parsenode_list(decls_, spaces+3);};
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* ExWhenArm::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ExWhenArm* new_node = new ExWhenArm(this->line, *this);
    new_node->names_ = names_ ? traverse_parsenode_list(names_,tobj):0;
    new_node->decls_ = decls_ ? traverse_parsenode_list(decls_,tobj):0;
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ExWhenArm::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->names_) propagate_parsenode_list(names_,tobj);
    if (this->decls_) propagate_parsenode_list(decls_,tobj);
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* ExWhenArm::get_names() {return names_;}
void ExWhenArm::set_names(ParseNodeList* val) {names_ = val;}

ParseNodeList* ExWhenArm::get_decls() {return decls_;}
void ExWhenArm::set_decls(ParseNodeList* val) {decls_ = val;}

Body* ExWhenArm::get_body() {return body_;}
void ExWhenArm::set_body(Body* val) {body_ = val;}






// Constructor Implementations

ExWhenArm::ExWhenArm(ParseNodeList* names , ParseNodeList* decls , Body* body  ) : ParseNode(ParseNode::ExWhenArmT),  names_(names), decls_(decls), body_(body)  
	{}

ExWhenArm::ExWhenArm(int lineno , ParseNodeList* names , ParseNodeList* decls , Body* body  ) : ParseNode(lineno, ParseNode::ExWhenArmT),  names_(names), decls_(decls), body_(body)  
	{line = lineno;}

ExWhenArm::ExWhenArm(const ExWhenArm& o) : ParseNode(ParseNode::ExWhenArmT),  names_(o.names_), decls_(o.decls_), body_(o.body_) 
	{line = o.line;}

ExWhenArm::ExWhenArm(int lineno, const ExWhenArm& o) : ParseNode(lineno, ParseNode::ExWhenArmT),  names_(o.names_), decls_(o.decls_), body_(o.body_) 
	{line = lineno;}

void OthersHandler::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("OthersHandler:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 
   if (body_) {body_->print(spaces+3);}; 

}

ParseNode* OthersHandler::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    OthersHandler* new_node = new OthersHandler(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 
    new_node->body_ = body_ ? (Body*)body_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* OthersHandler::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 
    if (this->body_) (Body*)body_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* OthersHandler::get_id() {return id_;}
void OthersHandler::set_id(Id* val) {id_ = val;}

TypeSpec* OthersHandler::get_typeSpec() {return typeSpec_;}
void OthersHandler::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}

Body* OthersHandler::get_body() {return body_;}
void OthersHandler::set_body(Body* val) {body_ = val;}






// Constructor Implementations

OthersHandler::OthersHandler(Id* id , TypeSpec* typeSpec , Body* body  ) : ParseNode(ParseNode::OthersHandlerT),  id_(id), typeSpec_(typeSpec), body_(body)  
	{}

OthersHandler::OthersHandler(int lineno , Id* id , TypeSpec* typeSpec , Body* body  ) : ParseNode(lineno, ParseNode::OthersHandlerT),  id_(id), typeSpec_(typeSpec), body_(body)  
	{line = lineno;}

OthersHandler::OthersHandler(const OthersHandler& o) : ParseNode(ParseNode::OthersHandlerT),  id_(o.id_), typeSpec_(o.typeSpec_), body_(o.body_) 
	{line = o.line;}

OthersHandler::OthersHandler(int lineno, const OthersHandler& o) : ParseNode(lineno, ParseNode::OthersHandlerT),  id_(o.id_), typeSpec_(o.typeSpec_), body_(o.body_) 
	{line = lineno;}

void FieldInit::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("FieldInit:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* FieldInit::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    FieldInit* new_node = new FieldInit(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* FieldInit::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* FieldInit::get_id() {return id_;}
void FieldInit::set_id(Id* val) {id_ = val;}

Expr* FieldInit::get_expr() {return expr_;}
void FieldInit::set_expr(Expr* val) {expr_ = val;}





// Constructor Implementations

FieldInit::FieldInit(Id* id , Expr* expr  ) : ParseNode(ParseNode::FieldInitT),  id_(id), expr_(expr)  
	{}

FieldInit::FieldInit(int lineno , Id* id , Expr* expr  ) : ParseNode(lineno, ParseNode::FieldInitT),  id_(id), expr_(expr)  
	{line = lineno;}

FieldInit::FieldInit(const FieldInit& o) : ParseNode(ParseNode::FieldInitT),  id_(o.id_), expr_(o.expr_) 
	{line = o.line;}

FieldInit::FieldInit(int lineno, const FieldInit& o) : ParseNode(lineno, ParseNode::FieldInitT),  id_(o.id_), expr_(o.expr_) 
	{line = lineno;}
 Expr::tag() {return tag_;} 
void Expr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Expr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Expr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Expr* new_node = new Expr(this->line, *this);

    return new_node;
}


ParseNode* Expr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Expr::Expr(Tag tag ) : ParseNode(ParseNode::ExprT), tag_(tag)  
	{}

Expr::Expr(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::ExprT), tag_(tag)  
	{line = lineno;}

Expr::Expr(const Expr& o) : ParseNode(ParseNode::ExprT), tag_(o.tag_)  
	{line = o.line;}

Expr::Expr(int lineno, const Expr& o) : ParseNode(lineno, ParseNode::ExprT), tag_(o.tag_)  
	{line = lineno;}

void BracketRef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BracketRef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* BracketRef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BracketRef* new_node = new BracketRef(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* BracketRef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* BracketRef::get_primary() {return primary_;}
void BracketRef::set_primary(Expr* val) {primary_ = val;}

ParseNodeList* BracketRef::get_exprs() {return exprs_;}
void BracketRef::set_exprs(ParseNodeList* val) {exprs_ = val;}





// Constructor Implementations

BracketRef::BracketRef(Expr* primary , ParseNodeList* exprs  ) : Expr(Expr::BracketRefT),  primary_(primary), exprs_(exprs)  
	{}

BracketRef::BracketRef(int lineno , Expr* primary , ParseNodeList* exprs  ) : Expr(lineno, Expr::BracketRefT),  primary_(primary), exprs_(exprs)  
	{line = lineno;}

BracketRef::BracketRef(const BracketRef& o) : Expr(Expr::BracketRefT),  primary_(o.primary_), exprs_(o.exprs_) 
	{line = o.line;}

BracketRef::BracketRef(int lineno, const BracketRef& o) : Expr(lineno, Expr::BracketRefT),  primary_(o.primary_), exprs_(o.exprs_) 
	{line = lineno;}

void BraceRef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BraceRef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* BraceRef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BraceRef* new_node = new BraceRef(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* BraceRef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* BraceRef::get_primary() {return primary_;}
void BraceRef::set_primary(Expr* val) {primary_ = val;}

ParseNodeList* BraceRef::get_exprs() {return exprs_;}
void BraceRef::set_exprs(ParseNodeList* val) {exprs_ = val;}





// Constructor Implementations

BraceRef::BraceRef(Expr* primary , ParseNodeList* exprs  ) : Expr(Expr::BraceRefT),  primary_(primary), exprs_(exprs)  
	{}

BraceRef::BraceRef(int lineno , Expr* primary , ParseNodeList* exprs  ) : Expr(lineno, Expr::BraceRefT),  primary_(primary), exprs_(exprs)  
	{line = lineno;}

BraceRef::BraceRef(const BraceRef& o) : Expr(Expr::BraceRefT),  primary_(o.primary_), exprs_(o.exprs_) 
	{line = o.line;}

BraceRef::BraceRef(int lineno, const BraceRef& o) : Expr(lineno, Expr::BraceRefT),  primary_(o.primary_), exprs_(o.exprs_) 
	{line = lineno;}
 Binary::tag() {return tag_;} 
void Binary::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Binary:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (op1_) {op1_->print(spaces+3);}; 
   if (op2_) {op2_->print(spaces+3);}; 

}

ParseNode* Binary::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Binary* new_node = new Binary(this->line, *this);
    new_node->op1_ = op1_ ? (Expr*)op1_->traverse(tobj) : 0; 
    new_node->op2_ = op2_ ? (Expr*)op2_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Binary::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->op1_) (Expr*)op1_->propagate(tobj); 
    if (this->op2_) (Expr*)op2_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Binary::get_op1() {return op1_;}
void Binary::set_op1(Expr* val) {op1_ = val;}

Expr* Binary::get_op2() {return op2_;}
void Binary::set_op2(Expr* val) {op2_ = val;}





// Constructor Implementations

Binary::Binary(Tag tag ,Expr* op1 , Expr* op2  ) : Expr(Expr::BinaryT), tag_(tag), op1_(op1), op2_(op2)  
	{}

Binary::Binary(int lineno ,  Tag tag ,Expr* op1 , Expr* op2  ) : Expr(lineno, Expr::BinaryT), tag_(tag), op1_(op1), op2_(op2)  
	{line = lineno;}

Binary::Binary(const Binary& o) : Expr(Expr::BinaryT), tag_(o.tag_) , op1_(o.op1_), op2_(o.op2_) 
	{line = o.line;}

Binary::Binary(int lineno, const Binary& o) : Expr(lineno, Expr::BinaryT), tag_(o.tag_) , op1_(o.op1_), op2_(o.op2_) 
	{line = lineno;}
 Unary::tag() {return tag_;} 
void Unary::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Unary:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (op_) {op_->print(spaces+3);}; 

}

ParseNode* Unary::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Unary* new_node = new Unary(this->line, *this);
    new_node->op_ = op_ ? (Expr*)op_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Unary::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->op_) (Expr*)op_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Unary::get_op() {return op_;}
void Unary::set_op(Expr* val) {op_ = val;}




// Constructor Implementations

Unary::Unary(Tag tag ,Expr* op  ) : Expr(Expr::UnaryT), tag_(tag), op_(op)  
	{}

Unary::Unary(int lineno ,  Tag tag ,Expr* op  ) : Expr(lineno, Expr::UnaryT), tag_(tag), op_(op)  
	{line = lineno;}

Unary::Unary(const Unary& o) : Expr(Expr::UnaryT), tag_(o.tag_) , op_(o.op_) 
	{line = o.line;}

Unary::Unary(int lineno, const Unary& o) : Expr(lineno, Expr::UnaryT), tag_(o.tag_) , op_(o.op_) 
	{line = lineno;}
 Literal::tag() {return tag_;} 
void Literal::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Literal:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* Literal::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Literal* new_node = new Literal(this->line, *this);

    return new_node;
}


ParseNode* Literal::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

Literal::Literal(Tag tag ) : Expr(Expr::LiteralT), tag_(tag)  
	{}

Literal::Literal(int lineno ,  Tag tag ) : Expr(lineno, Expr::LiteralT), tag_(tag)  
	{line = lineno;}

Literal::Literal(const Literal& o) : Expr(Expr::LiteralT), tag_(o.tag_)  
	{line = o.line;}

Literal::Literal(int lineno, const Literal& o) : Expr(lineno, Expr::LiteralT), tag_(o.tag_)  
	{line = lineno;}

void IntLiteral::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("IntLiteral:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("int:%d\n",i_);

}

ParseNode* IntLiteral::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    IntLiteral* new_node = new IntLiteral(this->line, *this);
   new_node->i_ = i_;

    return new_node;
}


ParseNode* IntLiteral::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->i_ = i_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

int IntLiteral::get_i() {return i_;}
void IntLiteral::set_i(int val) {i_ = val;}




// Constructor Implementations

IntLiteral::IntLiteral(int i  ) : Literal(Literal::IntLiteralT),  i_(i)  
	{}

IntLiteral::IntLiteral(int lineno , int i  ) : Literal(lineno, Literal::IntLiteralT),  i_(i)  
	{line = lineno;}

IntLiteral::IntLiteral(const IntLiteral& o) : Literal(Literal::IntLiteralT),  i_(o.i_) 
	{line = o.line;}

IntLiteral::IntLiteral(int lineno, const IntLiteral& o) : Literal(lineno, Literal::IntLiteralT),  i_(o.i_) 
	{line = lineno;}

void BoolLiteral::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BoolLiteral:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("int:%d\n",b_);

}

ParseNode* BoolLiteral::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BoolLiteral* new_node = new BoolLiteral(this->line, *this);
   new_node->b_ = b_;

    return new_node;
}


ParseNode* BoolLiteral::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->b_ = b_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

int BoolLiteral::get_b() {return b_;}
void BoolLiteral::set_b(int val) {b_ = val;}




// Constructor Implementations

BoolLiteral::BoolLiteral(int b  ) : Literal(Literal::BoolLiteralT),  b_(b)  
	{}

BoolLiteral::BoolLiteral(int lineno , int b  ) : Literal(lineno, Literal::BoolLiteralT),  b_(b)  
	{line = lineno;}

BoolLiteral::BoolLiteral(const BoolLiteral& o) : Literal(Literal::BoolLiteralT),  b_(o.b_) 
	{line = o.line;}

BoolLiteral::BoolLiteral(int lineno, const BoolLiteral& o) : Literal(lineno, Literal::BoolLiteralT),  b_(o.b_) 
	{line = lineno;}

void CharLiteral::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("CharLiteral:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("char:%c\n",c_);

}

ParseNode* CharLiteral::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    CharLiteral* new_node = new CharLiteral(this->line, *this);
   new_node->c_ = c_;

    return new_node;
}


ParseNode* CharLiteral::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->c_ = c_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

char CharLiteral::get_c() {return c_;}
void CharLiteral::set_c(char val) {c_ = val;}




// Constructor Implementations

CharLiteral::CharLiteral(char c  ) : Literal(Literal::CharLiteralT),  c_(c)  
	{}

CharLiteral::CharLiteral(int lineno , char c  ) : Literal(lineno, Literal::CharLiteralT),  c_(c)  
	{line = lineno;}

CharLiteral::CharLiteral(const CharLiteral& o) : Literal(Literal::CharLiteralT),  c_(o.c_) 
	{line = o.line;}

CharLiteral::CharLiteral(int lineno, const CharLiteral& o) : Literal(lineno, Literal::CharLiteralT),  c_(o.c_) 
	{line = lineno;}

void RealLiteral::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RealLiteral:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("double:%lf\n",r_);

}

ParseNode* RealLiteral::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RealLiteral* new_node = new RealLiteral(this->line, *this);
   new_node->r_ = r_;

    return new_node;
}


ParseNode* RealLiteral::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->r_ = r_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

double RealLiteral::get_r() {return r_;}
void RealLiteral::set_r(double val) {r_ = val;}




// Constructor Implementations

RealLiteral::RealLiteral(double r  ) : Literal(Literal::RealLiteralT),  r_(r)  
	{}

RealLiteral::RealLiteral(int lineno , double r  ) : Literal(lineno, Literal::RealLiteralT),  r_(r)  
	{line = lineno;}

RealLiteral::RealLiteral(const RealLiteral& o) : Literal(Literal::RealLiteralT),  r_(o.r_) 
	{line = o.line;}

RealLiteral::RealLiteral(int lineno, const RealLiteral& o) : Literal(lineno, Literal::RealLiteralT),  r_(o.r_) 
	{line = lineno;}

void StringLiteral::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("StringLiteral:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("\"%s\"\n", string_charp(s_));

}

ParseNode* StringLiteral::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    StringLiteral* new_node = new StringLiteral(this->line, *this);
   new_node->s_ = s_;

    return new_node;
}


ParseNode* StringLiteral::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->s_ = s_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

string StringLiteral::get_s() {return s_;}
void StringLiteral::set_s(string val) {s_ = val;}




// Constructor Implementations

StringLiteral::StringLiteral(string s  ) : Literal(Literal::StringLiteralT),  s_(s)  
	{}

StringLiteral::StringLiteral(int lineno , string s  ) : Literal(lineno, Literal::StringLiteralT),  s_(s)  
	{line = lineno;}

StringLiteral::StringLiteral(const StringLiteral& o) : Literal(Literal::StringLiteralT),  s_(o.s_) 
	{line = o.line;}

StringLiteral::StringLiteral(int lineno, const StringLiteral& o) : Literal(lineno, Literal::StringLiteralT),  s_(o.s_) 
	{line = lineno;}

void Instantiation::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Instantiation:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (otypeSpec_) {otypeSpec_->print(spaces+3);}; 
   if (id_) {id_->print(spaces+3);}; 
   if (actualParms_) {print_parsenode_list(actualParms_, spaces+3);};

}

ParseNode* Instantiation::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Instantiation* new_node = new Instantiation(this->line, *this);
    new_node->otypeSpec_ = otypeSpec_ ? (TypeSpec*)otypeSpec_->traverse(tobj) : 0; 
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 
    new_node->actualParms_ = actualParms_ ? traverse_parsenode_list(actualParms_,tobj):0;

    return new_node;
}


ParseNode* Instantiation::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->otypeSpec_) (TypeSpec*)otypeSpec_->propagate(tobj); 
    if (this->id_) (Id*)id_->propagate(tobj); 
    if (this->actualParms_) propagate_parsenode_list(actualParms_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* Instantiation::get_otypeSpec() {return otypeSpec_;}
void Instantiation::set_otypeSpec(TypeSpec* val) {otypeSpec_ = val;}

Id* Instantiation::get_id() {return id_;}
void Instantiation::set_id(Id* val) {id_ = val;}

ParseNodeList* Instantiation::get_actualParms() {return actualParms_;}
void Instantiation::set_actualParms(ParseNodeList* val) {actualParms_ = val;}






// Constructor Implementations

Instantiation::Instantiation(TypeSpec* otypeSpec , Id* id , ParseNodeList* actualParms  ) : Expr(Expr::InstantiationT),  otypeSpec_(otypeSpec), id_(id), actualParms_(actualParms)  
	{}

Instantiation::Instantiation(int lineno , TypeSpec* otypeSpec , Id* id , ParseNodeList* actualParms  ) : Expr(lineno, Expr::InstantiationT),  otypeSpec_(otypeSpec), id_(id), actualParms_(actualParms)  
	{line = lineno;}

Instantiation::Instantiation(const Instantiation& o) : Expr(Expr::InstantiationT),  otypeSpec_(o.otypeSpec_), id_(o.id_), actualParms_(o.actualParms_) 
	{line = o.line;}

Instantiation::Instantiation(int lineno, const Instantiation& o) : Expr(lineno, Expr::InstantiationT),  otypeSpec_(o.otypeSpec_), id_(o.id_), actualParms_(o.actualParms_) 
	{line = lineno;}

void DotExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("DotExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* DotExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    DotExpr* new_node = new DotExpr(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* DotExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->id_) (Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* DotExpr::get_primary() {return primary_;}
void DotExpr::set_primary(Expr* val) {primary_ = val;}

Id* DotExpr::get_id() {return id_;}
void DotExpr::set_id(Id* val) {id_ = val;}





// Constructor Implementations

DotExpr::DotExpr(Expr* primary , Id* id  ) : Expr(Expr::DotExprT),  primary_(primary), id_(id)  
	{}

DotExpr::DotExpr(int lineno , Expr* primary , Id* id  ) : Expr(lineno, Expr::DotExprT),  primary_(primary), id_(id)  
	{line = lineno;}

DotExpr::DotExpr(const DotExpr& o) : Expr(Expr::DotExprT),  primary_(o.primary_), id_(o.id_) 
	{line = o.line;}

DotExpr::DotExpr(int lineno, const DotExpr& o) : Expr(lineno, Expr::DotExprT),  primary_(o.primary_), id_(o.id_) 
	{line = lineno;}

void SuperId::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SuperId:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* SuperId::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SuperId* new_node = new SuperId(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* SuperId::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* SuperId::get_id() {return id_;}
void SuperId::set_id(Id* val) {id_ = val;}




// Constructor Implementations

SuperId::SuperId(Id* id  ) : Expr(Expr::SuperIdT),  id_(id)  
	{}

SuperId::SuperId(int lineno , Id* id  ) : Expr(lineno, Expr::SuperIdT),  id_(id)  
	{line = lineno;}

SuperId::SuperId(const SuperId& o) : Expr(Expr::SuperIdT),  id_(o.id_) 
	{line = o.line;}

SuperId::SuperId(int lineno, const SuperId& o) : Expr(lineno, Expr::SuperIdT),  id_(o.id_) 
	{line = lineno;}

void IdExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("IdExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* IdExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    IdExpr* new_node = new IdExpr(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* IdExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* IdExpr::get_id() {return id_;}
void IdExpr::set_id(Id* val) {id_ = val;}




// Constructor Implementations

IdExpr::IdExpr(Id* id  ) : Expr(Expr::IdExprT),  id_(id)  
	{}

IdExpr::IdExpr(int lineno , Id* id  ) : Expr(lineno, Expr::IdExprT),  id_(id)  
	{line = lineno;}

IdExpr::IdExpr(const IdExpr& o) : Expr(Expr::IdExprT),  id_(o.id_) 
	{line = o.line;}

IdExpr::IdExpr(int lineno, const IdExpr& o) : Expr(lineno, Expr::IdExprT),  id_(o.id_) 
	{line = lineno;}

void ArrayRef::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ArrayRef:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* ArrayRef::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ArrayRef* new_node = new ArrayRef(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* ArrayRef::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* ArrayRef::get_primary() {return primary_;}
void ArrayRef::set_primary(Expr* val) {primary_ = val;}

Expr* ArrayRef::get_expr() {return expr_;}
void ArrayRef::set_expr(Expr* val) {expr_ = val;}





// Constructor Implementations

ArrayRef::ArrayRef(Expr* primary , Expr* expr  ) : Expr(Expr::ArrayRefT),  primary_(primary), expr_(expr)  
	{}

ArrayRef::ArrayRef(int lineno , Expr* primary , Expr* expr  ) : Expr(lineno, Expr::ArrayRefT),  primary_(primary), expr_(expr)  
	{line = lineno;}

ArrayRef::ArrayRef(const ArrayRef& o) : Expr(Expr::ArrayRefT),  primary_(o.primary_), expr_(o.expr_) 
	{line = o.line;}

ArrayRef::ArrayRef(int lineno, const ArrayRef& o) : Expr(lineno, Expr::ArrayRefT),  primary_(o.primary_), expr_(o.expr_) 
	{line = lineno;}

void InvocExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("InvocExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (invoc_) {invoc_->print(spaces+3);}; 

}

ParseNode* InvocExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    InvocExpr* new_node = new InvocExpr(this->line, *this);
    new_node->invoc_ = invoc_ ? (Invoc*)invoc_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* InvocExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->invoc_) (Invoc*)invoc_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Invoc* InvocExpr::get_invoc() {return invoc_;}
void InvocExpr::set_invoc(Invoc* val) {invoc_ = val;}




// Constructor Implementations

InvocExpr::InvocExpr(Invoc* invoc  ) : Expr(Expr::InvocExprT),  invoc_(invoc)  
	{}

InvocExpr::InvocExpr(int lineno , Invoc* invoc  ) : Expr(lineno, Expr::InvocExprT),  invoc_(invoc)  
	{line = lineno;}

InvocExpr::InvocExpr(const InvocExpr& o) : Expr(Expr::InvocExprT),  invoc_(o.invoc_) 
	{line = o.line;}

InvocExpr::InvocExpr(int lineno, const InvocExpr& o) : Expr(lineno, Expr::InvocExprT),  invoc_(o.invoc_) 
	{line = lineno;}

void BindingExpr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BindingExpr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (binding_) {binding_->print(spaces+3);}; 

}

ParseNode* BindingExpr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BindingExpr* new_node = new BindingExpr(this->line, *this);
    new_node->binding_ = binding_ ? (Binding*)binding_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* BindingExpr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->binding_) (Binding*)binding_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Binding* BindingExpr::get_binding() {return binding_;}
void BindingExpr::set_binding(Binding* val) {binding_ = val;}




// Constructor Implementations

BindingExpr::BindingExpr(Binding* binding  ) : Expr(Expr::BindingExprT),  binding_(binding)  
	{}

BindingExpr::BindingExpr(int lineno , Binding* binding  ) : Expr(lineno, Expr::BindingExprT),  binding_(binding)  
	{line = lineno;}

BindingExpr::BindingExpr(const BindingExpr& o) : Expr(Expr::BindingExprT),  binding_(o.binding_) 
	{line = o.line;}

BindingExpr::BindingExpr(int lineno, const BindingExpr& o) : Expr(lineno, Expr::BindingExprT),  binding_(o.binding_) 
	{line = lineno;}

void SelectorConstr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SelectorConstr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 
   if (fields_) {print_parsenode_list(fields_, spaces+3);};

}

ParseNode* SelectorConstr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SelectorConstr* new_node = new SelectorConstr(this->line, *this);
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 
    new_node->fields_ = fields_ ? traverse_parsenode_list(fields_,tobj):0;

    return new_node;
}


ParseNode* SelectorConstr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 
    if (this->fields_) propagate_parsenode_list(fields_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* SelectorConstr::get_typeSpec() {return typeSpec_;}
void SelectorConstr::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}

ParseNodeList* SelectorConstr::get_fields() {return fields_;}
void SelectorConstr::set_fields(ParseNodeList* val) {fields_ = val;}





// Constructor Implementations

SelectorConstr::SelectorConstr(TypeSpec* typeSpec , ParseNodeList* fields  ) : Expr(Expr::SelectorConstrT),  typeSpec_(typeSpec), fields_(fields)  
	{}

SelectorConstr::SelectorConstr(int lineno , TypeSpec* typeSpec , ParseNodeList* fields  ) : Expr(lineno, Expr::SelectorConstrT),  typeSpec_(typeSpec), fields_(fields)  
	{line = lineno;}

SelectorConstr::SelectorConstr(const SelectorConstr& o) : Expr(Expr::SelectorConstrT),  typeSpec_(o.typeSpec_), fields_(o.fields_) 
	{line = o.line;}

SelectorConstr::SelectorConstr(int lineno, const SelectorConstr& o) : Expr(lineno, Expr::SelectorConstrT),  typeSpec_(o.typeSpec_), fields_(o.fields_) 
	{line = lineno;}

void ArrayConstr::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ArrayConstr:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 
   if (size_) {size_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};

}

ParseNode* ArrayConstr::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ArrayConstr* new_node = new ArrayConstr(this->line, *this);
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 
    new_node->size_ = size_ ? (Expr*)size_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;

    return new_node;
}


ParseNode* ArrayConstr::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 
    if (this->size_) (Expr*)size_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* ArrayConstr::get_typeSpec() {return typeSpec_;}
void ArrayConstr::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}

Expr* ArrayConstr::get_size() {return size_;}
void ArrayConstr::set_size(Expr* val) {size_ = val;}

ParseNodeList* ArrayConstr::get_exprs() {return exprs_;}
void ArrayConstr::set_exprs(ParseNodeList* val) {exprs_ = val;}






// Constructor Implementations

ArrayConstr::ArrayConstr(TypeSpec* typeSpec , Expr* size , ParseNodeList* exprs  ) : Expr(Expr::ArrayConstrT),  typeSpec_(typeSpec), size_(size), exprs_(exprs)  
	{}

ArrayConstr::ArrayConstr(int lineno , TypeSpec* typeSpec , Expr* size , ParseNodeList* exprs  ) : Expr(lineno, Expr::ArrayConstrT),  typeSpec_(typeSpec), size_(size), exprs_(exprs)  
	{line = lineno;}

ArrayConstr::ArrayConstr(const ArrayConstr& o) : Expr(Expr::ArrayConstrT),  typeSpec_(o.typeSpec_), size_(o.size_), exprs_(o.exprs_) 
	{line = o.line;}

ArrayConstr::ArrayConstr(int lineno, const ArrayConstr& o) : Expr(lineno, Expr::ArrayConstrT),  typeSpec_(o.typeSpec_), size_(o.size_), exprs_(o.exprs_) 
	{line = lineno;}

void Invoc::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Invoc:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (routineId_) {routineId_->print(spaces+3);}; 
   if (exprs_) {print_parsenode_list(exprs_, spaces+3);};
   if (lastarg_) {print_parsenode_list(lastarg_, spaces+3);};

}

ParseNode* Invoc::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Invoc* new_node = new Invoc(this->line, *this);
    new_node->routineId_ = routineId_ ? (RoutineId*)routineId_->traverse(tobj) : 0; 
    new_node->exprs_ = exprs_ ? traverse_parsenode_list(exprs_,tobj):0;
    new_node->lastarg_ = lastarg_ ? traverse_parsenode_list(lastarg_,tobj):0;

    return new_node;
}


ParseNode* Invoc::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->routineId_) (RoutineId*)routineId_->propagate(tobj); 
    if (this->exprs_) propagate_parsenode_list(exprs_,tobj);
    if (this->lastarg_) propagate_parsenode_list(lastarg_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

RoutineId* Invoc::get_routineId() {return routineId_;}
void Invoc::set_routineId(RoutineId* val) {routineId_ = val;}

ParseNodeList* Invoc::get_exprs() {return exprs_;}
void Invoc::set_exprs(ParseNodeList* val) {exprs_ = val;}

ParseNodeList* Invoc::get_lastarg() {return lastarg_;}
void Invoc::set_lastarg(ParseNodeList* val) {lastarg_ = val;}






// Constructor Implementations

Invoc::Invoc(RoutineId* routineId , ParseNodeList* exprs , ParseNodeList* lastarg  ) : ParseNode(ParseNode::InvocT),  routineId_(routineId), exprs_(exprs), lastarg_(lastarg)  
	{}

Invoc::Invoc(int lineno , RoutineId* routineId , ParseNodeList* exprs , ParseNodeList* lastarg  ) : ParseNode(lineno, ParseNode::InvocT),  routineId_(routineId), exprs_(exprs), lastarg_(lastarg)  
	{line = lineno;}

Invoc::Invoc(const Invoc& o) : ParseNode(ParseNode::InvocT),  routineId_(o.routineId_), exprs_(o.exprs_), lastarg_(o.lastarg_) 
	{line = o.line;}

Invoc::Invoc(int lineno, const Invoc& o) : ParseNode(lineno, ParseNode::InvocT),  routineId_(o.routineId_), exprs_(o.exprs_), lastarg_(o.lastarg_) 
	{line = lineno;}
 RoutineId::tag() {return tag_;} 
void RoutineId::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("RoutineId:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}

}

ParseNode* RoutineId::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    RoutineId* new_node = new RoutineId(this->line, *this);

    return new_node;
}


ParseNode* RoutineId::propagate(TraverseObj *tobj)
{
    tobj->setup(this);

    tobj->xmogrify(this);
    return this;
}

// Constructor Implementations

RoutineId::RoutineId(Tag tag ) : ParseNode(ParseNode::RoutineIdT), tag_(tag)  
	{}

RoutineId::RoutineId(int lineno ,  Tag tag ) : ParseNode(lineno, ParseNode::RoutineIdT), tag_(tag)  
	{line = lineno;}

RoutineId::RoutineId(const RoutineId& o) : ParseNode(ParseNode::RoutineIdT), tag_(o.tag_)  
	{line = o.line;}

RoutineId::RoutineId(int lineno, const RoutineId& o) : ParseNode(lineno, ParseNode::RoutineIdT), tag_(o.tag_)  
	{line = lineno;}

void SimpleRoutineId::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SimpleRoutineId:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 

}

ParseNode* SimpleRoutineId::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SimpleRoutineId* new_node = new SimpleRoutineId(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* SimpleRoutineId::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* SimpleRoutineId::get_primary() {return primary_;}
void SimpleRoutineId::set_primary(Expr* val) {primary_ = val;}




// Constructor Implementations

SimpleRoutineId::SimpleRoutineId(Expr* primary  ) : RoutineId(RoutineId::SimpleRoutineIdT),  primary_(primary)  
	{}

SimpleRoutineId::SimpleRoutineId(int lineno , Expr* primary  ) : RoutineId(lineno, RoutineId::SimpleRoutineIdT),  primary_(primary)  
	{line = lineno;}

SimpleRoutineId::SimpleRoutineId(const SimpleRoutineId& o) : RoutineId(RoutineId::SimpleRoutineIdT),  primary_(o.primary_) 
	{line = o.line;}

SimpleRoutineId::SimpleRoutineId(int lineno, const SimpleRoutineId& o) : RoutineId(lineno, RoutineId::SimpleRoutineIdT),  primary_(o.primary_) 
	{line = lineno;}

void ComplexRoutineId::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("ComplexRoutineId:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (primary_) {primary_->print(spaces+3);}; 
   if (parms_) {print_parsenode_list(parms_, spaces+3);};

}

ParseNode* ComplexRoutineId::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    ComplexRoutineId* new_node = new ComplexRoutineId(this->line, *this);
    new_node->primary_ = primary_ ? (Expr*)primary_->traverse(tobj) : 0; 
    new_node->parms_ = parms_ ? traverse_parsenode_list(parms_,tobj):0;

    return new_node;
}


ParseNode* ComplexRoutineId::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->primary_) (Expr*)primary_->propagate(tobj); 
    if (this->parms_) propagate_parsenode_list(parms_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* ComplexRoutineId::get_primary() {return primary_;}
void ComplexRoutineId::set_primary(Expr* val) {primary_ = val;}

ParseNodeList* ComplexRoutineId::get_parms() {return parms_;}
void ComplexRoutineId::set_parms(ParseNodeList* val) {parms_ = val;}





// Constructor Implementations

ComplexRoutineId::ComplexRoutineId(Expr* primary , ParseNodeList* parms  ) : RoutineId(RoutineId::ComplexRoutineIdT),  primary_(primary), parms_(parms)  
	{}

ComplexRoutineId::ComplexRoutineId(int lineno , Expr* primary , ParseNodeList* parms  ) : RoutineId(lineno, RoutineId::ComplexRoutineIdT),  primary_(primary), parms_(parms)  
	{line = lineno;}

ComplexRoutineId::ComplexRoutineId(const ComplexRoutineId& o) : RoutineId(RoutineId::ComplexRoutineIdT),  primary_(o.primary_), parms_(o.parms_) 
	{line = o.line;}

ComplexRoutineId::ComplexRoutineId(int lineno, const ComplexRoutineId& o) : RoutineId(lineno, RoutineId::ComplexRoutineIdT),  primary_(o.primary_), parms_(o.parms_) 
	{line = lineno;}

void SuperClassRoutineId::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SuperClassRoutineId:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (id_) {id_->print(spaces+3);}; 

}

ParseNode* SuperClassRoutineId::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SuperClassRoutineId* new_node = new SuperClassRoutineId(this->line, *this);
    new_node->id_ = id_ ? (Id*)id_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* SuperClassRoutineId::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->id_) (Id*)id_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Id* SuperClassRoutineId::get_id() {return id_;}
void SuperClassRoutineId::set_id(Id* val) {id_ = val;}




// Constructor Implementations

SuperClassRoutineId::SuperClassRoutineId(Id* id  ) : RoutineId(RoutineId::SuperClassRoutineIdT),  id_(id)  
	{}

SuperClassRoutineId::SuperClassRoutineId(int lineno , Id* id  ) : RoutineId(lineno, RoutineId::SuperClassRoutineIdT),  id_(id)  
	{line = lineno;}

SuperClassRoutineId::SuperClassRoutineId(const SuperClassRoutineId& o) : RoutineId(RoutineId::SuperClassRoutineIdT),  id_(o.id_) 
	{line = o.line;}

SuperClassRoutineId::SuperClassRoutineId(int lineno, const SuperClassRoutineId& o) : RoutineId(lineno, RoutineId::SuperClassRoutineIdT),  id_(o.id_) 
	{line = lineno;}

void SuperInfo::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("SuperInfo:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (typespec_) {typespec_->print(spaces+3);}; 
   if (renamings_) {print_parsenode_list(renamings_, spaces+3);};

}

ParseNode* SuperInfo::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    SuperInfo* new_node = new SuperInfo(this->line, *this);
    new_node->typespec_ = typespec_ ? (TypeSpec*)typespec_->traverse(tobj) : 0; 
    new_node->renamings_ = renamings_ ? traverse_parsenode_list(renamings_,tobj):0;

    return new_node;
}


ParseNode* SuperInfo::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->typespec_) (TypeSpec*)typespec_->propagate(tobj); 
    if (this->renamings_) propagate_parsenode_list(renamings_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

TypeSpec* SuperInfo::get_typespec() {return typespec_;}
void SuperInfo::set_typespec(TypeSpec* val) {typespec_ = val;}

ParseNodeList* SuperInfo::get_renamings() {return renamings_;}
void SuperInfo::set_renamings(ParseNodeList* val) {renamings_ = val;}





// Constructor Implementations

SuperInfo::SuperInfo(TypeSpec* typespec , ParseNodeList* renamings  ) : ParseNode(ParseNode::SuperInfoT),  typespec_(typespec), renamings_(renamings)  
	{}

SuperInfo::SuperInfo(int lineno , TypeSpec* typespec , ParseNodeList* renamings  ) : ParseNode(lineno, ParseNode::SuperInfoT),  typespec_(typespec), renamings_(renamings)  
	{line = lineno;}

SuperInfo::SuperInfo(const SuperInfo& o) : ParseNode(ParseNode::SuperInfoT),  typespec_(o.typespec_), renamings_(o.renamings_) 
	{line = o.line;}

SuperInfo::SuperInfo(int lineno, const SuperInfo& o) : ParseNode(lineno, ParseNode::SuperInfoT),  typespec_(o.typespec_), renamings_(o.renamings_) 
	{line = lineno;}

void Binding::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Binding:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (proc_) {proc_->print(spaces+3);}; 
   if (args_) {print_parsenode_list(args_, spaces+3);};
   if (lastarg_) {print_parsenode_list(lastarg_, spaces+3);};

}

ParseNode* Binding::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Binding* new_node = new Binding(this->line, *this);
    new_node->proc_ = proc_ ? (Expr*)proc_->traverse(tobj) : 0; 
    new_node->args_ = args_ ? traverse_parsenode_list(args_,tobj):0;
    new_node->lastarg_ = lastarg_ ? traverse_parsenode_list(lastarg_,tobj):0;

    return new_node;
}


ParseNode* Binding::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->proc_) (Expr*)proc_->propagate(tobj); 
    if (this->args_) propagate_parsenode_list(args_,tobj);
    if (this->lastarg_) propagate_parsenode_list(lastarg_,tobj);

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* Binding::get_proc() {return proc_;}
void Binding::set_proc(Expr* val) {proc_ = val;}

ParseNodeList* Binding::get_args() {return args_;}
void Binding::set_args(ParseNodeList* val) {args_ = val;}

ParseNodeList* Binding::get_lastarg() {return lastarg_;}
void Binding::set_lastarg(ParseNodeList* val) {lastarg_ = val;}






// Constructor Implementations

Binding::Binding(Expr* proc , ParseNodeList* args , ParseNodeList* lastarg  ) : ParseNode(ParseNode::BindingT),  proc_(proc), args_(args), lastarg_(lastarg)  
	{}

Binding::Binding(int lineno , Expr* proc , ParseNodeList* args , ParseNodeList* lastarg  ) : ParseNode(lineno, ParseNode::BindingT),  proc_(proc), args_(args), lastarg_(lastarg)  
	{line = lineno;}

Binding::Binding(const Binding& o) : ParseNode(ParseNode::BindingT),  proc_(o.proc_), args_(o.args_), lastarg_(o.lastarg_) 
	{line = o.line;}

Binding::Binding(int lineno, const Binding& o) : ParseNode(lineno, ParseNode::BindingT),  proc_(o.proc_), args_(o.args_), lastarg_(o.lastarg_) 
	{line = lineno;}

void BindingArg::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("BindingArg:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (expr_) {expr_->print(spaces+3);}; 

}

ParseNode* BindingArg::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    BindingArg* new_node = new BindingArg(this->line, *this);
    new_node->expr_ = expr_ ? (Expr*)expr_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* BindingArg::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->expr_) (Expr*)expr_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

Expr* BindingArg::get_expr() {return expr_;}
void BindingArg::set_expr(Expr* val) {expr_ = val;}




// Constructor Implementations

BindingArg::BindingArg(Expr* expr  ) : ParseNode(ParseNode::BindingArgT),  expr_(expr)  
	{}

BindingArg::BindingArg(int lineno , Expr* expr  ) : ParseNode(lineno, ParseNode::BindingArgT),  expr_(expr)  
	{line = lineno;}

BindingArg::BindingArg(const BindingArg& o) : ParseNode(ParseNode::BindingArgT),  expr_(o.expr_) 
	{line = o.line;}

BindingArg::BindingArg(int lineno, const BindingArg& o) : ParseNode(lineno, ParseNode::BindingArgT),  expr_(o.expr_) 
	{line = lineno;}

void Field::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Field:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
   if (ids_) {print_parsenode_list(ids_, spaces+3);};
   if (typeSpec_) {typeSpec_->print(spaces+3);}; 

}

ParseNode* Field::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Field* new_node = new Field(this->line, *this);
    new_node->ids_ = ids_ ? traverse_parsenode_list(ids_,tobj):0;
    new_node->typeSpec_ = typeSpec_ ? (TypeSpec*)typeSpec_->traverse(tobj) : 0; 

    return new_node;
}


ParseNode* Field::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
    if (this->ids_) propagate_parsenode_list(ids_,tobj);
    if (this->typeSpec_) (TypeSpec*)typeSpec_->propagate(tobj); 

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

ParseNodeList* Field::get_ids() {return ids_;}
void Field::set_ids(ParseNodeList* val) {ids_ = val;}

TypeSpec* Field::get_typeSpec() {return typeSpec_;}
void Field::set_typeSpec(TypeSpec* val) {typeSpec_ = val;}





// Constructor Implementations

Field::Field(ParseNodeList* ids , TypeSpec* typeSpec  ) : ParseNode(ParseNode::FieldT),  ids_(ids), typeSpec_(typeSpec)  
	{}

Field::Field(int lineno , ParseNodeList* ids , TypeSpec* typeSpec  ) : ParseNode(lineno, ParseNode::FieldT),  ids_(ids), typeSpec_(typeSpec)  
	{line = lineno;}

Field::Field(const Field& o) : ParseNode(ParseNode::FieldT),  ids_(o.ids_), typeSpec_(o.typeSpec_) 
	{line = o.line;}

Field::Field(int lineno, const Field& o) : ParseNode(lineno, ParseNode::FieldT),  ids_(o.ids_), typeSpec_(o.typeSpec_) 
	{line = lineno;}

void Id::print(int spaces)
{
   printf("Line %d:", line);
   put_spaces(spaces);
   printf("Id:\n");
   if (type_) {put_spaces(spaces+11); type_->print();}
  put_spaces(spaces+11); printf("\"%s\"\n", string_charp(id_));

}

ParseNode* Id::traverse(TraverseObj *tobj)
{
    ParseNode* processed_node = tobj->xmogrify(this);
    if (processed_node != 0)
	return processed_node;

    Id* new_node = new Id(this->line, *this);
   new_node->id_ = id_;

    return new_node;
}


ParseNode* Id::propagate(TraverseObj *tobj)
{
    tobj->setup(this);
   this->id_ = id_;

    tobj->xmogrify(this);
    return this;
}
 
// Accessor Implementations

string Id::get_id() {return id_;}
void Id::set_id(string val) {id_ = val;}




// Constructor Implementations

Id::Id(string id  ) : ParseNode(ParseNode::IdT),  id_(id)  
	{}

Id::Id(int lineno , string id  ) : ParseNode(lineno, ParseNode::IdT),  id_(id)  
	{line = lineno;}

Id::Id(const Id& o) : ParseNode(ParseNode::IdT),  id_(o.id_) 
	{line = o.line;}

Id::Id(int lineno, const Id& o) : ParseNode(lineno, ParseNode::IdT),  id_(o.id_) 
	{line = lineno;}


