#ifndef _COMPILER_PARSE_H
#define _COMPILER_PARSE_H

// A Compiler Parse Tree Format, based on the reference grammar in the
// draft Theta Reference Manual.  This file generates parse.h. See also
// parseCC.m4 for generating the corresponding .cc file.

#include "xlist.h"
#include "my_string.h"
#include "traverse.h"
#include "environment.h"
#include <stdio.h>
extern int cmpyy_lineno;
// ========================= M4 stuff ===========================
//
// The TAG macro is used to add a tag to the class. The usage is
// TAG(CLASS, `tag1, tag2, tag3 ...'). The tag of an object of this
// class can be accessed using the "tag" method. The possible
// tag values are named "CLASS::tag1", "CLASS::tag2", etc.
// A constructor "CLASS(CLASS::Tag)" is also created. It initializes
// only the tag.

// This next bit looks like a comment, but m4 notices it just fine.
// It's commented to allow "grind" to do the right thing.
/* 
 
*/
    
// The "Node" macro is used to automatically _define a class for a 
// parse tree node with tags, a constructor, and fields.
//
// The usage is  "Node(CLASSNAME, SUPERCLASS, tag1, tag2, ...,
//		       TYPE1, FIELDNAME1,
//		       TYPE2, FIELDNAME2,
//		       ...
// (The SUPERCLASS, tags, and fields arguments can be left blank to omit them.)
//
// This expands to:
//
//   class CLASSNAME : SUPERCLASS {
//     public:	
//      [enum Tag {CLASS::tag1, ...};]   // here if tags are not empty
//	[tag();]
//	
//      TYPE1 get_FIELDNAME1() {...}  	   		// get method
//      void set_FIELDNAME1(TYPE1 val) {...}		// set method
//      ...<the same thing for all of the other fields>...
//
//      CLASSNAME([Tag tag], TYPE1 FIELDNAME1, ...) :             // constructor
//	  [SUPERCLASS(SUPERCLASS::CLASSNAMET) ,]
//        [_tag(tag),]
//	  FIELDNAME1_(FIELDNAME1)
//	  ... {if (DEBUG_FLAG) print()};
//
//      CLASSNAME(const CLASSNAME& o) : ...:  		          // copy constr.
//
//     private:
//	 Tag tag_;
//	 TYPE1 FIELDNAME1_;
//       ...;
//   };

// Pardon the grunge below... Nicely formatted m4 output requires weird m4
// macro formatting.



// VARS: declare instance variables for each (type,name) pair
 

// ACCESSORS: declare get and set methods for each (type,name) pair       
 




    
// CONSTARGS: declare  constructor arguments for each (type,name) pair	      


// CONSTBODY: the body of the constructor


// : the body of the copy constructor

    




// The end of the file must have END_NODES so that the print methods can be generated.    




// We first declare all of the node classes used in the parse tree

     class Module; 
      class SpecModule; 
      class RoutineSpec; 
      class ProcHeader; 
      class IterHeader; 
      class MakeHeader; 
      class EquateModule; 
      class Decl; 
      class Equate; 
      class TypeEquate; 
      class ConstEquate; 
      class ImplModule; 
      class Impl; 
      class RoutineDef; 
      class ClassDef; 
      class Renaming; 
      class Export; 
      class MethodOrOpDef; 
      class Parm; 
      class Formal; 
      class Exception; 
      class Restriction; 
      class TypeSpec; 
      class BasicTypeSpec; 
      class ComplexTypeSpec; 
      class ActualParm; 
      class ParmOp; 
      class Stmt; 
      class DeclStmt; 
      class InitVarExpr; 
      class InitVarInvoke; 
      class AssignInvoke; 
      class AssignExprStmt; 
      class AssignExpr; 
      class InvokeStmt; 
      class WhileStmt; 
      class IfStmt; 
      class Tagcase; 
      class Typecase; 
      class ReturnStmt; 
      class Yield; 
      class SignalStmt; 
      class Exit; 
      class BlockStmt; 
      class ResignalStmt; 
      class ExceptStmt; 
      class IdOrIvar; 
      class Body; 
      class ElseIf; 
      class TagWhenArm; 
      class ExWhenArm; 
      class OthersHandler; 
      class FieldInit; 
      class Expr; 
      class Binary; 
      class Unary; 
      class Literal; 
      class Instantiation; 
      class DotExpr; 
      class SuperId; 
      class ArrayRef; 
      class BracketRef; 
      class BraceRef; 
      class InvocExpr; 
      class BindingExpr; 
      class SelectorConstr; 
      class ArrayConstr; 
      class Invoc; 
      class RoutineId; 
      class SimpleRoutineId; 
      class ComplexRoutineId; 
      class Binding; 
      class BindingArg; 
      class Field; 
      class Id; 
      class Signature; 
      class TypeWhenArm; 
      class Inherit; 
      class RoutineSpecModule; 
      class SuperInfo; 
      class IntLiteral; 
      class CharLiteral; 
      class StringLiteral; 
      class RealLiteral; 
      class IdExpr; 
      class TypeExtModule; 
      class Id; 
 

// The "Node" macro is used to automatically create a class for a 
// parse tree node with tags, a constructor, and fields.
//
// See parseMacrosH.m4 and parseMacrosCC.m4 for details of what node expands to.

// ParseNode is the superclass of all Parse node classes.  If the superclass
// argument in NODE is left blank, ParseNode will be used.


class ParseNode {
  public:
    enum Tag { SignatureT, ImplEltT, InheritT, RenamingT, ExportT,
		   MethodOrOpDefT, ParmT, FormalT, ExceptionT,
		   RestrictionT, TypeSpecT, TypeNameT, ActualParmT,
		   ParmOpT, IdOrIvarT, BodyT, ElseIfT, TagWhenArmT,
		   ExWhenArmT, OthersHandlerT, FieldInitT, InvocT,
		   RoutineIdT, SuperInfoT, BindingT, BindingArgT,
		   FieldT, IdT, ModuleT, SpecEltT, RoutineIntfT, StmtT, ExprT,
		   EquateT, DeclT, TypeWhenArmT, TypeObjectT, ClassEltT};
    Tag tag_;
    TypeInterface *type_;
    int line;
    tag();
    TypeInterface *get_type();
    int get_line();

    ParseNode(Tag tag );

    ParseNode(int lineno, Tag tag);

    virtual void print(int spaces)=0;
    virtual ParseNode* traverse(TraverseObj *tobj)=0;
    virtual ParseNode* propagate(TraverseObj *tobj)=0;
};

typedef xlist<ParseNode*> ParseNodeList;

ParseNodeList* propagate_parsenode_list(ParseNodeList *lp, TraverseObj *tobj);
ParseNodeList* traverse_parsenode_list(ParseNodeList *lp, TraverseObj *tobj);
void print_parsenode_list(ParseNodeList *lp, int spaces);

// ======================= Modules ==============================
class Module : public ParseNode {
   public:			 
    enum Tag { SpecModuleT, ImplModuleT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Module(Tag tag );

// Line-Number Preserving Constructor
    Module(int lineno ,  Tag tag );

// Copy Constructor
    Module(const Module& o);
   
// Line Preserving Copy Constructor
    Module(int lineno, const Module& o);
   
};

class SpecModule : public Module {
   
    private:
      ParseNodeList* specs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_specs();
      void set_specs(ParseNodeList* val);

// Normal Constructor
    SpecModule(ParseNodeList* specs  
		);

// Line-Number Preserving Constructor
    SpecModule(int lineno , ParseNodeList* specs  
		);

// Copy Constructor
    SpecModule(const SpecModule& o);
   
// Line Preserving Copy Constructor
    SpecModule(int lineno, const SpecModule& o);
   
};

class SpecElt : public ParseNode {
   public:			 
    enum Tag { TypeIntfT, RoutineSpecT, SpecEquateT  };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    SpecElt(Tag tag );

// Line-Number Preserving Constructor
    SpecElt(int lineno ,  Tag tag );

// Copy Constructor
    SpecElt(const SpecElt& o);
   
// Line Preserving Copy Constructor
    SpecElt(int lineno, const SpecElt& o);
   
};

class TypeIntf : public SpecElt {
   
    private:
      Id* id_; 
      ParseNodeList* parms_; 
      ParseNodeList* supers_; 
      ParseNodeList* wheres_; 
      ParseNodeList* methods_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_supers();
      void set_supers(ParseNodeList* val);
      ParseNodeList* get_wheres();
      void set_wheres(ParseNodeList* val);
      ParseNodeList* get_methods();
      void set_methods(ParseNodeList* val);

// Normal Constructor
    TypeIntf(Id* id , 
		ParseNodeList* parms , 
		ParseNodeList* supers , 
		ParseNodeList* wheres , 
		ParseNodeList* methods  
		);

// Line-Number Preserving Constructor
    TypeIntf(int lineno , Id* id , 
		ParseNodeList* parms , 
		ParseNodeList* supers , 
		ParseNodeList* wheres , 
		ParseNodeList* methods  
		);

// Copy Constructor
    TypeIntf(const TypeIntf& o);
   
// Line Preserving Copy Constructor
    TypeIntf(int lineno, const TypeIntf& o);
   
};

class RoutineIntf : public ParseNode {
   public:			 
    enum Tag { ProcHeaderT, IterHeaderT, MakeHeaderT };
    tag();
   private:		
    Tag tag_;
    private:
      Id* id_; 
      Signature* signature_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      Signature* get_signature();
      void set_signature(Signature* val);

// Normal Constructor
    RoutineIntf(Tag tag ,Id* id , 
		Signature* signature  
		);

// Line-Number Preserving Constructor
    RoutineIntf(int lineno ,  Tag tag ,Id* id , 
		Signature* signature  
		);

// Copy Constructor
    RoutineIntf(const RoutineIntf& o);
   
// Line Preserving Copy Constructor
    RoutineIntf(int lineno, const RoutineIntf& o);
   
};

class Signature : public ParseNode {
   public:			 
    enum Tag { ProcSigT, IterSigT, MakeSigT };
    tag();
   private:		
    Tag tag_;
    private:
      ParseNodeList* parms_; 
      ParseNodeList* args_; 
      ParseNodeList* returns_; 
      ParseNodeList* signals_; 
      ParseNodeList* where_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_args();
      void set_args(ParseNodeList* val);
      ParseNodeList* get_returns();
      void set_returns(ParseNodeList* val);
      ParseNodeList* get_signals();
      void set_signals(ParseNodeList* val);
      ParseNodeList* get_where();
      void set_where(ParseNodeList* val);

// Normal Constructor
    Signature(Tag tag ,ParseNodeList* parms , 
		ParseNodeList* args , 
		ParseNodeList* returns , 
		ParseNodeList* signals , 
		ParseNodeList* where  
		);

// Line-Number Preserving Constructor
    Signature(int lineno ,  Tag tag ,ParseNodeList* parms , 
		ParseNodeList* args , 
		ParseNodeList* returns , 
		ParseNodeList* signals , 
		ParseNodeList* where  
		);

// Copy Constructor
    Signature(const Signature& o);
   
// Line Preserving Copy Constructor
    Signature(int lineno, const Signature& o);
   
};

class RoutineSpec : public SpecElt {
   
    private:
      RoutineIntf* routine_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      RoutineIntf* get_routine();
      void set_routine(RoutineIntf* val);

// Normal Constructor
    RoutineSpec(RoutineIntf* routine  
		);

// Line-Number Preserving Constructor
    RoutineSpec(int lineno , RoutineIntf* routine  
		);

// Copy Constructor
    RoutineSpec(const RoutineSpec& o);
   
// Line Preserving Copy Constructor
    RoutineSpec(int lineno, const RoutineSpec& o);
   
};

class SpecEquate : public SpecElt {
   
    private:
      Equate * equate_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Equate * get_equate();
      void set_equate(Equate * val);

// Normal Constructor
    SpecEquate(Equate * equate  
		);

// Line-Number Preserving Constructor
    SpecEquate(int lineno , Equate * equate  
		);

// Copy Constructor
    SpecEquate(const SpecEquate& o);
   
// Line Preserving Copy Constructor
    SpecEquate(int lineno, const SpecEquate& o);
   
};

class Equate : public ParseNode {
   public:			 
    enum Tag { TypeEquateT, ExprEquateT  };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Equate(Tag tag );

// Line-Number Preserving Constructor
    Equate(int lineno ,  Tag tag );

// Copy Constructor
    Equate(const Equate& o);
   
// Line Preserving Copy Constructor
    Equate(int lineno, const Equate& o);
   
};

class ExprEquate : public Equate {
   
    private:
      Id* id_; 
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    ExprEquate(Id* id , 
		Expr* expr  
		);

// Line-Number Preserving Constructor
    ExprEquate(int lineno , Id* id , 
		Expr* expr  
		);

// Copy Constructor
    ExprEquate(const ExprEquate& o);
   
// Line Preserving Copy Constructor
    ExprEquate(int lineno, const ExprEquate& o);
   
};

class TypeEquate : public Equate {
   
    private:
      Id* id_; 
      TypeSpec* typ_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typ();
      void set_typ(TypeSpec* val);

// Normal Constructor
    TypeEquate(Id* id , 
		TypeSpec* typ  
		);

// Line-Number Preserving Constructor
    TypeEquate(int lineno , Id* id , 
		TypeSpec* typ  
		);

// Copy Constructor
    TypeEquate(const TypeEquate& o);
   
// Line Preserving Copy Constructor
    TypeEquate(int lineno, const TypeEquate& o);
   
};

class ImplModule : public Module {
   
    private:
      ParseNodeList* exports_; 
      ParseNodeList* equates_; 
      ParseNodeList* impls_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_exports();
      void set_exports(ParseNodeList* val);
      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_impls();
      void set_impls(ParseNodeList* val);

// Normal Constructor
    ImplModule(ParseNodeList* exports , 
		ParseNodeList* equates , 
		ParseNodeList* impls  
		);

// Line-Number Preserving Constructor
    ImplModule(int lineno , ParseNodeList* exports , 
		ParseNodeList* equates , 
		ParseNodeList* impls  
		);

// Copy Constructor
    ImplModule(const ImplModule& o);
   
// Line Preserving Copy Constructor
    ImplModule(int lineno, const ImplModule& o);
   
};

class ImplElt : public ParseNode {
   public:			 
    enum Tag { RoutineDefT, ClassDefT, ImplEquateT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    ImplElt(Tag tag );

// Line-Number Preserving Constructor
    ImplElt(int lineno ,  Tag tag );

// Copy Constructor
    ImplElt(const ImplElt& o);
   
// Line Preserving Copy Constructor
    ImplElt(int lineno, const ImplElt& o);
   
};

class RoutineDef : public ImplElt {
   
    private:
      RoutineIntf* routineIntf_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      RoutineIntf* get_routineIntf();
      void set_routineIntf(RoutineIntf* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    RoutineDef(RoutineIntf* routineIntf , 
		Body* body  
		);

// Line-Number Preserving Constructor
    RoutineDef(int lineno , RoutineIntf* routineIntf , 
		Body* body  
		);

// Copy Constructor
    RoutineDef(const RoutineDef& o);
   
// Line Preserving Copy Constructor
    RoutineDef(int lineno, const RoutineDef& o);
   
};

class ImplEquate : public ImplElt {
   
    private:
      Equate * equate_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Equate * get_equate();
      void set_equate(Equate * val);

// Normal Constructor
    ImplEquate(Equate * equate  
		);

// Line-Number Preserving Constructor
    ImplEquate(int lineno , Equate * equate  
		);

// Copy Constructor
    ImplEquate(const ImplEquate& o);
   
// Line Preserving Copy Constructor
    ImplEquate(int lineno, const ImplEquate& o);
   
};

class ClassDef : public ImplElt {
   
    private:
      Id* classId_; 
      TypeSpec* deftype_; 
      ParseNodeList* parms_; 
      ParseNodeList* wheres_; 
      Inherit* inherits_; 
      Export* exports_; 
      ParseNodeList* hides_; 
      int immutable_; 
      ParseNodeList* equates_; 
      ParseNodeList* decl_; 
      ParseNodeList* classElts_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_classId();
      void set_classId(Id* val);
      TypeSpec* get_deftype();
      void set_deftype(TypeSpec* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);
      ParseNodeList* get_wheres();
      void set_wheres(ParseNodeList* val);
      Inherit* get_inherits();
      void set_inherits(Inherit* val);
      Export* get_exports();
      void set_exports(Export* val);
      ParseNodeList* get_hides();
      void set_hides(ParseNodeList* val);
      int get_immutable();
      void set_immutable(int val);
      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_decl();
      void set_decl(ParseNodeList* val);
      ParseNodeList* get_classElts();
      void set_classElts(ParseNodeList* val);

// Normal Constructor
    ClassDef(Id* classId , 
		TypeSpec* deftype , 
		ParseNodeList* parms , 
		ParseNodeList* wheres , 
		Inherit* inherits , 
		Export* exports , 
		ParseNodeList* hides , 
		int immutable , 
		ParseNodeList* equates , 
		ParseNodeList* decl , 
		ParseNodeList* classElts  
		);

// Line-Number Preserving Constructor
    ClassDef(int lineno , Id* classId , 
		TypeSpec* deftype , 
		ParseNodeList* parms , 
		ParseNodeList* wheres , 
		Inherit* inherits , 
		Export* exports , 
		ParseNodeList* hides , 
		int immutable , 
		ParseNodeList* equates , 
		ParseNodeList* decl , 
		ParseNodeList* classElts  
		);

// Copy Constructor
    ClassDef(const ClassDef& o);
   
// Line Preserving Copy Constructor
    ClassDef(int lineno, const ClassDef& o);
   
};

class ClassElt : public ParseNode {
   public:			 
    enum Tag { MethodOrOpDefT, EquateT  };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    ClassElt(Tag tag );

// Line-Number Preserving Constructor
    ClassElt(int lineno ,  Tag tag );

// Copy Constructor
    ClassElt(const ClassElt& o);
   
// Line Preserving Copy Constructor
    ClassElt(int lineno, const ClassElt& o);
   
};

class Inherit : public ParseNode {
   
    private:
      TypeSpec* classSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_classSpec();
      void set_classSpec(TypeSpec* val);

// Normal Constructor
    Inherit(TypeSpec* classSpec  
		);

// Line-Number Preserving Constructor
    Inherit(int lineno , TypeSpec* classSpec  
		);

// Copy Constructor
    Inherit(const Inherit& o);
   
// Line Preserving Copy Constructor
    Inherit(int lineno, const Inherit& o);
   
};

class Renaming : public ParseNode {
   
    private:
      Expr* from_; 
      Id* to_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_from();
      void set_from(Expr* val);
      Id* get_to();
      void set_to(Id* val);

// Normal Constructor
    Renaming(Expr* from , 
		Id* to  
		);

// Line-Number Preserving Constructor
    Renaming(int lineno , Expr* from , 
		Id* to  
		);

// Copy Constructor
    Renaming(const Renaming& o);
   
// Line Preserving Copy Constructor
    Renaming(int lineno, const Renaming& o);
   
};

class Export : public ParseNode {
   
    private:
      ParseNodeList* exported_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_exported();
      void set_exported(ParseNodeList* val);

// Normal Constructor
    Export(ParseNodeList* exported  
		);

// Line-Number Preserving Constructor
    Export(int lineno , ParseNodeList* exported  
		);

// Copy Constructor
    Export(const Export& o);
   
// Line Preserving Copy Constructor
    Export(int lineno, const Export& o);
   
};

class MethodOrOpDef : public ParseNode {
   
    private:
      int isOp_; 
      int IsConstr_; 
      RoutineDef* routineDef_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      int get_isOp();
      void set_isOp(int val);
      int get_IsConstr();
      void set_IsConstr(int val);
      RoutineDef* get_routineDef();
      void set_routineDef(RoutineDef* val);

// Normal Constructor
    MethodOrOpDef(int isOp , 
		int IsConstr , 
		RoutineDef* routineDef  
		);

// Line-Number Preserving Constructor
    MethodOrOpDef(int lineno , int isOp , 
		int IsConstr , 
		RoutineDef* routineDef  
		);

// Copy Constructor
    MethodOrOpDef(const MethodOrOpDef& o);
   
// Line Preserving Copy Constructor
    MethodOrOpDef(int lineno, const MethodOrOpDef& o);
   
};

class Parm : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);

// Normal Constructor
    Parm(ParseNodeList* ids  
		);

// Line-Number Preserving Constructor
    Parm(int lineno , ParseNodeList* ids  
		);

// Copy Constructor
    Parm(const Parm& o);
   
// Line Preserving Copy Constructor
    Parm(int lineno, const Parm& o);
   
};

// unused
class Formal : public ParseNode {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);

// Normal Constructor
    Formal(Id* id , 
		TypeSpec* typeSpec  
		);

// Line-Number Preserving Constructor
    Formal(int lineno , Id* id , 
		TypeSpec* typeSpec  
		);

// Copy Constructor
    Formal(const Formal& o);
   
// Line Preserving Copy Constructor
    Formal(int lineno, const Formal& o);
   
};

class Exception : public ParseNode {
   
    private:
      Id* id_; 
      ParseNodeList* typeSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_typeSpec();
      void set_typeSpec(ParseNodeList* val);

// Normal Constructor
    Exception(Id* id , 
		ParseNodeList* typeSpec  
		);

// Line-Number Preserving Constructor
    Exception(int lineno , Id* id , 
		ParseNodeList* typeSpec  
		);

// Copy Constructor
    Exception(const Exception& o);
   
// Line Preserving Copy Constructor
    Exception(int lineno, const Exception& o);
   
};

class Restriction : public ParseNode {
   
    private:
      Id* TypeId_; 
      ParseNodeList* operations_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_TypeId();
      void set_TypeId(Id* val);
      ParseNodeList* get_operations();
      void set_operations(ParseNodeList* val);

// Normal Constructor
    Restriction(Id* TypeId , 
		ParseNodeList* operations  
		);

// Line-Number Preserving Constructor
    Restriction(int lineno , Id* TypeId , 
		ParseNodeList* operations  
		);

// Copy Constructor
    Restriction(const Restriction& o);
   
// Line Preserving Copy Constructor
    Restriction(int lineno, const Restriction& o);
   
};

class TypeSpec : public ParseNode {
   public:			 
    enum Tag { SimpleTypeSpecT, ParamTypeSpecT, TaggedTypeSpecT,
	RoutineTypeSpecT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    TypeSpec(Tag tag );

// Line-Number Preserving Constructor
    TypeSpec(int lineno ,  Tag tag );

// Copy Constructor
    TypeSpec(const TypeSpec& o);
   
// Line Preserving Copy Constructor
    TypeSpec(int lineno, const TypeSpec& o);
   
};

class TypeName : public ParseNode {
   
    private:
      Id* name_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_name();
      void set_name(Id* val);

// Normal Constructor
    TypeName(Id* name  
		);

// Line-Number Preserving Constructor
    TypeName(int lineno , Id* name  
		);

// Copy Constructor
    TypeName(const TypeName& o);
   
// Line Preserving Copy Constructor
    TypeName(int lineno, const TypeName& o);
   
};
      
class TypeObject : public ParseNode {
   
    private:
      TypeInterface* leaf_type_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeInterface* get_leaf_type();
      void set_leaf_type(TypeInterface* val);

// Normal Constructor
    TypeObject(TypeInterface* leaf_type  
		);

// Line-Number Preserving Constructor
    TypeObject(int lineno , TypeInterface* leaf_type  
		);

// Copy Constructor
    TypeObject(const TypeObject& o);
   
// Line Preserving Copy Constructor
    TypeObject(int lineno, const TypeObject& o);
   
};

class SimpleTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeName* get_name();
      void set_name(TypeName* val);

// Normal Constructor
    SimpleTypeSpec(TypeName* name  
		);

// Line-Number Preserving Constructor
    SimpleTypeSpec(int lineno , TypeName* name  
		);

// Copy Constructor
    SimpleTypeSpec(const SimpleTypeSpec& o);
   
// Line Preserving Copy Constructor
    SimpleTypeSpec(int lineno, const SimpleTypeSpec& o);
   
};

class ParamTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
      ParseNodeList* actualParms_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeName* get_name();
      void set_name(TypeName* val);
      ParseNodeList* get_actualParms();
      void set_actualParms(ParseNodeList* val);

// Normal Constructor
    ParamTypeSpec(TypeName* name , 
		ParseNodeList* actualParms  
		);

// Line-Number Preserving Constructor
    ParamTypeSpec(int lineno , TypeName* name , 
		ParseNodeList* actualParms  
		);

// Copy Constructor
    ParamTypeSpec(const ParamTypeSpec& o);
   
// Line Preserving Copy Constructor
    ParamTypeSpec(int lineno, const ParamTypeSpec& o);
   
};

class TaggedTypeSpec : public TypeSpec {
   
    private:
      TypeName* name_; 
      ParseNodeList* fields_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeName* get_name();
      void set_name(TypeName* val);
      ParseNodeList* get_fields();
      void set_fields(ParseNodeList* val);

// Normal Constructor
    TaggedTypeSpec(TypeName* name , 
		ParseNodeList* fields  
		);

// Line-Number Preserving Constructor
    TaggedTypeSpec(int lineno , TypeName* name , 
		ParseNodeList* fields  
		);

// Copy Constructor
    TaggedTypeSpec(const TaggedTypeSpec& o);
   
// Line Preserving Copy Constructor
    TaggedTypeSpec(int lineno, const TaggedTypeSpec& o);
   
};

class RoutineTypeSpec : public TypeSpec {
   
    private:
      Signature* signature_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Signature* get_signature();
      void set_signature(Signature* val);

// Normal Constructor
    RoutineTypeSpec(Signature* signature  
		);

// Line-Number Preserving Constructor
    RoutineTypeSpec(int lineno , Signature* signature  
		);

// Copy Constructor
    RoutineTypeSpec(const RoutineTypeSpec& o);
   
// Line Preserving Copy Constructor
    RoutineTypeSpec(int lineno, const RoutineTypeSpec& o);
   
};

class ActualParm : public ParseNode {
   
    private:
      TypeSpec* typeSpec_; 
      ParseNodeList* newNames_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      ParseNodeList* get_newNames();
      void set_newNames(ParseNodeList* val);

// Normal Constructor
    ActualParm(TypeSpec* typeSpec , 
		ParseNodeList* newNames  
		);

// Line-Number Preserving Constructor
    ActualParm(int lineno , TypeSpec* typeSpec , 
		ParseNodeList* newNames  
		);

// Copy Constructor
    ActualParm(const ActualParm& o);
   
// Line Preserving Copy Constructor
    ActualParm(int lineno, const ActualParm& o);
   
};

class ParmOp : public ParseNode {
   
    private:
      Expr* primary_; 
      Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      Id* get_id();
      void set_id(Id* val);

// Normal Constructor
    ParmOp(Expr* primary , 
		Id* id  
		);

// Line-Number Preserving Constructor
    ParmOp(int lineno , Expr* primary , 
		Id* id  
		);

// Copy Constructor
    ParmOp(const ParmOp& o);
   
// Line Preserving Copy Constructor
    ParmOp(int lineno, const ParmOp& o);
   
};

// ======================= Statements ===========================

/* Stmt */


// DeclT doesn't belong in the following list
class Stmt : public ParseNode {
   public:			 
    enum Tag { DeclStmtT, InitVarExprT, InitVarInvokeT, DeclT,
AssignInvokeT, AssignExprStmtT, AssignExprT, InvokeStmtT,
WhileStmtT, IfStmtT, TagcaseT, TypecaseT, ReturnStmtT,
YieldT, SignalStmtT, ExitT, BreakT, ContinueT, BlockStmtT,
ResignalStmtT, ExceptStmtT, InitT, DeclForStmtT, ForStmtT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Stmt(Tag tag );

// Line-Number Preserving Constructor
    Stmt(int lineno ,  Tag tag );

// Copy Constructor
    Stmt(const Stmt& o);
   
// Line Preserving Copy Constructor
    Stmt(int lineno, const Stmt& o);
   
};

class DeclStmt : public Stmt {
   
    private:
      Decl* decl_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Decl* get_decl();
      void set_decl(Decl* val);

// Normal Constructor
    DeclStmt(Decl* decl  
		);

// Line-Number Preserving Constructor
    DeclStmt(int lineno , Decl* decl  
		);

// Copy Constructor
    DeclStmt(const DeclStmt& o);
   
// Line Preserving Copy Constructor
    DeclStmt(int lineno, const DeclStmt& o);
   
};

class Decl : public ParseNode {
   public:			 
    enum Tag { RegDeclT, ImplDeclT, VarArgsDeclT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Decl(Tag tag );

// Line-Number Preserving Constructor
    Decl(int lineno ,  Tag tag );

// Copy Constructor
    Decl(const Decl& o);
   
// Line Preserving Copy Constructor
    Decl(int lineno, const Decl& o);
   
};

class RegDecl : public Decl {
   
    private:
      ParseNodeList* ids_; 
      TypeSpec* typeSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);

// Normal Constructor
    RegDecl(ParseNodeList* ids , 
		TypeSpec* typeSpec  
		);

// Line-Number Preserving Constructor
    RegDecl(int lineno , ParseNodeList* ids , 
		TypeSpec* typeSpec  
		);

// Copy Constructor
    RegDecl(const RegDecl& o);
   
// Line Preserving Copy Constructor
    RegDecl(int lineno, const RegDecl& o);
   
};

class VarArgsDecl : public Decl {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);

// Normal Constructor
    VarArgsDecl(Id* id , 
		TypeSpec* typeSpec  
		);

// Line-Number Preserving Constructor
    VarArgsDecl(int lineno , Id* id , 
		TypeSpec* typeSpec  
		);

// Copy Constructor
    VarArgsDecl(const VarArgsDecl& o);
   
// Line Preserving Copy Constructor
    VarArgsDecl(int lineno, const VarArgsDecl& o);
   
};

class ImplDecl : public Decl {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
      Id* get_; 
      Id* set_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Id* get_get();
      void set_get(Id* val);
      Id* get_set();
      void set_set(Id* val);

// Normal Constructor
    ImplDecl(Id* id , 
		TypeSpec* typeSpec , 
		Id* get , 
		Id* set  
		);

// Line-Number Preserving Constructor
    ImplDecl(int lineno , Id* id , 
		TypeSpec* typeSpec , 
		Id* get , 
		Id* set  
		);

// Copy Constructor
    ImplDecl(const ImplDecl& o);
   
// Line Preserving Copy Constructor
    ImplDecl(int lineno, const ImplDecl& o);
   
};

class InitVarExpr : public Stmt {
   
    private:
      Decl* decl_; 
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Decl* get_decl();
      void set_decl(Decl* val);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    InitVarExpr(Decl* decl , 
		Expr* expr  
		);

// Line-Number Preserving Constructor
    InitVarExpr(int lineno , Decl* decl , 
		Expr* expr  
		);

// Copy Constructor
    InitVarExpr(const InitVarExpr& o);
   
// Line Preserving Copy Constructor
    InitVarExpr(int lineno, const InitVarExpr& o);
   
};

class InitVarInvoke : public Stmt {
   
    private:
      ParseNodeList* decls_; 
      Invoc* invoc_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);

// Normal Constructor
    InitVarInvoke(ParseNodeList* decls , 
		Invoc* invoc  
		);

// Line-Number Preserving Constructor
    InitVarInvoke(int lineno , ParseNodeList* decls , 
		Invoc* invoc  
		);

// Copy Constructor
    InitVarInvoke(const InitVarInvoke& o);
   
// Line Preserving Copy Constructor
    InitVarInvoke(int lineno, const InitVarInvoke& o);
   
};


// unused
class AssignInvoke : public Stmt {
   
    private:
      ParseNodeList* idOrIvars_; 
      Invoc* invoc_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_idOrIvars();
      void set_idOrIvars(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);

// Normal Constructor
    AssignInvoke(ParseNodeList* idOrIvars , 
		Invoc* invoc  
		);

// Line-Number Preserving Constructor
    AssignInvoke(int lineno , ParseNodeList* idOrIvars , 
		Invoc* invoc  
		);

// Copy Constructor
    AssignInvoke(const AssignInvoke& o);
   
// Line Preserving Copy Constructor
    AssignInvoke(int lineno, const AssignInvoke& o);
   
};

class AssignExprStmt : public Stmt {
   
    private:
      ParseNodeList* ids_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    AssignExprStmt(ParseNodeList* ids , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    AssignExprStmt(int lineno , ParseNodeList* ids , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    AssignExprStmt(const AssignExprStmt& o);
   
// Line Preserving Copy Constructor
    AssignExprStmt(int lineno, const AssignExprStmt& o);
   
};


// unused
class AssignExpr : public Stmt {
   
    private:
      Expr* primary_; 
      Expr* primaryExpr_; 
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      Expr* get_primaryExpr();
      void set_primaryExpr(Expr* val);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    AssignExpr(Expr* primary , 
		Expr* primaryExpr , 
		Expr* expr  
		);

// Line-Number Preserving Constructor
    AssignExpr(int lineno , Expr* primary , 
		Expr* primaryExpr , 
		Expr* expr  
		);

// Copy Constructor
    AssignExpr(const AssignExpr& o);
   
// Line Preserving Copy Constructor
    AssignExpr(int lineno, const AssignExpr& o);
   
};

class InvokeStmt : public Stmt {
   
    private:
      Invoc* invoc_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);

// Normal Constructor
    InvokeStmt(Invoc* invoc  
		);

// Line-Number Preserving Constructor
    InvokeStmt(int lineno , Invoc* invoc  
		);

// Copy Constructor
    InvokeStmt(const InvokeStmt& o);
   
// Line Preserving Copy Constructor
    InvokeStmt(int lineno, const InvokeStmt& o);
   
};

class WhileStmt : public Stmt {
   
    private:
      Expr* expr_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    WhileStmt(Expr* expr , 
		Body* body  
		);

// Line-Number Preserving Constructor
    WhileStmt(int lineno , Expr* expr , 
		Body* body  
		);

// Copy Constructor
    WhileStmt(const WhileStmt& o);
   
// Line Preserving Copy Constructor
    WhileStmt(int lineno, const WhileStmt& o);
   
};

class IfStmt : public Stmt {
   
    private:
      Expr* expr_; 
      Body* body_; 
      ParseNodeList* elseifs_; 
      Body* elsebody_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);
      ParseNodeList* get_elseifs();
      void set_elseifs(ParseNodeList* val);
      Body* get_elsebody();
      void set_elsebody(Body* val);

// Normal Constructor
    IfStmt(Expr* expr , 
		Body* body , 
		ParseNodeList* elseifs , 
		Body* elsebody  
		);

// Line-Number Preserving Constructor
    IfStmt(int lineno , Expr* expr , 
		Body* body , 
		ParseNodeList* elseifs , 
		Body* elsebody  
		);

// Copy Constructor
    IfStmt(const IfStmt& o);
   
// Line Preserving Copy Constructor
    IfStmt(int lineno, const IfStmt& o);
   
};

class DeclForStmt : public Stmt {
   
    private:
      ParseNodeList* decls_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    DeclForStmt(ParseNodeList* decls , 
		Invoc* invoc , 
		Body* body  
		);

// Line-Number Preserving Constructor
    DeclForStmt(int lineno , ParseNodeList* decls , 
		Invoc* invoc , 
		Body* body  
		);

// Copy Constructor
    DeclForStmt(const DeclForStmt& o);
   
// Line Preserving Copy Constructor
    DeclForStmt(int lineno, const DeclForStmt& o);
   
};

class ForStmt : public Stmt {
   
    private:
      ParseNodeList* ids_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    ForStmt(ParseNodeList* ids , 
		Invoc* invoc , 
		Body* body  
		);

// Line-Number Preserving Constructor
    ForStmt(int lineno , ParseNodeList* ids , 
		Invoc* invoc , 
		Body* body  
		);

// Copy Constructor
    ForStmt(const ForStmt& o);
   
// Line Preserving Copy Constructor
    ForStmt(int lineno, const ForStmt& o);
   
};

class Tagcase : public Stmt {
   
    private:
      Expr* expr_; 
      ParseNodeList* tagWhenArms_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);
      ParseNodeList* get_tagWhenArms();
      void set_tagWhenArms(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    Tagcase(Expr* expr , 
		ParseNodeList* tagWhenArms , 
		Body* body  
		);

// Line-Number Preserving Constructor
    Tagcase(int lineno , Expr* expr , 
		ParseNodeList* tagWhenArms , 
		Body* body  
		);

// Copy Constructor
    Tagcase(const Tagcase& o);
   
// Line Preserving Copy Constructor
    Tagcase(int lineno, const Tagcase& o);
   
};


class Typecase : public Stmt {
   
    private:
      Expr* expr_; 
      ParseNodeList* typeWhenArms_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);
      ParseNodeList* get_typeWhenArms();
      void set_typeWhenArms(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    Typecase(Expr* expr , 
		ParseNodeList* typeWhenArms , 
		Body* body  
		);

// Line-Number Preserving Constructor
    Typecase(int lineno , Expr* expr , 
		ParseNodeList* typeWhenArms , 
		Body* body  
		);

// Copy Constructor
    Typecase(const Typecase& o);
   
// Line Preserving Copy Constructor
    Typecase(int lineno, const Typecase& o);
   
};

class TypeWhenArm : public ParseNode {
   
    private:
      TypeSpec* typ_; 
      Id* id_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_typ();
      void set_typ(TypeSpec* val);
      Id* get_id();
      void set_id(Id* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    TypeWhenArm(TypeSpec* typ , 
		Id* id , 
		Body* body  
		);

// Line-Number Preserving Constructor
    TypeWhenArm(int lineno , TypeSpec* typ , 
		Id* id , 
		Body* body  
		);

// Copy Constructor
    TypeWhenArm(const TypeWhenArm& o);
   
// Line Preserving Copy Constructor
    TypeWhenArm(int lineno, const TypeWhenArm& o);
   
};

class ReturnStmt : public Stmt {
   
    private:
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    ReturnStmt(ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    ReturnStmt(int lineno , ParseNodeList* exprs  
		);

// Copy Constructor
    ReturnStmt(const ReturnStmt& o);
   
// Line Preserving Copy Constructor
    ReturnStmt(int lineno, const ReturnStmt& o);
   
};

class Yield : public Stmt {
   
    private:
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    Yield(ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    Yield(int lineno , ParseNodeList* exprs  
		);

// Copy Constructor
    Yield(const Yield& o);
   
// Line Preserving Copy Constructor
    Yield(int lineno, const Yield& o);
   
};

class SignalStmt : public Stmt {
   
    private:
      Id* id_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    SignalStmt(Id* id , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    SignalStmt(int lineno , Id* id , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    SignalStmt(const SignalStmt& o);
   
// Line Preserving Copy Constructor
    SignalStmt(int lineno, const SignalStmt& o);
   
};

class Exit : public Stmt {
   
    private:
      Id* id_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    Exit(Id* id , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    Exit(int lineno , Id* id , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    Exit(const Exit& o);
   
// Line Preserving Copy Constructor
    Exit(int lineno, const Exit& o);
   
};

class BlockStmt : public Stmt {
   
    private:
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    BlockStmt(Body* body  
		);

// Line-Number Preserving Constructor
    BlockStmt(int lineno , Body* body  
		);

// Copy Constructor
    BlockStmt(const BlockStmt& o);
   
// Line Preserving Copy Constructor
    BlockStmt(int lineno, const BlockStmt& o);
   
};

class ResignalStmt : public Stmt {
   
    private:
      Stmt* stmt_; 
      ParseNodeList* ids_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Stmt* get_stmt();
      void set_stmt(Stmt* val);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);

// Normal Constructor
    ResignalStmt(Stmt* stmt , 
		ParseNodeList* ids  
		);

// Line-Number Preserving Constructor
    ResignalStmt(int lineno , Stmt* stmt , 
		ParseNodeList* ids  
		);

// Copy Constructor
    ResignalStmt(const ResignalStmt& o);
   
// Line Preserving Copy Constructor
    ResignalStmt(int lineno, const ResignalStmt& o);
   
};

class ExceptStmt : public Stmt {
   
    private:
      Stmt* stmt_; 
      ParseNodeList* exWhenArm_; 
      Decl* decl_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Stmt* get_stmt();
      void set_stmt(Stmt* val);
      ParseNodeList* get_exWhenArm();
      void set_exWhenArm(ParseNodeList* val);
      Decl* get_decl();
      void set_decl(Decl* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    ExceptStmt(Stmt* stmt , 
		ParseNodeList* exWhenArm , 
		Decl* decl , 
		Body* body  
		);

// Line-Number Preserving Constructor
    ExceptStmt(int lineno , Stmt* stmt , 
		ParseNodeList* exWhenArm , 
		Decl* decl , 
		Body* body  
		);

// Copy Constructor
    ExceptStmt(const ExceptStmt& o);
   
// Line Preserving Copy Constructor
    ExceptStmt(int lineno, const ExceptStmt& o);
   
};

class Init : public Stmt {
   
    private:
      ParseNodeList* fieldInits_; 
      Invoc* invoc_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_fieldInits();
      void set_fieldInits(ParseNodeList* val);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    Init(ParseNodeList* fieldInits , 
		Invoc* invoc , 
		Body* body  
		);

// Line-Number Preserving Constructor
    Init(int lineno , ParseNodeList* fieldInits , 
		Invoc* invoc , 
		Body* body  
		);

// Copy Constructor
    Init(const Init& o);
   
// Line Preserving Copy Constructor
    Init(int lineno, const Init& o);
   
};

class IdOrIvar : public ParseNode {
   
    private:
      Expr* primary_; 
      /* null if no primary */
     Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      /* null if no primary */
     Id* get_id();
      void set_id(/* null if no primary */
     Id* val);

// Normal Constructor
    IdOrIvar(Expr* primary , 
		/* null if no primary */
     Id* id  
		);

// Line-Number Preserving Constructor
    IdOrIvar(int lineno , Expr* primary , 
		/* null if no primary */
     Id* id  
		);

// Copy Constructor
    IdOrIvar(const IdOrIvar& o);
   
// Line Preserving Copy Constructor
    IdOrIvar(int lineno, const IdOrIvar& o);
   
};

class Body : public ParseNode {
   
    private:
      ParseNodeList* equates_; 
      ParseNodeList* statements_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_equates();
      void set_equates(ParseNodeList* val);
      ParseNodeList* get_statements();
      void set_statements(ParseNodeList* val);

// Normal Constructor
    Body(ParseNodeList* equates , 
		ParseNodeList* statements  
		);

// Line-Number Preserving Constructor
    Body(int lineno , ParseNodeList* equates , 
		ParseNodeList* statements  
		);

// Copy Constructor
    Body(const Body& o);
   
// Line Preserving Copy Constructor
    Body(int lineno, const Body& o);
   
};

class ElseIf : public ParseNode {
   
    private:
      Expr* expr_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    ElseIf(Expr* expr , 
		Body* body  
		);

// Line-Number Preserving Constructor
    ElseIf(int lineno , Expr* expr , 
		Body* body  
		);

// Copy Constructor
    ElseIf(const ElseIf& o);
   
// Line Preserving Copy Constructor
    ElseIf(int lineno, const ElseIf& o);
   
};

class TagWhenArm : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
      Decl* decl_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      Decl* get_decl();
      void set_decl(Decl* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    TagWhenArm(ParseNodeList* ids , 
		Decl* decl , 
		Body* body  
		);

// Line-Number Preserving Constructor
    TagWhenArm(int lineno , ParseNodeList* ids , 
		Decl* decl , 
		Body* body  
		);

// Copy Constructor
    TagWhenArm(const TagWhenArm& o);
   
// Line Preserving Copy Constructor
    TagWhenArm(int lineno, const TagWhenArm& o);
   
};

class ExWhenArm : public ParseNode {
   
    private:
      ParseNodeList* names_; 
      ParseNodeList* decls_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_names();
      void set_names(ParseNodeList* val);
      ParseNodeList* get_decls();
      void set_decls(ParseNodeList* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    ExWhenArm(ParseNodeList* names , 
		ParseNodeList* decls , 
		Body* body  
		);

// Line-Number Preserving Constructor
    ExWhenArm(int lineno , ParseNodeList* names , 
		ParseNodeList* decls , 
		Body* body  
		);

// Copy Constructor
    ExWhenArm(const ExWhenArm& o);
   
// Line Preserving Copy Constructor
    ExWhenArm(int lineno, const ExWhenArm& o);
   
};

// apparently unused
class OthersHandler : public ParseNode {
   
    private:
      Id* id_; 
      TypeSpec* typeSpec_; 
      Body* body_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Body* get_body();
      void set_body(Body* val);

// Normal Constructor
    OthersHandler(Id* id , 
		TypeSpec* typeSpec , 
		Body* body  
		);

// Line-Number Preserving Constructor
    OthersHandler(int lineno , Id* id , 
		TypeSpec* typeSpec , 
		Body* body  
		);

// Copy Constructor
    OthersHandler(const OthersHandler& o);
   
// Line Preserving Copy Constructor
    OthersHandler(int lineno, const OthersHandler& o);
   
};

class FieldInit : public ParseNode {
   
    private:
      Id* id_; 
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    FieldInit(Id* id , 
		Expr* expr  
		);

// Line-Number Preserving Constructor
    FieldInit(int lineno , Id* id , 
		Expr* expr  
		);

// Copy Constructor
    FieldInit(const FieldInit& o);
   
// Line Preserving Copy Constructor
    FieldInit(int lineno, const FieldInit& o);
   
};


// ======================= Expressions ==========================
class Expr : public ParseNode {
   public:			 
    enum Tag { NilT, LiteralT, InstantiationT,
      DotExprT, SuperIdT, SelfT, NewT, ArrayRefT, InvocExprT,
      BindingExprT, SelectorConstrT, ArrayConstrT, IdExprT, BinaryT,
      UnaryT, BracketRefT, BraceRefT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Expr(Tag tag );

// Line-Number Preserving Constructor
    Expr(int lineno ,  Tag tag );

// Copy Constructor
    Expr(const Expr& o);
   
// Line Preserving Copy Constructor
    Expr(int lineno, const Expr& o);
   
};

class BracketRef : public Expr {
   
    private:
      Expr* primary_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    BracketRef(Expr* primary , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    BracketRef(int lineno , Expr* primary , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    BracketRef(const BracketRef& o);
   
// Line Preserving Copy Constructor
    BracketRef(int lineno, const BracketRef& o);
   
};

class BraceRef : public Expr {
   
    private:
      Expr* primary_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    BraceRef(Expr* primary , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    BraceRef(int lineno , Expr* primary , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    BraceRef(const BraceRef& o);
   
// Line Preserving Copy Constructor
    BraceRef(int lineno, const BraceRef& o);
   
};

class Binary : public Expr {
   public:			 
    enum Tag { PlusT, MinusT, TimesT, DividesT, ModuloT, PowerT, AndT,
OrT, LTT, LTET, GTT, GTET, EqualT, ConcatT, NLTT, NLTET, NGTET, NGTT,
NotEqualT, EqualEqualT, NotEqualEqualT };
    tag();
   private:		
    Tag tag_;
    private:
      Expr* op1_; 
      Expr* op2_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_op1();
      void set_op1(Expr* val);
      Expr* get_op2();
      void set_op2(Expr* val);

// Normal Constructor
    Binary(Tag tag ,Expr* op1 , 
		Expr* op2  
		);

// Line-Number Preserving Constructor
    Binary(int lineno ,  Tag tag ,Expr* op1 , 
		Expr* op2  
		);

// Copy Constructor
    Binary(const Binary& o);
   
// Line Preserving Copy Constructor
    Binary(int lineno, const Binary& o);
   
};

class Unary : public Expr {
   public:			 
    enum Tag { NotT, MinusT };
    tag();
   private:		
    Tag tag_;
    private:
      Expr* op_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_op();
      void set_op(Expr* val);

// Normal Constructor
    Unary(Tag tag ,Expr* op  
		);

// Line-Number Preserving Constructor
    Unary(int lineno ,  Tag tag ,Expr* op  
		);

// Copy Constructor
    Unary(const Unary& o);
   
// Line Preserving Copy Constructor
    Unary(int lineno, const Unary& o);
   
};

class Literal : public Expr {
   public:			 
    enum Tag { IntLiteralT, BoolLiteralT, CharLiteralT, 
	StringLiteralT, RealLiteralT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    Literal(Tag tag );

// Line-Number Preserving Constructor
    Literal(int lineno ,  Tag tag );

// Copy Constructor
    Literal(const Literal& o);
   
// Line Preserving Copy Constructor
    Literal(int lineno, const Literal& o);
   
};

class IntLiteral : public Literal {
   
    private:
      int i_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      int get_i();
      void set_i(int val);

// Normal Constructor
    IntLiteral(int i  
		);

// Line-Number Preserving Constructor
    IntLiteral(int lineno , int i  
		);

// Copy Constructor
    IntLiteral(const IntLiteral& o);
   
// Line Preserving Copy Constructor
    IntLiteral(int lineno, const IntLiteral& o);
   
};

class BoolLiteral : public Literal {
   
    private:
      int b_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      int get_b();
      void set_b(int val);

// Normal Constructor
    BoolLiteral(int b  
		);

// Line-Number Preserving Constructor
    BoolLiteral(int lineno , int b  
		);

// Copy Constructor
    BoolLiteral(const BoolLiteral& o);
   
// Line Preserving Copy Constructor
    BoolLiteral(int lineno, const BoolLiteral& o);
   
};	/* Make proper boolean type! */

class CharLiteral : public Literal {
   
    private:
      char c_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      char get_c();
      void set_c(char val);

// Normal Constructor
    CharLiteral(char c  
		);

// Line-Number Preserving Constructor
    CharLiteral(int lineno , char c  
		);

// Copy Constructor
    CharLiteral(const CharLiteral& o);
   
// Line Preserving Copy Constructor
    CharLiteral(int lineno, const CharLiteral& o);
   
};

class RealLiteral : public Literal {
   
    private:
      double r_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      double get_r();
      void set_r(double val);

// Normal Constructor
    RealLiteral(double r  
		);

// Line-Number Preserving Constructor
    RealLiteral(int lineno , double r  
		);

// Copy Constructor
    RealLiteral(const RealLiteral& o);
   
// Line Preserving Copy Constructor
    RealLiteral(int lineno, const RealLiteral& o);
   
};

class StringLiteral : public Literal {
   
    private:
      string s_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      string get_s();
      void set_s(string val);

// Normal Constructor
    StringLiteral(string s  
		);

// Line-Number Preserving Constructor
    StringLiteral(int lineno , string s  
		);

// Copy Constructor
    StringLiteral(const StringLiteral& o);
   
// Line Preserving Copy Constructor
    StringLiteral(int lineno, const StringLiteral& o);
   
};

class Instantiation : public Expr {
   
    private:
      TypeSpec* otypeSpec_; 
      Id* id_; 
      ParseNodeList* actualParms_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_otypeSpec();
      void set_otypeSpec(TypeSpec* val);
      Id* get_id();
      void set_id(Id* val);
      ParseNodeList* get_actualParms();
      void set_actualParms(ParseNodeList* val);

// Normal Constructor
    Instantiation(TypeSpec* otypeSpec , 
		Id* id , 
		ParseNodeList* actualParms  
		);

// Line-Number Preserving Constructor
    Instantiation(int lineno , TypeSpec* otypeSpec , 
		Id* id , 
		ParseNodeList* actualParms  
		);

// Copy Constructor
    Instantiation(const Instantiation& o);
   
// Line Preserving Copy Constructor
    Instantiation(int lineno, const Instantiation& o);
   
};

class DotExpr : public Expr {
   
    private:
      Expr* primary_; 
      Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      Id* get_id();
      void set_id(Id* val);

// Normal Constructor
    DotExpr(Expr* primary , 
		Id* id  
		);

// Line-Number Preserving Constructor
    DotExpr(int lineno , Expr* primary , 
		Id* id  
		);

// Copy Constructor
    DotExpr(const DotExpr& o);
   
// Line Preserving Copy Constructor
    DotExpr(int lineno, const DotExpr& o);
   
};

class SuperId : public Expr {
   
    private:
      Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);

// Normal Constructor
    SuperId(Id* id  
		);

// Line-Number Preserving Constructor
    SuperId(int lineno , Id* id  
		);

// Copy Constructor
    SuperId(const SuperId& o);
   
// Line Preserving Copy Constructor
    SuperId(int lineno, const SuperId& o);
   
};

class IdExpr : public Expr {
   
    private:
      Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);

// Normal Constructor
    IdExpr(Id* id  
		);

// Line-Number Preserving Constructor
    IdExpr(int lineno , Id* id  
		);

// Copy Constructor
    IdExpr(const IdExpr& o);
   
// Line Preserving Copy Constructor
    IdExpr(int lineno, const IdExpr& o);
   
};

class ArrayRef : public Expr {
   
    private:
      Expr* primary_; 
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    ArrayRef(Expr* primary , 
		Expr* expr  
		);

// Line-Number Preserving Constructor
    ArrayRef(int lineno , Expr* primary , 
		Expr* expr  
		);

// Copy Constructor
    ArrayRef(const ArrayRef& o);
   
// Line Preserving Copy Constructor
    ArrayRef(int lineno, const ArrayRef& o);
   
};

class InvocExpr : public Expr {
   
    private:
      Invoc* invoc_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Invoc* get_invoc();
      void set_invoc(Invoc* val);

// Normal Constructor
    InvocExpr(Invoc* invoc  
		);

// Line-Number Preserving Constructor
    InvocExpr(int lineno , Invoc* invoc  
		);

// Copy Constructor
    InvocExpr(const InvocExpr& o);
   
// Line Preserving Copy Constructor
    InvocExpr(int lineno, const InvocExpr& o);
   
};

class BindingExpr : public Expr {
   
    private:
      Binding* binding_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Binding* get_binding();
      void set_binding(Binding* val);

// Normal Constructor
    BindingExpr(Binding* binding  
		);

// Line-Number Preserving Constructor
    BindingExpr(int lineno , Binding* binding  
		);

// Copy Constructor
    BindingExpr(const BindingExpr& o);
   
// Line Preserving Copy Constructor
    BindingExpr(int lineno, const BindingExpr& o);
   
};

class SelectorConstr : public Expr {
   
    private:
      TypeSpec* typeSpec_; 
      ParseNodeList* fields_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      ParseNodeList* get_fields();
      void set_fields(ParseNodeList* val);

// Normal Constructor
    SelectorConstr(TypeSpec* typeSpec , 
		ParseNodeList* fields  
		);

// Line-Number Preserving Constructor
    SelectorConstr(int lineno , TypeSpec* typeSpec , 
		ParseNodeList* fields  
		);

// Copy Constructor
    SelectorConstr(const SelectorConstr& o);
   
// Line Preserving Copy Constructor
    SelectorConstr(int lineno, const SelectorConstr& o);
   
};

class ArrayConstr : public Expr {
   
    private:
      TypeSpec* typeSpec_; 
      Expr* size_; 
      ParseNodeList* exprs_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);
      Expr* get_size();
      void set_size(Expr* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);

// Normal Constructor
    ArrayConstr(TypeSpec* typeSpec , 
		Expr* size , 
		ParseNodeList* exprs  
		);

// Line-Number Preserving Constructor
    ArrayConstr(int lineno , TypeSpec* typeSpec , 
		Expr* size , 
		ParseNodeList* exprs  
		);

// Copy Constructor
    ArrayConstr(const ArrayConstr& o);
   
// Line Preserving Copy Constructor
    ArrayConstr(int lineno, const ArrayConstr& o);
   
};

class Invoc : public ParseNode {
   
    private:
      RoutineId* routineId_; 
      ParseNodeList* exprs_; 
      ParseNodeList* lastarg_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      RoutineId* get_routineId();
      void set_routineId(RoutineId* val);
      ParseNodeList* get_exprs();
      void set_exprs(ParseNodeList* val);
      ParseNodeList* get_lastarg();
      void set_lastarg(ParseNodeList* val);

// Normal Constructor
    Invoc(RoutineId* routineId , 
		ParseNodeList* exprs , 
		ParseNodeList* lastarg  
		);

// Line-Number Preserving Constructor
    Invoc(int lineno , RoutineId* routineId , 
		ParseNodeList* exprs , 
		ParseNodeList* lastarg  
		);

// Copy Constructor
    Invoc(const Invoc& o);
   
// Line Preserving Copy Constructor
    Invoc(int lineno, const Invoc& o);
   
};

class RoutineId : public ParseNode {
   public:			 
    enum Tag { SimpleRoutineIdT, ComplexRoutineIdT, SuperClassRoutineIdT };
    tag();
   private:		
    Tag tag_;
   
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);

// Normal Constructor
    RoutineId(Tag tag );

// Line-Number Preserving Constructor
    RoutineId(int lineno ,  Tag tag );

// Copy Constructor
    RoutineId(const RoutineId& o);
   
// Line Preserving Copy Constructor
    RoutineId(int lineno, const RoutineId& o);
   
};

class SimpleRoutineId : public RoutineId {
   
    private:
      Expr* primary_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);

// Normal Constructor
    SimpleRoutineId(Expr* primary  
		);

// Line-Number Preserving Constructor
    SimpleRoutineId(int lineno , Expr* primary  
		);

// Copy Constructor
    SimpleRoutineId(const SimpleRoutineId& o);
   
// Line Preserving Copy Constructor
    SimpleRoutineId(int lineno, const SimpleRoutineId& o);
   
};

class ComplexRoutineId : public RoutineId {
   
    private:
      Expr* primary_; 
      ParseNodeList* parms_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_primary();
      void set_primary(Expr* val);
      ParseNodeList* get_parms();
      void set_parms(ParseNodeList* val);

// Normal Constructor
    ComplexRoutineId(Expr* primary , 
		ParseNodeList* parms  
		);

// Line-Number Preserving Constructor
    ComplexRoutineId(int lineno , Expr* primary , 
		ParseNodeList* parms  
		);

// Copy Constructor
    ComplexRoutineId(const ComplexRoutineId& o);
   
// Line Preserving Copy Constructor
    ComplexRoutineId(int lineno, const ComplexRoutineId& o);
   
};

class SuperClassRoutineId : public RoutineId {
   
    private:
      Id* id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Id* get_id();
      void set_id(Id* val);

// Normal Constructor
    SuperClassRoutineId(Id* id  
		);

// Line-Number Preserving Constructor
    SuperClassRoutineId(int lineno , Id* id  
		);

// Copy Constructor
    SuperClassRoutineId(const SuperClassRoutineId& o);
   
// Line Preserving Copy Constructor
    SuperClassRoutineId(int lineno, const SuperClassRoutineId& o);
   
};

class SuperInfo : public ParseNode {
   
    private:
      TypeSpec* typespec_; 
      ParseNodeList* renamings_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      TypeSpec* get_typespec();
      void set_typespec(TypeSpec* val);
      ParseNodeList* get_renamings();
      void set_renamings(ParseNodeList* val);

// Normal Constructor
    SuperInfo(TypeSpec* typespec , 
		ParseNodeList* renamings  
		);

// Line-Number Preserving Constructor
    SuperInfo(int lineno , TypeSpec* typespec , 
		ParseNodeList* renamings  
		);

// Copy Constructor
    SuperInfo(const SuperInfo& o);
   
// Line Preserving Copy Constructor
    SuperInfo(int lineno, const SuperInfo& o);
   
};

class Binding : public ParseNode {
   
    private:
      Expr* proc_; 
      ParseNodeList* args_; 
      ParseNodeList* lastarg_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_proc();
      void set_proc(Expr* val);
      ParseNodeList* get_args();
      void set_args(ParseNodeList* val);
      ParseNodeList* get_lastarg();
      void set_lastarg(ParseNodeList* val);

// Normal Constructor
    Binding(Expr* proc , 
		ParseNodeList* args , 
		ParseNodeList* lastarg  
		);

// Line-Number Preserving Constructor
    Binding(int lineno , Expr* proc , 
		ParseNodeList* args , 
		ParseNodeList* lastarg  
		);

// Copy Constructor
    Binding(const Binding& o);
   
// Line Preserving Copy Constructor
    Binding(int lineno, const Binding& o);
   
};

class BindingArg : public ParseNode {
   
    private:
      Expr* expr_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      Expr* get_expr();
      void set_expr(Expr* val);

// Normal Constructor
    BindingArg(Expr* expr  
		);

// Line-Number Preserving Constructor
    BindingArg(int lineno , Expr* expr  
		);

// Copy Constructor
    BindingArg(const BindingArg& o);
   
// Line Preserving Copy Constructor
    BindingArg(int lineno, const BindingArg& o);
   
}; /* if expr is null, indicates "*" */

class Field : public ParseNode {
   
    private:
      ParseNodeList* ids_; 
      TypeSpec* typeSpec_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      ParseNodeList* get_ids();
      void set_ids(ParseNodeList* val);
      TypeSpec* get_typeSpec();
      void set_typeSpec(TypeSpec* val);

// Normal Constructor
    Field(ParseNodeList* ids , 
		TypeSpec* typeSpec  
		);

// Line-Number Preserving Constructor
    Field(int lineno , ParseNodeList* ids , 
		TypeSpec* typeSpec  
		);

// Copy Constructor
    Field(const Field& o);
   
// Line Preserving Copy Constructor
    Field(int lineno, const Field& o);
   
};

class Id : public ParseNode {
   
    private:
      string id_; 
 
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
      string get_id();
      void set_id(string val);

// Normal Constructor
    Id(string id  
		);

// Line-Number Preserving Constructor
    Id(int lineno , string id  
		);

// Copy Constructor
    Id(const Id& o);
   
// Line Preserving Copy Constructor
    Id(int lineno, const Id& o);
   
};



#endif /* _COMPILER_PARSE_H */

