
// A Compiler Parse Tree Format, based on the reference grammar in the
// draft Theta Reference Manual

#include "xlist.h"
#include "my_string.h"
#include "traverse.h"
#include "environment.h"
#include <stdio.h>
extern int cmpyy_lineno;
include(`parseMacrosCC.m4')

// We first declare all of the node classes used in the parse tree

DECLARE_NODES(Module,SpecModule,RoutineSpec,ProcHeader,IterHeader,MakeHeader,EquateModule,
    Decl, Equate,TypeEquate,ConstEquate,ImplModule,Impl,RoutineDef,ClassDef,
    Renaming,Export,MethodOrOpDef,Parm,Formal,Exception,Restriction,
    TypeSpec,BasicTypeSpec,ComplexTypeSpec,ActualParm,ParmOp,Stmt,DeclStmt,
    InitVarExpr,InitVarInvoke,AssignInvoke,AssignExprStmt,AssignExpr,
    InvokeStmt,WhileStmt,IfStmt,Tagcase,Typecase,ReturnStmt,Yield,SignalStmt,Exit,
    BlockStmt,ResignalStmt,ExceptStmt,IdOrIvar,Body,ElseIf,TagWhenArm,ExWhenArm,
    OthersHandler,FieldInit,Expr,Binary,Unary,Literal,Instantiation,
    DotExpr,SuperId,ArrayRef,BracketRef,BraceRef,InvocExpr,BindingExpr,
    SelectorConstr,ArrayConstr,Invoc,RoutineId,SimpleRoutineId,
    ComplexRoutineId,Binding,BindingArg,Field,Id,
    Signature, TypeWhenArm, Inherit, RoutineSpecModule, SuperInfo, 
    IntLiteral, CharLiteral, StringLiteral, RealLiteral, IdExpr,
    TypeExtModule, Id,
    Dummy)

// The "Node" macro is used to automatically create a class for a 
// parse tree node with tags, a constructor, and fields.
//
// See parseMacros.h for details of what node expands to.

// ParseNode is the superclass of all Parse node classes.  If the superclass
// argument in `NODE' is left blank, ParseNode will be used.


#define DEBUG_FLAG  0
// If debug_flag is nonzero, each object prints itself out after being created

class ParseNode {
  public:
    enum Tag { SignatureT, ImplEltT, InheritT, RenamingT, ExportT,
		   MethodOrOpDefT, ParmT, FormalT, ExceptionT,
		   RestrictionT, TypeSpecT, TypeNameT, ActualParmT,
		   ParmOpT, IdOrIvarT, BodyT, ElseIfT, TagWhenArmT,
		   ExWhenArmT, OthersHandlerT, FieldInitT, InvocT,
		   RoutineIdT, SuperInfoT, BindingT, BindingArgT,
		   FieldT, IdT, ModuleT, SpecEltT, RoutineIntfT, StmtT, ExprT,
		   EquateT, DeclT, TypeWhenArmT, TypeObjectT, ClassEltT};
    Tag tag_;
    TypeInterface *type_;
    int line;
    tag();
    TypeInterface *get_type();
    int get_line();

    ParseNode(Tag tag ) :  tag_(tag),  type_(new TypeInterface()),
		line(cmpyy_lineno) {} 

    ParseNode(int lineno, Tag tag) :  tag_(tag),  type_(new TypeInterface()),
		line(lineno) {} 

    virtual void print(int spaces)=0;
    virtual ParseNode* traverse(TraverseObj *tobj)=0;
    virtual ParseNode* propagate(TraverseObj *tobj)=0;
};

    ParseNode::tag() { return tag_; }
    TypeInterface *ParseNode::get_type() { return type_; }
    int ParseNode::get_line() { return line; }

typedef xlist<ParseNode*> ParseNodeList;


#define put_spaces(count) {int i=count; while (i--) putchar(' ');}
void print_parsenode_list(ParseNodeList *lp, int spaces)
{
    ParseNodeList l = *lp;	/* for readability */
    for (Pix p = l.first(); p; l.next(p)) {
	l(p)->print(spaces);
    }}


ParseNodeList* traverse_parsenode_list(ParseNodeList *lp, TraverseObj *tobj)
{
    ParseNodeList l = *lp;
    ParseNodeList *new_list = new ParseNodeList();
    
    for (Pix p = l.first(); p; l.next(p)) {
	ParseNode *new_node = l(p)->traverse(tobj);
	new_list->append(new_node);
    }

    return new_list;
}

ParseNodeList* propagate_parsenode_list(ParseNodeList *lp, TraverseObj *tobj)
{
    ParseNodeList l = *lp;
    
    for (Pix p = l.first(); p; l.next(p)) {
	l(p)->propagate(tobj);
    }

    return lp;
}

// ======================= Modules ==============================
NODE(Module, ParseNode, `SpecModuleT, ImplModuleT', );

NODE(SpecModule, Module, ,
     LIST(SpecElt), specs);

NODE(SpecElt, ParseNode, `TypeIntfT, RoutineSpecT, SpecEquateT' );

NODE(TypeIntf, SpecElt, ,
     Id*, id,
     LIST(Parm), parms, 
     LIST(SuperInfo), supers,	
     LIST(Restriction), wheres,
     LIST(RoutineIntf), methods);

NODE(RoutineIntf, ParseNode, `ProcHeaderT, IterHeaderT, MakeHeaderT',
     Id*, id,
     Signature*, signature);

NODE(Signature, ParseNode, `ProcSigT, IterSigT, MakeSigT',
     LIST(Parm), parms,
     LIST(Decl), args,
     LIST(TypeSpec), returns,
     LIST(Exception), signals,
     LIST(Restriction), where);

NODE(RoutineSpec, SpecElt, ,
     RoutineIntf*, routine);

NODE(SpecEquate, SpecElt, ,
     Equate *, equate);

NODE(Equate,ParseNode, `TypeEquateT, ExprEquateT' ,);

NODE(ExprEquate, Equate,,
     Id*, id,
     Expr*, expr);

NODE(TypeEquate, Equate,,
     Id*, id,
     TypeSpec*, typ);

NODE(ImplModule, Module, ,
     LIST(Id), exports,
     LIST(Equate), equates,
     LIST(ImplElt), impls);

NODE(ImplElt, ParseNode, `RoutineDefT, ClassDefT, ImplEquateT', );

NODE(RoutineDef, ImplElt,  ,
     RoutineIntf*, routineIntf,
     Body*, body);

NODE(ImplEquate, ImplElt, ,
     Equate *, equate);

NODE(ClassDef, ImplElt, ,
     Id*, classId,
     TypeSpec*, deftype,
     LIST(Parm), parms, 
     LIST(Restriction), wheres,
     Inherit*, inherits,
     Export*, exports,
     LIST(Id), hides,
     int, immutable,
     LIST(Equate), equates,
     LIST(Decl), decl,
     LIST(ClassElt), classElts);

NODE(ClassElt, ParseNode, `MethodOrOpDefT, EquateT' );

NODE(Inherit, ParseNode,,
     TypeSpec*, classSpec);

NODE(Renaming, ParseNode,, Expr*, from, Id*, to);

NODE(Export, ParseNode,,
     LIST(Id), exported);

NODE(MethodOrOpDef, ParseNode,,
     int, isOp,
     int, IsConstr,
     RoutineDef*,routineDef);

NODE(Parm, ParseNode,, LIST(Id), ids);

// unused
NODE(Formal, ParseNode,, Id*, id, TypeSpec*, typeSpec);

NODE(Exception, ParseNode,,
     Id*, id,
     LIST(TypeSpec), typeSpec);

NODE(Restriction, ParseNode,,
     Id*, TypeId,
     LIST(RoutineIntf), operations);

NODE(TypeSpec, ParseNode,`SimpleTypeSpecT, ParamTypeSpecT, TaggedTypeSpecT,
	RoutineTypeSpecT',);

NODE(TypeName, ParseNode,,
     Id*, name);
      
NODE(TypeObject, ParseNode,,
     TypeInterface*, leaf_type);

NODE(SimpleTypeSpec, TypeSpec,,
     TypeName*, name);

NODE(ParamTypeSpec, TypeSpec,,
     TypeName*, name,
     LIST(ActualParm), actualParms);

NODE(TaggedTypeSpec, TypeSpec,,
     TypeName*, name,
     LIST(Field), fields);

NODE(RoutineTypeSpec, TypeSpec,,
     Signature*, signature);

NODE(ActualParm, ParseNode,, 
     TypeSpec*, typeSpec,
     LIST(ParmOp), newNames);

NODE(ParmOp, ParseNode,, Expr*, primary, Id*, id);

// ======================= Statements ===========================

/* Stmt */


// DeclT doesn't belong in the following list
NODE(Stmt, ParseNode, `DeclStmtT, InitVarExprT, InitVarInvokeT, DeclT,
AssignInvokeT, AssignExprStmtT, AssignExprT, InvokeStmtT,
WhileStmtT, IfStmtT, TagcaseT, TypecaseT, ReturnStmtT,
YieldT, SignalStmtT, ExitT, BreakT, ContinueT, BlockStmtT,
ResignalStmtT, ExceptStmtT, InitT, DeclForStmtT, ForStmtT', );

NODE(DeclStmt, Stmt,,
     Decl*, decl);

NODE(Decl,ParseNode,`RegDeclT, ImplDeclT, VarArgsDeclT',);

NODE(RegDecl, Decl,,
     LIST(Id), ids,
     TypeSpec*, typeSpec);

NODE(VarArgsDecl, Decl,,
     Id*, id,
     TypeSpec*, typeSpec);

NODE(ImplDecl,Decl,,
     Id*, id,
     TypeSpec*, typeSpec,
     Id*, get,
     Id*, set);

NODE(InitVarExpr, Stmt,,
	Decl*, decl,
	Expr*, expr);

NODE(InitVarInvoke, Stmt,,
     LIST(Decl), decls,
     Invoc*, invoc);


// unused
NODE(AssignInvoke, Stmt,,
     LIST(IdOrIvar), idOrIvars,
     Invoc*, invoc);

NODE(AssignExprStmt, Stmt,,
     LIST(Expr), ids,
     LIST(Expr), exprs);


// unused
NODE(AssignExpr, Stmt,,
     Expr*, primary,
     Expr*, primaryExpr,
     Expr*, expr);

NODE(InvokeStmt, Stmt,, Invoc*, invoc);

NODE(WhileStmt, Stmt,, Expr*, expr,  Body*, body);

NODE(IfStmt, Stmt,,
     Expr*, expr,
     Body*, body,
     LIST(ElseIf), elseifs,
     Body*, elsebody);

NODE(DeclForStmt, Stmt,,
     LIST(Decl), decls,
     Invoc*, invoc,
     Body*, body);

NODE(ForStmt, Stmt,,
     LIST(Id), ids,
     Invoc*, invoc,
     Body*, body);

NODE(Tagcase, Stmt,,
     Expr*, expr,
     LIST(TagWhenArm), tagWhenArms,
     Body*, body);


NODE(Typecase, Stmt,,
     Expr*, expr,
     LIST(TypeWhenArm), typeWhenArms,
     Body*, body);

NODE(TypeWhenArm, ParseNode,,
     TypeSpec*, typ,
     Id*, id,
     Body*, body);

NODE(ReturnStmt, Stmt,,
     LIST(Expr), exprs);

NODE(Yield, Stmt,,
     LIST(Expr), exprs);

NODE(SignalStmt, Stmt,,
     Id*, id,
     LIST(Expr), exprs);

NODE(Exit, Stmt,,
     Id*, id,
     LIST(Expr), exprs);

NODE(BlockStmt, Stmt,,
     Body*, body);

NODE(ResignalStmt, Stmt,,
     Stmt*, stmt,
     LIST(Id), ids);

NODE(ExceptStmt, Stmt,,
     Stmt*, stmt,
     LIST(ExWhenArm), exWhenArm,
     Decl*, decl,
     Body*, body);

NODE(Init, Stmt,,
     LIST(FieldInit), fieldInits,
     Invoc*, invoc,
     Body*, body);

NODE(IdOrIvar, ParseNode,,
     Expr*, primary,		/* null if no primary */
     Id*, id);

NODE(Body, ParseNode,,
     LIST(Equate), equates,
     LIST(Stmt), statements);

NODE(ElseIf, ParseNode,,
     Expr*, expr,
     Body*, body);

NODE(TagWhenArm, ParseNode,,
     LIST(Id), ids,
     Decl*, decl,
     Body*, body);

NODE(ExWhenArm, ParseNode,,
     LIST(Id), names,
     LIST(Decl), decls,
     Body*, body);

// apparently unused
NODE(OthersHandler, ParseNode,,
     Id*, id,
     TypeSpec*, typeSpec,
     Body*, body);

NODE(FieldInit, ParseNode,, 
     Id*, id,
     Expr*, expr);


// ======================= Expressions ==========================
NODE(Expr, ParseNode, `NilT, LiteralT, InstantiationT,
      DotExprT, SuperIdT, SelfT, NewT, ArrayRefT, InvocExprT,
      BindingExprT, SelectorConstrT, ArrayConstrT, IdExprT, BinaryT,
      UnaryT, BracketRefT, BraceRefT',);

NODE(BracketRef, Expr,,
     Expr*, primary,
     LIST(Expr), exprs);

NODE(BraceRef, Expr,,
     Expr*, primary,
     LIST(Expr), exprs);

NODE(Binary, Expr, `PlusT, MinusT, TimesT, DividesT, ModuloT, PowerT, AndT,
OrT, LTT, LTET, GTT, GTET, EqualT, ConcatT, NLTT, NLTET, NGTET, NGTT,
NotEqualT, EqualEqualT, NotEqualEqualT', Expr*, op1, Expr*, op2);

NODE(Unary, Expr,`NotT, MinusT', Expr*, op);

NODE(Literal, Expr, `IntLiteralT, BoolLiteralT, CharLiteralT, 
	StringLiteralT, RealLiteralT',);

NODE(IntLiteral, Literal,,
     int, i);

NODE(BoolLiteral, Literal,,
     int, b);	/* Make proper boolean type! */

NODE(CharLiteral, Literal,,
     char, c);

NODE(RealLiteral, Literal,,
     double, r);

NODE(StringLiteral, Literal,,
     string, s);

NODE(Instantiation, Expr,,
     TypeSpec*, otypeSpec,
     Id*, id,
     LIST(ActualParm), actualParms);

NODE(DotExpr, Expr,,
     Expr*, primary,
     Id*, id);

NODE(SuperId, Expr,,
     Id*, id);

NODE(IdExpr, Expr,,
     Id*, id);

NODE(ArrayRef, Expr,,
     Expr*, primary,
     Expr*, expr);

NODE(InvocExpr, Expr,,
     Invoc*, invoc);

NODE(BindingExpr, Expr,,
     Binding*, binding);

NODE(SelectorConstr, Expr,,
     TypeSpec*, typeSpec,
     LIST(FieldInit), fields);

NODE(ArrayConstr, Expr,,
     TypeSpec*, typeSpec,
     Expr*, size,
     LIST(Expr), exprs);

NODE(Invoc, ParseNode,,
     RoutineId*, routineId,
     LIST(Expr), exprs,
     LIST(Expr), lastarg);

NODE(RoutineId, ParseNode, `SimpleRoutineIdT, ComplexRoutineIdT, SuperClassRoutineIdT',);

NODE(SimpleRoutineId, RoutineId,,
     Expr*, primary);

NODE(ComplexRoutineId, RoutineId,,
     Expr*, primary,
     LIST(ActualParm), parms);

NODE(SuperClassRoutineId, RoutineId,,
     Id*, id);

NODE(SuperInfo, ParseNode,,
     TypeSpec*, typespec,
     LIST(Renaming), renamings);

NODE(Binding, ParseNode,,
     Expr*, proc,
     LIST(BindingArg), args,
     LIST(Expr), lastarg);

NODE(BindingArg, ParseNode,,  Expr*, expr); /* if expr is null, indicates "*" */

NODE(Field, ParseNode,, LIST(Id*),ids, TypeSpec*, typeSpec);

NODE(Id, ParseNode,, string, id);

END_NODES

