#ifndef _COMPILER_PARSE_H
#define _COMPILER_PARSE_H

// A Compiler Parse Tree Format, based on the reference grammar in the
// draft Theta Reference Manual.  This file generates parse.h. See also
// parseCC.m4 for generating the corresponding .cc file.

#include "xlist.h"
#include "my_string.h"
#include "traverse.h"
#include "environment.h"
#include <stdio.h>
extern int cmpyy_lineno;
include(`parseMacrosH.m4')

// We first declare all of the node classes used in the parse tree

DECLARE_NODES(Module,SpecModule,RoutineSpec,ProcHeader,IterHeader,MakeHeader,EquateModule,
    Decl, Equate,TypeEquate,ConstEquate,ImplModule,Impl,RoutineDef,ClassDef,
    Renaming,Export,MethodOrOpDef,Parm,Formal,Exception,Restriction,
    TypeSpec,BasicTypeSpec,ComplexTypeSpec,ActualParm,ParmOp,Stmt,DeclStmt,
    InitVarExpr,InitVarInvoke,AssignInvoke,AssignExprStmt,AssignExpr,
    InvokeStmt,WhileStmt,IfStmt,Tagcase,Typecase,ReturnStmt,Yield,SignalStmt,Exit,
    BlockStmt,ResignalStmt,ExceptStmt,IdOrIvar,Body,ElseIf,TagWhenArm,ExWhenArm,
    OthersHandler,FieldInit,Expr,Binary,Unary,Literal,Instantiation,
    DotExpr,SuperId,ArrayRef,BracketRef,BraceRef,InvocExpr,BindingExpr,
    SelectorConstr,ArrayConstr,Invoc,RoutineId,SimpleRoutineId,
    ComplexRoutineId,Binding,BindingArg,Field,Id,
    Signature, TypeWhenArm, Inherit, RoutineSpecModule, SuperInfo, 
    IntLiteral, CharLiteral, StringLiteral, RealLiteral, IdExpr,
    TypeExtModule, Id,
    Dummy)

// The "Node" macro is used to automatically create a class for a 
// parse tree node with tags, a constructor, and fields.
//
// See parseMacrosH.m4 and parseMacrosCC.m4 for details of what node expands to.

// ParseNode is the superclass of all Parse node classes.  If the superclass
// argument in `NODE' is left blank, ParseNode will be used.


class ParseNode {
  public:
    enum Tag { SignatureT, ImplEltT, InheritT, RenamingT, ExportT,
		   MethodOrOpDefT, ParmT, FormalT, ExceptionT,
		   RestrictionT, TypeSpecT, TypeNameT, ActualParmT,
		   ParmOpT, IdOrIvarT, BodyT, ElseIfT, TagWhenArmT,
		   ExWhenArmT, OthersHandlerT, FieldInitT, InvocT,
		   RoutineIdT, SuperInfoT, BindingT, BindingArgT,
		   FieldT, IdT, ModuleT, SpecEltT, RoutineIntfT, StmtT, ExprT,
		   EquateT, DeclT, TypeWhenArmT, TypeObjectT, ClassEltT};
    Tag tag_;
    TypeInterface *type_;
    int line;
    tag();
    TypeInterface *get_type();
    int get_line();

    ParseNode(Tag tag );

    ParseNode(int lineno, Tag tag);

    virtual void print(int spaces)=0;
    virtual ParseNode* traverse(TraverseObj *tobj)=0;
    virtual ParseNode* propagate(TraverseObj *tobj)=0;
};

typedef xlist<ParseNode*> ParseNodeList;

ParseNodeList* propagate_parsenode_list(ParseNodeList *lp, TraverseObj *tobj);
ParseNodeList* traverse_parsenode_list(ParseNodeList *lp, TraverseObj *tobj);
void print_parsenode_list(ParseNodeList *lp, int spaces);

include(`parse.m4')

#endif /* _COMPILER_PARSE_H */

