// ========================= M4 stuff ===========================
//
// The `TAG' macro is used to add a tag to the class. The usage is
// `TAG(CLASS, `tag1, tag2, tag3 ...')'. The tag of an object of this
// class can be accessed using the "tag" method. The possible
// tag values are named "CLASS::tag1", "CLASS::tag2", etc.
// A constructor "CLASS(CLASS::Tag)" is also created. It initializes
// only the tag.

// This next bit looks like a comment, but m4 notices it just fine.
// It's commented to allow "grind" to do the right thing.
/* 
 define(`TAG', 
`public:			 
    enum Tag { `$2' };
    tag();
   private:		
    Tag tag_')
*/
    
// The "Node" macro is used to automatically _define a class for a 
// parse tree node with tags, a constructor, and fields.
//
// The usage is  "Node(CLASSNAME, SUPERCLASS, `tag1, tag2, ...',
//		       TYPE1, FIELDNAME1,
//		       TYPE2, FIELDNAME2,
//		       ...
// (The SUPERCLASS, tags, and fields arguments can be left blank to omit them.)
//
// This expands to:
//
//   class CLASSNAME : SUPERCLASS {
//     public:	
//      [enum Tag {CLASS::tag1, ...};]   // here if tags are not empty
//	[tag();]
//	
//      TYPE1 get_FIELDNAME1() {...}  	   		// get method
//      void set_FIELDNAME1(TYPE1 val) {...}		// set method
//      ...<the same thing for all of the other fields>...
//
//      CLASSNAME([Tag tag], TYPE1 FIELDNAME1, ...) :             // constructor
//	  [SUPERCLASS(SUPERCLASS::CLASSNAMET) ,]
//        [_tag(tag),]
//	  FIELDNAME1_(FIELDNAME1)
//	  ... {if (DEBUG_FLAG) print()};
//
//      CLASSNAME(const CLASSNAME& o) : ...:  		          // copy constr.
//
//     private:
//	 Tag tag_;
//	 TYPE1 FIELDNAME1_;
//       ...;
//   };

// Pardon the grunge below... Nicely formatted m4 output requires weird m4
// macro formatting.

define(`NODE',
`class $1 ifelse(`$2', `', `: public ParseNode' ,`: public `$2'') {
   ifelse(`$3', `',,`TAG(`$1',`$3');')
   ifelse(`$4', `',,
` private:
 VARS(shift(shift(shift($@))))')
    public:
      virtual void print(int spaces);
      virtual ParseNode* traverse(TraverseObj*);
      virtual ParseNode* propagate(TraverseObj*);
ifelse(`$4', `', , `ACCESSORS(shift(shift(shift($@))))')
// Normal Constructor
    $1(ifelse(`$3', `',,`Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@)))));

// Line-Number Preserving Constructor
    $1(int lineno ifelse(`$3',`', `ifelse(`$4',`',,`,')',`,') ifelse(`$3', `',,` Tag tag ifelse(`$4', `',,`,')')CONSTARGS(shift(shift(shift($@)))));

// Copy Constructor
    $1(const $1& o);
   
// Line Preserving Copy Constructor
    $1(int lineno, const $1& o);
   
}')

// VARS: declare instance variables for each (type,name) pair
 define(`VARS', `ifelse($#, 0,, $#, 1,,
`     $1 $2_; 
 VARS(shift(shift($@)))')')

// ACCESSORS: declare get and set methods for each (type,name) pair       
 define(`ACCESSORS', `ifelse(`$#', 0,, `$#', 1,,
`      $1 get_$2();
      void set_$2($1 val);
ACCESSORS(shift(shift($@)))')')


define(CONSTR_NEW_NODE, `ifelse($#, 0,, $#, 1,,
`new_$2 ifelse($#, 2, ,``,'') CONSTR_NEW_NODE(shift(shift($@)))')')

    
// CONSTARGS: declare  constructor arguments for each (type,name) pair	      
define(`CONSTARGS', `ifelse($#, 0, , $#, 1, , 
`$1 $2 ifelse($#, 2, ,``,'') 
		CONSTARGS(shift(shift($@)))')')

// CONSTBODY: the body of the constructor
define(`CONSTBODY', `ifelse($#, 0, , $#, 1, ,`$2_($2)ifelse($#, 2, ,``,'') CONSTBODY(shift(shift($@)))')')

// CONSTBODY: the body of the copy constructor
define(`CONSTBODY2', `ifelse($#, 0, , $#, 1, ,`$2_(o.$2_)ifelse($#, 2, ,``,'') CONSTBODY2(shift(shift($@)))')')
    
define(`DECLARE_NODES', `ifelse($#,0,, $#,1,, 
`     class $1; 
 DECLARE_NODES(shift($@))')')

define(`LIST', `ParseNodeList*')

// The end of the file must have END_NODES so that the print methods can be generated.    
define(END_NODES, `undivert(1)')

