{id}            { yylval.s = string_new(slower(text));
		  return ID; }
{decint}        { yylval.i = atoi(text);
		  return INT; }
{real}          { yylval.r = (real)atof(text); return REAL; }
{unreal}        { yylval.r = (real)atof(text); return REAL; }
{uptohexnum}	{ return(lexhex(text)); }
{string}	{ return(lexstr(text)); }
{charac}	{ return(lexchar(text+1)); }
.		{ return LexErr; }

%%

int is_octal(char c)
{
    return (c>='0' && c<='7')?TRUE:FALSE;
}

char *slower(char *s)
{
char *c;
	for (c = s; *c; c++) {
		/* _tolower appears to be broken on osf 1.2 7/15/94 dwc */
		*c = tolower(*c);
		}
	return s;
	}

/* 1/27/95 dcurtis; added mapping for \b, \v; removed \f mapping;
		    added \p (to \f) mapping;
		    fixed 3 digit octal computation
*/

char dochar(char *s, int *size, int *err)
{
    *size = 1;
    *err = 0;
    if (!s[0]) {
	*err = 1;
	return '?';
	}
    if (s[0] != '\\') {
	return s[0];
	}
    else {
	*size = 2;
	switch (s[1]) {
		case 0: {
			*err = 1;
			return '?';
			}
		case 'n': return '\n';
		case 'r': return '\r';
		case 'f': return '\f';
		case 't': return '\t';
		case 'v': return '\v';
		case 'b': return '\b';
		case '"': return '\"';
		case '\'': return '\'';
		case '\\': return '\\';
		case '0': case '1': case '2': case '3':
		case '4': case '5': case '6': case '7': {
		    *size = 4;
		    if (is_octal(s[2]) & is_octal(s[3])) {
			int temp = (64 * (s[1] - '0') +
				       8 * (s[2] - '0') +
					   (s[3] - '0')) & 0xff;
			return temp;
			}
		    else {
			*err = 1;
			return '?';
			}
		    }
			
		default: {
			*err = 1;
			return '?';
			}
	}
    }
}

int lexchar(char *s)
{
    int temp;
    int err;
    yylval.c = dochar(s, &temp, &err);
    if (err) {
	yyerror("Illegal character");
	return LexErr;
	}
    return CHAR;
}

char lexedstr[MAX_STRING];
int lexstr(char *s)
{
    char *cp = lexedstr;
    int err;
    s++;
    for (;;) {
	char c = *s;
	int skip, cc;
	if (c == '"') { 
    		int len = cp-lexedstr;
		*cp = 0; 
		yylval.s = string_newn(lexedstr, len); 
		return STRING;
		}
	cc = dochar(s, &skip, &err);
	if (err) {
		yyerror("Illegal character in string)");
		return LexErr;
		}
	*cp++ = (char)cc;
	s += skip;
    }
}

int lexhex(char *num)
{
  char *val, *base, *check;
  int res, b;

  val = base = num;
  while (*val != '_') val++;
  *val = 0; val++;
  if (DEBUG_FLAG)
	fprintf(stderr,"Base = %s, Value = %s\n", base, val);
  b = atoi(base);
  if ((b > 16) || (b < 2))
	{yyerror("Illegal integer literal (unrecognized base value)");
	 return LexErr;}
  if (((res = strtol(val, &check, b)) == 0) && (val != "0"))
	{yyerror("Illegal integer literal");
	 return LexErr;}
  if (*check != 0)
	{yyerror("Illegal integer literal");
	 return LexErr;}
  yylval.i = res;
  return INT;
}

void yydocomment()
{
   char c;
   while (1) {
      c = yyinput();
      if (c == '\n' || c == 0) {
#ifdef FLEX_SCANNER
        yylineno++;
#endif
	return;
      }
   }
}

extern void cmp_err(char *msg, int lineno);

void yyerror(char *msg)
{
    /* fprintf(stderr, "line %d: %s\n", yylineno, msg); */
    cmp_err(msg, yylineno);
}

#ifndef yywrap

/* Keep new flex happy */
int yywrap() {
    return 1;
}

#endif
