
# line 3 "./theta.y"
#include <malloc.h>
#include "parse.h"
#include "compiler.h"
#include "string.h"
    
extern void save_where_id(Id *i);
extern Id *get_where_id();
extern void tsl2dl_init();
extern ParseNodeList* tsl2dl(ParseNodeList* pnl);
extern TypeSpec *ex2ts(Expr *ex);
extern Invoc *ex2inv(Expr *ex);
extern Id *exl2id(ParseNodeList *pnl);
extern ParseNodeList* exl2idl(ParseNodeList *pnl);
extern ParseNodeList* exl2lhs(ParseNodeList *pnl);
extern ParseNodeList* exl2apl(ParseNodeList *pnl);
extern ParseNodeList* pl2apl(ParseNodeList *pnl);
extern ParseNodeList* apl2pl(ParseNodeList *pnl);
extern ParseNodeList *apl2exl(ParseNodeList *apl);
extern Id *ex2id(Expr *ex);
extern Id *pts_get_name(TypeSpec *pts);
extern ParseNodeList *pts_get_aparms(TypeSpec *pts);
extern TypeWhenArm *ex2twa(Expr *ex, Body *b);
extern RoutineId *ex2rid(Expr *ex);
extern Expr *ts2ex(TypeSpec *ts);
ParseNodeList *parse_tree;
string err_list;
extern "C" {
extern string int_unparse(int i);
}

# line 49 "./theta.y"
typedef union  {
#ifdef  _COMPILER_PARSE_H
     Module* module; 
     ParseNodeList* moduleList; 
     SpecElt* specElt;
     ParseNodeList* specEltList;
     RoutineSpec* routineSpec; 
     RoutineIntf* routineIntf;
     ParseNodeList* routineIntfList; 
     ProcHeader* procHeader; 
     ParseNodeList* procHeaderList; 
     IterHeader* iterHeader; 
     ParseNodeList* iterHeaderList; 
     SuperInfo* superInfo;
     ParseNodeList* superInfoList;
     Decl* decl; 
     ParseNodeList* declList; 
     Equate* equate; 
     ParseNodeList* equateList; 
     TypeEquate* typeEquate; 
     ParseNodeList* typeEquateList; 
     ConstEquate* constEquate; 
     ParseNodeList* constEquateList; 
     ImplModule* implModule; 
     ImplElt* implElt; 
     ParseNodeList* implEltList; 
     RoutineDef* routineDef; 
     ParseNodeList* routineDefList; 
     ClassDef* classDef; 
     ParseNodeList* classDefList;
     Inherit* inherit;
     Renaming* renaming; 
     ParseNodeList* renamingList; 
     Export* export; 
     ParseNodeList* exportList; 
     MethodOrOpDef* methodOrOpDef; 
     ParseNodeList* methodOrOpDefList; 
     Parm* parm; 
     ParseNodeList* parmList; 
     Exception* exception; 
     ParseNodeList* exceptionList; 
     Restriction* restriction; 
     ParseNodeList* restrictionList; 
     TypeSpec* typeSpec; 
     ParamTypeSpec *paramTypeSpec;
     ParseNodeList* typeSpecList; 
     TypeName* typeName;
     ActualParm* actualParm; 
     ParseNodeList* actualParmList; 
     Stmt* stmt; 
     ParseNodeList* stmtList; 
     DeclStmt* declStmt; 
     ParseNodeList* declStmtList; 
     InitVarExpr* initVarExpr; 
     ParseNodeList* initVarExprList; 
     InitVarInvoke* initVarInvoke; 
     ParseNodeList* initVarInvokeList; 
     AssignInvoke* assignInvoke; 
     ParseNodeList* assignInvokeList; 
     AssignExprStmt* assignExprStmt; 
     ParseNodeList* assignExprStmtList; 
     AssignExpr* assignExpr; 
     ParseNodeList* assignExprList; 
     InvokeStmt* invokeStmt; 
     ParseNodeList* invokeStmtList; 
     WhileStmt* while_; 
     ParseNodeList* whileList; 
     IfStmt* ifStmt; 
     ParseNodeList* ifList; 
     Tagcase* tagcase; 
     ParseNodeList* tagcaseList; 
     Typecase* typecase; 
     ParseNodeList* typecaseList; 
     ReturnStmt* returnStmt; 
     ParseNodeList* returnList; 
     Yield* yield; 
     ParseNodeList* yieldList; 
     SignalStmt* signalStmt; 
     ParseNodeList* signalStmtList; 
     Exit* exit; 
     ParseNodeList* exitList; 
     BlockStmt* blockStmt; 
     ParseNodeList* blockStmtList; 
     ResignalStmt* resignalStmt; 
     ParseNodeList* resignalStmtList; 
     ExceptStmt* exceptStmt; 
     ParseNodeList* exceptStmtList; 
     IdOrIvar* idOrIvar; 
     ParseNodeList* idOrIvarList; 
     Body* body; 
     ParseNodeList* bodyList; 
     ElseIf* elseIf; 
     ParseNodeList* elseIfList; 
     TagWhenArm* tagWhenArm; 
     ParseNodeList* tagWhenArmList; 
     ParseNodeList* exWhenArmList; 
     ExWhenArm* exWhenArm; 
     ParseNodeList* whenArmList; 
     OthersHandler* othersHandler; 
     ParseNodeList* othersHandlerList; 
     Init* init;
     FieldInit* fieldInit; 
     ParseNodeList* fieldInitList; 
     Expr* expr;
     IdExpr* idExpr; 
     ParseNodeList* exprList; 
     Binary* binary; 
     Unary* unary; 
     Literal* literal; 
     IntLiteral* intLiteral;
     CharLiteral* charLiteral;
     StringLiteral* stringLiteral;
     DotExpr* dotExpr; 
     ArrayRef* arrayRef; 
     ParseNodeList* arrayRefList; 
     InvocExpr* invocExpr; 
     BindingExpr* bindingExpr; 
     SelectorConstr* selectorConstr; 
     ArrayConstr* arrayConstr; 
     Invoc* invoc; 
     RoutineId* routineId; 
     ParseNodeList* routineIdList; 
     SimpleRoutineId* simpleRoutineId; 
     ParseNodeList* simpleRoutineIdList; 
     ComplexRoutineId* complexRoutineId; 
     SuperClassRoutineId* superClassRoutineId;
     ParseNodeList* complexRoutineIdList; 
     Binding* binding; 
     ParseNodeList* bindingList; 
     BindingArg* bindingArg; 
     ParseNodeList* bindingArgList; 
     Field* field; 
     ParseNodeList* fieldList; 
     Id* id_; 
     ParseNodeList* idList; 
     Signature* signature; 
     ParseNodeList* signatureList; 
     TypeWhenArm* typeWhenArm; 
     ParseNodeList* typeWhenArmList; 
     ParseNodeList* parseNodeList;
#endif
  real r;
  string s;
  char c;
  int i;
} YYSTYPE;
# define MODULE 257
# define END 258
# define TYPE 259
# define CLASS 260
# define ID 261
# define EQ 262
# define INHERITS 263
# define HIDES 264
# define PROVIDES 265
# define LPAREN 266
# define RPAREN 267
# define LBRACK 268
# define RBRACK 269
# define LCURLY 270
# define RCURLY 271
# define YIELDS 272
# define RETURNS 273
# define SIGNALS 274
# define MAKES 275
# define COLON 276
# define SEMI 277
# define COMMA 278
# define WHERE 279
# define IMPLEMENTS 280
# define OP 281
# define FOR 282
# define HAS 283
# define DOTS 284
# define MAKE 285
# define BIND 286
# define ASSIGN 287
# define CARET 288
# define IF 289
# define THEN 290
# define ELSEIF 291
# define ELSE 292
# define WHILE 293
# define DO 294
# define IN 295
# define TAGCASE 296
# define OTHERS 297
# define TYPECASE 298
# define WHEN 299
# define BEGIN_ 300
# define RETURN 301
# define YIELD 302
# define SIGNAL 303
# define EXIT 304
# define BREAK 305
# define CONTINUE 306
# define RESIGNAL 307
# define EXCEPT 308
# define RECORD 309
# define STRUCT 310
# define ONEOF 311
# define VARIANT 312
# define SELF 313
# define NEWOBJECT 314
# define DOT 315
# define PROC 316
# define ITER 317
# define TILDE 318
# define MINUS 319
# define PLUS 320
# define STAR 321
# define EXP 322
# define MOD 323
# define DIV 324
# define CONCAT 325
# define LT 326
# define LE 327
# define GT 328
# define GE 329
# define NEQ 330
# define CAND 331
# define COR 332
# define NIL 333
# define TRUE_ 334
# define FALSE_ 335
# define CHAR 336
# define STRING 337
# define REAL 338
# define INT 339
# define LexErr 340
# define CONST_IVARS 341
# define DUMMY 342
# define UMINUS 343
#define cmpyy_clearin cmpyy_char = -1
#define cmpyy_errok cmpyy_errflag = 0
extern int cmpyy_char;
extern int cmpyy_errflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE cmpyy_lval, cmpyy_val;
typedef int cmpyy_tabelem;
# define YYERRCODE 256

# line 1571 "./theta.y"


void cmpyy_init()
{
	tsl2dl_init();
	}

Id *where_saved_id = 0;

void save_where_id(Id *i)
{
	/* printf("saving %X\n", i); */
	where_saved_id = i;
	}

Id *get_where_id()
{
	/* printf("returning %X\n", where_saved_id); */
	return where_saved_id;
	}

/* needs to handle Parmd types */
TypeSpec *ex2ts(Expr *ex)
{
	// printf("entering ex2ts\n");
	// if (ex) ex->print(3);
	switch (ex->tag()) {
	    case (Expr::IdExprT): {
		IdExpr *tempid = (IdExpr *)ex;
		return
		   new SimpleTypeSpec(
			 new TypeName(tempid->get_id()));
		}
	    case (Expr::BracketRefT): {
		/* insist that ex be a bracket ref...
		   primary s.b. idexpr
		   exprs s.b. idns or bracerefs
		*/
		BracketRef *br = (BracketRef *)ex;
		Expr *prim = br->get_primary();
		if (prim->tag() != Expr::IdExprT) break;
		IdExpr *tempid = (IdExpr *)prim;
		ParseNodeList *newl = new ParseNodeList();
		ParseNodeList *el = br->get_exprs();
		for (Pix p = el->first(); p ; el->next(p)) {
		   Expr *ex = (Expr *)(*el)(p);
		   switch (ex->tag()) {
			case Expr::IdExprT: {
				newl->append(new ActualParm(
					new SimpleTypeSpec(
						new TypeName(ex2id(ex))),
					new ParseNodeList()));
				continue;
				}
			case Expr::BracketRefT: {
				newl->append(new ActualParm(ex2ts(ex),
					new ParseNodeList()));
				continue;
				}
			case Expr::BraceRefT: {
				// needs work
				continue;
				}
			}
		   printf("bouncing due to:i\n");
		   ex->print(3);
		   break;
		   }
		return new ParamTypeSpec(
			 new TypeName(tempid->get_id()), newl);
		}
	} // end switch
	// NOTE: this error occurs normally
	// cmpyy_error("expected typespec\n");
	// if (ex) ex->print(3);
	return 0;
}

/* convert expression to routine id */
RoutineId *ex2rid(Expr *ex)
{
	if (!ex) {cmpyy_error("missing expr"); return 0;}
	switch (ex->tag()) {
		case (Expr::IdExprT): return new SimpleRoutineId(ex);
		case (Expr::DotExprT): return new SimpleRoutineId(ex);
		case (Expr::BindingT): return new SimpleRoutineId(ex);
		case (Expr::InvocExprT): return new SimpleRoutineId(ex);
		case (Expr::SuperIdT): {
			SuperId *sid = (SuperId *)ex;
			return new SuperClassRoutineId(sid->get_id());
			}
		case (Expr::BracketRefT): {
			BracketRef *br = (BracketRef *)ex;
			return new ComplexRoutineId(br->get_primary(),
					exl2apl(br->get_exprs()));
			}
		} // end switch
	cmpyy_error("expecting routine id");
	if (ex) ex->print(3);
	return 0;
	}

Id *ex2id(Expr *ex)
{
	if (ex->tag() != Expr::IdExprT) {
		cmpyy_error("expecting Id\n");
		if (ex) ex->print(3);
		return 0;
		}
	else {
		IdExpr *tempid = (IdExpr *)ex;
		return tempid->get_id();
		}
	}

Invoc *ex2inv(Expr *ex)
{
	if (ex->tag() != Expr::InvocExprT) {
		cmpyy_error("expecting Invoc\n");
		return 0;
		}
	else {
		InvocExpr *tempinv = (InvocExpr *)ex;
		return tempinv->get_invoc();
		}
	}

TypeWhenArm *ex2twa(Expr *ex, Body *b)
{
	// printf("entering ex2twa\n");
	// ex->print(3);
	if (ex->tag() != Expr::InvocExprT) {
		cmpyy_error("expecting typespec (id)\n");
		return 0;
		}
	else {
		InvocExpr *tempinv = (InvocExpr *)ex;
		RoutineId *rid = tempinv->get_invoc()-> get_routineId();
		TypeSpec *ts = 0;
		switch (rid->tag()) {
			case RoutineId::SimpleRoutineIdT: {
				SimpleRoutineId *srid = (SimpleRoutineId *)rid;
				ts = ex2ts(srid->get_primary());
				break;
				}
			case RoutineId::ComplexRoutineIdT: {
				ComplexRoutineId *crid = (ComplexRoutineId *)rid;
				Expr *prim = crid->get_primary();
				ParseNodeList *apl = crid->get_parms();
				ParseNodeList *exl = apl2exl(apl);
				ts = ex2ts(new BracketRef(prim,exl));
				break;
				}
			case RoutineId::SuperClassRoutineIdT: {
				cmpyy_error("expecting typespec (id)\n");
				return 0;
				}
			}
		if (!ts) {cmpyy_error("expecting typespec (id)\n"); return 0;}
		ParseNodeList *exl = tempinv->get_invoc()->get_exprs();
		Pix p = exl->first();
		Id *tempid = ex2id((Expr*)(*exl)(p));
		if (!tempid) {cmpyy_error("expecting typespec (id)\n"); return 0;}
		return new TypeWhenArm(ts, tempid, b);
		}
	}

Id *exl2id(ParseNodeList *pnl)
{
	int size = pnl->length();
	if (size != 1) {
		cmpyy_error("Expecting single identifier\n");
		return 0;
		}
	Pix p = pnl->first();
	return ex2id((Expr*)(*pnl)(p));
	}

/* convert primary list to idn list (for statement decls) (no ivars) */
ParseNodeList* exl2idl(ParseNodeList *pnl)
{
	if (!pnl) {cmpyy_error("missing id list"); return 0;}
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Expr *ex = (Expr *) (*pnl)(p);
		switch (ex->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)ex;
				nl->append(ide->get_id());
				break;
				}
			default: {
				cmpyy_error("exl2idl: expecting id");
				if (ex) ex->print(3);
				return 0;
				}
			}
		}
	return nl;
	}

/* convert primaries (expr list) to lhs (legal left hand side)
	 (for assignment statements) */

ParseNodeList* exl2lhs(ParseNodeList *pnl)
{
	if (!pnl) {cmpyy_error("missing id list"); return 0;}
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		Expr *ex = (Expr *) (*pnl)(p);
		switch (ex->tag()) {
			case Expr::IdExprT: {
				IdExpr *ide = (IdExpr *)ex;
				nl->append(ide);
				break;
				}
			case Expr::DotExprT: {
				nl->append(ex);
				break;
				}
			case Expr::BracketRefT: {
				nl->append(ex);
				break;
				}
			default: {
				cmpyy_error("exl2lhs: expecting id or dotexpr");
				if (ex) ex->print(3);
				return 0;
				}
			}
		}
	return nl;
	}

static int dummy_count = 0;
static string dummy_name = 0;

void tsl2dl_init()
{
	if (dummy_count == 0) dummy_name = string_new("dummy_");
	dummy_count = 0;
	}

ParseNodeList* tsl2dl(ParseNodeList* pnl)
{
	ParseNodeList *nl = new ParseNodeList();
	for (Pix p = pnl->first(); p ; pnl->next(p)) {
		TypeSpec *ts = (TypeSpec *)(*pnl)(p);
		nl->append(new RegDecl(
				new ParseNodeList(new Id(
					string_concat(dummy_name,
					int_unparse(dummy_count)))), 
				ts));
		dummy_count++;
		}
	return nl;
	}

ParseNodeList* pl2apl(ParseNodeList* pl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!pl) return NULL;
	for (Pix p = pl->first() ; p ; pl->next(p)) {
		Parm *pm = (Parm *)(*pl)(p);
		ParseNodeList *l = pm->get_ids();
		for (Pix p2 = l->first(); p2; l->next(p2)) {
			Id *id = (Id *)(*l)(p2);
			newl->append(new ActualParm(new SimpleTypeSpec
				(new TypeName(id)), 0));
		}
	}
	return newl;
}

ParseNodeList* apl2pl(ParseNodeList* pl)
{

	if (!pl) return NULL;

	ParseNodeList *newl = new ParseNodeList();

	for (Pix p = pl->first() ; p ; pl->next(p)) {
		ActualParm *ap = (ActualParm *)(*pl)(p);
		ap->print(1);
		TypeSpec *ts = ap->get_typeSpec();
		switch (ts->tag()) {
			case TypeSpec::SimpleTypeSpecT: {
				SimpleTypeSpec *sts = (SimpleTypeSpec*)ts;
				Id *id = sts->get_name()->get_name();
				newl->append(new Parm(new ParseNodeList(id)));
				break;
				}
			default: {
				cmpyy_error("apl2pl: expecting simple typespec/id");
				}
			}
	}
	return newl;
}


ParseNodeList *exl2apl(ParseNodeList* exl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!exl) return NULL;
	for (Pix p = exl->first() ; p ; exl->next(p)) {
		Expr *ex = (Expr *)(*exl)(p);
		TypeSpec *ts = ex2ts(ex);
		newl->append(new ActualParm(ts, 0));
		}
	return newl;
}

Id *pts_get_name(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			return pts->get_name()->get_name();
			break;
			}
		default: {
			cmpyy_error("pts_get_name: expecting paramtypespec");
			}
		}
	}

ParseNodeList *pts_get_aparms(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			return pts->get_actualParms();
			break;
			}
		default: {
			cmpyy_error("pts_get_name: expecting paramtypespec");
			}
		}
	}

ParseNodeList *apl2exl(ParseNodeList *apl)
{
ParseNodeList *newl = new ParseNodeList();

	if (!apl) return NULL;
	for (Pix p = apl->first(); p ; apl->next(p)) {
		ActualParm *ap = (ActualParm *)(*apl)(p);
		newl->append(ts2ex(ap->get_typeSpec()));
		}
	return newl;
	}

Expr *ts2ex(TypeSpec *ts)
{
	switch (ts->tag()) {
		case TypeSpec::ParamTypeSpecT: {
			ParamTypeSpec *pts = (ParamTypeSpec *)ts;
			Id *id = pts->get_name()->get_name();
			ParseNodeList *aparms = pts->get_actualParms();
			return new BracketRef(new IdExpr(id),
					apl2exl(aparms));
			break;
			}
		case TypeSpec::SimpleTypeSpecT: {
			SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
			Id *id = sts->get_name()->get_name();
			return new IdExpr(id);
			break;
			}
		default: {
			cmpyy_error("pts_get_name: expecting simple or param typespec");
			}
		}
	}
static cmpyy_tabelem cmpyy_exca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 75,
	278, 113,
	287, 113,
	-2, 88,
-1, 78,
	276, 260,
	278, 260,
	287, 260,
	-2, 91,
-1, 486,
	294, 136,
	-2, 239,
	};
# define YYNPROD 312
# define YYLAST 1806
static cmpyy_tabelem cmpyy_act[]={

    38,   193,    11,   520,   526,    42,    69,    21,   522,   427,
   548,    19,   525,   514,   477,   361,   500,    21,   494,   370,
   407,    19,   294,    73,    73,   206,    67,   357,   146,   287,
   107,    96,    64,    21,   208,   297,   221,    19,    30,   394,
   123,    22,   108,    10,    26,    71,   389,     9,   183,   265,
   388,   400,    18,   104,   162,   109,   163,   321,   162,   358,
   163,    97,    63,   120,   214,   119,   233,   220,   137,   138,
    73,    35,    96,   411,   121,   351,   409,   244,    18,   245,
   408,    78,   147,   347,   247,   152,   153,   312,   162,   328,
   163,   127,   260,    73,   472,   323,   243,    33,   578,   140,
   453,   246,    97,   161,   512,   359,   524,   161,   139,   511,
   164,   195,   118,    33,   350,   134,   259,    21,   145,   122,
   544,    19,   346,   216,   256,   218,   147,   160,   327,   184,
   188,   373,   226,   228,   454,    14,   312,   161,   147,   142,
   365,   117,    96,   167,   164,   165,   166,   189,   239,   366,
   141,   498,   187,   124,    15,   585,   551,    77,   584,   262,
   190,   160,    63,   579,   528,   403,   156,    14,   472,   559,
   189,   117,    97,    32,   229,   402,   237,   245,   240,   244,
   142,   245,   117,   190,   499,   249,   250,   527,   267,   115,
   308,   290,   291,   107,   212,   373,   309,   310,   268,   202,
   482,   433,   296,   296,   215,   401,   302,   412,   583,   245,
   184,   247,   434,   386,   188,   374,   372,   245,   331,   162,
   298,   163,    33,   364,   387,   320,   373,   373,   344,   314,
   313,   316,   331,   245,   147,    14,   301,   310,   315,   331,
   303,   515,    73,    73,   307,   200,   339,   117,   147,   304,
   338,   191,   117,   331,   429,   306,   199,   147,   160,   417,
   192,    73,   508,   326,   481,   355,   362,   461,   161,   418,
   330,   449,   170,   169,   167,   164,   165,   166,   168,   419,
   337,    33,   415,   124,   342,   413,   194,   345,   110,   420,
   111,   110,   111,   349,   371,   354,    14,   441,   236,   111,
   110,   136,   131,   535,   311,    31,   124,    29,   136,   122,
   136,   218,    31,   124,    29,   122,   147,    81,   122,   185,
    91,    50,   384,    39,    80,    31,    66,    29,    79,    29,
    31,    89,    29,    90,   125,    92,    82,    83,    84,    85,
    86,    87,   534,   492,    57,    58,    59,    60,    40,    41,
   367,   368,   385,   491,    31,    25,   185,   115,   425,    31,
   428,    29,   486,   476,   444,   399,   363,   343,    36,    53,
    54,    52,    56,    55,    51,   380,   305,   198,   375,   438,
   393,   379,   397,   382,   498,   436,   401,   293,    31,   252,
   227,   215,   197,   196,   151,   150,   432,   126,   478,   424,
   501,   414,   450,    73,   147,   395,    14,   225,   509,   439,
    73,   430,    73,   440,    73,   504,    73,    73,   464,    73,
   466,    73,   446,   425,   470,   445,   468,   455,   471,    14,
   362,   490,   452,    68,   443,   371,   458,   448,   442,   431,
   342,   423,   296,   201,    14,   473,    14,   488,    61,     6,
    73,    14,    30,    14,   474,    73,   487,    93,    26,   475,
   485,   421,    73,   404,   469,   261,   158,   132,   258,   493,
   210,   148,   255,   159,   232,    75,   479,   114,   130,   147,
   106,   334,    98,   211,   257,    73,    65,   507,   219,   318,
    27,    43,   207,    70,   503,    47,    95,    28,    34,    48,
   251,   529,   147,    74,   296,    34,    34,   521,    16,    73,
    45,    46,    73,    73,    34,   502,   540,   506,   542,   543,
   532,   518,   529,   529,   555,   541,   157,   539,   557,   558,
   545,    44,   556,   529,   553,   550,   560,    95,   531,   521,
   516,   116,   562,    37,   204,    17,   529,   555,   248,   555,
   143,   144,    34,   517,   555,    34,   563,   565,   550,   561,
   154,   155,    62,   133,   555,   573,   555,   134,   552,   552,
   179,   180,   181,   149,   230,    34,   135,   231,   580,   581,
   582,   574,    33,   254,   586,   587,   588,   405,   406,   203,
   205,   552,   552,   182,   569,   572,    88,   222,    72,   569,
    34,   186,   224,    33,    33,    34,   223,    95,   217,   569,
   234,   569,   286,   238,    33,    49,   235,   435,   322,   513,
   426,   369,   105,    34,   263,   264,   360,    33,   547,   549,
   554,    20,   266,   497,   112,   269,   270,   271,   272,   273,
   274,   275,   276,   277,   278,   279,   280,   281,   282,   283,
    76,   113,   564,   566,   253,   567,   288,   523,   530,   422,
   570,   496,    62,   495,    24,    23,    13,   295,   295,    12,
   575,   300,   576,   292,   285,   332,   333,   299,   546,   530,
   530,     7,    34,     8,     5,   289,     1,     4,     3,   523,
   530,     2,     0,     0,   356,   128,    14,     0,   325,   324,
     0,    99,     0,   530,     0,   568,   329,     0,     0,     0,
   568,     0,     0,     0,   335,   336,     0,   335,     0,   341,
   568,    50,   568,    39,    34,    34,   352,   348,   340,     0,
   353,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,    34,    57,    58,    59,    60,    40,    41,
     0,   102,   103,   100,   101,    14,     0,     0,     0,     0,
    99,   519,     0,     0,     0,     0,     0,     0,    36,    53,
    54,    52,    56,    55,    51,   376,   129,   377,     0,     0,
    50,     0,    39,   381,     0,     0,     0,   383,     0,     0,
   392,     0,    34,     0,   396,     0,     0,     0,     0,     0,
     0,     0,   377,    57,    58,    59,    60,    40,    41,     0,
   102,   103,   100,   101,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    36,    53,    54,
    52,    56,    55,    51,     0,     0,   451,   288,     0,     0,
     0,     0,     0,   457,   437,   459,     0,   460,     0,   462,
   463,     0,   465,     0,   467,     0,     0,     0,   392,     0,
     0,     0,     0,     0,     0,     0,   447,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   456,
     0,     0,     0,   480,     0,    34,     0,     0,   483,     0,
     0,     0,    34,     0,    34,   489,    34,     0,    34,    34,
     0,    34,     0,    34,     0,     0,     0,   295,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   510,     0,
     0,     0,    94,     0,    14,     0,     0,     0,     0,    99,
     0,     0,    34,     0,     0,     0,     0,    34,     0,     0,
     0,     0,   536,     0,    34,   537,   538,     0,     0,    50,
     0,    39,   505,     0,     0,     0,     0,     0,     0,     0,
     0,    14,     0,     0,     0,     0,    99,    34,     0,   295,
     0,     0,    57,    58,    59,    60,    40,    41,     0,   102,
   103,   100,   101,    34,     0,     0,    50,     0,    39,     0,
     0,    34,     0,     0,    34,    34,    36,    53,    54,    52,
    56,    55,    51,     0,    34,    34,     0,     0,     0,    57,
    58,    59,    60,    40,    41,    34,   102,   103,   100,   101,
    14,     0,     0,     0,     0,    99,     0,     0,    34,     0,
   571,     0,     0,    36,    53,    54,    52,    56,    55,    51,
     0,     0,     0,   390,     0,    50,     0,    39,     0,     0,
     0,     0,     0,     0,     0,     0,    14,     0,     0,     0,
     0,    99,     0,     0,     0,     0,     0,     0,    57,    58,
    59,    60,    40,    41,     0,     0,     0,   100,   101,   209,
   391,    50,     0,    39,     0,     0,     0,     0,     0,     0,
     0,     0,    36,    53,    54,    52,    56,    55,    51,     0,
     0,     0,     0,     0,    57,    58,    59,    60,    40,    41,
     0,     0,    14,   100,   101,     0,     0,    99,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,    36,    53,
    54,    52,    56,    55,    51,   378,     0,    50,     0,    39,
     0,     0,     0,     0,     0,     0,    14,     0,     0,     0,
     0,    99,     0,     0,     0,     0,     0,     0,     0,     0,
    57,    58,    59,    60,    40,    41,     0,     0,     0,   100,
   101,    50,     0,    39,     0,     0,     0,   528,     0,     0,
    14,     0,     0,     0,    36,    53,    54,    52,    56,    55,
    51,     0,     0,     0,    57,    58,    59,    60,    40,    41,
   527,     0,     0,   100,   101,    50,     0,    39,     0,     0,
     0,     0,     0,     0,     0,    14,     0,     0,    36,    53,
    54,    52,    56,    55,    51,   213,     0,     0,    57,    58,
    59,    60,    40,    41,     0,     0,     0,     0,     0,     0,
    50,     0,    39,     0,     0,     0,    14,     0,     0,     0,
     0,     0,    36,    53,    54,    52,    56,    55,    51,     0,
     0,     0,     0,    57,    58,    59,    60,    40,    41,     0,
     0,    50,     0,    39,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    36,    53,    54,
    52,    56,    55,    51,    57,    58,    59,    60,    40,    41,
   173,     0,     0,     0,   162,   317,   163,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   319,     0,    36,    53,
    54,    52,    56,    55,    51,   173,     0,     0,     0,   162,
     0,   163,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   577,   173,     0,     0,     0,   162,   533,
   163,     0,     0,   161,     0,     0,     0,   170,   169,   167,
   164,   165,   166,   168,   171,   172,   176,   175,   174,   177,
   178,   173,     0,     0,     0,   162,     0,   163,   161,     0,
     0,     0,   170,   169,   167,   164,   165,   166,   168,   171,
   172,   176,   175,   174,   177,   178,     0,   161,     0,   484,
     0,   170,   169,   167,   164,   165,   166,   168,   171,   172,
   176,   175,   174,   177,   178,   173,     0,     0,     0,   162,
   398,   163,     0,     0,   161,     0,     0,     0,   170,   169,
   167,   164,   165,   166,   168,   171,   172,   176,   175,   174,
   177,   178,   173,     0,     0,     0,   162,     0,   163,     0,
     0,     0,     0,     0,     0,     0,   416,     0,     0,     0,
   173,     0,     0,     0,   162,   284,   163,     0,   161,     0,
     0,     0,   170,   169,   167,   164,   165,   166,   168,   171,
   172,   176,   175,   174,   177,   178,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   161,     0,     0,     0,   170,
   169,   167,   164,   165,   166,   168,   171,   172,   176,   175,
   174,   177,   178,   161,     0,     0,     0,   170,   169,   167,
   164,   165,   166,   168,   171,   172,   176,   175,   174,   177,
   178,   173,     0,     0,     0,   162,     0,   163,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,   173,
     0,     0,     0,   162,     0,   163,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,   259,     0,
     0,     0,     0,     0,     0,   173,     0,     0,     0,   162,
     0,   163,     0,     0,   161,     0,   256,     0,   170,   169,
   167,   164,   165,   166,   168,   171,   172,   176,   175,   174,
   177,   178,   161,   242,     0,     0,   170,   169,   167,   164,
   165,   166,   168,   171,   172,   176,   175,   174,   177,   178,
   173,     0,     0,     0,   162,     0,   163,     0,   161,     0,
     0,     0,   170,   169,   167,   164,   165,   166,   168,   171,
   172,   176,   175,   174,   177,   178,     0,   173,     0,     0,
     0,   162,   241,   163,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   173,     0,     0,     0,   410,
     0,   163,     0,   161,     0,     0,     0,   170,   169,   167,
   164,   165,   166,   168,   171,   172,   176,   175,   174,   177,
   178,   173,     0,     0,     0,   162,     0,   163,     0,     0,
   161,     0,     0,     0,   170,   169,   167,   164,   165,   166,
   168,   171,   172,   176,   175,   174,   177,   178,   161,   173,
     0,     0,   170,   169,   167,   164,   165,   166,   168,   171,
   172,   176,   175,   174,   177,   178,     0,   173,     0,     0,
     0,   162,     0,   163,   161,     0,     0,     0,   170,   169,
   167,   164,   165,   166,   168,   171,   172,   176,   175,   174,
   177,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   170,   169,   167,   164,
   165,   166,   168,   171,   172,   176,   175,   174,   177,   178,
   161,     0,     0,     0,   170,   169,   167,   164,   165,   166,
   168,   171,   172,   176,   175,   174 };
static cmpyy_tabelem cmpyy_pact[]={

 -1000,   192, -1000, -1000, -1000, -1000,  -126, -1000, -1000, -1000,
 -1000,    93, -1000, -1000, -1000,   985,   190, -1000, -1000, -1000,
 -1000,    64,    35,    35, -1000,   663,   122, -1000, -1000,   145,
    18,   985,   -26,  -203, -1000, -1000, -1000, -1000,    45,   145,
 -1000, -1000,    43, -1000, -1000, -1000, -1000, -1000, -1000,    66,
   131, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
 -1000, -1000, -1000, -1000,   122, -1000,   435,    27,   209,    35,
 -1000, -1000,    35,    48,  -239, -1000,  -179,  -137,  -203,   885,
   885,   145,   129,   128,   145,   145, -1000, -1000, -1000,   885,
   885,    45,    35,   208,    61,  1385,    43, -1000, -1000,   885,
   885,   885,    88,    88,    18,   -18, -1000, -1000,    12,    12,
   127,   126,   110,   -22, -1000,   -31,   185,   985,   885,   885,
   795, -1000,   954, -1000,   145,   145,   885,    27,    61,   147,
    12,   124,   145, -1000, -1000,  -239,   700,   145,  -233,   885,
   985,   885,   700,  1358,  1313,  -199,  -194, -1000, -1000, -1000,
   885,   885,   123,   123,  1287,  1269,  -198,   207,   145,  -277,
 -1000,   885,   795,   885,   885,   885,   885,   885,   885,   885,
   885,   885,   885,   885,   885,   885,   885,   885,   885,  1198,
  -208,  -208, -1000,   122,    15,   885, -1000,   122,    20,    12,
    12, -1000,   145, -1000,   121, -1000,   700,   700, -1000,   985,
   700, -1000,  -203,  1457,   -29,  1385,   109, -1000,   -23,   885,
  1385,   -81,    33, -1000, -1000,  -203,  -151,   -41,  -200,   -40,
 -1000,   -45,  1038,    12,  -187,    61, -1000,   700, -1000,   -69,
  -169,  -233, -1000,   145,  1385, -1000,   -96,   -25,  1385,    43,
 -1000,    35,    35,   885,   700,   145,   885,   145,   100,   -25,
   -39, -1000,   885, -1000,  -175, -1000,   145,  -183, -1000,   700,
    35, -1000, -1000,  -174, -1000,   145, -1000,    99,   -46,  -208,
  -212,  -212,  -212,  -178,  -178,  -178,   -47,   -47,   -47,   -47,
   -47,   -47,  1475,  1429, -1000, -1000,  -129, -1000,  1385, -1000,
  -174,  -174, -1000,   145,   -51,  1385,    43, -1000,   -52, -1000,
  1385, -1000,    43,    45,   885, -1000,   851,   -25, -1000,   985,
   145, -1000,   885, -1000, -1000,   145,   700, -1000,   -54,   759,
  -174,   142, -1000,   885,  -187,  1153,    98,   120, -1000, -1000,
  -101,   885,   205,  -211,  -218,  1403,  1385, -1000,    43, -1000,
  -221, -1000,   -97, -1000, -1000,   -60,     9, -1000, -1000,   -61,
     6, -1000, -1000,  1180,    -7,    13,   203,   183, -1000,   145,
   -24, -1000,    51, -1000,    45, -1000,   885, -1000, -1000,   -66,
 -1000,   119, -1000,   700, -1000, -1000,  1385,  1385,   885,    26,
 -1000,  1385, -1000,  1385,    43, -1000, -1000,   759,    97, -1000,
   885, -1000,  1385, -1000,  -174,   885,  1385,   142, -1000, -1000,
    -5,   145,    35,   145, -1000,  -158,  -211, -1000,   885,    35,
   795,    35, -1000,    35,    -9,    35,    35,   145,    35,   145,
    35, -1000,   168,   145, -1000,    59, -1000,   145,  -189,   145,
 -1000, -1000, -1000, -1000,   145, -1000,   700,  1385,    43, -1000,
   -25, -1000,    96, -1000, -1000,   -25,   133,  1385,  -174,    35,
   -12, -1000,   -67, -1000,    35, -1000,  1109,   202,    95,   198,
   189,    35,   173, -1000,    86, -1000,    76, -1000,   145, -1000,
 -1000,   118, -1000, -1000, -1000,   -83, -1000,   136,   145,   133,
   157,   700,   -14,   150,    35, -1000, -1000, -1000, -1000, -1000,
 -1000,  -167,  -172, -1000,   -37, -1000, -1000,    18,   494, -1000,
   919,   145,   -69,   136, -1000,  1082,    75,    36,    35, -1000,
 -1000,    35,    35,   -37, -1000,   145,    12,    12,  -147, -1000,
 -1000,   919,   919,   -94, -1000, -1000, -1000,   145,   145,    39,
  -107,   -69,   919, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
  -115,   145, -1000, -1000, -1000,   919,   -94, -1000,   -94, -1000,
 -1000, -1000, -1000,   -94, -1000,    46, -1000,    59, -1000,   700,
 -1000, -1000,   118,   -94, -1000,   -94, -1000, -1000, -1000, -1000,
 -1000,  1063,  -182,  -117, -1000, -1000, -1000,   145,   145,   145,
   -70,  -120,  -123,   145,   145,   145, -1000, -1000, -1000 };
static cmpyy_tabelem cmpyy_pgo[]={

     0,   691,   688,   687,   686,   684,   683,   681,   669,   666,
    41,   665,   664,    18,   663,   661,   659,   471,   477,    51,
   475,    12,    28,   651,   650,    26,   634,     8,   633,    45,
     6,   545,   508,     4,   631,     3,   106,    15,   626,   625,
   624,    14,    39,   156,    10,   480,   622,   473,    32,    19,
   621,     1,    13,    27,    59,   620,   619,    35,     5,    57,
   618,    22,    55,   478,    42,   617,   615,    29,   612,    48,
   503,   598,   493,   596,   433,    20,   588,   587,   472,   583,
   577,   574,   474,    64,   483,    74,   470,    81,   482,    34,
   500,   573,   548,   157,    50,   544,   543,   531,   511,   510,
   499,   495,   481,    71,    25,   492,   491,    46,   489,    67,
   488,    16,    36,     0,     9,   490,   497,   486,   468,   484 };
static cmpyy_tabelem cmpyy_r1[]={

     0,     4,     4,     1,     1,     2,     5,     5,     5,     7,
     6,     6,    16,    16,    10,    10,    11,     8,     8,     8,
     9,     9,     9,    12,    12,    12,    13,    13,   115,    14,
    15,   116,   117,     3,     3,    32,    32,    32,    32,    31,
    31,    34,    34,   111,   111,    35,    35,    35,    35,    35,
    35,    35,    35,    35,    35,    36,    44,    44,    44,    44,
    59,    59,    60,    21,    21,    21,    21,    21,    21,    21,
    21,    21,    27,    27,    41,    41,    42,    42,    43,    43,
    33,    33,    74,    74,    72,    72,    71,    71,    70,    70,
    70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
    70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
    70,    70,    70,    24,    24,    20,    20,    20,    85,    85,
    85,    85,    84,    84,    83,    73,    81,    81,    80,    80,
    82,    82,    19,    19,    19,    19,   102,    79,    79,   119,
   119,   118,   118,   118,   118,   118,    78,    77,    77,    76,
    76,    75,    91,    91,    92,    92,    90,    90,    89,    89,
    25,    28,    28,    26,    26,    23,    23,    22,    22,    17,
    17,    17,    18,    18,    18,    64,    64,    62,    63,    63,
    51,    51,    50,    50,    49,    65,    65,    61,    61,    61,
    61,    61,    61,    53,    53,    54,    55,    55,    56,    56,
    52,    52,   114,    40,    40,    39,    38,    38,    37,    37,
    30,    30,    29,    29,    29,    47,    47,    48,    46,    46,
    45,   112,   112,    58,    57,    57,    57,    57,   110,   110,
   109,   109,   109,    69,    68,    68,    67,    86,    86,    86,
    86,    86,    86,    86,    86,    86,    86,    86,    86,    86,
    86,    86,    86,    86,    86,    86,    86,    86,    86,    86,
    93,    93,    87,    87,    87,    87,    87,    95,    95,    88,
    88,    88,    88,    88,    88,    88,    88,    88,   106,   106,
   106,   106,   108,   108,   107,   107,    94,    94,   103,   104,
   104,   105,   105,   105,   105,   105,    96,    96,    96,    96,
    96,    97,   101,    98,    98,    99,   100,   113,    66,    66,
    66,    66 };
static cmpyy_tabelem cmpyy_r2[]={

     0,     1,     5,     3,     3,     3,     3,     3,     3,     3,
    19,    17,     3,     5,     3,     3,     3,    13,    11,     5,
    13,    11,     5,    13,    11,     5,     3,     3,     7,     7,
     7,     7,     7,    11,     7,     3,     3,     5,     5,     3,
     3,    21,    23,     5,     1,     9,     7,     7,     5,     9,
     7,     5,     7,     5,     3,     5,     3,     3,     5,     5,
     1,     3,     5,     7,     7,     7,    11,    11,    11,    15,
    15,    15,     3,     5,     1,     5,     1,     5,     3,     5,
     9,     9,     5,     3,     1,     3,     3,     5,     3,     7,
     7,     3,    11,    13,    17,    15,    15,     5,     9,     7,
     7,     3,     3,     3,     7,    17,     9,    15,     9,    15,
     9,     5,    11,     3,     7,     7,     7,     7,     7,    11,
     7,     5,     3,     7,     7,     7,     1,     3,     3,     5,
     9,    15,     1,    11,    11,    11,     9,     3,     5,     3,
     5,     9,    15,    15,     9,     9,    11,     1,     3,     3,
     5,     9,     1,     7,     1,     3,     1,     7,     3,     7,
     7,     7,     5,     1,     3,     3,     7,     3,     7,     7,
     7,     7,     7,     7,     7,     1,     9,     9,     9,     9,
     1,     9,     3,     7,     5,     7,     1,     3,     3,     3,
     7,     7,     7,     1,     3,     5,     7,     9,     3,     5,
     7,     9,     5,     3,     1,     5,     3,     7,     3,     5,
     3,     5,     7,     7,     7,     3,     1,     7,     3,     7,
     3,     3,     7,     9,     5,     7,     5,     7,     3,     7,
     7,     7,     7,     7,     3,     7,     3,     3,     7,     9,
     9,    11,     7,     5,     5,     7,     7,     7,     7,     7,
     7,     7,     7,     7,     7,     7,     7,     7,     7,     7,
     3,     7,     3,     3,     7,     9,    11,     3,     7,     3,
     3,     3,     5,     3,     3,     9,     5,     3,     9,    11,
    13,    15,     5,     7,     3,     3,     3,     5,     9,     1,
     3,     3,     7,     9,     3,     5,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3 };
static cmpyy_tabelem cmpyy_chk[]={

 -1000,    -4,    -1,    -2,    -3,    -5,   257,    -7,    -6,   -29,
   -10,  -113,    -8,    -9,   261,   280,   -32,   -31,   -29,   -33,
   -34,  -113,   -10,   -11,   -12,   262,   -48,  -115,  -116,   268,
   -25,   266,   -93,   -87,   -88,  -103,   333,   -96,  -113,   288,
   313,   314,   -58,  -106,   -97,   -99,   -98,  -101,  -100,   -66,
   286,   339,   336,   334,   335,   338,   337,   309,   310,   311,
   312,   258,   -31,   -29,   -48,  -117,   262,   -25,   -74,   -30,
   -72,   -29,   -71,  -113,   -70,   -20,   -24,   -93,   -87,   293,
   289,   282,   301,   302,   303,   304,   305,   306,   -73,   296,
   298,   285,   300,   -74,   259,   -86,   -58,   -57,   -88,   266,
   318,   319,   316,   317,   -25,   -46,   -45,  -113,   -64,   -62,
   273,   272,   -26,   -23,   -18,   -93,   -32,   278,   315,   268,
   266,   -85,   270,  -113,   270,   268,   266,   -25,   260,   341,
   -63,   275,   258,   -72,   -29,   -70,   262,   307,   308,   287,
   278,   287,   276,   -86,   -86,  -112,   -22,  -113,   -17,   -91,
   266,   266,  -113,  -113,   -86,   -86,   -85,   -74,   258,   -47,
   -48,   315,   266,   268,   322,   323,   324,   321,   325,   320,
   319,   326,   327,   262,   330,   329,   328,   331,   332,   -86,
   -86,   -86,  -115,   -69,   -25,   268,  -116,   -69,   -25,   -64,
   -62,   269,   278,   -51,   274,   -51,   266,   266,   267,   278,
   276,   258,   -87,   -86,   -95,   -86,  -104,  -105,   -89,   284,
   -86,   -84,  -103,   271,   -83,   -87,  -113,   -84,  -113,  -110,
  -109,  -112,   -86,   -63,   -47,   260,   -51,   266,  -113,  -112,
   -81,   -80,   -82,   299,   -86,   -20,   -93,   -89,   -86,   -58,
   -57,   294,   290,   295,   276,   278,   295,   278,   -92,   -89,
   -89,   -90,   266,   -90,   -79,   -78,   299,  -119,  -118,   299,
   290,   258,  -113,   -40,   -39,   326,   -86,  -104,   -89,   -86,
   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,   -86,
   -86,   -86,   -86,   -86,   267,  -115,   -68,   -67,   -86,  -116,
   -51,   -51,   -45,   266,   -61,   -86,   -58,   -57,   -61,   -18,
   -86,   -57,   -58,   269,   278,   267,   278,   -89,   271,   277,
   278,   271,   287,   271,   269,   278,   276,   267,  -108,   278,
   -51,   -59,   -60,   282,   -47,   -86,   -57,   297,   258,   -82,
  -112,   278,   -74,   -74,  -102,   -86,   -86,   -57,   -58,  -113,
  -102,   -17,  -112,   267,   267,   -89,   297,   258,   -78,  -112,
   297,   258,  -118,   -86,   -57,   -58,   -74,   -53,   -54,   279,
   -38,   -37,  -113,   267,   269,   269,   278,   -54,   -54,   -50,
   -49,  -113,   267,   278,   267,   -85,   -86,   -86,   284,  -103,
   -83,   -86,  -109,   -86,   -58,   -57,   267,   278,   -94,  -107,
   284,   321,   -86,   -54,   -42,   263,   -86,   -59,   267,   267,
   -19,   266,   276,   266,   258,   -77,   -76,   -75,   291,   294,
   266,   294,   267,   276,   -19,   276,   276,   266,   276,   266,
   276,   258,   -16,   258,   -10,  -113,   -55,  -114,  -113,   278,
   -69,   -85,   -67,   267,   278,   -65,   266,   -86,   -58,   -57,
   -89,   271,   -94,  -107,   267,   -89,   -53,   -86,   -42,   276,
  -113,   -74,   -22,   258,   292,   -75,   -86,   -74,  -104,   -74,
   -74,   276,   -74,   -74,  -113,   -74,  -113,   -74,   258,   -10,
  -113,  -113,   283,   -37,   -49,   -61,   267,   -41,   265,   -53,
   -74,   276,   267,   -74,   290,   258,   267,   258,   258,   -74,
   258,   267,   267,  -113,   -13,   -14,   -15,   -28,   266,   267,
  -111,   264,  -112,   -41,   258,   -86,   -57,   -58,   276,   258,
   -74,   276,   276,   -56,   -52,   278,   -64,   -62,   -61,   267,
   -35,   -30,   -27,   -43,   -36,   -21,   -33,   281,   258,  -113,
   -93,  -112,  -111,   267,   267,   267,   -74,   -74,   -74,   -52,
  -113,  -114,   -51,   -51,   267,   -27,   -43,   -36,   -44,   -36,
   -21,   -43,   -29,   -44,   -36,  -113,   -33,  -113,  -113,   276,
   -35,   -13,  -113,   -44,   -36,   -44,   -36,   -36,   -43,   -29,
   -36,   -86,   -57,   -58,   -13,   -36,   -36,   280,   280,   280,
  -113,  -113,  -113,   278,   278,   278,  -113,  -113,  -113 };
static cmpyy_tabelem cmpyy_def[]={

     1,    -2,     2,     3,     4,     5,     0,     6,     7,     8,
     9,     0,    14,    15,   307,     0,     0,    35,    36,    39,
    40,     0,    84,    84,    16,     0,     0,    19,    22,     0,
   175,   163,     0,   260,   262,   263,   269,   270,   271,     0,
   273,   274,     0,   277,   296,   297,   298,   299,   300,     0,
     0,   301,   305,   303,   304,   302,   306,   308,   309,   310,
   311,    34,    37,    38,     0,    25,     0,   175,     0,    84,
    83,   210,    85,   271,    86,    -2,     0,     0,    -2,     0,
     0,     0,   152,     0,     0,     0,   101,   102,   103,     0,
     0,     0,    84,     0,   216,   212,   213,   214,   237,     0,
     0,     0,     0,     0,   175,     0,   218,   220,   180,   180,
     0,     0,     0,   164,   165,     0,     0,     0,     0,     0,
   289,   276,     0,   272,     0,     0,     0,   175,   216,     0,
   180,     0,     0,    82,   211,    87,     0,     0,   126,     0,
     0,     0,     0,     0,     0,     0,     0,   221,   167,    97,
   154,     0,   156,   156,     0,     0,   111,     0,     0,   204,
   215,     0,   289,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   243,   244,   224,     0,   175,     0,   226,     0,     0,   180,
   180,   217,     0,    28,     0,    31,     0,     0,   160,     0,
     0,    33,   261,   264,     0,   267,     0,   290,   291,   294,
   158,     0,   263,   121,   122,     0,   271,     0,     0,     0,
   228,     0,     0,   180,    60,   216,    32,     0,    80,   104,
     0,   127,   128,     0,    89,   114,     0,    90,   115,   116,
   117,    84,    84,     0,     0,     0,     0,     0,     0,   155,
     0,    99,     0,   100,     0,   137,     0,     0,   139,     0,
    84,   125,    81,   193,   203,     0,   238,     0,     0,   245,
   246,   247,   248,   249,   250,   251,   252,   253,   254,   255,
   256,   257,   258,   259,   242,   225,     0,   234,   236,   227,
    18,    21,   219,     0,     0,   187,   188,   189,     0,   166,
   172,   173,   174,   265,     0,   288,     0,   295,   118,     0,
     0,   120,     0,   275,   223,     0,     0,   278,     0,     0,
    24,    76,    61,     0,    60,     0,     0,   132,   106,   129,
     0,     0,     0,   147,     0,     0,   169,   170,   171,   222,
     0,   168,     0,   153,    98,     0,     0,   108,   138,   132,
     0,   110,   140,     0,     0,     0,     0,     0,   194,     0,
   205,   206,   208,   239,   240,   233,     0,    17,    20,     0,
   182,   186,   176,     0,   177,   266,   268,   159,   292,   263,
   123,   124,   229,   230,   231,   232,   279,     0,     0,   282,
   286,   284,   285,    23,   193,     0,    62,    76,   178,   179,
     0,     0,    84,     0,    92,     0,   148,   149,     0,    84,
   289,    84,   157,    84,     0,    84,    84,     0,    84,     0,
    84,   112,     0,     0,    12,     0,   195,     0,     0,     0,
   209,   241,   235,   181,     0,   184,     0,   190,   191,   192,
   293,   119,     0,   283,   280,   287,    74,    77,   193,    84,
     0,   130,     0,    93,    84,   150,     0,     0,     0,     0,
     0,    84,     0,   141,     0,   144,     0,   145,     0,    13,
    11,     0,   202,   207,   183,     0,   281,    44,     0,    74,
     0,     0,     0,     0,    84,    95,    -2,    96,   107,   146,
   109,     0,     0,    10,   196,    26,    27,   175,     0,   185,
     0,     0,    75,    44,   105,     0,     0,     0,    84,    94,
   151,    84,    84,   197,   198,     0,   180,   180,     0,   162,
    41,     0,     0,     0,    54,    72,    78,     0,     0,   271,
     0,    43,     0,   133,   134,   135,   131,   142,   143,   199,
     0,     0,    29,    30,   161,     0,     0,    51,     0,    48,
    73,    56,    57,     0,    53,     0,    79,     0,    55,     0,
    42,   200,     0,     0,    46,     0,    50,    47,    58,    59,
    52,    63,    64,    65,   201,    45,    49,     0,     0,     0,
    66,    67,    68,     0,     0,     0,    69,    70,    71 };
typedef struct { char *t_name; int t_val; } cmpyy_toktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

cmpyy_toktype cmpyy_toks[] =
{
	"MODULE",	257,
	"END",	258,
	"TYPE",	259,
	"CLASS",	260,
	"ID",	261,
	"EQ",	262,
	"INHERITS",	263,
	"HIDES",	264,
	"PROVIDES",	265,
	"LPAREN",	266,
	"RPAREN",	267,
	"LBRACK",	268,
	"RBRACK",	269,
	"LCURLY",	270,
	"RCURLY",	271,
	"YIELDS",	272,
	"RETURNS",	273,
	"SIGNALS",	274,
	"MAKES",	275,
	"COLON",	276,
	"SEMI",	277,
	"COMMA",	278,
	"WHERE",	279,
	"IMPLEMENTS",	280,
	"OP",	281,
	"FOR",	282,
	"HAS",	283,
	"DOTS",	284,
	"MAKE",	285,
	"BIND",	286,
	"ASSIGN",	287,
	"CARET",	288,
	"IF",	289,
	"THEN",	290,
	"ELSEIF",	291,
	"ELSE",	292,
	"WHILE",	293,
	"DO",	294,
	"IN",	295,
	"TAGCASE",	296,
	"OTHERS",	297,
	"TYPECASE",	298,
	"WHEN",	299,
	"BEGIN_",	300,
	"RETURN",	301,
	"YIELD",	302,
	"SIGNAL",	303,
	"EXIT",	304,
	"BREAK",	305,
	"CONTINUE",	306,
	"RESIGNAL",	307,
	"EXCEPT",	308,
	"RECORD",	309,
	"STRUCT",	310,
	"ONEOF",	311,
	"VARIANT",	312,
	"SELF",	313,
	"NEWOBJECT",	314,
	"DOT",	315,
	"PROC",	316,
	"ITER",	317,
	"TILDE",	318,
	"MINUS",	319,
	"PLUS",	320,
	"STAR",	321,
	"EXP",	322,
	"MOD",	323,
	"DIV",	324,
	"CONCAT",	325,
	"LT",	326,
	"LE",	327,
	"GT",	328,
	"GE",	329,
	"NEQ",	330,
	"CAND",	331,
	"COR",	332,
	"NIL",	333,
	"TRUE_",	334,
	"FALSE_",	335,
	"CHAR",	336,
	"STRING",	337,
	"REAL",	338,
	"INT",	339,
	"LexErr",	340,
	"CONST_IVARS",	341,
	"DUMMY",	342,
	"UMINUS",	343,
	"-unknown-",	-1	/* ends search */
};

char * cmpyy_reds[] =
{
	"-no such reduction-",
      "module_list : /* empty */",
      "module_list : module_list module",
      "module : spec_mod",
      "module : impl_mod",
      "spec_mod : spec_elt",
      "spec_elt : routine_spec",
      "spec_elt : type_intf",
      "spec_elt : equate",
      "routine_spec : routine_intf",
      "type_intf : id EQ TYPE oparms osupers owhere routine_list END id",
      "type_intf : id EQ TYPE oparms osupers owhere END id",
      "routine_list : routine_intf",
      "routine_list : routine_list routine_intf",
      "routine_intf : proc_header",
      "routine_intf : iter_header",
      "make_intf : make_header",
      "proc_header : id parms args oreturns osignals where_list",
      "proc_header : id parms args oreturns osignals",
      "proc_header : id non_param_proc_sig",
      "iter_header : id parms args yields osignals where_list",
      "iter_header : id parms args yields osignals",
      "iter_header : id non_param_iter_sig",
      "make_header : id parms args makes osignals where_list",
      "make_header : id parms args makes osignals",
      "make_header : id non_param_make_sig",
      "nf_non_param_routine_header : nf_non_param_proc_header",
      "nf_non_param_routine_header : nf_non_param_iter_header",
      "non_param_proc_sig : args oreturns osignals",
      "nf_non_param_proc_header : nf_args oreturns osignals",
      "nf_non_param_iter_header : nf_args yields osignals",
      "non_param_iter_sig : args yields osignals",
      "non_param_make_sig : args makes osignals",
      "impl_mod : MODULE IMPLEMENTS primaries impl_elt_list END",
      "impl_mod : MODULE impl_elt_list END",
      "impl_elt_list : impl_elt",
      "impl_elt_list : equate",
      "impl_elt_list : impl_elt_list impl_elt",
      "impl_elt_list : impl_elt_list equate",
      "impl_elt : routine_def",
      "impl_elt : class_def",
      "class_def : id EQ CLASS oparms oreltype oinherits owhere oexports ohides class_def_rest",
      "class_def : id EQ CONST_IVARS CLASS oparms oreltype oinherits owhere oexports ohides class_def_rest",
      "ohides : HIDES id_list",
      "ohides : /* empty */",
      "class_def_rest : equate_list ivar_decl_list cdef_elts class_def_end",
      "class_def_rest : equate_list ivar_decl_list class_def_end",
      "class_def_rest : ivar_decl_list cdef_elts class_def_end",
      "class_def_rest : ivar_decl_list class_def_end",
      "class_def_rest : equate_list method_or_op_def cdef_elts class_def_end",
      "class_def_rest : equate_list method_or_op_def class_def_end",
      "class_def_rest : equate_list class_def_end",
      "class_def_rest : method_or_op_def cdef_elts class_def_end",
      "class_def_rest : method_or_op_def class_def_end",
      "class_def_rest : class_def_end",
      "class_def_end : END id",
      "cdef_elts : method_or_op_def",
      "cdef_elts : equate",
      "cdef_elts : cdef_elts method_or_op_def",
      "cdef_elts : cdef_elts equate",
      "oreltype : /* empty */",
      "oreltype : reltype",
      "reltype : FOR expr",
      "ivar_decl : primaries COLON expr",
      "ivar_decl : primaries COLON routine_type",
      "ivar_decl : primaries COLON tagged_type_spec",
      "ivar_decl : primaries COLON expr IMPLEMENTS id",
      "ivar_decl : primaries COLON routine_type IMPLEMENTS id",
      "ivar_decl : primaries COLON tagged_type_spec IMPLEMENTS id",
      "ivar_decl : primaries COLON expr IMPLEMENTS id COMMA id",
      "ivar_decl : primaries COLON routine_type IMPLEMENTS id COMMA id",
      "ivar_decl : primaries COLON tagged_type_spec IMPLEMENTS id COMMA id",
      "ivar_decl_list : ivar_decl",
      "ivar_decl_list : ivar_decl_list ivar_decl",
      "oexports : /* empty */",
      "oexports : PROVIDES id_list",
      "oinherits : /* empty */",
      "oinherits : INHERITS expr",
      "method_or_op_def : routine_def",
      "method_or_op_def : OP routine_def",
      "routine_def : routine_intf body END id",
      "routine_def : make_intf body END id",
      "body : equate_list ostatements",
      "body : ostatements",
      "ostatements : /* empty */",
      "ostatements : statement_list",
      "statement_list : statement",
      "statement_list : statement_list statement",
      "statement : sdecl",
      "statement : sdecl_list ASSIGN expr",
      "statement : primaries ASSIGN expr_list",
      "statement : primary",
      "statement : WHILE expr DO body END",
      "statement : IF expr THEN body oelse_ifs END",
      "statement : IF expr THEN body oelse_ifs ELSE body END",
      "statement : FOR id_list IN invoc DO body END",
      "statement : FOR decl_list IN invoc DO body END",
      "statement : RETURN oparen_expr_list2",
      "statement : YIELD LPAREN expr_list RPAREN",
      "statement : SIGNAL id oparen_expr_list",
      "statement : EXIT id oparen_expr_list",
      "statement : BREAK",
      "statement : CONTINUE",
      "statement : begin_end",
      "statement : statement RESIGNAL id_list",
      "statement : statement EXCEPT oex_when_arms OTHERS odecl COLON body END",
      "statement : statement EXCEPT oex_when_arms END",
      "statement : TAGCASE expr tag_when_arm_list OTHERS COLON body END",
      "statement : TAGCASE expr tag_when_arm_list END",
      "statement : TYPECASE expr type_when_arm_list OTHERS COLON body END",
      "statement : TYPECASE expr type_when_arm_list END",
      "statement : MAKE field_inits",
      "statement : MAKE field_inits THEN body END",
      "sdecl_list : sdecl",
      "sdecl_list : sdecl_list COMMA sdecl",
      "sdecl : primaries COLON expr",
      "sdecl : primaries COLON tagged_type_spec",
      "sdecl : primaries COLON routine_type",
      "field_inits : LCURLY field_init_list RCURLY",
      "field_inits : LCURLY field_init_list SEMI simple_invoc RCURLY",
      "field_inits : LCURLY simple_invoc RCURLY",
      "field_inits : LCURLY RCURLY",
      "field_init_list : field_init",
      "field_init_list : field_init_list COMMA field_init",
      "field_init : id ASSIGN expr",
      "begin_end : BEGIN_ body END",
      "oex_when_arms : /* empty */",
      "oex_when_arms : ex_when_arms",
      "ex_when_arms : ex_when_arm",
      "ex_when_arms : ex_when_arms ex_when_arm",
      "ex_when_arm : WHEN id_list COLON body",
      "ex_when_arm : WHEN id_list LPAREN decl_list RPAREN COLON body",
      "odecl : /* empty */",
      "odecl : LPAREN id COLON expr RPAREN",
      "odecl : LPAREN id COLON routine_type RPAREN",
      "odecl : LPAREN id COLON tagged_type_spec RPAREN",
      "invoc : expr LPAREN oinv_args RPAREN",
      "tag_when_arm_list : tag_when_arm",
      "tag_when_arm_list : tag_when_arm_list tag_when_arm",
      "type_when_arm_list : type_when_arm",
      "type_when_arm_list : type_when_arm_list type_when_arm",
      "type_when_arm : WHEN expr COLON body",
      "type_when_arm : WHEN routine_type LPAREN id RPAREN COLON body",
      "type_when_arm : WHEN tagged_type_spec LPAREN id RPAREN COLON body",
      "type_when_arm : WHEN routine_type COLON body",
      "type_when_arm : WHEN tagged_type_spec COLON body",
      "tag_when_arm : WHEN id_list odecl COLON body",
      "oelse_ifs : /* empty */",
      "oelse_ifs : else_if_list",
      "else_if_list : else_if",
      "else_if_list : else_if_list else_if",
      "else_if : ELSEIF expr THEN body",
      "oparen_expr_list2 : /* empty */",
      "oparen_expr_list2 : LPAREN oparen_expr_list2_contents RPAREN",
      "oparen_expr_list2_contents : /* empty */",
      "oparen_expr_list2_contents : expr_list",
      "oparen_expr_list : /* empty */",
      "oparen_expr_list : LPAREN expr_list RPAREN",
      "expr_list : expr",
      "expr_list : expr_list COMMA expr",
      "args : LPAREN oadecl_list RPAREN",
      "nf_args : LPAREN type_spec_list RPAREN",
      "nf_args : LPAREN RPAREN",
      "oadecl_list : /* empty */",
      "oadecl_list : adecl_list",
      "adecl_list : adecl",
      "adecl_list : adecl_list COMMA adecl",
      "decl_list : decl",
      "decl_list : decl_list COMMA decl",
      "decl : id_list COLON expr",
      "decl : id_list COLON routine_type",
      "decl : id_list COLON tagged_type_spec",
      "adecl : primaries COLON expr",
      "adecl : primaries COLON routine_type",
      "adecl : primaries COLON tagged_type_spec",
      "oreturns : /* empty */",
      "oreturns : RETURNS LPAREN type_spec_list RPAREN",
      "yields : YIELDS LPAREN type_spec_list RPAREN",
      "makes : MAKES LPAREN expr RPAREN",
      "makes : MAKES LPAREN routine_type RPAREN",
      "osignals : /* empty */",
      "osignals : SIGNALS LPAREN exception_list RPAREN",
      "exception_list : exception",
      "exception_list : exception_list COMMA exception",
      "exception : id oparent_list",
      "oparent_list : LPAREN type_spec_list RPAREN",
      "oparent_list : /* empty */",
      "type_spec_list : expr",
      "type_spec_list : tagged_type_spec",
      "type_spec_list : routine_type",
      "type_spec_list : type_spec_list COMMA expr",
      "type_spec_list : type_spec_list COMMA tagged_type_spec",
      "type_spec_list : type_spec_list COMMA routine_type",
      "owhere : /* empty */",
      "owhere : where_list",
      "where_list : WHERE where_clause_list",
      "where_clause_list : where_id id nf_non_param_routine_header",
      "where_clause_list : where_id id nf_non_param_routine_header where_subclause_list",
      "where_subclause_list : where_subclause",
      "where_subclause_list : where_subclause_list where_subclause",
      "where_subclause : COMMA id nf_non_param_routine_header",
      "where_subclause : COMMA where_id id nf_non_param_routine_header",
      "where_id : id HAS",
      "osupers : supers",
      "osupers : /* empty */",
      "supers : LT super_info_list",
      "super_info_list : super_info",
      "super_info_list : super_info_list COMMA super_info",
      "super_info : id",
      "super_info : id actual_params",
      "equate_list : equate",
      "equate_list : equate_list equate",
      "equate : id EQ expr",
      "equate : id EQ tagged_type_spec",
      "equate : id EQ routine_type",
      "oparms : parms",
      "oparms : /* empty */",
      "parms : LBRACK param_list RBRACK",
      "param_list : param",
      "param_list : param_list COMMA param",
      "param : id",
      "id_list : id",
      "id_list : id_list COMMA id",
      "tagged_type_spec : taggedtype_id LBRACK field_list RBRACK",
      "routine_type : PROC non_param_proc_sig",
      "routine_type : PROC actual_params non_param_proc_sig",
      "routine_type : ITER non_param_iter_sig",
      "routine_type : ITER actual_params non_param_iter_sig",
      "field_list : field",
      "field_list : field_list COMMA field",
      "field : id_list COLON expr",
      "field : id_list COLON tagged_type_spec",
      "field : id_list COLON routine_type",
      "actual_params : LBRACK actual_param_list RBRACK",
      "actual_param_list : actual_param",
      "actual_param_list : actual_param_list COMMA actual_param",
      "actual_param : expr",
      "expr : simple_expr",
      "expr : expr DOT expr",
      "expr : expr LPAREN oinv_args RPAREN",
      "expr : expr LBRACK expr_list RBRACK",
      "expr : expr LBRACK expr_list RBRACK field_inits",
      "expr : LPAREN expr RPAREN",
      "expr : TILDE expr",
      "expr : MINUS expr",
      "expr : expr EXP expr",
      "expr : expr MOD expr",
      "expr : expr DIV expr",
      "expr : expr STAR expr",
      "expr : expr CONCAT expr",
      "expr : expr PLUS expr",
      "expr : expr MINUS expr",
      "expr : expr LT expr",
      "expr : expr LE expr",
      "expr : expr EQ expr",
      "expr : expr NEQ expr",
      "expr : expr GE expr",
      "expr : expr GT expr",
      "expr : expr CAND expr",
      "expr : expr COR expr",
      "primaries : primary",
      "primaries : primaries COMMA primary",
      "primary : simple_expr",
      "primary : simple_invoc",
      "primary : primary DOT expr",
      "primary : primary LBRACK insides RBRACK",
      "primary : primary LBRACK insides RBRACK field_inits",
      "insides : expr",
      "insides : insides COMMA expr",
      "simple_expr : NIL",
      "simple_expr : literal",
      "simple_expr : id",
      "simple_expr : CARET id",
      "simple_expr : SELF",
      "simple_expr : NEWOBJECT",
      "simple_expr : tagged_type_spec LCURLY field_init_list RCURLY",
      "simple_expr : id field_inits",
      "simple_expr : binding",
      "binding : BIND LPAREN expr RPAREN",
      "binding : BIND LPAREN expr bind_arg_list RPAREN",
      "binding : BIND LPAREN expr COMMA btrail RPAREN",
      "binding : BIND LPAREN expr bind_arg_list COMMA btrail RPAREN",
      "bind_arg_list : COMMA bind_arg",
      "bind_arg_list : bind_arg_list COMMA bind_arg",
      "bind_arg : STAR",
      "bind_arg : expr",
      "btrail : DOTS",
      "btrail : DOTS expr_list",
      "simple_invoc : primary LPAREN oinv_args RPAREN",
      "oinv_args : /* empty */",
      "oinv_args : inv_args",
      "inv_args : expr_list",
      "inv_args : expr_list COMMA DOTS",
      "inv_args : expr_list COMMA DOTS expr_list",
      "inv_args : DOTS",
      "inv_args : DOTS expr_list",
      "literal : int_literal",
      "literal : char_literal",
      "literal : bool_literal",
      "literal : real_literal",
      "literal : string_literal",
      "int_literal : INT",
      "real_literal : REAL",
      "bool_literal : TRUE_",
      "bool_literal : FALSE_",
      "char_literal : CHAR",
      "string_literal : STRING",
      "id : ID",
      "taggedtype_id : RECORD",
      "taggedtype_id : STRUCT",
      "taggedtype_id : ONEOF",
      "taggedtype_id : VARIANT",
};
#endif /* YYDEBUG */
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
 */
/* @(#)yaccpar	1.3  com/cmd/lang/yacc,3.1, 9/7/89 18:46:37 */
/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#ifdef YYSPLIT
#   define YYERROR	return(-2)
#else
#   define YYERROR	goto cmpyy_errlab
#endif

#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( cmpyy_char >= 0 || ( cmpyy_r2[ cmpyy_tmp ] >> 1 ) != 1 )\
	{\
		cmpyy_error( "syntax error - cannot backup" );\
		goto cmpyy_errlab;\
	}\
	cmpyy_char = newtoken;\
	cmpyy_state = *cmpyy_ps;\
	cmpyy_lval = newvalue;\
	goto cmpyy_newstate;\
}
#define YYRECOVERING()	(!!cmpyy_errflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int cmpyy_debug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-1000)

#ifdef YYSPLIT
#   define YYSCODE { \
			extern int (*cmpyy_f[])(); \
			register int cmpyy_ret; \
			if (cmpyy_f[cmpyy_tmp]) \
			    if ((cmpyy_ret=(*cmpyy_f[cmpyy_tmp])()) == -2) \
				    goto cmpyy_errlab; \
				else if (cmpyy_ret>=0) return(cmpyy_ret); \
		   }
#endif

/*
** global variables used by the parser
*/
YYSTYPE cmpyy_v[ YYMAXDEPTH ];	/* value stack */
int cmpyy_s[ YYMAXDEPTH ];		/* state stack */

YYSTYPE *cmpyy_pv;			/* top of value stack */
YYSTYPE *cmpyy_pvt;			/* top of value stack for $vars */
int *cmpyy_ps;			/* top of state stack */

int cmpyy_state;			/* current state */
int cmpyy_tmp;			/* extra var (lasts between blocks) */

int cmpyy_nerrs;			/* number of errors */
int cmpyy_errflag;			/* error recovery flag */
int cmpyy_char;			/* current input token number */



/*
** cmpyy_parse - return 0 if worked, 1 if syntax error not recovered from
*/
int
cmpyy_parse()
{
	/*
	** Initialize externals - cmpyy_parse may be called more than once
	*/
	cmpyy_pv = &cmpyy_v[-1];
	cmpyy_ps = &cmpyy_s[-1];
	cmpyy_state = 0;
	cmpyy_tmp = 0;
	cmpyy_nerrs = 0;
	cmpyy_errflag = 0;
	cmpyy_char = -1;

	goto cmpyy_stack;
	{
		register YYSTYPE *cmpyy__pv;	/* top of value stack */
		register int *cmpyy__ps;		/* top of state stack */
		register int cmpyy__state;		/* current state */
		register int  cmpyy__n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	cmpyy_newstate:
		cmpyy__pv = cmpyy_pv;
		cmpyy__ps = cmpyy_ps;
		cmpyy__state = cmpyy_state;
		goto cmpyy__newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	cmpyy_stack:
		cmpyy__pv = cmpyy_pv;
		cmpyy__ps = cmpyy_ps;
		cmpyy__state = cmpyy_state;

		/*
		** top of for (;;) loop while no reductions done
		*/
	cmpyy__stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( cmpyy_debug )
		{
			register int cmpyy__i;

			printf( "State %d, token ", cmpyy__state );
			if ( cmpyy_char == 0 )
				printf( "end-of-file\n" );
			else if ( cmpyy_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( cmpyy__i = 0; cmpyy_toks[cmpyy__i].t_val >= 0;
					cmpyy__i++ )
				{
					if ( cmpyy_toks[cmpyy__i].t_val == cmpyy_char )
						break;
				}
				printf( "%s\n", cmpyy_toks[cmpyy__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++cmpyy__ps >= &cmpyy_s[ YYMAXDEPTH ] )	/* room on stack? */
		{
			cmpyy_error( "yacc stack overflow" );
			YYABORT;
		}
		*cmpyy__ps = cmpyy__state;
		*++cmpyy__pv = cmpyy_val;

		/*
		** we have a new state - find out what to do
		*/
	cmpyy__newstate:
		if ( ( cmpyy__n = cmpyy_pact[ cmpyy__state ] ) <= YYFLAG )
			goto cmpyy_default;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		cmpyy_tmp = cmpyy_char < 0;
#endif
		if ( ( cmpyy_char < 0 ) && ( ( cmpyy_char = cmpyy_lex() ) < 0 ) )
			cmpyy_char = 0;		/* reached EOF */
#if YYDEBUG
		if ( cmpyy_debug && cmpyy_tmp )
		{
			register int cmpyy__i;

			printf( "Received token " );
			if ( cmpyy_char == 0 )
				printf( "end-of-file\n" );
			else if ( cmpyy_char < 0 )
				printf( "-none-\n" );
			else
			{
				for ( cmpyy__i = 0; cmpyy_toks[cmpyy__i].t_val >= 0;
					cmpyy__i++ )
				{
					if ( cmpyy_toks[cmpyy__i].t_val == cmpyy_char )
						break;
				}
				printf( "%s\n", cmpyy_toks[cmpyy__i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( cmpyy__n += cmpyy_char ) < 0 ) || ( cmpyy__n >= YYLAST ) )
			goto cmpyy_default;
		if ( cmpyy_chk[ cmpyy__n = cmpyy_act[ cmpyy__n ] ] == cmpyy_char )	/*valid shift*/
		{
			cmpyy_char = -1;
			cmpyy_val = cmpyy_lval;
			cmpyy__state = cmpyy__n;
			if ( cmpyy_errflag > 0 )
				cmpyy_errflag--;
			goto cmpyy__stack;
		}

	cmpyy_default:
		if ( ( cmpyy__n = cmpyy_def[ cmpyy__state ] ) == -2 )
		{
#if YYDEBUG
			cmpyy_tmp = cmpyy_char < 0;
#endif
			if ( ( cmpyy_char < 0 ) && ( ( cmpyy_char = cmpyy_lex() ) < 0 ) )
				cmpyy_char = 0;		/* reached EOF */
#if YYDEBUG
			if ( cmpyy_debug && cmpyy_tmp )
			{
				register int cmpyy__i;

				printf( "Received token " );
				if ( cmpyy_char == 0 )
					printf( "end-of-file\n" );
				else if ( cmpyy_char < 0 )
					printf( "-none-\n" );
				else
				{
					for ( cmpyy__i = 0;
						cmpyy_toks[cmpyy__i].t_val >= 0;
						cmpyy__i++ )
					{
						if ( cmpyy_toks[cmpyy__i].t_val
							== cmpyy_char )
						{
							break;
						}
					}
					printf( "%s\n", cmpyy_toks[cmpyy__i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *cmpyy_xi = cmpyy_exca;

				while ( ( *cmpyy_xi != -1 ) ||
					( cmpyy_xi[1] != cmpyy__state ) )
				{
					cmpyy_xi += 2;
				}
				while ( ( *(cmpyy_xi += 2) >= 0 ) &&
					( *cmpyy_xi != cmpyy_char ) )
					;
				if ( ( cmpyy__n = cmpyy_xi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( cmpyy__n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( cmpyy_errflag )
			{
			case 0:		/* new error */
				cmpyy_error( "syntax error" );
				goto skip_init;
			cmpyy_errlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				cmpyy__pv = cmpyy_pv;
				cmpyy__ps = cmpyy_ps;
				cmpyy__state = cmpyy_state;
				cmpyy_nerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				cmpyy_errflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( cmpyy__ps >= cmpyy_s )
				{
					cmpyy__n = cmpyy_pact[ *cmpyy__ps ] + YYERRCODE;
					if ( cmpyy__n >= 0 && cmpyy__n < YYLAST &&
						cmpyy_chk[cmpyy_act[cmpyy__n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						cmpyy__state = cmpyy_act[ cmpyy__n ];
						goto cmpyy__stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( cmpyy_debug )
						printf( _POP_, *cmpyy__ps,
							cmpyy__ps[-1] );
#	undef _POP_
#endif
					cmpyy__ps--;
					cmpyy__pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( cmpyy_debug )
				{
					register int cmpyy__i;

					printf( "Error recovery discards " );
					if ( cmpyy_char == 0 )
						printf( "token end-of-file\n" );
					else if ( cmpyy_char < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( cmpyy__i = 0;
							cmpyy_toks[cmpyy__i].t_val >= 0;
							cmpyy__i++ )
						{
							if ( cmpyy_toks[cmpyy__i].t_val
								== cmpyy_char )
							{
								break;
							}
						}
						printf( "token %s\n",
							cmpyy_toks[cmpyy__i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( cmpyy_char == 0 )	/* reached EOF. quit */
					YYABORT;
				cmpyy_char = -1;
				goto cmpyy__newstate;
			}
		}/* end if ( cmpyy__n == 0 ) */
		/*
		** reduction by production cmpyy__n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( cmpyy_debug )
			printf( "Reduce by (%d) \"%s\"\n",
				cmpyy__n, cmpyy_reds[ cmpyy__n ] );
#endif
		cmpyy_tmp = cmpyy__n;			/* value to switch over */
		cmpyy_pvt = cmpyy__pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using cmpyy__state here as temporary
		** register variable, but why not, if it works...
		** If cmpyy_r2[ cmpyy__n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto cmpyy__stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int cmpyy__len = cmpyy_r2[ cmpyy__n ];

			if ( !( cmpyy__len & 01 ) )
			{
				cmpyy__len >>= 1;
				cmpyy_val = ( cmpyy__pv -= cmpyy__len )[1];	/* $$ = $1 */
				cmpyy__state = cmpyy_pgo[ cmpyy__n = cmpyy_r1[ cmpyy__n ] ] +
					*( cmpyy__ps -= cmpyy__len ) + 1;
				if ( cmpyy__state >= YYLAST ||
					cmpyy_chk[ cmpyy__state =
					cmpyy_act[ cmpyy__state ] ] != -cmpyy__n )
				{
					cmpyy__state = cmpyy_act[ cmpyy_pgo[ cmpyy__n ] ];
				}
				goto cmpyy__stack;
			}
			cmpyy__len >>= 1;
			cmpyy_val = ( cmpyy__pv -= cmpyy__len )[1];	/* $$ = $1 */
			cmpyy__state = cmpyy_pgo[ cmpyy__n = cmpyy_r1[ cmpyy__n ] ] +
				*( cmpyy__ps -= cmpyy__len ) + 1;
			if ( cmpyy__state >= YYLAST ||
				cmpyy_chk[ cmpyy__state = cmpyy_act[ cmpyy__state ] ] != -cmpyy__n )
			{
				cmpyy__state = cmpyy_act[ cmpyy_pgo[ cmpyy__n ] ];
			}
		}
					/* save until reenter driver code */
		cmpyy_state = cmpyy__state;
		cmpyy_ps = cmpyy__ps;
		cmpyy_pv = cmpyy__pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/

		switch(cmpyy_tmp){

case 1:
# line 288 "./theta.y"
{ cmpyy_val.moduleList = new ParseNodeList();
				  parse_tree = cmpyy_val.moduleList;
				} /*NOTREACHED*/ break;
case 2:
# line 292 "./theta.y"
{ cmpyy_val.moduleList = cmpyy_pvt[-1].moduleList; cmpyy_val.moduleList->append(cmpyy_pvt[-0].module); } /*NOTREACHED*/ break;
case 3:
# line 296 "./theta.y"
{ cmpyy_val.module = cmpyy_pvt[-0].module; } /*NOTREACHED*/ break;
case 4:
# line 298 "./theta.y"
{ cmpyy_val.module = cmpyy_pvt[-0].module; } /*NOTREACHED*/ break;
case 5:
# line 302 "./theta.y"
{ 
				  cmpyy_val.module = new SpecModule(new ParseNodeList(cmpyy_pvt[-0].specElt));
				} /*NOTREACHED*/ break;
case 6:
# line 307 "./theta.y"
{ cmpyy_val.specElt = cmpyy_pvt[-0].specElt; } /*NOTREACHED*/ break;
case 7:
# line 309 "./theta.y"
{ cmpyy_val.specElt = cmpyy_pvt[-0].specElt; } /*NOTREACHED*/ break;
case 8:
# line 311 "./theta.y"
{ cmpyy_val.specElt = new SpecEquate(cmpyy_pvt[-0].equate); } /*NOTREACHED*/ break;
case 9:
# line 316 "./theta.y"
{ cmpyy_val.specElt = new RoutineSpec(cmpyy_pvt[-0].routineIntf); } /*NOTREACHED*/ break;
case 10:
# line 320 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-8].id_, cmpyy_pvt[-0].id_))
				  cmpyy_val.specElt = new TypeIntf(cmpyy_pvt[-8].id_, cmpyy_pvt[-5].parmList, cmpyy_pvt[-4].superInfoList, cmpyy_pvt[-3].restrictionList, cmpyy_pvt[-2].routineIntfList);
				  else {cmpyy_error("mismatching ids"); YYABORT;}
				} /*NOTREACHED*/ break;
case 11:
# line 325 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-7].id_, cmpyy_pvt[-0].id_))
				  cmpyy_val.specElt = new TypeIntf(cmpyy_pvt[-7].id_, cmpyy_pvt[-4].parmList, cmpyy_pvt[-3].superInfoList, cmpyy_pvt[-2].restrictionList, 0);
				  else {cmpyy_error("mismatching ids"); YYABORT;}
				} /*NOTREACHED*/ break;
case 12:
# line 332 "./theta.y"
{ cmpyy_val.routineIntfList = new ParseNodeList(cmpyy_pvt[-0].routineIntf); } /*NOTREACHED*/ break;
case 13:
# line 334 "./theta.y"
{ cmpyy_val.routineIntfList = cmpyy_pvt[-1].routineIntfList; cmpyy_val.routineIntfList->append(cmpyy_pvt[-0].routineIntf); } /*NOTREACHED*/ break;
case 14:
# line 338 "./theta.y"
{ cmpyy_val.routineIntf = cmpyy_pvt[-0].routineIntf; } /*NOTREACHED*/ break;
case 15:
# line 340 "./theta.y"
{ cmpyy_val.routineIntf = cmpyy_pvt[-0].routineIntf; } /*NOTREACHED*/ break;
case 16:
# line 344 "./theta.y"
{ cmpyy_val.routineIntf = cmpyy_pvt[-0].routineIntf; } /*NOTREACHED*/ break;
case 17:
# line 348 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 
					cmpyy_pvt[-5].id_,
					new Signature(
					Signature::ProcSigT,
					cmpyy_pvt[-4].parmList, cmpyy_pvt[-3].declList, cmpyy_pvt[-2].typeSpecList, cmpyy_pvt[-1].exceptionList, cmpyy_pvt[-0].restrictionList));
				} /*NOTREACHED*/ break;
case 18:
# line 357 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 
					cmpyy_pvt[-4].id_,
					new Signature(
					Signature::ProcSigT,
					cmpyy_pvt[-3].parmList, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0));
				} /*NOTREACHED*/ break;
case 19:
# line 365 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, cmpyy_pvt[-1].id_, cmpyy_pvt[-0].signature);} /*NOTREACHED*/ break;
case 20:
# line 370 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::IterHeaderT, 
					cmpyy_pvt[-5].id_,
					new Signature(
					Signature::IterSigT,
					cmpyy_pvt[-4].parmList, cmpyy_pvt[-3].declList, cmpyy_pvt[-2].typeSpecList, cmpyy_pvt[-1].exceptionList, cmpyy_pvt[-0].restrictionList));
				} /*NOTREACHED*/ break;
case 21:
# line 378 "./theta.y"
{ new RoutineIntf(
					RoutineIntf::IterHeaderT, 
					cmpyy_pvt[-4].id_,
					new Signature(
					Signature::IterSigT,
					cmpyy_pvt[-3].parmList, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0));
				} /*NOTREACHED*/ break;
case 22:
# line 386 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, cmpyy_pvt[-1].id_, cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 23:
# line 391 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::MakeHeaderT, 
					cmpyy_pvt[-5].id_,
					new Signature(
					Signature::MakeSigT,
					cmpyy_pvt[-4].parmList, cmpyy_pvt[-3].declList, cmpyy_pvt[-2].typeSpecList, cmpyy_pvt[-1].exceptionList, cmpyy_pvt[-0].restrictionList));
				} /*NOTREACHED*/ break;
case 24:
# line 399 "./theta.y"
{ new RoutineIntf(
					RoutineIntf::MakeHeaderT, 
					cmpyy_pvt[-4].id_,
					new Signature(
					Signature::MakeSigT,
					cmpyy_pvt[-3].parmList, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0));
				} /*NOTREACHED*/ break;
case 25:
# line 407 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, cmpyy_pvt[-1].id_, cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 26:
# line 412 "./theta.y"
{ cmpyy_val.routineIntf = cmpyy_pvt[-0].routineIntf; } /*NOTREACHED*/ break;
case 27:
# line 414 "./theta.y"
{ cmpyy_val.routineIntf = cmpyy_pvt[-0].routineIntf; } /*NOTREACHED*/ break;
case 28:
# line 418 "./theta.y"
{ cmpyy_val.signature = new Signature(
					Signature::ProcSigT,
					0, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0);
				} /*NOTREACHED*/ break;
case 29:
# line 425 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::ProcHeaderT, 0,
					new Signature(
					Signature::ProcSigT,
					0, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0));
				} /*NOTREACHED*/ break;
case 30:
# line 434 "./theta.y"
{ cmpyy_val.routineIntf = new RoutineIntf(
					RoutineIntf::IterHeaderT, 0,
					new Signature(
					Signature::IterSigT,
					0, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0));
				} /*NOTREACHED*/ break;
case 31:
# line 443 "./theta.y"
{ cmpyy_val.signature = new Signature(
					Signature::IterSigT,
					0, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0);
				} /*NOTREACHED*/ break;
case 32:
# line 450 "./theta.y"
{ cmpyy_val.signature = new Signature(
					Signature::MakeSigT,
					0, cmpyy_pvt[-2].declList, cmpyy_pvt[-1].typeSpecList, cmpyy_pvt[-0].exceptionList, 0);
				} /*NOTREACHED*/ break;
case 33:
# line 459 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
				  if (!ids) {cmpyy_error("id list expected");YYABORT;}
				  cmpyy_val.module = new ImplModule(ids, 0, cmpyy_pvt[-1].implEltList); 
				} /*NOTREACHED*/ break;
case 34:
# line 464 "./theta.y"
{ 
				  cmpyy_val.module = new ImplModule(0, 0, cmpyy_pvt[-1].implEltList); 
				} /*NOTREACHED*/ break;
case 35:
# line 470 "./theta.y"
{ cmpyy_val.implEltList = new ParseNodeList(cmpyy_pvt[-0].implElt); } /*NOTREACHED*/ break;
case 36:
# line 472 "./theta.y"
{ cmpyy_val.implEltList = new ParseNodeList(new ImplEquate(cmpyy_pvt[-0].equate)); } /*NOTREACHED*/ break;
case 37:
# line 474 "./theta.y"
{ cmpyy_val.implEltList = cmpyy_pvt[-1].implEltList;
				  cmpyy_val.implEltList->append(cmpyy_pvt[-0].implElt);
				} /*NOTREACHED*/ break;
case 38:
# line 478 "./theta.y"
{ cmpyy_val.implEltList = cmpyy_pvt[-1].implEltList;
				  cmpyy_val.implEltList->append(new ImplEquate(cmpyy_pvt[-0].equate));
				} /*NOTREACHED*/ break;
case 39:
# line 484 "./theta.y"
{ cmpyy_val.implElt = cmpyy_pvt[-0].routineDef; } /*NOTREACHED*/ break;
case 40:
# line 486 "./theta.y"
{ cmpyy_val.implElt = cmpyy_pvt[-0].classDef; } /*NOTREACHED*/ break;
case 41:
# line 490 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-9].id_, cmpyy_pvt[-0].classDef->get_classId())) {
				  cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  /*
				  TypeSpec *ts = ex2ts($5);
				  if (ts) { $10->set_deftype($5); }
				  */
				  cmpyy_pvt[-0].classDef->set_parms(cmpyy_pvt[-6].parmList);
				  cmpyy_pvt[-0].classDef->set_deftype(cmpyy_pvt[-5].typeSpec);
				  cmpyy_pvt[-0].classDef->set_inherits(cmpyy_pvt[-4].inherit);
				  cmpyy_pvt[-0].classDef->set_wheres(cmpyy_pvt[-3].restrictionList);
				  cmpyy_pvt[-0].classDef->set_exports(cmpyy_pvt[-2].export);
				  cmpyy_pvt[-0].classDef->set_hides(cmpyy_pvt[-1].idList);
				  cmpyy_pvt[-0].classDef->set_immutable(0);
					}
				  else {cmpyy_error("mismatching ids"); YYABORT;}
				} /*NOTREACHED*/ break;
case 42:
# line 509 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-10].id_, cmpyy_pvt[-0].classDef->get_classId())) {
				  cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  /*
				  TypeSpec *ts = ex2ts($5);
				  if (ts) { $10->set_deftype($5); }
				  */
				  cmpyy_pvt[-0].classDef->set_parms(cmpyy_pvt[-6].parmList);
				  cmpyy_pvt[-0].classDef->set_deftype(cmpyy_pvt[-5].typeSpec);
				  cmpyy_pvt[-0].classDef->set_inherits(cmpyy_pvt[-4].inherit);
				  cmpyy_pvt[-0].classDef->set_wheres(cmpyy_pvt[-3].restrictionList);
				  cmpyy_pvt[-0].classDef->set_exports(cmpyy_pvt[-2].export);
				  cmpyy_pvt[-0].classDef->set_hides(cmpyy_pvt[-1].idList);
				  cmpyy_pvt[-0].classDef->set_immutable(1);
					}
				  else {cmpyy_error("mismatching ids"); YYABORT;}
				} /*NOTREACHED*/ break;
case 43:
# line 528 "./theta.y"
{ cmpyy_val.idList = cmpyy_pvt[-0].idList; } /*NOTREACHED*/ break;
case 44:
# line 530 "./theta.y"
{ cmpyy_val.idList = 0; } /*NOTREACHED*/ break;
case 45:
# line 535 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_equates(cmpyy_pvt[-3].equateList);
				  cmpyy_pvt[-0].classDef->set_decl(cmpyy_pvt[-2].declList);
				  cmpyy_pvt[-0].classDef->set_classElts(cmpyy_pvt[-1].methodOrOpDefList);
				} /*NOTREACHED*/ break;
case 46:
# line 541 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_equates(cmpyy_pvt[-2].equateList);
				  cmpyy_pvt[-0].classDef->set_decl(cmpyy_pvt[-1].declList);
				} /*NOTREACHED*/ break;
case 47:
# line 546 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_decl(cmpyy_pvt[-2].declList);
				  cmpyy_pvt[-0].classDef->set_classElts(cmpyy_pvt[-1].methodOrOpDefList);
				} /*NOTREACHED*/ break;
case 48:
# line 551 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_decl(cmpyy_pvt[-1].declList);
				} /*NOTREACHED*/ break;
case 49:
# line 555 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-1].methodOrOpDefList->prepend(cmpyy_pvt[-2].methodOrOpDef);
				  cmpyy_pvt[-0].classDef->set_equates(cmpyy_pvt[-3].equateList);
				  cmpyy_pvt[-0].classDef->set_classElts(cmpyy_pvt[-1].methodOrOpDefList);
				} /*NOTREACHED*/ break;
case 50:
# line 561 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_equates(cmpyy_pvt[-2].equateList);
				  cmpyy_pvt[-0].classDef->set_classElts(new ParseNodeList(cmpyy_pvt[-1].methodOrOpDef));
				} /*NOTREACHED*/ break;
case 51:
# line 566 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_equates(cmpyy_pvt[-1].equateList);
				} /*NOTREACHED*/ break;
case 52:
# line 582 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-1].methodOrOpDefList->prepend(cmpyy_pvt[-2].methodOrOpDef);
				  cmpyy_pvt[-0].classDef->set_classElts(cmpyy_pvt[-1].methodOrOpDefList);
				} /*NOTREACHED*/ break;
case 53:
# line 587 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef;
				  cmpyy_pvt[-0].classDef->set_classElts(new ParseNodeList(cmpyy_pvt[-1].methodOrOpDef));
				} /*NOTREACHED*/ break;
case 54:
# line 591 "./theta.y"
{ cmpyy_val.classDef = cmpyy_pvt[-0].classDef; } /*NOTREACHED*/ break;
case 55:
# line 595 "./theta.y"
{ cmpyy_val.classDef = new ClassDef(cmpyy_pvt[-0].id_,0,0,0,0,0,0,0,0,0,0); } /*NOTREACHED*/ break;
case 56:
# line 599 "./theta.y"
{ cmpyy_val.methodOrOpDefList = new ParseNodeList(cmpyy_pvt[-0].methodOrOpDef); } /*NOTREACHED*/ break;
case 57:
# line 601 "./theta.y"
{ cmpyy_val.methodOrOpDefList = new ParseNodeList(new ImplEquate(cmpyy_pvt[-0].equate)); } /*NOTREACHED*/ break;
case 58:
# line 603 "./theta.y"
{ cmpyy_val.methodOrOpDefList = cmpyy_pvt[-1].methodOrOpDefList;
                                  cmpyy_val.methodOrOpDefList->append(cmpyy_pvt[-0].methodOrOpDef);
                                } /*NOTREACHED*/ break;
case 59:
# line 607 "./theta.y"
{ cmpyy_val.methodOrOpDefList = cmpyy_pvt[-1].methodOrOpDefList;
                                  cmpyy_val.methodOrOpDefList->append(new ImplEquate(cmpyy_pvt[-0].equate));
                                } /*NOTREACHED*/ break;
case 60:
# line 613 "./theta.y"
{ cmpyy_val.typeSpec = 0; } /*NOTREACHED*/ break;
case 61:
# line 615 "./theta.y"
{ cmpyy_val.typeSpec = cmpyy_pvt[-0].typeSpec; } /*NOTREACHED*/ break;
case 62:
# line 619 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.typeSpec = ts; } /*NOTREACHED*/ break;
case 63:
# line 625 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
				  if (!ids) {cmpyy_error("id list expected");YYABORT;}
				  TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.decl = new RegDecl(ids, ts); } /*NOTREACHED*/ break;
case 64:
# line 631 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
                                  if (!ids) {cmpyy_error("id list expected");YYABORT
;}
				  cmpyy_val.decl = new RegDecl(ids, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 65:
# line 636 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
                                  if (!ids) {cmpyy_error("id list expected");YYABORT
;}
				  cmpyy_val.decl = new RegDecl(ids, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 66:
# line 641 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-4].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  TypeSpec *ts = ex2ts(cmpyy_pvt[-2].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.decl = new ImplDecl(temp, ts, cmpyy_pvt[-0].id_, 0); } /*NOTREACHED*/ break;
case 67:
# line 647 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-4].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  cmpyy_val.decl = new ImplDecl(temp, cmpyy_pvt[-2].typeSpec, cmpyy_pvt[-0].id_, 0); } /*NOTREACHED*/ break;
case 68:
# line 651 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-4].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  cmpyy_val.decl = new ImplDecl(temp, cmpyy_pvt[-2].typeSpec, cmpyy_pvt[-0].id_, 0); } /*NOTREACHED*/ break;
case 69:
# line 655 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-6].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  TypeSpec *ts = ex2ts(cmpyy_pvt[-4].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.decl = new ImplDecl(temp, ts, cmpyy_pvt[-2].id_, cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 70:
# line 661 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-6].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  cmpyy_val.decl = new ImplDecl(temp, cmpyy_pvt[-4].typeSpec, cmpyy_pvt[-2].id_, cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 71:
# line 665 "./theta.y"
{ Id *temp = exl2id(cmpyy_pvt[-6].exprList);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
                                  cmpyy_val.decl = new ImplDecl(temp, cmpyy_pvt[-4].typeSpec, cmpyy_pvt[-2].id_, cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 72:
# line 671 "./theta.y"
{ cmpyy_val.declList = new ParseNodeList(cmpyy_pvt[-0].decl); } /*NOTREACHED*/ break;
case 73:
# line 673 "./theta.y"
{ cmpyy_val.declList = cmpyy_pvt[-1].declList;
				  cmpyy_val.declList->append(cmpyy_pvt[-0].decl);
				} /*NOTREACHED*/ break;
case 74:
# line 679 "./theta.y"
{ cmpyy_val.export = 0; } /*NOTREACHED*/ break;
case 75:
# line 681 "./theta.y"
{ cmpyy_val.export = new Export(cmpyy_pvt[-0].idList);
				} /*NOTREACHED*/ break;
case 76:
# line 686 "./theta.y"
{ cmpyy_val.inherit = 0; } /*NOTREACHED*/ break;
case 77:
# line 688 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.inherit = new Inherit(ts); } /*NOTREACHED*/ break;
case 78:
# line 694 "./theta.y"
{ cmpyy_val.methodOrOpDef = new MethodOrOpDef(FALSE, FALSE, cmpyy_pvt[-0].routineDef); } /*NOTREACHED*/ break;
case 79:
# line 696 "./theta.y"
{ cmpyy_val.methodOrOpDef = new MethodOrOpDef(TRUE, FALSE, cmpyy_pvt[-0].routineDef);
				} /*NOTREACHED*/ break;
case 80:
# line 701 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-3].routineIntf->get_id(), cmpyy_pvt[-0].id_))
				  	cmpyy_val.routineDef = new RoutineDef(cmpyy_pvt[-3].routineIntf, cmpyy_pvt[-2].body);
				  else {cmpyy_error("mismatching ids");YYABORT;}
				} /*NOTREACHED*/ break;
case 81:
# line 706 "./theta.y"
{ if (!match_ids(cmpyy_pvt[-3].routineIntf->get_id(), cmpyy_pvt[-0].id_))
				  	cmpyy_val.routineDef = new RoutineDef(cmpyy_pvt[-3].routineIntf, cmpyy_pvt[-2].body);
				  else {cmpyy_error("mismatching ids");YYABORT;}
				} /*NOTREACHED*/ break;
case 82:
# line 713 "./theta.y"
{ cmpyy_val.body = new Body(cmpyy_pvt[-1].equateList, cmpyy_pvt[-0].stmtList);
				} /*NOTREACHED*/ break;
case 83:
# line 716 "./theta.y"
{ cmpyy_val.body = new Body(0, cmpyy_pvt[-0].stmtList);
				} /*NOTREACHED*/ break;
case 84:
# line 721 "./theta.y"
{ cmpyy_val.stmtList = 0; } /*NOTREACHED*/ break;
case 85:
# line 723 "./theta.y"
{ cmpyy_val.stmtList = cmpyy_pvt[-0].stmtList; } /*NOTREACHED*/ break;
case 86:
# line 727 "./theta.y"
{ cmpyy_val.stmtList = new ParseNodeList(cmpyy_pvt[-0].stmt); 
				  /* $1->print(3); */
				} /*NOTREACHED*/ break;
case 87:
# line 731 "./theta.y"
{ cmpyy_val.stmtList = cmpyy_pvt[-1].stmtList;
				  cmpyy_val.stmtList->append(cmpyy_pvt[-0].stmt);
				} /*NOTREACHED*/ break;
case 88:
# line 737 "./theta.y"
{ cmpyy_val.stmt = new DeclStmt(cmpyy_pvt[-0].decl);} /*NOTREACHED*/ break;
case 89:
# line 739 "./theta.y"
{ Expr *ex;
				  ParseNodeList l = *cmpyy_pvt[-2].declList;

				/* decl [,decl]* := invoc */
				  if (cmpyy_pvt[-0].expr->tag() == Expr::InvocExprT) {
				      ex = cmpyy_pvt[-0].expr;
				      cmpyy_val.stmt = new InitVarInvoke
					(cmpyy_pvt[-2].declList, ((InvocExpr*) ex)->get_invoc());
					}
	
				/* id : type_spec := expr */
				  else {
				    RegDecl *d = (RegDecl *) l(l.first());

				    if (l.length() > 1)
				      {cmpyy_error("Illegal initialization");
				       YYABORT;}
				    else {
				      if (d->get_ids()->length() > 1)
					{cmpyy_error("Illegal initialization");
					YYABORT;}
				      else
					cmpyy_val.stmt = new InitVarExpr(d, cmpyy_pvt[-0].expr); 
				    }
				  }
				} /*NOTREACHED*/ break;
case 90:
# line 770 "./theta.y"
{ ParseNodeList *lhs = exl2lhs(cmpyy_pvt[-2].exprList);
				  cmpyy_val.stmt = new AssignExprStmt(lhs, cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 91:
# line 773 "./theta.y"
{ Invoc *inv = ex2inv(cmpyy_pvt[-0].expr);
				  if (!inv) {cmpyy_error("inv expected");YYABORT;}
				  cmpyy_val.stmt = new InvokeStmt(inv);} /*NOTREACHED*/ break;
case 92:
# line 777 "./theta.y"
{ cmpyy_val.stmt = new WhileStmt(cmpyy_pvt[-3].expr, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 93:
# line 779 "./theta.y"
{ cmpyy_val.stmt = new IfStmt(cmpyy_pvt[-4].expr, cmpyy_pvt[-2].body, cmpyy_pvt[-1].elseIfList, 0); } /*NOTREACHED*/ break;
case 94:
# line 781 "./theta.y"
{ cmpyy_val.stmt = new IfStmt(cmpyy_pvt[-6].expr, cmpyy_pvt[-4].body, cmpyy_pvt[-3].elseIfList, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 95:
# line 783 "./theta.y"
{  cmpyy_val.stmt = new ForStmt(cmpyy_pvt[-5].idList, cmpyy_pvt[-3].invoc, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 96:
# line 785 "./theta.y"
{ cmpyy_val.stmt = new DeclForStmt(cmpyy_pvt[-5].declList, cmpyy_pvt[-3].invoc, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 97:
# line 787 "./theta.y"
{ cmpyy_val.stmt = new ReturnStmt(cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 98:
# line 789 "./theta.y"
{ cmpyy_val.stmt = new Yield(cmpyy_pvt[-1].exprList); } /*NOTREACHED*/ break;
case 99:
# line 791 "./theta.y"
{ cmpyy_val.stmt = new SignalStmt(cmpyy_pvt[-1].id_, cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 100:
# line 793 "./theta.y"
{ cmpyy_val.stmt = new Exit(cmpyy_pvt[-1].id_, cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 101:
# line 795 "./theta.y"
{ cmpyy_val.stmt = new Stmt(Stmt::BreakT); } /*NOTREACHED*/ break;
case 102:
# line 797 "./theta.y"
{ cmpyy_val.stmt = new Stmt(Stmt::ContinueT); } /*NOTREACHED*/ break;
case 103:
# line 799 "./theta.y"
{ cmpyy_val.stmt = cmpyy_pvt[-0].blockStmt; } /*NOTREACHED*/ break;
case 104:
# line 801 "./theta.y"
{ cmpyy_val.stmt = new ResignalStmt(cmpyy_pvt[-2].stmt, cmpyy_pvt[-0].idList); } /*NOTREACHED*/ break;
case 105:
# line 804 "./theta.y"
{ cmpyy_val.stmt = new ExceptStmt(cmpyy_pvt[-7].stmt, cmpyy_pvt[-5].exWhenArmList, cmpyy_pvt[-3].decl, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 106:
# line 806 "./theta.y"
{ cmpyy_val.stmt = new ExceptStmt(cmpyy_pvt[-3].stmt, cmpyy_pvt[-1].exWhenArmList, 0, 0); } /*NOTREACHED*/ break;
case 107:
# line 808 "./theta.y"
{ cmpyy_val.stmt = new Tagcase(cmpyy_pvt[-5].expr, cmpyy_pvt[-4].tagWhenArmList, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 108:
# line 810 "./theta.y"
{ cmpyy_val.stmt = new Tagcase(cmpyy_pvt[-2].expr, cmpyy_pvt[-1].tagWhenArmList, 0); } /*NOTREACHED*/ break;
case 109:
# line 812 "./theta.y"
{ cmpyy_val.stmt = new Typecase(cmpyy_pvt[-5].expr, cmpyy_pvt[-4].typeWhenArmList, cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 110:
# line 814 "./theta.y"
{ cmpyy_val.stmt = new Typecase(cmpyy_pvt[-2].expr, cmpyy_pvt[-1].typeWhenArmList, 0); } /*NOTREACHED*/ break;
case 111:
# line 817 "./theta.y"
{ cmpyy_val.stmt = cmpyy_pvt[-0].init; } /*NOTREACHED*/ break;
case 112:
# line 819 "./theta.y"
{ cmpyy_val.stmt = cmpyy_pvt[-3].init; cmpyy_pvt[-3].init->set_body(cmpyy_pvt[-1].body); 	} /*NOTREACHED*/ break;
case 113:
# line 823 "./theta.y"
{ cmpyy_val.declList = new ParseNodeList(cmpyy_pvt[-0].decl); } /*NOTREACHED*/ break;
case 114:
# line 825 "./theta.y"
{ cmpyy_val.declList = cmpyy_pvt[-2].declList; cmpyy_val.declList->append(cmpyy_pvt[-0].decl); } /*NOTREACHED*/ break;
case 115:
# line 830 "./theta.y"
{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {cmpyy_error("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl(cmpyy_pvt[-2].exprList);
				    if (!idl) {cmpyy_error("idl expected");YYABORT;}
				    TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				    if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				    cmpyy_val.decl = new RegDecl(idl, ts);
				} /*NOTREACHED*/ break;
case 116:
# line 846 "./theta.y"
{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {cmpyy_error("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl(cmpyy_pvt[-2].exprList);
				    if (!idl) {cmpyy_error("idl expected");YYABORT;}
				    cmpyy_val.decl = new RegDecl(idl, cmpyy_pvt[-0].typeSpec);
				} /*NOTREACHED*/ break;
case 117:
# line 860 "./theta.y"
{   /* ParseNodeList l = *$1;
				    ParseNodeList *idList = new ParseNodeList();
				    for (Pix p = l.first(); p; l.next(p)) {
					IdOrIvar *iv = (IdOrIvar *) l(p);
					if (iv->get_primary() != 0) 
					    {cmpyy_error("Ivar given where id expected");
					     YYABORT;}
					idList->append(iv->get_id());
				    } */
				    ParseNodeList *idl = exl2idl(cmpyy_pvt[-2].exprList);
				    if (!idl) {cmpyy_error("idl expected");YYABORT;}
				    cmpyy_val.decl = new RegDecl(idl, cmpyy_pvt[-0].typeSpec);
				} /*NOTREACHED*/ break;
case 118:
# line 876 "./theta.y"
{ cmpyy_val.init = new Init(cmpyy_pvt[-1].fieldInitList, 0, 0); } /*NOTREACHED*/ break;
case 119:
# line 878 "./theta.y"
{ cmpyy_val.init = new Init(cmpyy_pvt[-3].fieldInitList, cmpyy_pvt[-1].invoc, 0); } /*NOTREACHED*/ break;
case 120:
# line 880 "./theta.y"
{ cmpyy_val.init = new Init(0, cmpyy_pvt[-1].invoc, 0); } /*NOTREACHED*/ break;
case 121:
# line 882 "./theta.y"
{ cmpyy_val.init = new Init(0, 0, 0); } /*NOTREACHED*/ break;
case 122:
# line 886 "./theta.y"
{ cmpyy_val.fieldInitList = new ParseNodeList(cmpyy_pvt[-0].fieldInit); } /*NOTREACHED*/ break;
case 123:
# line 888 "./theta.y"
{ cmpyy_val.fieldInitList = cmpyy_pvt[-2].fieldInitList;
				  cmpyy_val.fieldInitList->append(cmpyy_pvt[-0].fieldInit);
				} /*NOTREACHED*/ break;
case 124:
# line 894 "./theta.y"
{ cmpyy_val.fieldInit = new FieldInit(cmpyy_pvt[-2].id_, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 125:
# line 898 "./theta.y"
{ cmpyy_val.blockStmt = new BlockStmt(cmpyy_pvt[-1].body); } /*NOTREACHED*/ break;
case 126:
# line 902 "./theta.y"
{ cmpyy_val.exWhenArmList = 0; } /*NOTREACHED*/ break;
case 127:
# line 904 "./theta.y"
{ cmpyy_val.exWhenArmList = cmpyy_pvt[-0].exWhenArmList; } /*NOTREACHED*/ break;
case 128:
# line 908 "./theta.y"
{ cmpyy_val.exWhenArmList = new ParseNodeList(cmpyy_pvt[-0].exWhenArm); } /*NOTREACHED*/ break;
case 129:
# line 910 "./theta.y"
{ cmpyy_val.exWhenArmList = cmpyy_pvt[-1].exWhenArmList; cmpyy_val.exWhenArmList->append(cmpyy_pvt[-0].exWhenArm);} /*NOTREACHED*/ break;
case 130:
# line 914 "./theta.y"
{ cmpyy_val.exWhenArm = new ExWhenArm(cmpyy_pvt[-2].idList, 0, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 131:
# line 916 "./theta.y"
{ cmpyy_val.exWhenArm = new ExWhenArm(cmpyy_pvt[-5].idList, cmpyy_pvt[-3].declList, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 132:
# line 920 "./theta.y"
{ cmpyy_val.decl = 0; } /*NOTREACHED*/ break;
case 133:
# line 922 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-1].expr);
				  if (!ts) {cmpyy_error("typespec expectedd");YYABORT;}
				  cmpyy_val.decl = new RegDecl(new ParseNodeList(cmpyy_pvt[-3].id_),
					 ts); } /*NOTREACHED*/ break;
case 134:
# line 927 "./theta.y"
{ cmpyy_val.decl = new RegDecl(new ParseNodeList(cmpyy_pvt[-3].id_), 
					cmpyy_pvt[-1].typeSpec); } /*NOTREACHED*/ break;
case 135:
# line 930 "./theta.y"
{ cmpyy_val.decl = new RegDecl(new ParseNodeList(cmpyy_pvt[-3].id_),
					 cmpyy_pvt[-1].typeSpec); } /*NOTREACHED*/ break;
case 136:
# line 938 "./theta.y"
{ RoutineId *rid = ex2rid(cmpyy_pvt[-3].expr);
				  if (!rid) {cmpyy_error("rid expected");YYABORT;}
				  cmpyy_val.invoc = cmpyy_pvt[-1].invoc; cmpyy_pvt[-1].invoc->set_routineId(rid);} /*NOTREACHED*/ break;
case 137:
# line 944 "./theta.y"
{ cmpyy_val.tagWhenArmList = new ParseNodeList(cmpyy_pvt[-0].tagWhenArm); } /*NOTREACHED*/ break;
case 138:
# line 946 "./theta.y"
{ cmpyy_val.tagWhenArmList = cmpyy_pvt[-1].tagWhenArmList;
				  cmpyy_val.tagWhenArmList->append(cmpyy_pvt[-0].tagWhenArm);
				} /*NOTREACHED*/ break;
case 139:
# line 952 "./theta.y"
{ cmpyy_val.typeWhenArmList = new ParseNodeList(cmpyy_pvt[-0].typeWhenArm); } /*NOTREACHED*/ break;
case 140:
# line 954 "./theta.y"
{ cmpyy_val.typeWhenArmList = cmpyy_pvt[-1].typeWhenArmList;
				  cmpyy_val.typeWhenArmList->append(cmpyy_pvt[-0].typeWhenArm);
				} /*NOTREACHED*/ break;
case 141:
# line 961 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-2].expr);
				  if (ts) cmpyy_val.typeWhenArm = new TypeWhenArm(ts, 0, cmpyy_pvt[-0].body); 
				  else { cmpyy_val.typeWhenArm = ex2twa(cmpyy_pvt[-2].expr, cmpyy_pvt[-0].body); }
				} /*NOTREACHED*/ break;
case 142:
# line 966 "./theta.y"
{ cmpyy_val.typeWhenArm = new TypeWhenArm(cmpyy_pvt[-5].typeSpec, cmpyy_pvt[-3].id_, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 143:
# line 968 "./theta.y"
{ cmpyy_val.typeWhenArm = new TypeWhenArm(cmpyy_pvt[-5].typeSpec, cmpyy_pvt[-3].id_, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 144:
# line 970 "./theta.y"
{ cmpyy_val.typeWhenArm = new TypeWhenArm(cmpyy_pvt[-2].typeSpec, 0, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 145:
# line 972 "./theta.y"
{ cmpyy_val.typeWhenArm = new TypeWhenArm(cmpyy_pvt[-2].typeSpec, 0, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 146:
# line 976 "./theta.y"
{ cmpyy_val.tagWhenArm = new TagWhenArm(cmpyy_pvt[-3].idList, cmpyy_pvt[-2].decl, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 147:
# line 980 "./theta.y"
{ cmpyy_val.elseIfList = 0; } /*NOTREACHED*/ break;
case 148:
# line 982 "./theta.y"
{ cmpyy_val.elseIfList = cmpyy_pvt[-0].elseIfList; } /*NOTREACHED*/ break;
case 149:
# line 986 "./theta.y"
{ cmpyy_val.elseIfList = new ParseNodeList(cmpyy_pvt[-0].elseIf); } /*NOTREACHED*/ break;
case 150:
# line 988 "./theta.y"
{ cmpyy_val.elseIfList = cmpyy_pvt[-1].elseIfList;
				  cmpyy_val.elseIfList->append(cmpyy_pvt[-0].elseIf);
				} /*NOTREACHED*/ break;
case 151:
# line 994 "./theta.y"
{ cmpyy_val.elseIf = new ElseIf(cmpyy_pvt[-2].expr, cmpyy_pvt[-0].body); } /*NOTREACHED*/ break;
case 152:
# line 998 "./theta.y"
{ cmpyy_val.exprList = 0; } /*NOTREACHED*/ break;
case 153:
# line 1000 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-1].exprList; } /*NOTREACHED*/ break;
case 154:
# line 1004 "./theta.y"
{ cmpyy_val.exprList = 0; } /*NOTREACHED*/ break;
case 155:
# line 1006 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-0].exprList; } /*NOTREACHED*/ break;
case 156:
# line 1010 "./theta.y"
{ cmpyy_val.exprList = 0; } /*NOTREACHED*/ break;
case 157:
# line 1012 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-1].exprList; } /*NOTREACHED*/ break;
case 158:
# line 1016 "./theta.y"
{ cmpyy_val.exprList = new ParseNodeList(cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 159:
# line 1018 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-2].exprList;
				  cmpyy_val.exprList->append(cmpyy_pvt[-0].expr);
				} /*NOTREACHED*/ break;
case 160:
# line 1024 "./theta.y"
{ cmpyy_val.declList = cmpyy_pvt[-1].declList; } /*NOTREACHED*/ break;
case 161:
# line 1028 "./theta.y"
{ cmpyy_val.declList = tsl2dl(cmpyy_pvt[-1].typeSpecList); } /*NOTREACHED*/ break;
case 162:
# line 1030 "./theta.y"
{ cmpyy_val.declList = 0; } /*NOTREACHED*/ break;
case 163:
# line 1034 "./theta.y"
{ cmpyy_val.declList = 0; } /*NOTREACHED*/ break;
case 164:
# line 1036 "./theta.y"
{ 
				   ParseNodeList l = *cmpyy_pvt[-0].declList;
				   
				   for (Pix p = l.first(); p; l.next(p)) {
				     if (l(p) == l.rear()) continue;
				     Decl *d = (Decl *) l(p);
				     if (d->tag() == Decl::VarArgsDeclT) 
				       {cmpyy_error("Variable arguments may only appear at the end of the argument list");
				        YYABORT;}
				    }
				  cmpyy_val.declList = cmpyy_pvt[-0].declList; 
				} /*NOTREACHED*/ break;
case 165:
# line 1051 "./theta.y"
{ cmpyy_val.declList = new ParseNodeList(cmpyy_pvt[-0].decl); } /*NOTREACHED*/ break;
case 166:
# line 1053 "./theta.y"
{ cmpyy_val.declList = cmpyy_pvt[-2].declList;
				  cmpyy_val.declList->append(cmpyy_pvt[-0].decl);
				} /*NOTREACHED*/ break;
case 167:
# line 1059 "./theta.y"
{ cmpyy_val.declList = new ParseNodeList(cmpyy_pvt[-0].decl); } /*NOTREACHED*/ break;
case 168:
# line 1061 "./theta.y"
{ cmpyy_val.declList = cmpyy_pvt[-2].declList;
				  cmpyy_val.declList->append(cmpyy_pvt[-0].decl);
				} /*NOTREACHED*/ break;
case 169:
# line 1067 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.decl = new RegDecl(cmpyy_pvt[-2].idList, ts); } /*NOTREACHED*/ break;
case 170:
# line 1071 "./theta.y"
{ cmpyy_val.decl = new RegDecl(cmpyy_pvt[-2].idList, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 171:
# line 1073 "./theta.y"
{ cmpyy_val.decl = new RegDecl(cmpyy_pvt[-2].idList, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 172:
# line 1077 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
                                  if (!ids) {cmpyy_error("id list expected");YYABORT
;}
				  cmpyy_val.decl = new RegDecl(ids, ts); } /*NOTREACHED*/ break;
case 173:
# line 1084 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
                                  if (!ids) {cmpyy_error("id list expected");YYABORT
;}
				  cmpyy_val.decl = new RegDecl(ids, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 174:
# line 1089 "./theta.y"
{ ParseNodeList *ids = exl2idl(cmpyy_pvt[-2].exprList);
                                  if (!ids) {cmpyy_error("id list expected");YYABORT
;}
				  cmpyy_val.decl = new RegDecl(ids, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 175:
# line 1096 "./theta.y"
{ cmpyy_val.typeSpecList = 0; } /*NOTREACHED*/ break;
case 176:
# line 1098 "./theta.y"
{ cmpyy_val.typeSpecList = cmpyy_pvt[-1].typeSpecList; } /*NOTREACHED*/ break;
case 177:
# line 1102 "./theta.y"
{ cmpyy_val.typeSpecList = cmpyy_pvt[-1].typeSpecList; } /*NOTREACHED*/ break;
case 178:
# line 1106 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-1].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.typeSpecList = new ParseNodeList(ts); } /*NOTREACHED*/ break;
case 179:
# line 1110 "./theta.y"
{ cmpyy_val.typeSpecList = new ParseNodeList(cmpyy_pvt[-1].typeSpec); } /*NOTREACHED*/ break;
case 180:
# line 1114 "./theta.y"
{ cmpyy_val.exceptionList = 0; } /*NOTREACHED*/ break;
case 181:
# line 1116 "./theta.y"
{ cmpyy_val.exceptionList = cmpyy_pvt[-1].exceptionList; } /*NOTREACHED*/ break;
case 182:
# line 1120 "./theta.y"
{ cmpyy_val.exceptionList = new ParseNodeList(cmpyy_pvt[-0].exception); } /*NOTREACHED*/ break;
case 183:
# line 1122 "./theta.y"
{ cmpyy_val.exceptionList = cmpyy_pvt[-2].exceptionList;
				  cmpyy_val.exceptionList->append(cmpyy_pvt[-0].exception);
				} /*NOTREACHED*/ break;
case 184:
# line 1128 "./theta.y"
{ cmpyy_val.exception = new Exception(cmpyy_pvt[-1].id_, cmpyy_pvt[-0].typeSpecList); } /*NOTREACHED*/ break;
case 185:
# line 1132 "./theta.y"
{ cmpyy_val.typeSpecList = cmpyy_pvt[-1].typeSpecList; } /*NOTREACHED*/ break;
case 186:
# line 1134 "./theta.y"
{ cmpyy_val.typeSpecList = 0; } /*NOTREACHED*/ break;
case 187:
# line 1138 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
                                  if (!ts) {cmpyy_error("typespec expected"); 
					    YYABORT;}
				  cmpyy_val.typeSpecList = new ParseNodeList(ts); } /*NOTREACHED*/ break;
case 188:
# line 1143 "./theta.y"
{ cmpyy_val.typeSpecList = new ParseNodeList(cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 189:
# line 1145 "./theta.y"
{ cmpyy_val.typeSpecList = new ParseNodeList(cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 190:
# line 1147 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
                                  if (!ts) {cmpyy_error("typespec expected"); 
                                            YYABORT;}
				  cmpyy_val.typeSpecList = cmpyy_pvt[-2].typeSpecList; cmpyy_val.typeSpecList->append(ts); } /*NOTREACHED*/ break;
case 191:
# line 1152 "./theta.y"
{ cmpyy_val.typeSpecList = cmpyy_pvt[-2].typeSpecList; cmpyy_val.typeSpecList->append(cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 192:
# line 1154 "./theta.y"
{ cmpyy_val.typeSpecList = cmpyy_pvt[-2].typeSpecList; cmpyy_val.typeSpecList->append(cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 193:
# line 1158 "./theta.y"
{ cmpyy_val.restrictionList = 0; } /*NOTREACHED*/ break;
case 194:
# line 1160 "./theta.y"
{ cmpyy_val.restrictionList = cmpyy_pvt[-0].restrictionList; } /*NOTREACHED*/ break;
case 195:
# line 1164 "./theta.y"
{ cmpyy_val.restrictionList = cmpyy_pvt[-0].restrictionList; } /*NOTREACHED*/ break;
case 196:
# line 1168 "./theta.y"
{ cmpyy_val.restrictionList = new ParseNodeList(new Restriction(cmpyy_pvt[-2].id_,
					new ParseNodeList(cmpyy_pvt[-0].routineIntf)));
				  cmpyy_pvt[-0].routineIntf->set_id(cmpyy_pvt[-1].id_);
				} /*NOTREACHED*/ break;
case 197:
# line 1174 "./theta.y"
{ cmpyy_val.restrictionList = cmpyy_pvt[-0].restrictionList;
				  cmpyy_pvt[-0].restrictionList->prepend(new Restriction(cmpyy_pvt[-3].id_,
					new ParseNodeList(cmpyy_pvt[-1].routineIntf)));
				  cmpyy_pvt[-1].routineIntf->set_id(cmpyy_pvt[-2].id_);
				} /*NOTREACHED*/ break;
case 198:
# line 1182 "./theta.y"
{ cmpyy_val.restrictionList = new ParseNodeList(cmpyy_pvt[-0].restriction); } /*NOTREACHED*/ break;
case 199:
# line 1184 "./theta.y"
{ cmpyy_val.restrictionList = cmpyy_pvt[-1].restrictionList; cmpyy_pvt[-1].restrictionList->append(cmpyy_pvt[-0].restriction); } /*NOTREACHED*/ break;
case 200:
# line 1188 "./theta.y"
{ cmpyy_val.restriction = new Restriction(get_where_id(),
					new ParseNodeList(cmpyy_pvt[-0].routineIntf));
				  cmpyy_pvt[-0].routineIntf->set_id(cmpyy_pvt[-1].id_);
				} /*NOTREACHED*/ break;
case 201:
# line 1193 "./theta.y"
{ cmpyy_val.restriction = new Restriction(cmpyy_pvt[-2].id_,
					new ParseNodeList(cmpyy_pvt[-0].routineIntf));
				  cmpyy_pvt[-0].routineIntf->set_id(cmpyy_pvt[-1].id_);
				} /*NOTREACHED*/ break;
case 202:
# line 1200 "./theta.y"
{ cmpyy_val.id_ = cmpyy_pvt[-1].id_ ; save_where_id(cmpyy_pvt[-1].id_); } /*NOTREACHED*/ break;
case 203:
# line 1205 "./theta.y"
{ cmpyy_val.superInfoList = cmpyy_pvt[-0].superInfoList; } /*NOTREACHED*/ break;
case 204:
# line 1207 "./theta.y"
{ cmpyy_val.superInfoList = 0; } /*NOTREACHED*/ break;
case 205:
# line 1211 "./theta.y"
{ cmpyy_val.superInfoList = cmpyy_pvt[-0].superInfoList; } /*NOTREACHED*/ break;
case 206:
# line 1215 "./theta.y"
{ cmpyy_val.superInfoList = new ParseNodeList(cmpyy_pvt[-0].superInfo); } /*NOTREACHED*/ break;
case 207:
# line 1217 "./theta.y"
{ cmpyy_val.superInfoList = cmpyy_pvt[-2].superInfoList;
				  cmpyy_val.superInfoList->append(cmpyy_pvt[-0].superInfo);
				} /*NOTREACHED*/ break;
case 208:
# line 1223 "./theta.y"
{ cmpyy_val.superInfo = new SuperInfo(new SimpleTypeSpec(new TypeName(cmpyy_pvt[-0].id_)), 0); } /*NOTREACHED*/ break;
case 209:
# line 1225 "./theta.y"
{ cmpyy_val.superInfo = new SuperInfo(new ParamTypeSpec(
						new TypeName(cmpyy_pvt[-1].id_), cmpyy_pvt[-0].actualParmList), NULL);} /*NOTREACHED*/ break;
case 210:
# line 1230 "./theta.y"
{ cmpyy_val.equateList = new ParseNodeList(cmpyy_pvt[-0].equate); } /*NOTREACHED*/ break;
case 211:
# line 1232 "./theta.y"
{ cmpyy_val.equateList = cmpyy_pvt[-1].equateList;
				  cmpyy_val.equateList->append(cmpyy_pvt[-0].equate);
				} /*NOTREACHED*/ break;
case 212:
# line 1238 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (ts) cmpyy_val.equate = new TypeEquate(cmpyy_pvt[-2].id_, ts);
				  else cmpyy_val.equate = new ExprEquate(cmpyy_pvt[-2].id_, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 213:
# line 1242 "./theta.y"
{ cmpyy_val.equate = new TypeEquate(cmpyy_pvt[-2].id_, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 214:
# line 1244 "./theta.y"
{ cmpyy_val.equate = new TypeEquate(cmpyy_pvt[-2].id_, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 215:
# line 1249 "./theta.y"
{ cmpyy_val.parmList = cmpyy_pvt[-0].parmList; } /*NOTREACHED*/ break;
case 216:
# line 1251 "./theta.y"
{ cmpyy_val.parmList = 0; } /*NOTREACHED*/ break;
case 217:
# line 1255 "./theta.y"
{ cmpyy_val.parmList = cmpyy_pvt[-1].parmList; } /*NOTREACHED*/ break;
case 218:
# line 1259 "./theta.y"
{ cmpyy_val.parmList = new ParseNodeList(cmpyy_pvt[-0].parm); } /*NOTREACHED*/ break;
case 219:
# line 1261 "./theta.y"
{ cmpyy_val.parmList = cmpyy_pvt[-2].parmList;
                                  cmpyy_val.parmList->append(cmpyy_pvt[-0].parm);
                                } /*NOTREACHED*/ break;
case 220:
# line 1268 "./theta.y"
{ cmpyy_val.parm = new Parm(new ParseNodeList(cmpyy_pvt[-0].id_)); } /*NOTREACHED*/ break;
case 221:
# line 1273 "./theta.y"
{ cmpyy_val.idList = new ParseNodeList(cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 222:
# line 1275 "./theta.y"
{ cmpyy_val.idList = cmpyy_pvt[-2].idList;
				  cmpyy_val.idList->append(cmpyy_pvt[-0].id_);
				} /*NOTREACHED*/ break;
case 223:
# line 1281 "./theta.y"
{ cmpyy_val.typeSpec = new TaggedTypeSpec(cmpyy_pvt[-3].typeName, cmpyy_pvt[-1].fieldList); } /*NOTREACHED*/ break;
case 224:
# line 1285 "./theta.y"
{ cmpyy_val.typeSpec = new RoutineTypeSpec(cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 225:
# line 1287 "./theta.y"
{ cmpyy_val.typeSpec = new RoutineTypeSpec(cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 226:
# line 1289 "./theta.y"
{ cmpyy_val.typeSpec = new RoutineTypeSpec(cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 227:
# line 1291 "./theta.y"
{ cmpyy_val.typeSpec = new RoutineTypeSpec(cmpyy_pvt[-0].signature); } /*NOTREACHED*/ break;
case 228:
# line 1296 "./theta.y"
{ cmpyy_val.fieldList = new ParseNodeList(cmpyy_pvt[-0].field); } /*NOTREACHED*/ break;
case 229:
# line 1298 "./theta.y"
{ cmpyy_val.fieldList = cmpyy_pvt[-2].fieldList;
				  cmpyy_val.fieldList->append(cmpyy_pvt[-0].field); } /*NOTREACHED*/ break;
case 230:
# line 1303 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.field = new Field(cmpyy_pvt[-2].idList, ts); } /*NOTREACHED*/ break;
case 231:
# line 1307 "./theta.y"
{ cmpyy_val.field = new Field(cmpyy_pvt[-2].idList, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 232:
# line 1309 "./theta.y"
{ cmpyy_val.field = new Field(cmpyy_pvt[-2].idList, cmpyy_pvt[-0].typeSpec); } /*NOTREACHED*/ break;
case 233:
# line 1313 "./theta.y"
{ cmpyy_val.actualParmList = cmpyy_pvt[-1].actualParmList; } /*NOTREACHED*/ break;
case 234:
# line 1317 "./theta.y"
{ cmpyy_val.actualParmList = new ParseNodeList(cmpyy_pvt[-0].actualParm); } /*NOTREACHED*/ break;
case 235:
# line 1319 "./theta.y"
{ cmpyy_val.actualParmList = cmpyy_pvt[-2].actualParmList;
				  cmpyy_val.actualParmList->append(cmpyy_pvt[-0].actualParm);
				} /*NOTREACHED*/ break;
case 236:
# line 1325 "./theta.y"
{ TypeSpec *ts = ex2ts(cmpyy_pvt[-0].expr);
				  if (!ts) {cmpyy_error("typespec expected");YYABORT;}
				  cmpyy_val.actualParm = new ActualParm(ts, 0); } /*NOTREACHED*/ break;
case 237:
# line 1332 "./theta.y"
{ cmpyy_val.expr = cmpyy_pvt[-0].expr;} /*NOTREACHED*/ break;
case 238:
# line 1334 "./theta.y"
{ Id *tempid = ex2id(cmpyy_pvt[-0].expr);
				  if (!tempid) {cmpyy_error("id expected");YYABORT;}
				  cmpyy_val.expr = new DotExpr(cmpyy_pvt[-2].expr, tempid); } /*NOTREACHED*/ break;
case 239:
# line 1338 "./theta.y"
{ RoutineId *rid = ex2rid(cmpyy_pvt[-3].expr);
				  if (!rid) {cmpyy_error("rid expected");YYABORT;}
				  cmpyy_pvt[-1].invoc->set_routineId(rid);
				  cmpyy_val.expr = new InvocExpr(cmpyy_pvt[-1].invoc);} /*NOTREACHED*/ break;
case 240:
# line 1343 "./theta.y"
{ cmpyy_val.expr = new BracketRef(cmpyy_pvt[-3].expr, cmpyy_pvt[-1].exprList);} /*NOTREACHED*/ break;
case 241:
# line 1345 "./theta.y"
{ cmpyy_val.expr = new SelectorConstr(
					new ParamTypeSpec(
						new TypeName(ex2id(cmpyy_pvt[-4].expr)), 
						exl2apl(cmpyy_pvt[-2].exprList)),
					cmpyy_pvt[-0].init->get_fieldInits());} /*NOTREACHED*/ break;
case 242:
# line 1351 "./theta.y"
{ cmpyy_val.expr = cmpyy_pvt[-1].expr; } /*NOTREACHED*/ break;
case 243:
# line 1353 "./theta.y"
{ cmpyy_val.expr = new Unary(Unary::NotT, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 244:
# line 1355 "./theta.y"
{ cmpyy_val.expr = new Unary(Unary::MinusT, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 245:
# line 1357 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::PowerT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 246:
# line 1359 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::ModuloT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 247:
# line 1361 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::DividesT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 248:
# line 1363 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::TimesT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 249:
# line 1365 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::ConcatT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 250:
# line 1367 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::PlusT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 251:
# line 1369 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::MinusT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 252:
# line 1371 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::LTT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 253:
# line 1373 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::LTET, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 254:
# line 1375 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::EqualT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 255:
# line 1377 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::NotEqualT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 256:
# line 1379 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::GTET, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 257:
# line 1381 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::GTT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 258:
# line 1383 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::AndT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 259:
# line 1385 "./theta.y"
{  cmpyy_val.expr = new Binary(Binary::OrT, cmpyy_pvt[-2].expr, cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 260:
# line 1389 "./theta.y"
{ cmpyy_val.exprList = new ParseNodeList(cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 261:
# line 1391 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-2].exprList;
				  cmpyy_val.exprList->append(cmpyy_pvt[-0].expr);
				} /*NOTREACHED*/ break;
case 262:
# line 1397 "./theta.y"
{ cmpyy_val.expr = cmpyy_pvt[-0].expr; } /*NOTREACHED*/ break;
case 263:
# line 1406 "./theta.y"
{ cmpyy_val.expr = new InvocExpr(cmpyy_pvt[-0].invoc);} /*NOTREACHED*/ break;
case 264:
# line 1408 "./theta.y"
{ Id *temp = ex2id(cmpyy_pvt[-0].expr);
				  if (!temp) {cmpyy_error("id expected");YYABORT;}
				  cmpyy_val.expr = new DotExpr(cmpyy_pvt[-2].expr, temp); } /*NOTREACHED*/ break;
case 265:
# line 1412 "./theta.y"
{ cmpyy_val.expr = new BracketRef(cmpyy_pvt[-3].expr, cmpyy_pvt[-1].exprList); } /*NOTREACHED*/ break;
case 266:
# line 1415 "./theta.y"
{ cmpyy_val.expr = new SelectorConstr(
					new ParamTypeSpec(
						new TypeName(ex2id(cmpyy_pvt[-4].expr)), 
						exl2apl(cmpyy_pvt[-2].exprList)),
					cmpyy_pvt[-0].init->get_fieldInits());} /*NOTREACHED*/ break;
case 267:
# line 1423 "./theta.y"
{ cmpyy_val.exprList = new ParseNodeList(cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 268:
# line 1425 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-2].exprList;
				  cmpyy_val.exprList->append(cmpyy_pvt[-0].expr);
				} /*NOTREACHED*/ break;
case 269:
# line 1431 "./theta.y"
{ cmpyy_val.expr = new Expr(Expr::NilT); } /*NOTREACHED*/ break;
case 270:
# line 1433 "./theta.y"
{ cmpyy_val.expr = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 271:
# line 1435 "./theta.y"
{ cmpyy_val.expr = new IdExpr(cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 272:
# line 1437 "./theta.y"
{ cmpyy_val.expr = new SuperId(cmpyy_pvt[-0].id_); } /*NOTREACHED*/ break;
case 273:
# line 1439 "./theta.y"
{ cmpyy_val.expr = new Expr(Expr::SelfT); } /*NOTREACHED*/ break;
case 274:
# line 1441 "./theta.y"
{ cmpyy_val.expr = new Expr(Expr::NewT); } /*NOTREACHED*/ break;
case 275:
# line 1443 "./theta.y"
{ cmpyy_val.expr = new SelectorConstr(cmpyy_pvt[-3].typeSpec, cmpyy_pvt[-1].fieldInitList); } /*NOTREACHED*/ break;
case 276:
# line 1445 "./theta.y"
{ cmpyy_val.expr = new SelectorConstr(
				new SimpleTypeSpec(new TypeName(cmpyy_pvt[-1].id_)), 
					cmpyy_pvt[-0].init->get_fieldInits()); } /*NOTREACHED*/ break;
case 277:
# line 1449 "./theta.y"
{ cmpyy_val.expr = new BindingExpr(cmpyy_pvt[-0].binding); } /*NOTREACHED*/ break;
case 278:
# line 1460 "./theta.y"
{ 
				  cmpyy_val.binding = new Binding(cmpyy_pvt[-1].expr, 0, 0);
				} /*NOTREACHED*/ break;
case 279:
# line 1464 "./theta.y"
{ 
				  cmpyy_val.binding = new Binding(cmpyy_pvt[-2].expr, cmpyy_pvt[-1].bindingArgList, 0);
				} /*NOTREACHED*/ break;
case 280:
# line 1468 "./theta.y"
{ 
				  cmpyy_val.binding = new Binding(cmpyy_pvt[-3].expr, 0, cmpyy_pvt[-1].exprList);
				} /*NOTREACHED*/ break;
case 281:
# line 1472 "./theta.y"
{ 
				  cmpyy_val.binding = new Binding(cmpyy_pvt[-4].expr, cmpyy_pvt[-3].bindingArgList, cmpyy_pvt[-1].exprList);
				} /*NOTREACHED*/ break;
case 282:
# line 1478 "./theta.y"
{ cmpyy_val.bindingArgList = new ParseNodeList(cmpyy_pvt[-0].bindingArg); } /*NOTREACHED*/ break;
case 283:
# line 1480 "./theta.y"
{ cmpyy_val.bindingArgList = cmpyy_pvt[-2].bindingArgList;
				  cmpyy_val.bindingArgList->append(cmpyy_pvt[-0].bindingArg);
				} /*NOTREACHED*/ break;
case 284:
# line 1486 "./theta.y"
{ cmpyy_val.bindingArg = new BindingArg(0); } /*NOTREACHED*/ break;
case 285:
# line 1488 "./theta.y"
{ cmpyy_val.bindingArg = new BindingArg(cmpyy_pvt[-0].expr); } /*NOTREACHED*/ break;
case 286:
# line 1492 "./theta.y"
{ cmpyy_val.exprList = 0; } /*NOTREACHED*/ break;
case 287:
# line 1494 "./theta.y"
{ cmpyy_val.exprList = cmpyy_pvt[-0].exprList; } /*NOTREACHED*/ break;
case 288:
# line 1498 "./theta.y"
{ RoutineId *rid = ex2rid(cmpyy_pvt[-3].expr);
				  if (!rid) {cmpyy_error("rid expected");YYABORT;}
				  cmpyy_pvt[-1].invoc->set_routineId(rid);
				  cmpyy_val.invoc = cmpyy_pvt[-1].invoc; } /*NOTREACHED*/ break;
case 289:
# line 1505 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0,0,0); } /*NOTREACHED*/ break;
case 290:
# line 1507 "./theta.y"
{ cmpyy_val.invoc = cmpyy_pvt[-0].invoc; } /*NOTREACHED*/ break;
case 291:
# line 1511 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0, cmpyy_pvt[-0].exprList, 0); } /*NOTREACHED*/ break;
case 292:
# line 1513 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0, cmpyy_pvt[-2].exprList, new ParseNodeList()); } /*NOTREACHED*/ break;
case 293:
# line 1515 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0, cmpyy_pvt[-3].exprList, cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 294:
# line 1517 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0, 0, new ParseNodeList()); } /*NOTREACHED*/ break;
case 295:
# line 1519 "./theta.y"
{ cmpyy_val.invoc = new Invoc(0, 0, cmpyy_pvt[-0].exprList); } /*NOTREACHED*/ break;
case 296:
# line 1524 "./theta.y"
{ cmpyy_val.literal = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 297:
# line 1526 "./theta.y"
{ cmpyy_val.literal = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 298:
# line 1528 "./theta.y"
{ cmpyy_val.literal = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 299:
# line 1530 "./theta.y"
{ cmpyy_val.literal = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 300:
# line 1532 "./theta.y"
{ cmpyy_val.literal = cmpyy_pvt[-0].literal; } /*NOTREACHED*/ break;
case 301:
# line 1536 "./theta.y"
{ cmpyy_val.literal = new IntLiteral(cmpyy_lval.i); } /*NOTREACHED*/ break;
case 302:
# line 1540 "./theta.y"
{ cmpyy_val.literal = new RealLiteral(cmpyy_lval.r); } /*NOTREACHED*/ break;
case 303:
# line 1544 "./theta.y"
{ cmpyy_val.literal = new BoolLiteral(1); } /*NOTREACHED*/ break;
case 304:
# line 1546 "./theta.y"
{ cmpyy_val.literal = new BoolLiteral(0); } /*NOTREACHED*/ break;
case 305:
# line 1550 "./theta.y"
{ cmpyy_val.literal = new CharLiteral(cmpyy_lval.c); } /*NOTREACHED*/ break;
case 306:
# line 1554 "./theta.y"
{ cmpyy_val.literal = new StringLiteral(cmpyy_lval.s); } /*NOTREACHED*/ break;
case 307:
# line 1558 "./theta.y"
{ cmpyy_val.id_ = new Id(cmpyy_lval.s); } /*NOTREACHED*/ break;
case 308:
# line 1562 "./theta.y"
{ cmpyy_val.typeName = new TypeName(new Id(string_new("record"))); } /*NOTREACHED*/ break;
case 309:
# line 1564 "./theta.y"
{ cmpyy_val.typeName = new TypeName(new Id(string_new("struct"))); } /*NOTREACHED*/ break;
case 310:
# line 1566 "./theta.y"
{ cmpyy_val.typeName = new TypeName(new Id(string_new("oneof"))); } /*NOTREACHED*/ break;
case 311:
# line 1568 "./theta.y"
{ cmpyy_val.typeName = new TypeName(new Id(string_new("variant"))); } /*NOTREACHED*/ break;
}


	goto cmpyy_stack;		/* reset registers in driver code */
}
