// Copyright 1995 Barbara Liskov

#include <string.h>
#include "parse.h"
#include "types/class_class.h"
#include "types/any.h"
#include "types/vec.h"
#include "types/ptype.h"
#include "type_chk.h"
#include "types/type.h"
#include "types/type_def.h"
#include "types/class.h"
#include "types/objtype_class.h"
#include "types/pclass.h"
#include "types/pclass_class.h"
#include "types/method.h"
#include "types/vec_instns.h"
#include "types/param.h"
#include "types/param_class.h"

#define DEBUG 0
#define DEBUG1 0

extern string err_list;

char cmp_err_buf[1000];
void cmp_err_check_point();
void cmp_err_return_to_checkpoint();
extern "C" {
extern string simple_type_name(string type_name);
	}

/*
	This is the type checker.  It is far more magical
	than necessary, due to my having started off on the
	wrong foot.  It should be reorganized.

	xmogrify is interesting.  see also setup below,
	where processing really starts.  type_util.cc contains
	related supporting functions.

*/

ParseNode* TypeCheckObj::xmogrify(ParseNode *pn)
{
  switch (pn->tag()) {
    
  case ParseNode::ModuleT: {
    Module *m = (Module *) pn;
    if (DEBUG) printf("got module\n");
    
    switch (m->tag()) {
      
    case Module::SpecModuleT: {
      SpecModule *sm = (SpecModule *) m;
      SpecModule *new_sm;
      ParseNodeList *equates, *specs;
      // handle_equates(sm, FALSE, this);
      if (!allow_redefs) {
		if (err_list != 0 && redef_count == 0) {
			ParseNodeList *pnl = new ParseNodeList(m);
			cmp_err_return_to_checkpoint();
			allow_redefs = TRUE;
			propagate_parsenode_list(pnl, this);
			allow_redefs = FALSE;
			}
		}
      break;
      }
      
    case Module::ImplModuleT: { 
      ImplModule *im = (ImplModule *)m;
      ParseNodeList *idl = im->get_exports();
      handle_equates(im, FALSE, this);
      if (idl) for (Pix p = idl->first(); p ; idl->next(p)) {
	Id *id = (Id *)(*idl)(p);
	// TypeInterface *ti = get_type(id->get_id(), env);
	find_var(id->get_id(), id, env, TRUE);
	TypeInterface *ti = id->get_type();
	if (!ti) {
                sprintf(cmp_err_buf, "Module claims to implement %s"
				     " but definition is missing",
				string_charp(id->get_id()));
		cmp_err(cmp_err_buf, im->get_line());
		}
	else {
	    switch (ti->tag()) {
		case TypeInterface::MethodT: break;
		case TypeInterface::PMethodT: break;
		default: {
                    sprintf(cmp_err_buf, "Module implements %s"
				     " but %s is not a routine",
				string_charp(id->get_id()),
				string_charp(id->get_id()));
		    cmp_err(cmp_err_buf, im->get_line());
		    }
		}
	    }
	}
      current_module = 0;
      // only clear mark if this is the last pass
      if (allow_redefs) env = env->clear_mark();
      else {
	if ((err_list == 0) || (redef_count != 0)) env = env->clear_mark();
	else {
		// There are some errors: try a second pass
		ParseNodeList *pnl = new ParseNodeList(m);
		// Go back to err_list before ImplModule processed
		cmp_err_return_to_checkpoint();
		// Indicate second pass for this module
		allow_redefs = TRUE;
		propagate_parsenode_list(pnl, this);
		// Continue with 1st pass for subsequent modules
		allow_redefs = FALSE;
		}
	}
      break;	
      }
    }
    break;
  }
    
  case ParseNode::SpecEltT:  {
    if (DEBUG) printf("got specelt\n");
    SpecElt *se = (SpecElt *) pn;
    
    switch (se->tag()) {
      
    case SpecElt::RoutineSpecT: { 
      RoutineSpec *rs = (RoutineSpec *) se;
      TypeInterface *ti = rs->get_routine()->get_type();
      env = env->clear_mark();
	string nm = rs->get_routine()->get_id()->get_id();
	// string nm2 = string_concat(nm, string_const("_SPEC"));
	if (env->look_up(nm)) {
		if (!allow_redefs) {
                	sprintf(cmp_err_buf, "Attempted redefinition of %.50s foiled",
				string_charp(nm));
			cmp_err(cmp_err_buf, rs->get_line());
			redef_count++;
			}
		else env->update_binding(nm, ti);
		}
	else {
	        // 9/25/95 dwc: changed from type to var binding...
		env = env->add_var_binding(nm, ti);
		}
      break;
    }
      
    case SpecElt::TypeIntfT: {
      TypeIntf *ti = (TypeIntf *)se;
      env = env->clear_mark();
      // env = env->add_type_binding(ti->get_id()->get_id(), 
	// 		new TypeInterface(ti));
      inside_type_intf = FALSE;
      break;
    }
      
    }
    break;
  }
    
  case ParseNode::RoutineIntfT: {
    if (DEBUG) printf("got routineintf\n");
    RoutineIntf *ri = (RoutineIntf *) pn;
    TypeInterface *ti = ri->get_signature()->get_type();
    method m = 0;
    switch (ti->tag()) {
    case TypeInterface::MethodT: {
      m = ti->get_method();
      break;
      }
    case TypeInterface::PMethodT: {
      m = ti->get_pmethod();
      break;
      }
    }
    if (m) m->name = ri->get_id()->get_id();
    ri->type_ = ti;
    // new... might be ok...  probably name clash vs routinespecs
    // string nm = m->name;
    // if (env->look_up(m->name)) {
	// if (!allow_redefs) {
          //      	sprintf(cmp_err_buf, "Attempted redefinition of %.50s foiled",
	// 			string_charp(nm));
	// 	cmp_err(cmp_err_buf, rs->get_line());
	// 	redef_count++;
	// 	}
	// else env->update_binding(nm, ti);
	// }
    // else {
// 	env = env->add_type_binding(nm, ti);
// 	}
    if (inside_type_intf) env = env->clear_mark();
    break;   
  }
    
  case ParseNode::SignatureT: {
    if (DEBUG) printf("got signature\n");
    Signature *sig = (Signature *) pn;
    // 6/21/95: dwc: removed so that 2nd pass improves things.
    //		I hope this was only added to avoid wasting space,
    //		not to fix something...
    // if (sig->type_->tag() != TypeInterface::NullT) {
        // this->set_current_method(sig->get_type()->get_method());
	// break;
	// }
    method m = method_from_signature(sig, this);
    ParseNodeList *parms = sig->get_parms();
    ParseNodeList *rl = sig->get_where();
    if (parms) {
    	int nparms = count_parms(parms);
	vec p = parms2vec(parms, 0, rl, nparms, this);
    	sig->type_ = new TypeInterface(m, p);
	}
    else {
    	sig->type_ = new TypeInterface(m, 0);
	}
    if (DEBUG) printf("m %lX sig %lX\n", m, sig->type_);
    this->set_current_method(m);
    break;    
  }
    
  case ParseNode::EquateT: {
    if (DEBUG) printf("got equate\n");
    Equate *eq = (Equate *) pn;
    
    switch (eq->tag()) {
      
    case Equate::TypeEquateT: {
      TypeEquate *teq = (TypeEquate *) eq;
      // string nm = teq->get_id()->get_id();
      // env = env->remove_binding(nm);
      break;
    }
      
    case Equate::ExprEquateT: {
      if (DEBUG) printf("got exprequate\n");
      ExprEquate *eeq = (ExprEquate *) eq;
      // new stuff...
      // look up name and add type to it
      string nm = eeq->get_id()->get_id();
      TypeInterface *ti = eeq->get_expr()->get_type();
      eeq->type_ = ti;
      bool exists = FALSE;
      if (env->look_up(nm)) exists = TRUE;
      //if (exists && !allow_redefs) {
       // sprintf(cmp_err_buf, "Attempted redefinition "
	//	"of %.50s foiled", string_charp(nm));
	//cmp_err(cmp_err_buf, eeq->get_line());
	//redef_count++; 
	//}
      //else {
	if (exists) env->update_binding(nm, ti);
	// 9/25/95 dwc: changed from type to var
	// 11/28/95 dwc: let process_equate do the insert...
	// else env = env->add_var_binding(nm, ti);
      //}
      // env = env->remove_binding(nm);
      break;    
      }
    }
  break;
  }
    
  case ParseNode::ImplEltT:  {
    if (DEBUG) printf("got implelt\n");
    ImplElt * ie = (ImplElt *) pn;
    
    switch(ie->tag()) {
    case ImplElt::RoutineDefT: {
      RoutineDef *rd = (RoutineDef *) ie;
      string id = rd->get_routineIntf()->get_id()->get_id();
      string nm2 = string_concat(id, string_const("_IMPL"));
      TypeInterface *ti = rd->get_routineIntf()->get_type();
      rd->type_ = ti;
      env = env->clear_mark();
      // Nope: Move routine def to the outer environment, if it's exported
      //	by current_module
      // if (exported(id, this)) {
      	// this->env = env->add_type_binding(nm2, ti);
	// }
      // check def against spec for stand-alone routines
      //	(methods have already been checked against type specs)
      if (!inside_class_def) { 
      	string nm = rd->get_routineIntf()->get_id()->get_id();
      	// string spec_nm = string_concat(nm, string_const("_SPEC"));
      	TypeInterface *spec_ti = get_type(nm, env);
      	if (spec_ti == 0) { // sprintf(cmp_err_buf, 
			// "No specification found for routine %s",
			 // string_charp(nm));
		     // cmp_err(cmp_err_buf, rd->get_line()); 
		// 9/25/95 dwc: changed from type to var
      		this->env = env->add_var_binding(nm, ti);
		}
      	else {
		method m1 = ti->get_method();
		method m2 = spec_ti->get_method();
		check_rtn_against_rtn_spec(m1, m2, rd->get_line());
		}
	}
      break;
    }
      
    case ImplElt::ClassDefT: {
      ClassDef *cd = (ClassDef *) ie;
      string id = cd->get_classId()->get_id();
      TypeInterface *ti = cd->get_type();
      env = env->clear_mark();
      // Nope: Move class def to the outer environment, if it's exported
      //	by current_module
      // if (exported(id, this)) {
      	// this->env = env->add_type_binding(id, ti);
	// }
      handle_equates(cd, FALSE, this);
      inside_class_def = FALSE;
      current_class = NULL;
      break;
    }
    case ImplElt::EquateT: {
	Equate *eq = (Equate *)ie;
	handle_equates(eq, FALSE, this);
	}
    }
    break;
  }  
    
  case ParseNode::InheritT: { 
    Inherit *inh = (Inherit *) pn;
    TypeSpec *ts = inh->get_classSpec();
    set_node_type(ts, inh, this, TRUE);
    break;
  }
    
  // Need to handle both class exports and module exports
  // Nope: actually module exports are just a list of ids...
  case ParseNode::ExportT: { 
    Export *expt = (Export *) pn;
    ParseNodeList *idl = expt->get_exported();
    check_methods(idl, (ClassDef *)this->get_current_class(), env);
    break;
  }
    
  case ParseNode::MethodOrOpDefT: { 
    if (DEBUG) printf("got methodoropdef\n");
    break;
  }
    
  case ParseNode::ParmT: { 
    break;
  }
    
  case ParseNode::FormalT: { 
    break;
  }
    
  case ParseNode::ExceptionT: { 
    break;
  }
    
  case ParseNode::RestrictionT: { 
    break;
  }
    
  case ParseNode::TypeSpecT:  {
    TypeSpec * ts = (TypeSpec *) pn;
    set_node_type(ts, ts, this, TRUE);
    break;
  }  
    
  case ParseNode::TypeNameT:  {
    TypeName *tn = (TypeName *) pn;
  }
    
  case ParseNode::ActualParmT:  {
    break;
  }
    
  case ParseNode::ParmOpT:  {
    break;
  }
    
  case ParseNode::StmtT:  {
    Stmt * s = (Stmt *) pn;
    if (DEBUG) printf("got BEGIN STMT SWITCH\n");
    
    switch (s->tag()) {
      
    case Stmt::InitVarExprT: {
      if (DEBUG) printf("got init var expr\n");
      InitVarExpr *ive = (InitVarExpr *)s;
      switch (ive->get_decl()->tag()) {
      case Decl::RegDeclT: {
	RegDecl *d = (RegDecl *) ive->get_decl();
	type dt = d->get_type()->get_type();
	type et = get_one_type(ive->get_expr()->get_type(), ive->get_line());
	if (dt && et && isSubtype(et, dt))
	  {if (DEBUG) fprintf(stderr, "ive SEEMS OK\n");}
	else {cmp_err(
		"Invalid assignment due to type mismatch (IVE).", d->get_line());
		}
	
	break;
      }
      case Decl::ImplDeclT: {
	cmp_err("Unexpected ImplDecl in InitVarExpr.", s->get_line());
	break;
      }
      case Decl::VarArgsDeclT: {
	cmp_err("Unexpected VarArgsDecl in InitVarExpr.", s->get_line());
	break;
      }
      }
      break;
    }
      
    case Stmt::InitVarInvokeT: {
      if (DEBUG) printf("got initvarinvoke\n");
      InitVarInvoke *ivi = (InitVarInvoke *)s;
      TypeInterface *ti = ivi->get_invoc()->get_type();
      ParseNodeList dl  = *ivi->get_decls();
      int nids = count_lhs(ivi->get_decls());

      switch (ti->tag()) {
      case TypeInterface::MultipleT: {
      // Check numbers of types
      if (vec_length(ti->get_mult()) != nids) {
		Pix p = dl.first();
		int line  = dl(p)->get_line();
		cmp_err("Invalid assigment because number of return values differs from number needed.", line);
		break;
		}
      // iterate matching types
      Pix pe, pi;
      int i = 0;
      for (pi = dl.first(); pi; dl.next(pi)) {
	type dlt = dl(pi)->get_type()->get_type();
	ParseNode *pnd = dl(pi);
	// Assumes regdecl...
	ParseNodeList *pnl = ((RegDecl*)pnd)->get_ids();
          for (int j = 0; j < pnl->length(); j++) {
	  type pet = (type)vec_fetch(ti->get_mult(), i);
	  if (pet && dlt && isSubtype(pet, dlt)) {
	    if (DEBUG) fprintf (stderr, " IVI ok\n");}
	    else { sprintf(cmp_err_buf, 
			"Invalid assignment due to type mismatch (IVI)."
			" %s is not a subtype of %s",
			pet? string_charp(type_name(pet)) : "NONE",
			dlt? string_charp(type_name(dlt)) : "NONE");
		   cmp_err(cmp_err_buf, pnd->line);}
	 i++;
	 }
      }
      break;
      } // end mult

      case TypeInterface::SingleT: {
      if (nids != 1) {
		cmp_err("Invalid assigment because number of return values differs from number needed.", ivi->get_line());
		break;
		}
      else {
	Pix p = dl.first();
        type t = ti->get_type();
	type dlt = dl(p)->get_type()->get_type();
        if (t && dlt && isSubtype(t, dlt)) {
	    if (DEBUG) fprintf (stderr, " IVI ok\n");}
	    else { sprintf(cmp_err_buf, 
			"Invalid assignment due to type mismatch (IVI)."
			" %s is not a subtype of %s",
			t? string_charp(type_name(t)) : "NONE",
			dlt? string_charp(type_name(dlt)) : "NONE");
		   cmp_err(cmp_err_buf, ivi->line);}
	}
      break;
      } // end single

      default: {
	cmp_err("Invalid assignment due to type mismatch (IVI).",
			ivi->line);
	}

      } // end switch
      break;
    }
      
    case Stmt::DeclStmtT: {
      // Nothing to be done here
      if (DEBUG) printf("got decl stmt\n");
      DeclStmt *ds = (DeclStmt *)s;
      break;
    }
      
    case Stmt::AssignInvokeT: {
      if (DEBUG) printf("got assigninvoke\n");
      break;
    }
      
    case Stmt::AssignExprStmtT: {
      if (DEBUG) printf("got assignexprstmt\n");
      AssignExprStmt *aes = (AssignExprStmt *)s;
      // iterate matching types
      ParseNodeList el  = *aes->get_exprs();
      ParseNodeList lhs  = *aes->get_ids();
      int ecount = el.length();
      bool invocation = FALSE;
      TypeInterface *ti;
      if (ecount == 1) {
		Pix p = el.first();
		Expr *e = (Expr*)el(p);
		ti = e->get_type();
		if (ti->tag() == TypeInterface::MultipleT) {
			invocation = TRUE;
			ecount = vec_length(ti->get_mult());
			}
		}
      if (ecount != count_lhs(aes->get_ids())) {
		Pix p = lhs.first();
		int line  = lhs(p)->get_line();
		cmp_err("Invalid assigment because number of return values differs from number needed.", line);
		break;
		}

      // Handle invocation case a, b := foo()
      if (invocation) {
      Pix pe, pi;
      int i;
      for (i = 0, pi = lhs.first(); pi; i++, lhs.next(pi)) {
	ParseNode *lhselt = lhs(pi);
	TypeInterface *lti = lhselt->get_type();
	type lhst = ((IdOrIvar*)lhs(pi))->get_type()->get_type();
	if (!lhst && lti->tag() == TypeInterface::MultipleT) {
		vec v  = ti->get_mult();
		if (vec_length(v) == 1) {
			lhst = UNPV(type, vec_fetch(v, 0));
			}
		}
	type pet = (type)vec_fetch(ti->get_mult(), i);
	if (!pet || !lhst || !isSubtype(pet, lhst)) {
	     sprintf(cmp_err_buf, 
			"Invalid assignment due to type mismatch (AES)."
			" %s is not a subtype of %s",
			pet? string_charp(type_name(pet)) : "NONE",
			lhst? string_charp(type_name(lhst)) : "NONE");
		   cmp_err(cmp_err_buf, lhselt->line);}
      }
      break;
     }

      // Handle non-invocation case  a, b := 1, 2
      Pix pe, pi;
      int i;
      for (i = 1, pe = el.first(), pi = lhs.first();
	   pe && pi; i++, el.next(pe), lhs.next(pi)) {
	Expr *e = (Expr*)el(pe);
	ParseNode *lhselt = lhs(pi);
	TypeInterface *lti = lhselt->get_type();
	type lhst = lhs(pi)->get_type()->get_type();
	type pet = ((Expr*)el(pe))->get_type()->get_type();
	if (!lhst && lti->tag() == TypeInterface::MultipleT) {
		vec v  = lti->get_mult();
		if (vec_length(v) == 1) {
			lhst = UNPV(type, vec_fetch(v, 0));
			}
		}
	if (!pet || !lhst || !isSubtype(pet, lhst)) {
	     sprintf(cmp_err_buf, 
			"Invalid assignment due to type mismatch (AES)."
			" %s is not a subtype of %s",
			pet? string_charp(type_name(pet)) : "NONE",
			lhst? string_charp(type_name(lhst)) : "NONE");
		   cmp_err(cmp_err_buf, lhselt->line);}
      }
      break;
    }
      
    case Stmt::AssignExprT: {
      if (DEBUG) printf("got assignexpr\n");
      break;
    }
      
    case Stmt::InvokeStmtT: {
      // Nothing to be done here
      if (DEBUG) printf("got invokestmt\n");
      break;
    }
      
    case Stmt::WhileStmtT: {
      if (DEBUG) printf("got whilestmt\n");
      this->env = this->env->clear_mark();
      this->active_loops -= 1;
      WhileStmt *ws = (WhileStmt *)s;
      Expr *e = ws->get_expr();
      type et = get_one_type(e->get_type(), e->get_line());
      type bt = env->look_up(string_const("bool"))->get_type()->get_type();
      if (!(et && isSubtype(et, bt)))
      cmp_err("Invalid While Statement: the expression is not a boolean.",
		ws->get_line());
      break;
    }
      
    case Stmt::IfStmtT: {
      if (DEBUG) printf("got ifstmt\n");
      this->env = this->env->clear_mark();
      IfStmt *is = (IfStmt *)s;
      Expr *e = is->get_expr();
      type et = get_one_type(e->get_type(), e->get_line());
      type bt = env->look_up(string_const("bool"))->get_type()->get_type();
      if (!(et && isSubtype(et, bt)))
      cmp_err("Invalid If Statement: the expression is not a boolean.",
		is->get_line());
      break;
    }
      
    case Stmt::TagcaseT: {
      break;
    }
      
    case Stmt::TypecaseT: {
      Typecase *tc = (Typecase *)s;
      Expr *ex = tc->get_expr();
      type et  = get_one_type(ex->get_type(), ex->get_line());
      if (!et) {
	vec v = ex->get_type()->get_mult();
	if (v && (vec_length(v) > 0)) et = UNPV(type, vec_fetch(v, 0));
	}
      type lastt = et;
      ParseNodeList *arms = tc->get_typeWhenArms();
      int index = 0;
      for (Pix p = arms->first(); p ; arms->next(p), index++) {
	TypeWhenArm *twa = (TypeWhenArm *)(*arms)(p);
	type at = get_one_type(twa->get_typ()->get_type(), twa->get_line());
        // each arm's expr's type must be a proper(?) subtypes of expr's type
	if (at && et && isSubtype(at, et) && !isSubtype(et, at)) { }
	else { sprintf(cmp_err_buf,
		"Invalid typecase statement due to type mismatch: "
		" %s is not a subtype of %s",
		at? string_charp(type_name(at)) : "NONE",
		et? string_charp(type_name(et)) : "NONE");
	       cmp_err(cmp_err_buf, ex->line);
	       break;
	      }
        // order of types must be from narrowest to widest
	if (at && lastt && !isSubtype(lastt, at)) lastt = at;
	else { sprintf(cmp_err_buf,
		"Invalid typecase statement due to type narrowing: "
		" %s is a subtype of %s",
		lastt? string_charp(type_name(lastt)) : "NONE",
		at? string_charp(type_name(at)) : "NONE");
	       cmp_err(cmp_err_buf, ex->line);
	       break;
	      }
        // types enumerated in arms must be distinct
	int index2 = 0;
        for (Pix p2 = arms->first(); p2 ; arms->next(p2), index2++) {
	   if (index == index2) continue;
	   TypeWhenArm *twai = (TypeWhenArm *)(*arms)(p2);
	   type ati = twai->get_typ()->get_type()->get_type();
	   if (at && ati && isSubtype(at, ati) && isSubtype(ati, at)) {
	       sprintf(cmp_err_buf,
		"Invalid typecase statement due type arms types not being distinct: "
		" %s is not a subtype of %s",
		at? string_charp(type_name(at)) : "NONE",
		ati? string_charp(type_name(ati)) : "NONE");
	       cmp_err(cmp_err_buf, ex->line);
	       break;
	       }
	   }
	}
      break;
    }
      
    case Stmt::ReturnStmtT: {
      if (DEBUG) printf("got return\n");
      ReturnStmt *rs = (ReturnStmt *)s;
      ParseNodeList *el = rs->get_exprs();
      method m = this->get_current_method();

      // If iter, return stmt is ok, but must have no values
      if (m->iter) {
		if (el != NULL) {
			cmp_err(
			"Invalid return statement: no return values allowed within iterator.", 
				rs->get_line());
			}
	}

      // Handle return in procedure
      else {
        // Handle zero returns
	if (el == NULL) {
		if (vec_length(m->returns) == 0) {
			}
		else {
		  cmp_err("Invalid return: needs values.", rs->get_line());
			}
		}
	// Check counts
	else {
		int ecount = el->length();
		if (ecount != vec_length(m->returns)) {
		  cmp_err("Invalid return: wrong number of values.",
				rs->get_line());
			}
	// Iterate through lists
		else {
			int i = 0;
			for (Pix p = el->first(); p ; el->next(p), i++) {
				Expr *e = (Expr *)(*el)(p);
                		TypeInterface *ti = e->get_type();
      				type et = get_one_type(e->get_type(), 
							e->get_line());
				type rt = UNPV(type, vec_fetch(m->returns, i));
				if (!et || !rt || !isSubtype(et, rt)) {
                        		sprintf(cmp_err_buf, 
						"Invalid return statment due to type mismatch: expected %.50s, got %.50s.",
                                		rt?string_charp(type_name(rt)):"NONE",
                                		et?string_charp(type_name(et)):"NONE");
					cmp_err(cmp_err_buf, rs->get_line());
					}
				}
			}
		}
	}
      break;
    }
      
    case Stmt::YieldT: {
      if (DEBUG) printf("got yield\n");
      Yield *ys = (Yield *)s;
      ParseNodeList *el = ys->get_exprs();
      method m = this->get_current_method();
      // must be iter
      if (!m->iter) {
	cmp_err("Invalid yield statement: yield not allowed within procedure.",
		ys->get_line());
	}
      else {
        // Handle zero yields
	if (el == NULL) {
		if (vec_length(m->returns) == 0) {
			}
		else {
		  cmp_err("Invalid yield: needs values.", ys->get_line());
			}
		}
	// Check counts
	else {
		int ecount = el->length();
		if (ecount != vec_length(m->returns)) {
		  cmp_err("Invalid return: wrong number of values.",
				ys->get_line());
			}
	// Iterate through lists
		else {
			int i = 0;
			for (Pix p = el->first(); p ; el->next(p), i++) {
				Expr *e = (Expr *)(*el)(p);
				type et = e->get_type()->get_type();
				type rt = UNPV(type, vec_fetch(m->returns, i));
				if (!et || !rt || !isSubtype(et, rt)) {
					cmp_err("Invalid yield due to type mismatch",
						ys->get_line());
					}
				}
			}
		}
	}
      break;
    }
      
    case Stmt::SignalStmtT: {
      if (DEBUG) printf("got signal\n");
      SignalStmt *ss = (SignalStmt *)s;
      string nm = ss->get_id()->get_id();
      ParseNodeList *el = ss->get_exprs();
      method m = this->get_current_method();
      // Find signal in signal list
      signal_ sig;
      int scount = vec_length(m->signals);
      if (scount == 0) {
		if (string_equal(nm, string_const("failure"))) break;
		else
		cmp_err("Invalid signal statement: no signals in current signature",
			ss->get_line());
		}
      else {
      	int found = 0;
      	int i;
      	for (i = 0; i < scount ; i++ ) {
		signal_ isig =  UNPV(signal_, vec_fetch(m->signals, i));
		if (string_equal(nm, isig->name)) {
			found = 1;
			sig = isig;
			}
      		    }
	if (found == 0) {
		if (string_equal(nm, string_const("failure"))) {
			if (el == NULL) {
			cmp_err("Invalid signal statement: failure value missing.",
			ss->get_line());
				}
			else {
				if (el->length() != 1) {
				cmp_err("Invalid signal statement: too many values for failure.",
				ss->get_line());
					}
				else {
					Pix p = el->first();
					Expr *e = (Expr *)(*el)(p);
					type et = e->get_type()->get_type();
     					NameBinding *bind = env->look_up
						(string_const("string"));
					type rt = bind->get_type()->get_type();
					if (!et || !rt || !isSubtype(et, rt)) {
						cmp_err("Invalid signal due to type mismatch",
							ss->get_line());
				}
					}
				}
			}
		else {
			cmp_err("Invalid signal statement: no such signal in current signature.",
			ss->get_line());
			}
		}
	else {
      // Check Exprs against expected types
      		int vcount = vec_length(sig->returns);
      // Handle no values case
		if (el == NULL) {
			if (vcount == 0) {}
			else {
				cmp_err("Invalid signal statement: values missing",
				ss->get_line());
				}
			}
      // Check counts
		else {
			if (el->length() != vcount) {
				cmp_err("Invalid signal statement: wrong number of values.",
				ss->get_line());
				}
			else {
      // Iterate over lists
				int i = 0;
				for (Pix p = el->first(); p ; el->next(p), i++){
					Expr *e = (Expr *)(*el)(p);
					type et = e->get_type()->get_type();
					type rt = UNPV(type, vec_fetch(sig->returns, i));
					if (!et || !rt || !isSubtype(et, rt)) {
						cmp_err("Invalid signal due to type mismatch",
							ss->get_line());
				}
			}
		    }
		}
            }
	}
      break;
    }
      
    case Stmt::ExitT: {
      if (this->active_loops == 0)
	cmp_err("Invalid exit statement: not within a loop", s->get_line());
      break;
    }
      
    case Stmt::BreakT: {
      if (this->active_loops == 0)
	cmp_err("Invalid break statement: not within a loop", s->get_line());
      break;
    }
      
    case Stmt::ContinueT: {
      if (this->active_loops == 0)
	cmp_err("Invalid continue statement: not within a loop", s->get_line());
      break;
    }
      
    case Stmt::BlockStmtT: {
      if (DEBUG) printf("got BLOCK\n");
      this->env = this->env->clear_mark();
      break;
    }
      
    case Stmt::ResignalStmtT: {
      if (DEBUG) printf("got resignal\n");
      ResignalStmt *rs = (ResignalStmt *)s;
      ParseNodeList * pnl = rs->get_ids();
      for (Pix p = pnl->first(); p ; pnl->next(p)) {
        string nm = ((Id *)(*pnl)(p))->get_id();
        method m = this->get_current_method();
        // Find signal in signal list
        int scount = vec_length(m->signals);
        if (scount == 0) {
		cmp_err("Invalid resignal statement: no signals in current signature",
			rs->get_line());
		}
        else {
      	  int found = 0;
      	  int i;
      	  for (i = 0; i < scount ; i++ ) {
		signal_ isig =  UNPV(signal_, vec_fetch(m->signals, i));
		if (string_equal(nm, isig->name)) {
			found = 1;
			}
      		    }
	  if (found == 0) {
		cmp_err("Invalid resignal statement: no such signal in current signature.",
			rs->get_line());
		}
	}
      }
      break;
    }
      
    case Stmt::ExceptStmtT: {
      break;
    }
      
    case Stmt::InitT: {
      break;
    }
      
    case Stmt::DeclForStmtT: {
      this->env = this->env->clear_mark();
      this->active_loops -= 1;
      if (DEBUG) printf("got declforstmt\n");
      DeclForStmt *fs = (DeclForStmt *)s;
      Invoc *inv = fs->get_invoc();
      method m = inv->get_routineId()->
                      get_type()->get_method();
      TypeInterface *ti = inv->get_type();
      vec v = ti->get_mult();
      ParseNodeList *dl  = fs->get_decls();

      // Check that invoc is an iter
      if (!m || !m->iter) {
		cmp_err("Invalid for statement: needs an iterator.",
			fs->get_line());
		}
      // Check result count vs. count of ids
      else {
	int vcount = vec_length(m->returns);
        int icount = count_lhs(dl);
	if (icount != vcount) {
		cmp_err("Invalid for statement: wrong number of identifiers.",
			fs->get_line());
		}
      // Match id types with result types
	else {
	    if (v) {
		if (vcount != 0) {
			int i = 0;
			for (Pix p = dl->first(); p ; dl->next(p)) {
				type idlt = (*dl)(p)->get_type()->get_type();
				ParseNode *pnd = (*dl)(p);
        			ParseNodeList *pnl = ((RegDecl*)pnd)->get_ids();
          			for (int j = 0; j < pnl->length(); j++) {
		                   type rt = UNPV(type, vec_fetch(v, i));
				   if (rt && idlt && isSubtype(rt, idlt)) {}
				   else {
					sprintf(cmp_err_buf, 
					"Invalid for statement due to type mismatch."
					" %s is not a subtype of %s",
					rt ? string_charp(type_name(rt)) : "NONE",
					idlt ? string_charp(type_name(idlt)) : "NONE");
					cmp_err(cmp_err_buf, fs->get_line());
				   	  }
				   i++;
				   }
				}
			}
		}
	    	else {
			cmp_err("Insufficient type information to check for statement.",
				inv->get_line());
		}
	    }
	}
      break;
    }
      
    case Stmt::ForStmtT: {
      this->env = this->env->clear_mark();
      this->active_loops -= 1;
      if (DEBUG) printf("got forstmt\n");
      ForStmt *fs = (ForStmt *)s;
      Invoc *inv = fs->get_invoc();
      TypeInterface *ti = inv->get_type();
      vec v = ti->get_mult();
      method m = inv->get_routineId()->
                      get_type()->get_method();
      ParseNodeList *idl  = fs->get_ids();

      // Check that invoc is an iter
      if (!m || !m->iter) {
		cmp_err("Invalid for statement: needs an iterator.",
			fs->get_line());
		}
      // Check result count vs. count of ids
      else {
	int vcount = vec_length(m->returns);
        int icount = count_lhs(idl);
	if (icount != vcount) {
		cmp_err("Invalid for statement: wrong number of identifiers.",
			fs->get_line());
		}
      // Match id types with result types
	else {
	    if (v) {
		if (vcount != 0) {
			int i = 0;
			for (Pix p = idl->first(); p ; idl->next(p), i++) {
				type idlt = (*idl)(p)->get_type()->get_type();
		                type rt = UNPV(type, vec_fetch(ti->get_mult(), i));
				if (rt && idlt && isSubtype(rt, idlt)) {}
				else {
					sprintf(cmp_err_buf, 
						"Invalid for statement due to type mismatch."
						" %s is not a subtype of %s",
						rt ? string_charp(type_name(rt)):"NONE",
						idlt ? string_charp(type_name(idlt)):"NONE");
					cmp_err(cmp_err_buf, fs->get_line());
					}
				i++;
				}
			}
		}
	    	else {
			cmp_err("Insufficient type information to check for statement.",
				inv->get_line());
		}
	    }
	}
      break;
    }
      break;
    }
    if (DEBUG) printf("got END STMT SWITCH\n");
    break;
  }
    
  case ParseNode::DeclT: {
    Decl *d = (Decl *) pn;
    
    switch (d->tag()) {
      
    case Decl::RegDeclT: {
      if (DEBUG) printf("got regdecl\n");
	  RegDecl *r = (RegDecl *)d;
	  TypeSpec *ts = r->get_typeSpec();
    	  set_node_type(ts, r, this, TRUE);
	  // iterate over ids in decl
	  ParseNodeList l = *(r->get_ids());
	  for (Pix p = l.first(); p ; l.next(p)) {
		Id *id = (Id*)l(p);
		if (DEBUG) id->print(3);
		string nm = id->get_id();
		RESET_EXC
		env = env->add_var_binding(nm, d->type_);
		CATCH_EXC(exc_duplicate) {
	           sprintf(cmp_err_buf, "Duplicate name: %.50s",
		           string_charp(id->get_id()));
	           cmp_err(cmp_err_buf, id->get_line());
		}
	}
      break;
    }
      
    case Decl::ImplDeclT: {
	  ImplDecl *imd = (ImplDecl *)d;
	  TypeSpec *ts = imd->get_typeSpec();
    	  set_node_type(ts, imd, this, TRUE);
	  // set type for id
	  Id *id = imd->get_id();
	  if (DEBUG) id->print(3);
	  string nm = id->get_id();
 	  RESET_EXC
	  env = env->add_var_binding(nm, d->type_);
	  CATCH_EXC(exc_duplicate) {
	          sprintf(cmp_err_buf, "Duplicate name: %.50s",
	           string_charp(id->get_id()));
	          cmp_err(cmp_err_buf, id->get_line());
	   }
      break;
    }
      
// varargs needs work
    case Decl::VarArgsDeclT: {
      break;
    }
      break;
    }
    break;
  }
    
  case ParseNode::IdOrIvarT:  {
    IdOrIvar *id = (IdOrIvar *)pn;
    if (DEBUG) printf("decorating id\n");
		find_var(id->get_id()->get_id(), id, env, TRUE);
    break;
  }
    
  case ParseNode::BodyT:  {
    this->env = this->env->clear_mark();
    break;
  }
    
  case ParseNode::ElseIfT:  {
      this->env = this->env->clear_mark();
      ElseIf *els = (ElseIf *)pn;
      Expr *e = els->get_expr();
      type et = e->get_type()->get_type();
      if (!et) {
	vec v = e->get_type()->get_mult();
	if (v && vec_length(v)) et = UNPV(type, vec_fetch(v, 0));
	}
      type bt = env->look_up(string_const("bool"))->get_type()->get_type();
      if (!(et && isSubtype(et, bt)))
      cmp_err("Invalid ElseIf: the expression is not a boolean.",
		els->get_line());
    break;
  }
    
  case ParseNode::TagWhenArmT:  {
    break;
  }
    
  case ParseNode::TypeWhenArmT:  {
    env = env->clear_mark();
    break;
  }
    
  case ParseNode::ExWhenArmT:  {
    break;
  }
    
  case ParseNode::OthersHandlerT:  {
    break;
  }
    
  case ParseNode::FieldInitT:  {
      FieldInit *fi = (FieldInit *)pn;
      fi->type_ = fi->get_expr()->get_type();
    break;
  }
    
  case ParseNode::ExprT:  {
    Expr *ex = (Expr *) pn;
    if (DEBUG) printf("got expr\n");
    
    switch (ex->tag()) {
      
    case Expr::NilT: {
      ex->type_ = env->look_up(string_const("null"))->get_type();
      break;
    }
      
    case Expr::LiteralT: {
      Literal *l = (Literal *) pn;
      if (DEBUG) printf("got literal\n");
      
      switch (l->tag()) {
	
      case Literal::IntLiteralT: {
	if (DEBUG) printf("got int literal\n");
        ex->type_ = env->look_up(string_const("int"))->get_type();
	break;
      }
	
      case Literal::BoolLiteralT:  {
	if (DEBUG) printf("got bool literal\n");
        ex->type_ = env->look_up(string_const("bool"))->get_type();
	break;
      }
	
      case Literal::CharLiteralT:  {
	if (DEBUG) printf("got char literal\n");
        ex->type_ = env->look_up(string_const("char"))->get_type();
	break;
      }
	
      case Literal::StringLiteralT:  {
	if (DEBUG) printf("got string literal\n");
        ex->type_ = env->look_up(string_const("string"))->get_type();
	break;
      }
	
      case Literal::RealLiteralT: {
	if (DEBUG) printf("got real literal\n");
	ex->type_ = env->look_up(string_const("real"))->get_type();
	break;
      }
	break;
      }
      break;
    }
      
    case Expr::BinaryT: {
      // The only cases we should have to handle are AndT and OrT.
      // The others should have been handled in desugar
      // Note: these are really cand and cor (only eval 2nd arg if nec.)
      Binary *bin = (Binary *)ex;
      TypeInterface *bti = env->look_up(string_const("bool"))->get_type();
      type bt = bti->get_type();
      type t1;
      type t2;
      switch (bin->tag()) {
	case Binary::AndT:
	case Binary::OrT:
	     // both exprs should be boolean; if so set result type to boolean.
		t1 = get_one_type(bin->get_op1()->get_type(), bin->get_line());
		t2 = get_one_type(bin->get_op2()->get_type(), bin->get_line());
		break; // end  AndT/OrT case
	default:
		cmp_err("Unexpected binary op.", ex->get_line());
      } // end of bin tag switch
      // if both types are boolean then set bin type to boolean
      if (t1 && t2 && isSubtype(t1, bt) && isSubtype(t2, bt)) {
		bin->type_ = bti;
		}
      else {
		cmp_err("Type problems in binary expression.", bin->get_line());
		}
      break;
    }

    case Expr::BracketRefT: {
      // This code assumes that the primary of a bracket ref
      //	has both fetch and store and that these methods
      //        are symmetric, i.e., that the storable and fetchable
      //	values have the same types and that a single expression
      //	is used as an index.
      BracketRef *br = (BracketRef *)ex;
      Expr *prim = br->get_primary();
      ParseNodeList *exprs = br->get_exprs();
      // Try to see if this is a sugar ref for get or set.
      int size = exprs->length();
      if (size == 1) {
        TypeInterface *ti = prim->get_type();
	type t = ti->get_type();
        fevalue tgm_ret[2];
	if (t) {
	   RESET_EXC
	   getMethod(type_as_objtype(t), tgm_ret, 
				string_const("fetch"));
	   CATCH {
		exc = EXC_NONE;
		break;
           	}
	   method m  = (method) tgm_ret[0].o;
	   // needs to take a single argument
	   if (vec_length(m->arguments) != 1) break;
	   // first elt of exprs needs to be a subtype of that argument
	   formal f = UNPV(formal, vec_fetch(m->arguments, 0));
	   type at = get_one_type(exprs->front()->get_type(), prim->get_line());
	   if (!at || !f->t || !isSubtype(at, f->t)) {
		sprintf(cmp_err_buf, " %s is not a subtype of %s",
				at?string_charp(type_name(at)):"NONE",
				f->t?string_charp(type_name(f->t)):"NONE");
		cmp_err(cmp_err_buf, prim->get_line());
		break;
		}
	   // needs to return one value
	   if (vec_length(m->returns) != 1) {
		cmp_err("Too many return values for a fetch method.", prim->get_line());
		break;
		}
	   // use that value for type of bracket ref
	   // 		a little overkill, but analogous to Invoc
	   br->type_ = new TypeInterface(m->returns);
           }
	}
      else {
	cmp_err("Too many indexing expressions.", prim->get_line());
	
	}
      break;
    }
      
    case Expr::UnaryT: {
      break;
    }
      
    case Expr::InstantiationT: {
      break;
    }
      
    case Expr::DotExprT:  {
      fevalue tgm_ret[2];
      if (DEBUG) printf("decorating dot expr\n");
      DotExpr *de = (DotExpr *)ex;
      string m_name = de->get_id()->get_id();
      TypeInterface *ti = de->get_primary()->get_type();
      switch (ti->tag()){
      	case TypeInterface::SingleT: {
        type t = ti->get_type();
	RESET_EXC
	getMethod(type_as_objtype(t), tgm_ret, m_name);
        CATCH {
	   exc = EXC_NONE;
	   type ctype = 0;
	   if (this->get_current_class()) {
		    ClassDef *cd = (ClassDef *) this->get_current_class();
	   	    ctype = get_type(cd->get_classId()->get_id(),
					env)->get_type();
		   }
	   if (t && ctype && t == ctype) {
		Decl *d = find_ivar_decl(m_name, this);
		if (d) {
			de->type_ = d->get_type();
			break;
			}
		}
	   if (t) {  // try other types' ivars
		RESET_EXC
		class_ c = type_as_class(t);
	   	if (exc == EXC_NONE) {
		   type itype = class_get_field_type(c, m_name);
		   if (itype) {
			de->type_ = new TypeInterface(itype);
			break;
			}
		   }
		}
           sprintf(cmp_err_buf, "Type \"%.50s\" has no method (or ivar)"
		   " \"%.50s\".",
                   string_charp(type_name(t)),
                   string_charp(m_name));
	   cmp_err(cmp_err_buf, de->get_line());
           de->type_ = new TypeInterface();
         }
         else {
		method m  = (method) tgm_ret[0].o;
		TypeInterface *mti = new TypeInterface(m, 0);
		de->type_ = mti;
		}
	 break;
	}
	case TypeInterface::IntfT: {
	   ParseNode *tpn = ti->get_intf();
	   ParseNodeList *rets = tintf_get_method_rets(tpn, m_name);
	   // if the method is not found, see if type is the same as
	   // the current class and if the method is the name of an
	   // instance variable...
	   if (!rets) {
		// current class => current etype => current type
		if (same_deftype(tpn, this->get_current_deftype(), env)) {
			Decl *d = find_ivar_decl(m_name, this);
			if (d) {
				de->type_ = d->get_type();
				break;
				}
			}
		}
	   if (!rets || rets->length() != 1) { // we're losing most probably
		sprintf(cmp_err_buf,"Dot Expr Intf TI rets not 1.");
		cmp_err(cmp_err_buf, de->get_line());
	   	de->type_ = new TypeInterface();
		}
	   else {
		Pix p = rets->first();
		TypeInterface *nti = pn_to_ti((*rets)(p), env);
		de->type_ = nti;
		}
	   break;
       }
       case TypeInterface::MultipleT: {
	vec v  = ti->get_mult();
	if (vec_length(v) != 1) {
		sprintf(cmp_err_buf,"Dot Expr Mult TI not 1 but %d.",
			vec_length(v));
		cmp_err(cmp_err_buf, de->get_line());
		de->type_ = new TypeInterface();
		}
	else {
		type t = UNPV(type, vec_fetch(v, 0));
		RESET_EXC
		if (t) getMethod(type_as_objtype(t), tgm_ret, m_name);
        	CATCH {
	   		exc = EXC_NONE;
			type ctype = 0;
           		if (this->get_current_class()) {
                    		ClassDef *cd = (ClassDef *) this->
							get_current_class();
                    		ctype = get_type(cd->get_classId()->get_id(),
                                        env)->get_type();
                   		}
           		if (t && ctype && t == ctype) {
                		Decl *d = find_ivar_decl(m_name, this);
                		if (d) {
                        		de->type_ = d->get_type();
                        		break;
                        		}
                		}
           		if (t) {  // try other types' ivars
                		RESET_EXC
                		class_ c = type_as_class(t);
                		if (exc == EXC_NONE) {
                   		type itype = class_get_field_type(c, m_name);
                   		if (itype) {
                        		de->type_ = new TypeInterface(itype);
                        		break;
                        		}
           		        }
                		}
           		sprintf(cmp_err_buf, "Type \"%.50s\" has no "
				"method (or ivar) \"%.50s\".",
                   		string_charp(type_name(t)),
                   		string_charp(m_name));
           		cmp_err(cmp_err_buf, de->get_line());
           		de->type_ = new TypeInterface();
         		}
		else {
			method m  = (method) tgm_ret[0].o;
			TypeInterface *mti = new TypeInterface(m, 0);
			de->type_ = mti;
			}
	   }
	break;
	}
	default: {
		cmp_err("Dot Expr Not Handling some TI.", de->get_line());
		de->type_ = new TypeInterface();
		}
	} // end TI switch
      break;
    }
      
    case Expr::SelfT:  {
      if (current_class) {
		TypeInterface *ct = current_class->get_type();	// TypeInterface *
      		ex->type_ = ct;
		}
//      switch (ct->tag()) {
//	case ParseNode::TypeSpecT: {
//		TypeSpec *ts = (TypeSpec *)ct;
//		switch (ts->tag()) {
//			case TypeSpec::SimpleTypeSpecT: {
//				SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
//				TypeName *tn = sts->get_name();
//				find_type(tn->get_name()->get_id(), 
//							ex, env, FALSE);
//				break;
//				}
//			default: {
//				cmp_err("Losing in Self (ts)", -1);
//				}
//			} // end ts switch
//		break;
//		}
//	default: {
//		cmp_err("Losing in Self (pn)", -1);
//		}
//	} // end pn switch
        break;
      }
      
    case Expr::NewT:  {
      // needs inside maker test
      TypeInterface *ct = current_type;		// TypeInterface *
      ex->type_ = ct;
      break;
    }
      
    case Expr::ArrayRefT:  {
      break;
    }
      
    case Expr::InvocExprT:  {
      InvocExpr *inve = (InvocExpr *)ex;
      inve->type_ = inve->get_invoc()->get_type();
      break;
    }
      
    case Expr::BindingExprT: {
      break;
    }
      
    case Expr::SelectorConstrT:  {
      SelectorConstr *sc = (SelectorConstr *)ex;
      // needs work
      TypeSpec *ts = sc->get_typeSpec();
      ParseNodeList *sc_fields = sc->get_fields();
      int nfields = count_lhs(sc_fields);
      switch (ts->tag()) {
	case TypeSpec::TaggedTypeSpecT: {
		TaggedTypeSpec *tts = (TaggedTypeSpec *)ts;
      		string tts_name = tts->get_name()->get_name()->get_id();
		bool one = string_equal(tts_name, string_const("oneof"));
		bool rec = string_equal(tts_name, string_const("record"));
		string nm = ts2nm(tts, sc->get_line());
		if (!one && !rec) {
		 	sprintf(cmp_err_buf, 
		 		"Constructors not yet supported for %s",
		 		string_charp(tts_name));
		 	cmp_err(cmp_err_buf, sc->get_line());
			break;
		 	}
		if (one && nfields != 1) {
				sprintf(cmp_err_buf, 
					"Wrong number of field initializers");
				cmp_err(cmp_err_buf, sc->get_line());
				break;
				}
		// create name for maker and look it up
		string nm2 = string_concat(nm, string_const("_MAKE"));
		type ft = 0;
		if (one) {FieldInit *fi = (FieldInit *) (sc_fields->front());
			string fnm = fi->get_id()->get_id();
			ft = fi->get_type()->get_type();
			nm2 = string_concat(nm2, string_const("_"));
			nm2 = string_concat(nm2, fnm);
			}
		find_type(nm2, sc, env, TRUE);
		TypeInterface *ti = sc->get_type();
		switch (ti->tag()) {
		  case TypeInterface::MethodT: {
			method m = ti->get_method();
			type at = UNPV(type, vec_fetch(m->arguments, 0));
			if (one && !isSubtype(ft, at)) {
					sprintf(cmp_err_buf, 
					"Invalid constructor due to "
					"type mismatch: %s is not "
					"a subtype of %s",
					ft?string_charp(type_name(ft))
						:"NONE",
					at?string_charp(type_name(at))
						:"NONE");
					cmp_err(cmp_err_buf, 
						sc->get_line());
					}
				    }
				} // end switch
		set_node_type(ts, sc, this, TRUE);
		break;
		}
	case TypeSpec::ParamTypeSpecT:
	case TypeSpec::SimpleTypeSpecT: {
		// we hope this is an equated name
		// actually we're coming through here with init exprs
		// 	i.e. any-old-type{...}
		// SimpleTypeSpec *sts = (SimpleTypeSpec *)ts;
		int line = sc->get_line();
		set_node_type(ts, ts, this, FALSE);
		type t = ts->get_type()->get_type();
		if (!t) {
			sprintf(cmp_err_buf, "Insufficient information "
				"to check constructor");
			cmp_err(cmp_err_buf, line);
			break;
			}
		else {
		   vec fields = type_as_class(t)->fields;
		   int fcount = vec_length(fields);
		   int index;
		   ParseNodeList *scfields = sc->get_fields();
		   int found_fields = 0;
		   int scount = scfields?scfields->length():0;
		   const char *snm = string_charp(simple_type_name(type_name(t)));
		   if (!strcmp(snm, "maybe")) {
				// Handle maybes separately...
				//    scount should be 1
				if (scount != 1) {
					cmp_err("Wrong number of initializers for maybe", line);
					}
				else {
					//    field name should be full or empty
					FieldInit *fi = (FieldInit*)scfields->front();
					string fi_name = fi->get_id()->get_id();
					TypeInterface *ti = fi->get_expr()->get_type();
                			type et = get_one_type(ti, line);
					if (string_equal(fi_name, string_const("full"))) {
						//    full value should have correct type 
						//		per field named value
      						formal f = UNPV(formal, vec_fetch(fields, 0));
      						type ft = f->t;
						//    also decorate the id of the field init...
						fi->get_id()->type_ = new TypeInterface(ft);
      						if (!(et && ft && isSubtype(et, ft))) {
				     	    		sprintf(cmp_err_buf, 
				     	    		"Invalid field initialization"
					    		" for field %s due to type"
					    		" mismatch."
				     	    		" %s is not a subtype of %s",
					    		string_charp(fi_name),
				     	    		et ? string_charp(type_name(et))
							:"NONE",
				     	    		ft ? string_charp(type_name(ft))
							:"NONE");
			        	    	cmp_err(cmp_err_buf, fi->get_line());
					    	}
					   }
					else {
						if (string_equal(fi_name, string_const("empty"))) {
						//    empty value should be nil (or type null)
      						type ft = class_as_type(Null);
						//    also decorate the id of the field init...
						fi->get_id()->type_ = new TypeInterface(ft);
      						if (!(et && ft && isSubtype(et, ft))) {
				     	    		sprintf(cmp_err_buf, 
				     	    		"Invalid field initialization"
					    		" for field %s due to type"
					    		" mismatch."
				     	    		" %s is not a subtype of %s",
					    		string_charp(fi_name),
				     	    		et ? string_charp(type_name(et))
							:"NONE",
				     	    		ft ? string_charp(type_name(ft))
							:"NONE");
			        	    		cmp_err(cmp_err_buf, fi->get_line());
							}
						}
						else {
							cmp_err("Wrong field name for maybe", line);
							}
					}
				}
			}
		   else {
			if (fcount != scount) {
			 	sprintf(cmp_err_buf, 
				    "Wrong number of initializers for type %s "
		 			"constructor", snm);
		 		cmp_err(cmp_err_buf, line);
				}
			else {
			      if (scfields) for (Pix p = scfields->first(); p ; 
							scfields->next(p)) {
				FieldInit *fi = (FieldInit*)(*scfields)(p);
				string fi_name = fi->get_id()->get_id();
      				TypeInterface *ti = fi->get_expr()->get_type();
                		type et = get_one_type(ti, line);
				for (index = 0; index < scount; index++) {
      					formal f = UNPV(formal, 
						vec_fetch(fields, index));
					if (!string_equal(f->name, fi_name))
						continue;
      					type ft = f->t;
					// as a side effect also decorate
					//  id of field init with appropriate
					//	type
					fi->get_id()->type_ = 
						new TypeInterface(ft);
      					if (!(et && ft && isSubtype(et, ft))) {
				     	    sprintf(cmp_err_buf, 
				     	    "Invalid field initialization"
					    " for field %s due to type"
					    " mismatch."
				     	    " %s is not a subtype of %s",
					    string_charp(fi_name),
				     	    et ? string_charp(type_name(et))
						:"NONE",
				     	    ft ? string_charp(type_name(ft))
						:"NONE");
			        	    cmp_err(cmp_err_buf, fi->get_line());
					    }
					else found_fields++;
				}
			      }
			    if ((!strcmp(snm, "oneof") && found_fields != 1)
				|| (found_fields != scount) ) {
				cmp_err("Incorrect number of field initializers",
					sc->get_line());
				}
			    }
			 }
		      }
		set_node_type(ts, sc, this, TRUE); 
		// string nm = type_name(t);
		// decode name to check if it's oneof or record...
		// int len = string_length(nm);
		// const char *nmcs = string_charp(nm);
		// if (len > 9 && ((nmcs[0] == 'r' &&
		// 	         nmcs[1] == 'e' &&
		// 	         nmcs[2] == 'c' &&
		// 	         nmcs[3] == 'o' &&
		// 	         nmcs[4] == 'r' &&
		// 	         nmcs[5] == 'd' &&
		// 	         nmcs[6] == '_' &&
		// 	         nmcs[7] == 'O' &&
		// 	         nmcs[8] == 'F')
		// 	      ||(nmcs[0] == 'o' &&
		// 		 nmcs[1] == 'n' &&
		// 		 nmcs[2] == 'e' &&
		// 		 nmcs[3] == 'o' &&
		// 		 nmcs[4] == 'f' &&
		// 		 nmcs[5] == '_' &&
		// 		 nmcs[6] == 'O' &&
		// 		 nmcs[7] == 'F')))
		// 	{ set_node_type(sts, sc, this, TRUE); }
		// else {
		// 	sprintf(cmp_err_buf, "Unexpected type %s for "
		// 		"constructor", nmcs);
		// 	cmp_err(cmp_err_buf, sc->get_line());
		// 	}
		break;
		}
	default: {
		sprintf(cmp_err_buf, "Unexpected type for SelectorConstr");
		cmp_err(cmp_err_buf, sc->get_line());
		}
	}
      break;
    }
      
    case Expr::ArrayConstrT:  {
      break;
    }
      
    case Expr::IdExprT: {
      IdExpr *ie = (IdExpr *)ex;
      string nm = ie->get_id()->get_id();
      // 9/25/95 dwc: changed from find_var_or_type
      // 	so that x: int := int wouldn't work...
      find_var(nm, ex, env, TRUE);
      break;
    }

      break;
    }
    return ex;
  }
    
  case ParseNode::InvocT:  {
    Invoc *inv = (Invoc*)pn;
    if (DEBUG) printf("got Invoc\n");
        Pix p;
        int i;
	method m;
	TypeInterface *iti = inv->get_routineId()->get_type();
	// dwc: 7/31/95: reworked to disallow types here, only methods now
	if (iti) m = iti->get_method();
	else {
		cmp_err("No type information for routine.",
				inv->get_line());
		inv->type_ = new TypeInterface();
		break;
		}

	// Handle no method
	if (m == NULL) {
		// Maybe try to find a name: switch on routine type
		// sprintf(cmp_err_buf, "No type information for method %.50s.",
		//	string_charp(inv->get_routineId()->get_id()));
		// cmp_err(cmp_err_buf, inv->get_line());
		cmp_err("No type information (or inappropriate type) for invocation.",
				inv->get_line());
		inv->type_ = new TypeInterface();
		break;
		}

	// Handle no arguments
        if (inv->get_exprs() == NULL) {
		if (vec_length(m->arguments) != 0) {
			cmp_err("Argument count mismatch.", inv->get_line());
			inv->type_ = new TypeInterface();
			}
		else {
			if (vec_length(m->returns) == 0) 
				inv->type_ = new TypeInterface();
			// if (vec_length(m->returns) == 1) {
				// type rt = UNPV(type, vec_fetch(m->returns, 0));
				// inv->type_ = new TypeInterface(rt);
				// }
        		if (vec_length(m->returns) > 0) 
				inv->type_ = new TypeInterface(m->returns);
			}
		break;
		}

	// Check argument count
        ParseNodeList l = *inv->get_exprs();
	if (!(m->arguments) || (vec_length(m->arguments) != l.length())) {
		cmp_err("Argument count mismatch.", inv->get_line());
		inv->type_ = new TypeInterface();
		break;
		}

	// Normal case
        for (i = 0, p = l.first(); p; l.next(p), i++) {
                formal f = UNPV(formal, vec_fetch(m->arguments, i));
                Expr *act = (Expr*)(l(p));
                type arg_type = get_one_type(act->get_type(), act->get_line());
                if (!arg_type || !f->t || !isSubtype(arg_type, f->t)) {
                        sprintf(cmp_err_buf, 
				"Type mismatch on argument %.50s to %.50s: expected %.50s, got %.50s.",
                                string_charp(f->name),
                                string_charp(method_name(m)),
                                f->t?string_charp(type_name(f->t)):"NONE",
                                arg_type?string_charp(type_name(arg_type)):"NONE");
			cmp_err(cmp_err_buf, inv->get_line());
			break;
                        }
                }
	if (vec_length(m->returns) == 0) inv->type_ = new TypeInterface();
	// if (vec_length(m->returns) == 1) {
			// type rt = UNPV(type, vec_fetch(m->returns, 0));
			// inv->type_ = new TypeInterface(rt);
			// }
        if (vec_length(m->returns) > 0) 
			inv->type_ = new TypeInterface(m->returns);
        break;
  }
    
  case ParseNode::RoutineIdT:  {
    RoutineId * rid = (RoutineId *) pn;
    
    switch (rid->tag()) {

    case RoutineId::SimpleRoutineIdT: {
      if (DEBUG) printf("decorating simpleroutine\n");
      SimpleRoutineId *sr = (SimpleRoutineId *)rid;
      sr->type_ = sr->get_primary()->get_type();
      rid->type_ = sr->type_;
      break;
    }

    case RoutineId::ComplexRoutineIdT:  {
      ComplexRoutineId *crid = (ComplexRoutineId *)rid;
      Expr *ex = crid->get_primary();
      TypeInterface *ti = ex->get_type();
      if (ti->tag() != TypeInterface::PMethodT) {
	cmp_err("Expected parameterized procedure or method type here",
			crid->get_line());
        break;
	}
      ParseNodeList *parms = crid->get_parms();
      vec pargs = tis2vec(parms, crid->get_line(), this);
      if (!pargs) {
	cmp_err("Insufficient information to do instantiation",
			crid->get_line());
	break;
	}
      method m = ti->get_pmethod();
      vec v = ti->get_parms();
      // possibly this 0 should be something else if inside a class...
      method instm = method_instantiate(m, 0, v, pargs);
      crid->type_ = new TypeInterface(instm, 0);
      rid->type_ = crid->type_;
      break;
    }

    case RoutineId::SuperClassRoutineIdT: {
      SuperClassRoutineId *sr = (SuperClassRoutineId *)rid;
      Id *id = sr->get_id();
      sr->type_ = new TypeInterface();
      rid->type_ = sr->type_;
      if (!this->get_current_class()) break;
      ClassDef *cd = (ClassDef *) this->get_current_class();
      type ctype = get_type(cd->get_classId()->get_id(), env)->get_type();
      class_ cc = type_as_class(ctype);
      RESET_EXC;
      class_ sc = class_superclass(cc);
      CATCH { exc = EXC_NONE; break; }
      objtype osc = type_as_objtype(class_as_type(sc));
      RESET_EXC;
      fevalue tgm_ret[2];
      getMethod(osc, tgm_ret, id->get_id());
      CATCH { exc = EXC_NONE; break; }
      method m  = (method) tgm_ret[0].o;
      sr->type_ = new TypeInterface(m,0);
      rid->type_ = sr->type_;
      break;
    }
  }
  break;
  }
    
  case ParseNode::BindingT:  {
    break;
  }
    
  case ParseNode::BindingArgT:  {
    break;
  }
    
  case ParseNode::FieldT:  {
    break;
  }
    
  case ParseNode::SuperInfoT:  {
    break;
  }
    
  case ParseNode::IdT: {
    if (DEBUG) printf("got IdT\n");
    Id *id = (Id *)pn;
    find_var_or_type(id->get_id(), id, env, FALSE);
    break;
  }
    
  default: {
    return NULL;
  }
  }
}
  

extern string err_list;
void cmp_err(const char *msg, int lineno)
{
char buf[1000];

	// sprintf(buf, "Error: Line %4.d: %.800s\n", lineno, msg);
	sprintf(buf, "Error: line %d: %.800s\n", lineno, msg);
	// sprintf(buf, "%.10d: error: %.800s\n", lineno, msg);
	if (err_list == NULL) err_list = string_new(buf);
	else err_list = string_concat(err_list, string_new(buf));
	}

#define MAX_CHECKPOINTS 10
static string save_err_list[MAX_CHECKPOINTS];
static int nchkpts = 0;

void cmp_err_check_point()
{
	save_err_list[nchkpts] = err_list;
	nchkpts++;
	}

void cmp_err_return_to_checkpoint()
{
	nchkpts--;
	err_list = save_err_list[nchkpts];
	}

int count_lhs(ParseNodeList *lp)
{
int count = 0;

      if (lp == NULL) return 0;
      ParseNodeList l = *lp;
      for (Pix p = l.first(); p ; l.next(p)) {
	ParseNode *pn = l(p);
	switch (pn->tag()) {
	case ParseNode::DeclT: {
          Decl *arg = (Decl *)pn;
	  switch (arg->tag()) {
	    case Decl::RegDeclT: {
	       RegDecl *r = (RegDecl *)arg;
	       count += r->get_ids()->length();
	       break;
	       }
	    case Decl::ImplDeclT: {
	       count++;
	       break;
	       }
	    }
          break;
	  }
       case ParseNode::IdOrIvarT: {
	 count++;
	 break;
	 }
       case ParseNode::FieldInitT: {
	 count++;
	 break;
	 }
       case ParseNode::FieldT: {
         Field *f = (Field *)pn;
	 count += f->get_ids()->length();
	 break;
	 }
       case ParseNode::IdT: {
	 count++;
	 break;
	 }
       case ParseNode::ExprT: {
	 /* this case may or may not be used... */
	 count++;
	 break;
	 }
       default: {
  	cmp_err("count_lhs not handling some node", pn->get_line());
	if (DEBUG) pn->print(2);
  	  }
        }
      }
	return count;
}
ParseNode* TypeCheckObj::setup(ParseNode *pn)
{
  if (DEBUG1) printf("BEGIN **SETUP** SWITCH\n");
  switch (pn->tag()) {
  case ParseNode::ModuleT:  {
    Module *m = (Module *) pn;
    cmp_err_check_point();
    // removed 8/28/95 dwc
    // handle_equates(pn, TRUE, this);
    switch (m->tag()) {
    	case Module::ImplModuleT: {
    	ImplModule *im = (ImplModule *)m; 
	current_module = im;
	// do 1st pass bookkeeping
        if (!allow_redefs) {
		env = env->add_mark();
		cmp_err_check_point();
		}
	}
      }
    break;
    }
  case ParseNode::EquateT: {
	Equate *eq = (Equate *)pn;
	handle_equates(eq, TRUE, this);
	break;
	}
  case ParseNode::SpecEltT:  {
    SpecElt * se = (SpecElt *) pn;
    switch (se->tag()) {
    case SpecElt::TypeIntfT: {
	TypeIntf *ti = (TypeIntf *)se;
	objtype nt;
	ptype pt;
	ParseNodeList *parms = ti->get_parms();
	ParseNodeList *restricts = ti->get_wheres();
	string nm = ti->get_id()->get_id();
        bool exists = FALSE;
	if (env->look_up(nm)) exists = TRUE;
	if (!exists || ti->get_type()->tag() == TypeInterface::NullT) {
	   if (parms) {
		pt = new_ptype();
		nt = &pt->hdr.inh;
	     }
	   else {
		if (restricts) {
                	sprintf(cmp_err_buf, "Extraneous where clauses in "
				"non-parameterized type", 
				string_charp(nm));
			cmp_err(cmp_err_buf, ti->get_line());
		}
		nt = new_objtype();
	     } 
	  nt->name = nm;
          }
	else nt = type_as_objtype(ti->get_type()->get_type());
	if (exists && !allow_redefs) {
                sprintf(cmp_err_buf, "Redefinition of %.50s occurred",
				string_charp(nm));
		cmp_err(cmp_err_buf, ti->get_line());
		redef_count++;
		}
	else {
		if (!exists) {
		   TypeInterface *ti = new TypeInterface( objtype_as_type(nt));
		   se->type_ = ti;
		   env = env->add_type_binding(nm, ti);
		   }
		}
        env = env->add_mark();
	if (parms) {
		// Really need to have parms added to env after mark
		int count = count_parms(parms);
		pt->params = parms2vec(parms, pt, restricts, count, this);
		}
	nt->methods_ = make_vec_Method(0, FALSE);
	nt->supertypes_ = make_vec_Method(0, FALSE);
	nt->methods_ = methods_from_def(ti, objtype_as_type(nt), this);
	nt->supertypes_ = supertypes_from_intf(ti, this);
	bool ok = check_type_against_supertypes(nt, ti->get_line(), env);
	if (!ok) nt->supertypes_ = make_vec_Method(0, FALSE);
	inside_type_intf = TRUE;
        break;
	}
    case SpecElt::RoutineSpecT: {
	RoutineSpec *rs = (RoutineSpec *)pn;
	RoutineIntf *ri = rs->get_routine();
	Signature* sig = ri->get_signature();
	ParseNodeList *parms = sig->get_parms();
	ParseNodeList *restricts = sig->get_where();
        env = env->add_mark();
	int count = parms? count_parms(parms) : 0;
	if (parms) parms2vec(parms, 0, restricts, count, this);
	// if (parms) for (Pix p = parms->first(); p ; parms->next(p)) {
        //       Parm *parm = (Parm *)(*parms)(p);
        //       ParseNodeList *ids = parm->get_ids();
        //       if (ids) for (Pix p2 = ids->first() ; p2 ; ids->next(p2)) {
        //         Id *id = (Id *)(*ids)(p2);
        //         param pm = new_param();
        //         pm->name = id->get_id();
        //         pm->ptype_ = 0;
        //         env = env->add_type_binding(id->get_id(),
        //               new TypeInterface(param_as_type(pm)));
        //         }
	//   }
        break;
        }
    } // end switch
    break;
    } // end spec elt
  case ParseNode::ImplEltT:  {
    ImplElt *ie = (ImplElt *)pn;
    switch (ie->tag()) {
    case ImplElt::RoutineDefT: {
	RoutineDef *rd = (RoutineDef *)ie;
	RoutineIntf *ri = rd->get_routineIntf();
	string nm = ri->get_id()->get_id();
	Signature *sign = ri->get_signature();
	// new... might be ok... probable name clash...
	// env = env->add_type_binding(nm, new TypeInterface(m, 0));
        env = env->add_mark();
	//ParseNodeList *args = sign->get_args();
        //if (args) for (Pix pa = args->first(); pa ; args->next(pa)) {
          //Decl *arg = (Decl *)(*args)(pa);
          //switch (arg->tag()) {
            //case Decl::RegDeclT: {
               //RegDecl *r = (RegDecl *)arg;
               //TypeInterface *ti = arg->get_type();
                 //ParseNodeList *l = r->get_ids();
                 //for (Pix p = l->first(); p ; l->next(p)) {
                        //Id *id = (Id*)(*l)(p);
                        //if (DEBUG) id->print(3);
                        //string nm = id->get_id();
                        //RESET_EXC
                        //inv = env->add_var_binding(nm, ti);
                        //CATCH_EXC(exc_duplicate) {
                        //sprintf(cmp_err_buf, "Duplicate name: %.50s",
                                //string_charp(id->get_id()));
                         //cmp_err(cmp_err_buf, id->get_line());
                         //}
                        //}
                //break;
                //}
            //}
          //}
	break;
	}
    case ImplElt::ClassDefT: {
	ClassDef *cd = (ClassDef *)ie;
	ParseNodeList *parms = cd->get_parms();
	ParseNodeList *restricts = cd->get_wheres();
	this->set_current_class(cd);
	TypeSpec *dt = (TypeSpec *)cd->get_deftype();
	this->set_current_deftype(dt);
	string nm = string_empty();
	if (dt) switch (dt->tag()) {
	   case TypeSpec::SimpleTypeSpecT: {
		nm = ts2nm(dt, cd->get_line());
		break;
		}
	   case TypeSpec::ParamTypeSpecT: {
		ParamTypeSpec *pts = (ParamTypeSpec *)dt;
		nm = pts->get_name()->get_name()->get_id();
		break;
		}
	   }
	this->set_current_type(get_type(nm, env));
	if (this->get_current_type() == 0) {
		// sprintf(cmp_err_buf, "Type %.50s is missing", string_charp(nm));
		// cmp_err(cmp_err_buf, cd->get_line());
		this->set_current_type(new TypeInterface());
		}
        inside_class_def = TRUE;
        // Build a class_ Object
	bool exists;
	TypeInterface *ti;
	type nt;
	pclass pc;
	class_ c;
	if (parms) {
		nm = string_concat(cd->get_classId()->get_id(), 
					parms2nm(parms));
		exists = FALSE;
		if (env->look_up(nm)) exists = TRUE;
		if (exists) {
			ti = cd->get_type();
			nt = cd->get_type()->get_type();
			c = type_as_class(nt);
        		c->fields = formals_from_decls(cd->get_decl(), this);
			}
		else {
			pc = new_pclass();
			// ?need to set up fields, special, specialText
        		pc->hdr.inh.hdr.inh.name = cd->get_classId()->get_id();
        		pc->fields = formals_from_decls(cd->get_decl(), this);
	        	pc->special = FALSE;
       	 		pc->specialText = string_empty();
       			pc->superclass = superclass_from_inherits(
				cd->get_inherits(), this);
			nt = ptype_as_type(pclass_as_ptype(pc));
			ti = new TypeInterface(nt);
			}
		}
	else {
		nm = cd->get_classId()->get_id();
		exists = FALSE;
		if (env->look_up(nm)) exists = TRUE;
		if (exists) {
			ti = cd->get_type();
			nt = cd->get_type()->get_type();
			// recompute fields (and their types)
			if (nt) {
				c = type_as_class(nt);
	        		c->fields = formals_from_decls(cd->get_decl(), this);
				}
			}
		else {
        		c = new_class();
        		c->hdr.inh.name = cd->get_classId()->get_id();
	        	c->fields = formals_from_decls(cd->get_decl(), this);
       	 		c->special = FALSE;
        		c->specialText = string_empty();
        		c->superclass = superclass_from_inherits(
				cd->get_inherits(), this);
			nt = class_as_type(c);
			ti = new TypeInterface(nt);
			}
		}
	if (exists && !allow_redefs) {
                sprintf(cmp_err_buf, "Attempted redefinition "
			"of %.50s foiled", string_charp(nm));
		cmp_err(cmp_err_buf, cd->get_line());
		redef_count++; 
		break;
		}
	else {
		cd->type_ = ti;
		if (exists) env->update_binding(nm, ti);
		else env = env->add_type_binding(nm, ti);
		}
        env = env->add_mark();
	TypeInterface *so_ti = make_same_object_interface(nt);
	string so_nm = method_name(so_ti->get_method());
	env = env->add_var_binding(so_nm, so_ti);

	objtype objtnt = type_as_objtype(nt);
	vec sprs;
	if (this->get_current_type() == 0 || 
		this->get_current_type()->get_type() == 0) {
		sprs = make_vec_simple(Type, 0);
		}
	else {
		sprs = make_vec_simple(Type, 1);
		vec_store(sprs, 0, PV(this->get_current_type()->get_type()));
		}
        handleSupertypes(objtnt, sprs);
	// objtype nt = new_objtype();
	// nt->name = cd->get_classId()->get_id();
	// nt->supertypes_ = make_vec_simple(Type, 0);
	// Suppress the following for a while: seems like a leftover from exts
	// vec_store(nt->supertypes_, 0, PV(this->get_current_type()->get_type()));
	// nt->methods_ = methods_from_def(cd->get_classElts(), 
	// 			objtype_as_type(nt), env);
	if (!exists) {
	    if (parms) {
		int count = count_parms(parms);
		parms2vec(parms, pclass_as_ptype(pc), restricts, 
					count, this);
		pc->hdr.inh.hdr.inh.methods_ = make_vec_Method(0, FALSE);
       		pc->hdr.inh.hdr.inh.methods_ = methods_from_def(cd, nt, this);
		}
	     else {
        	c->hdr.inh.methods_ = make_vec_Method(0, FALSE);
        	c->hdr.inh.methods_ = methods_from_def(cd, nt, this);
		}
	     }
	int vsize = vec_length(objtnt->methods_);
	int i;
	for (i = 0; i < vsize; i++) {
		method m = UNPV(method, (vec_fetch(objtnt->methods_, i)));
		env = env->add_var_binding(m->name,
			new TypeInterface(m, 0));
		}
        // Check Class Definition against itself, its type interface,
        //	its superclass
        check_def_against_type(nt, this->get_current_type()->get_type(), 
					cd->get_line(), env);
	break;
	}
    } // end switch
    break;
    } // end impl elt
  case ParseNode::TypeWhenArmT: {
    TypeWhenArm *twa = (TypeWhenArm *)pn;
    TypeCheckObj::xmogrify(twa->get_typ());
    env = env->add_mark();
    Id *id = twa->get_id();
    if (id) {
	id->type_ = twa->get_typ()->get_type();
	RESET_EXC
    	env = env->add_var_binding(id->get_id(), id->type_);
	CATCH_EXC(exc_duplicate) {
           sprintf(cmp_err_buf, "Duplicate name: %.50s",
	           string_charp(id->get_id()));
           cmp_err(cmp_err_buf, id->get_line());
	   }
	}
    }
  case ParseNode::RoutineIntfT: {
        if (inside_type_intf) env = env->add_mark();
        break;
	}
  case ParseNode::BodyT:  {
    if (DEBUG1) printf("got ELSEIF\n");
    this->env = this->env->add_mark();
    // removed 8/28/95 dwc
     // handle_equates(pn, TRUE, this);
    break;
    } // end body case
  case ParseNode::ElseIfT:  {
    if (DEBUG1) printf("got ELSEIF\n");
    this->env = this->env->add_mark();
    break;
    } // end elseif case
  case ParseNode::StmtT:  {
    Stmt * s = (Stmt *) pn;
    switch (s->tag()) {
    case Stmt::BlockStmtT: {
        if (DEBUG1) printf("got BLOCK\n");
        this->env = this->env->add_mark();
        break;
	}  // end block stmt case
    case Stmt::WhileStmtT:{
        if (DEBUG1) printf("got WHILE\n");
        this->env = this->env->add_mark();
	this->active_loops += 1;
        break;
	}  // end while stmt case
    case Stmt::IfStmtT:{
        if (DEBUG1) printf("got IF\n");
        this->env = this->env->add_mark();
        break;
	}  // end if stmt case
    case Stmt::ForStmtT:{
        if (DEBUG1) printf("got WHILE\n");
        this->env = this->env->add_mark();
	this->active_loops += 1;
        break;
	}  // end for stmt case
    case Stmt::DeclForStmtT:{
        if (DEBUG1) printf("got WHILE\n");
        this->env = this->env->add_mark();
	this->active_loops += 1;
        break;
	}  // end declfor stmt case
     break;
    } // end stmt switch
   break;
   } // end stmt case in parse node switch
  break;
  } // end parse node switch
  if (DEBUG1) printf("END **SETUP** SWITCH\n");
  return NULL;
}

/* During typechecking, classes have had the type they implement as their
	supertype.  This is not really kosher, so we clean it up here.
*/
void fix_class_supertypes(ParseNodeList *pnl)
{
    for (Pix p = pnl->first(); p ; pnl->next(p)) {
    ParseNode *pn = (*pnl)(p);
    switch (pn->tag()) {
        case ParseNode::ModuleT: {
            Module *m = (Module *) pn;
            switch (m->tag()) {
                case Module::ImplModuleT: {
                    ImplModule *im = (ImplModule *)m;
                    ParseNodeList *impls = im->get_impls();
		    for (Pix p2 = impls->first(); p2 ; impls->next(p2)) {
			ImplElt *ie = (ImplElt*)(*impls)(p2);
			switch (ie->tag()) {
			    case ImplElt::ClassDefT: {
				ClassDef *cd = (ClassDef*)ie;
				TypeInterface *ti = cd->get_type();
      				type t = ti->get_type();
      				objtype objt = type_as_objtype(t);
      				handleSupertypes(objt, 
					make_vec_simple(Type, 0));
				}
			    }
			}
                    }
                }
            }
        }
    }
 }
