// Copyright 1995 Barbara Liskov

#ifndef _TYPE_CHECK_H
#define _TYPE_CHECK_H

#include "traverse.h"
#include "environment.h"
#include "parse.h"

/*----------------------------------------------------------------

     A TypeCheckObj is a type of TraverseObj, who's xmogrify method
     when invoked on a ParseNode, returns a new ParseNode in which all
     type names have been replaced with pointers to the respective type
     interfaces specified in the type environment.

----------------------------------------------------------------*/
    
class TypeCheckObj : public TraverseObj {

  public: 
    enum Mission { Check };
    TypeCheckObj(Environment *e, Mission m) {
	env = e; 
	instns = new Environment();
	mission_ = m; 
	active_loops = 0; 
	inside_type_intf = FALSE;
	inside_class_def = FALSE; 
	current_class = 0; 
	current_type = 0; 
	current_module = 0; 
	current_deftype = 0; 
	allow_redefs = FALSE;
        redef_count = 0;
	}

    ParseNode *xmogrify(ParseNode *pn);
    ParseNode *setup(ParseNode *pn);

    Environment *get_env()
      { return env; }
  
    void set_env(Environment *e)
      { env = e; }
  
    Environment *get_instns()
      { return instns; }
  
    void set_instns(Environment *new_instns)
      { instns = new_instns; }
  
    ParseNode *get_current_class()
      { return current_class; }
  
    ParseNode *get_current_deftype()
      { return current_deftype; }
  
    ParseNode *get_current_module()
      { return current_module; }
  
    TypeInterface *get_current_type()
      { return current_type; }
    bool allow_redefs;
    int redef_count;
  
  private:
    Environment *env;		// symbol table
    Environment *instns;	// instantiations of tagged types
    Mission mission_;
    method current_method;
    ParseNode *current_class;
    ParseNode *current_deftype;
    ParseNode *current_module;
    TypeInterface *current_type;
    int active_loops;
    bool inside_type_intf;
    bool inside_class_def;

    void set_current_method(method m)
      { current_method  = m; }
  
    method get_current_method()
      { return current_method; }
  
    void set_current_class(ParseNode * c)
      { current_class  = c; }
  
    void set_current_deftype(ParseNode * e)
      { current_deftype  = e; }
  
    void set_current_type(TypeInterface * t)
      { current_type  = t; }
  

};

#endif /* _TYPE_CHECK_H */

extern void handle_equates(ParseNode *pn, bool add, TypeCheckObj *tco);
extern void process_equates(ParseNodeList *l, TypeCheckObj *tco);
extern void remove_equates(ParseNodeList *l, TypeCheckObj *tco);
extern void instantiate_tagged(TypeSpec *ts, string nm, int line,
			TypeCheckObj *tco);
extern method new_is_method(type, string, int);
extern method new_value_method(type, string, int, TypeSpec *);
extern method new_get_method(type, string, int, TypeSpec *);
extern method new_set_method(type, string, int, TypeSpec *);
extern method new_one_var_make_method(type, string, int, TypeSpec *);
extern method new_rec_str_make_method(type, int, ParseNodeList *);
extern method new_copy_method(type t);
extern method new_equal_method(type t);
extern method new_similar_method(type t);
extern int count_parms(ParseNodeList *parms);
extern int count_lhs(ParseNodeList *l);
extern int count_fcns(ParseNodeList *l);
extern int count_meths(ParseNodeList *l);
extern vec formals_from_decls(ParseNodeList *l, TypeCheckObj *tco);
extern vec methods_from_def(ParseNode *def, type t, TypeCheckObj *tco);
extern method method_from_signature(Signature *signa, TypeCheckObj *tco);
extern vec superclass_from_inherits(Inherit *l, TypeCheckObj *tco);
extern vec supertypes_from_intf(TypeIntf *tin, TypeCheckObj *tco);
extern vec supertypes_from_intfnm(string s);
extern vec parms2vec(ParseNodeList *l, ptype pt, ParseNodeList *r,
                        int count, TypeCheckObj *tco);
extern vec tis2vec(ParseNodeList *l, int count, TypeCheckObj *tco);
extern void instantiate_pts(ParamTypeSpec *ps, string nm, int line,
                        TypeCheckObj *tco);
extern ParseNodeList *tintf_get_method_rets(ParseNode *tpn, string m_name);
extern TypeInterface *pn_to_ti(ParseNode *tpn, Environment *env);
extern Decl *find_ivar_decl(string m_name, TypeCheckObj *tco);
extern bool same_deftype(ParseNode *tpn, ParseNode *current, Environment *env);
extern TypeInterface *get_type(string s, Environment *env);
extern string ts2nm(TypeSpec *ts, int line);
extern string fields2nm(ParseNodeList *pnl);
extern string parms2nm(ParseNodeList *pnl);
extern void set_node_type(TypeSpec *st, ParseNode *pn, TypeCheckObj *tco,
                bool verbose);
extern bool find_type(string s, ParseNode *pn, Environment *env, bool verbose);
extern void find_var(string s, ParseNode *pn, Environment *env, bool verbose);
extern void find_var_or_type(string s, ParseNode *pn,
                        Environment *env, bool verbose);
extern bool check_type_against_supertypes(objtype nt, int line, Environment *env
);
extern void check_def_against_type(type def, type typ, int line,
                        Environment *env);
extern TypeInterface *make_same_object_interface(type ct);
extern "C" {
extern type get_one_type(TypeInterface *ti, int lineno);
extern method method_instantiate(method m, type self_type, vec parms, vec pargs);
extern Decl *find_ivar_in_dl(string m_name, ParseNodeList *dl);
extern void handleSupertypes(objtype t, vec as_parsed);
extern void check_methods(ParseNodeList *idl, ClassDef *cd, Environment *env);
extern void check_method(Id *idn, ClassDef *cd, Environment *env);
extern void check_rtn_against_rtn_spec(method m1, method m2, int line);
extern void dupe_method(vec v, int size, string m_name, int line);
extern void finishParams(ptype pt);
extern string string_const(char *s);
extern bool exported(string nm, TypeCheckObj *tco);
extern type class_get_field_type(class_, string);
extern ptype new_ptype();
extern param new_param();
extern pclass new_pclass();
extern type instn_as_type(instn i);
}
