// Copyright 1995 Barbara Liskov

#ifndef _INTERFACE_H
#define _INTERFACE_H

#include "runtime/obj.h"
#include "types/method.h"
#include "types/vec.h"
#include <stdio.h>
#include "my_string.h"

extern "C" {
extern string type_name(type t);
}

class ParseNode;


/*----------------------------------------------------------------------
  This is a temporary definition of the type interface class.  Each
  interface has a number to ensure that synonyms for a type do indeed
  point to the same type interface.

-----------------------------------------------------------------------*/

class TypeInterface {

 public:
   enum Tag 
	{ SingleT, MultipleT, NullT, MethodT, IntfT, ParmT, PMethodT };

   tag() 
	{ return tag_; }
   uid() 
	{ return uid_; }
   type get_type() 
	{ if (tag_ == SingleT) return type_; else return (type)0; }
   method get_method() 
	{ if (tag_ == MethodT) return method_; else return (method)0; }
   method get_pmethod() 
	{ if (tag_ == PMethodT) return method_; else return (method)0; }
   vec get_parms() 
	{ if (tag_ == PMethodT) return parms_; else return (vec)0; }
   vec get_mult() 
	{ if (tag_ == MultipleT) return v_; else return (vec)0; }
   string get_parm() 
	{ if (tag_ == ParmT) return parm_; else return (string)0; }
   ParseNode *get_intf() 
	{ if (tag_ == IntfT) return intf_; else return (ParseNode *)0; }

   void print() { printf("Type: ");
		if (tag_ == NullT) printf("None\n");
		if (tag_ == SingleT) {
			printf("Single Type: ");
			if (type_) printf("%s\n",
				string_charp(type_name(type_)));
			else printf("No Type\n");
			}
		if (tag_ == MethodT) {
			printf("Method Type: ");
			if (method_) printf("%s\n", 
				string_charp(method_name(method_)));
			else printf("No Method\n");
			}
		if (tag_ == PMethodT) {
			printf("Param Method Type: ");
			if (method_) printf("%s\n", 
				string_charp(method_name(method_)));
			else printf("No Method\n");
			}
		if (tag_ == MultipleT) printf("Multiple Types\n");
		if (tag_ == ParmT) printf("Parameter %s\n", parm_); 
		if (tag_ == IntfT) printf("Type Interface\n"); 
		if (tag_ != NullT && tag_ != SingleT && tag_ != MethodT
				&& tag_ != PMethodT && tag_ != MultipleT && 
				tag_ != IntfT) {
			printf("OOPS %d\n", tag_);
			}
	   }

   TypeInterface(vec v) 
	{ uid_ = count++; tag_ = MultipleT; v_ = v; }
   TypeInterface(method m, int x) 
	{ uid_ = count++; tag_ = MethodT; method_ = m; parms_ = 0; }
   TypeInterface(method m, vec parms) 
	{ uid_ = count++; tag_ = PMethodT; method_ = m; parms_ = parms; }
   TypeInterface(type t) 
	{ uid_ = count++; tag_ = SingleT; type_ = t; }
   TypeInterface(ParseNode *intf) 
	{ uid_ = count++; tag_ = IntfT; intf_ = intf; }
   TypeInterface(string p) 
	{ uid_ = count++; tag_ = ParmT; parm_ = p; }
   TypeInterface() 
	{ uid_ = -1; tag_ = NullT; type_ = (type)0; method_ = (method)0; }

 private:
   int uid_;
   type type_;
   vec v_;
   method method_;
   ParseNode *intf_;
   string parm_;
   vec parms_;
   Tag tag_;
   static int count;
 };

#endif /* _INTERFACE_H */
