// Copyright 1995 Barbara Liskov

#include "parse.h"
#include "type_replace.h"
#include "boot/wellknown.h"
#include "types/class.h"
#include "types/dict.h"
#include "cmp_err.h"

#define get_any_obj(x) (any_get_value(x).o)

extern dict global_typeEnv;
extern "C" {
extern obj findType(string name, dict typeEnv);
extern void dict_print(dict d);
extern string err_list;
}

#define DEBUG 0

string null_str;

Environment *my_basic_env() {

  Environment *res;

  res = new Environment();
  null_str = string_new("null");
  string int_str = string_new("int");
  string bool_str = string_new("bool");
  string real_str = string_new("real");
  string string_str = string_new("string");
  string char_str = string_new("char");
  string array_str = string_new("array");
  string any_str = string_new("any");
  string vector_str = string_new("vector");
  string sequence_str = string_new("sequence");
  string maybe_str = string_new("maybe");
  res = res->add_type_binding(null_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(null_str)))));
  res = res->add_type_binding(int_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(int_str)))));
  res = res->add_type_binding(bool_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(bool_str)))));
  res = res->add_type_binding(real_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(real_str)))));
  res = res->add_type_binding(string_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(string_str)))));
  res = res->add_type_binding(char_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(char_str)))));
  res = res->add_type_binding(any_str,
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(any_str)))));
  res = res->add_type_binding(array_str,
      new TypeInterface(obj_as_type2(get_any_obj(get_wellknown(array_str)))));
  res = res->add_type_binding(vector_str,
      new TypeInterface(obj_as_type2(get_any_obj(get_wellknown(vector_str)))));
  res = res->add_type_binding(sequence_str,
      new TypeInterface(obj_as_type2(get_any_obj(get_wellknown(sequence_str)))));
  res = res->add_type_binding(maybe_str,
      new TypeInterface(obj_as_type2(get_any_obj(get_wellknown(maybe_str)))));
      /* new TypeInterface(obj_as_type(findType(char_str, global_typeEnv)))); */
#ifdef STANDALONE
  res = res->add_type_binding(string_new("record"), new TypeInterface);
  res = res->add_type_binding(string_new("struct"), new TypeInterface);
  res = res->add_type_binding(string_new("oneof"), new TypeInterface);
#endif
/*
  printf("testing look_up\n");
  res->look_up(null_str);
  printf("end testing look_up\n");
*/
  return res;
}

ParseNode* TypeReplaceObj::setup(ParseNode *pn)
{
	return NULL;
	}

ParseNode* TypeReplaceObj::xmogrify(ParseNode *pn)
{
  switch (pn->tag()) {

    case ParseNode::ModuleT: {
      Module *m = (Module *) pn;
    
      switch (m->tag()) {
      
	case Module::SpecModuleT: {
	  SpecModule *sm = (SpecModule *) m;
	  SpecModule *new_sm;
	  ParseNodeList *equates, *specs;

	  /* Add all new types defined in this module to the current */
	  /* environment (first, push a marker so that these */
	  /* definitions can be easily removed again). */

	  env = env->add_mark();

	  mission_ = Add;

	  if (specs = sm->get_specs())
	    traverse_parsenode_list(specs, this);

	  /* Add all new type names defined in the equate list to the */
	  /* current environment. */

	  // removed 3/1/95... sm structure reorganized...
	  // if (equates = sm->get_equates())
	  // 	equates = traverse_parsenode_list(equates, this);

	  if (DEBUG) env->print();

	  env = env->resolve();

	  if (DEBUG) env->print();

	  /* Now use the new environment to replace type names in this */
	  /* module */

	  mission_ = Replace;
	  // if (equates)
	  //   equates = traverse_parsenode_list(equates, this);
	  if (specs = sm->get_specs())
	     specs = traverse_parsenode_list(specs, this);
	  new_sm = new SpecModule(specs);

	  if (err_list) env = env->clear_mark();

	  return new_sm;
	}

	case Module::ImplModuleT: { 
	  break;	
	}

      }
      break;
    }

    case ParseNode::SpecEltT:  {
      SpecElt *se = (SpecElt *) pn;
    
      switch (se->tag()) {
      
	case SpecElt::RoutineSpecT: { 
	  RoutineSpec *rs = (RoutineSpec *) se;

	  if (mission_ == Add) {
	    string nm = rs->get_routine()->get_id()->get_id();
	    env = env->add_type_binding(nm, new TypeInterface(rs));
	    return rs;
	  }
	  break;
	}
      
	case SpecElt::TypeIntfT: {
	  TypeIntf *ti = (TypeIntf *) se;

	  if (mission_ == Add) {
	    string nm = ti->get_id()->get_id();
	    env =
	      env->add_type_binding(nm, new TypeInterface(ti));
	    ParseNodeList *parms = ti->get_parms();
	    if (parms) {
		for (Pix p = parms->first(); p ; parms->next(p)) {
		   ParseNodeList *idl = ((Parm *)(*parms)(p))->get_ids();
		   if (idl) {
		      for (Pix pa = idl->first(); pa ; idl->next(pa)) {
			Id *id = (Id *)(*idl)(pa);
	    		env =
	      		    env->add_type_binding(id->get_id(),
      			    new TypeInterface(id->get_id()));
			    }
			}
		   }
		}
	    return ti;
	  }
	  break;
	}
      
      }
      break;
    }

    case ParseNode::RoutineIntfT: {
      RoutineIntf *ri = (RoutineIntf *) pn;
    
      switch (ri->tag()) {
      
	case RoutineIntf::ProcHeaderT: {
	  break;
	}
     
	case RoutineIntf::IterHeaderT: {
	  break;
	}
      
      }
      break;   
    }

    case ParseNode::SignatureT: {
      Signature *sig = (Signature *) pn;

      switch (sig->tag()) {

	case Signature::ProcSigT: {
	  break;
	}
	case Signature::IterSigT: {
	  break;
	}
      }
      break;    
    }

    case ParseNode::EquateT: {
      Equate *eq = (Equate *) pn;
    
      switch (eq->tag()) {
      
	case Equate::TypeEquateT: {
	  TypeEquate *teq = (TypeEquate *) eq;

	  if (mission_ == Add) {
	   env = env->add_type_binding(teq->get_id()->get_id(),
      new TypeInterface(obj_as_type(get_any_obj(get_wellknown(null_str)))));
	    return teq;
	  }

	  break;
	}
      
	case Equate::ExprEquateT: {
	  ExprEquate *eeq = (ExprEquate *) eq;
	  Expr *expr = eeq->get_expr();

	  if (mission_ == Add)
	    if (expr->tag() == Expr::IdExprT) {
	      IdExpr *idexpr = (IdExpr *) expr;
	      
	      env = env->add_ind_binding(
		       eeq->get_id()->get_id(),
		       idexpr->get_id()->get_id());
	      return eeq;
	    }
	    else
	      env = env->add_const_binding(
		       eeq->get_id()->get_id(),
		       (TypeInterface *) NULL,
		       (Value *) NULL);
	  break;
	}
      }
      break;    
    }

    case ParseNode::ImplEltT:  {
      ImplElt * ie = (ImplElt *) pn;
    
      switch(ie->tag()) {
	case ImplElt::RoutineDefT: {
	  break;
	}
	
	case ImplElt::ClassDefT: {
	  break;
	}
      }
      break;
    }  

    case ParseNode::InheritT: { 
      break;
    }
    
    case ParseNode::RenamingT: { 
      break;
    }
    
    case ParseNode::ExportT: { 
      break;
    }
  
    case ParseNode::MethodOrOpDefT: { 
      break;
    }
    
    case ParseNode::ParmT: { 
      break;
    }
    
    case ParseNode::FormalT: { 
      break;
    }
    
    case ParseNode::ExceptionT: { 
      break;
    }
    
    case ParseNode::RestrictionT: { 
      break;
    }
    
    case ParseNode::TypeSpecT:  {
      TypeSpec * ts = (TypeSpec *) pn;

      switch (ts->tag()) {

	case TypeSpec::SimpleTypeSpecT: {
	  break;
	}
	case TypeSpec::ParamTypeSpecT: {
	  break;
	}
	case TypeSpec::TaggedTypeSpecT: {
	  break;
	}
	case TypeSpec::RoutineTypeSpecT: {
	  break;
	}
      }
      break;
    }  

    case ParseNode::TypeNameT:  {
//      TypeName *tn = (TypeName *) pn;
//
 //     NameBinding *bind = this->env->look_up(tn->get_name()->get_id());
//
 //     if (bind == 0) {
//	sprintf(cmp_err_buf, "No binding found for %.50s (TR).",
//			string_charp(tn->get_name()->get_id()));
//	// exit(1);
//	cmp_err(cmp_err_buf, tn->get_line());
 //     }
  //    else if (bind->tag() != NameBinding::TypeBindingT) {
//	sprintf(cmp_err_buf, "Naming conflict; %.50s found, but not as type.",
//		string_charp(tn->get_name()->get_id()));
//	// exit(1);
//	cmp_err(cmp_err_buf, tn->get_line());
 //     }
  //    else
//	// return (new TypeObject(tn->get_line, bind->get_type()));
//	return (new TypeInterface(bind->get_type()));
    }

    case ParseNode::ActualParmT:  {
      break;
    }

    case ParseNode::ParmOpT:  {
      break;
    }

    case ParseNode::StmtT:  {
      Stmt * s = (Stmt *) pn;

      switch (s->tag()) {

	case Stmt::InitVarExprT: {
	  break;
	}

	case Stmt::InitVarInvokeT: {
	  break;
	}

	case Stmt::DeclStmtT: {
	  break;
	}

	case Stmt::AssignInvokeT: {
	  break;
	}

	case Stmt::AssignExprStmtT: {
	  break;
	}

	case Stmt::AssignExprT: {
	  break;
	}

	case Stmt::InvokeStmtT: {
	  break;
	}

	case Stmt::WhileStmtT: {
	  break;
	}

	case Stmt::IfStmtT: {
	  break;
	}

	case Stmt::TagcaseT: {
	  break;
	}

	case Stmt::TypecaseT: {
	  break;
	}

	case Stmt::ReturnStmtT: {
	  break;
	}

	case Stmt::YieldT: {
	  break;
	}

	case Stmt::SignalStmtT: {
	  break;
	}

	case Stmt::ExitT: {
	  break;
	}

	case Stmt::BreakT: {
	  break;
	}

	case Stmt::ContinueT: {
	  break;
	}

	case Stmt::BlockStmtT: {
	  break;
	}

	case Stmt::ResignalStmtT: {
	  break;
	}

	case Stmt::ExceptStmtT: {
	  break;
	}

	case Stmt::InitT: {
	  break;
	}

	case Stmt::DeclForStmtT: {
	  break;
	}

	case Stmt::ForStmtT: {
	  break;
	}
	break;
      }
    }
    
    case ParseNode::DeclT: {
      Decl *d = (Decl *) pn;
    
      switch (d->tag()) {
      
	case Decl::RegDeclT: {
	  break;
	}

	case Decl::ImplDeclT: {
	  break;
	}

	case Decl::VarArgsDeclT: {
	  break;
	}
	break;
      }
    }

    case ParseNode::IdOrIvarT:  {
      break;
    }
    
    case ParseNode::BodyT:  {
      break;
    }
    
    case ParseNode::ElseIfT:  {
      break;
    }
    
    case ParseNode::TagWhenArmT:  {
      break;
    }

    case ParseNode::TypeWhenArmT:  {
      break;
    }
    
    case ParseNode::ExWhenArmT:  {
      break;
    }
    
    case ParseNode::OthersHandlerT:  {
      break;
    }
    
    case ParseNode::FieldInitT:  {
      break;
    }

    case ParseNode::ExprT:  {
      Expr *ex = (Expr *) pn;
    
      switch (ex->tag()) {

	case Expr::NilT: {
	  break;
	}

	case Expr::LiteralT: {
	  Literal *l = (Literal *) pn;
	      
	  switch (l->tag()) {
		
	    case Literal::IntLiteralT: {
	      break;
	    }
		
	    case Literal::BoolLiteralT:  {
	      break;
	    }
		
	    case Literal::CharLiteralT:  {
	      break;
	    }

	    case Literal::StringLiteralT:  {
	      break;
	    }

	    case Literal::RealLiteralT: {
	      break;
	    }
	    break;
	  }
	}

	case Expr::BinaryT: {
	  break;
	}

	case Expr::UnaryT: {
	  break;
	}

	case Expr::InstantiationT: {
	  break;
	}

	case Expr::DotExprT:  {
	  break;
	}

	case Expr::SelfT:  {
	  break;
	}

	case Expr::NewT:  {
	  break;
	}

	case Expr::ArrayRefT:  {
	  break;
	}

	case Expr::InvocExprT:  {
	  break;
	}

	case Expr::BindingExprT: {
	  break;
	}

	case Expr::SelectorConstrT:  {
	  break;
	}

	case Expr::ArrayConstrT:  {
	  break;
	}

	case Expr::IdExprT: {
	  break;
	}
	break;
      }
    }

    case ParseNode::InvocT:  {
      break;
    }

    case ParseNode::RoutineIdT:  {
      RoutineId * rid = (RoutineId *) pn;

      switch (rid->tag()) {
      
	case RoutineId::SimpleRoutineIdT: {
	  break;
	}

	case RoutineId::ComplexRoutineIdT:  {
	  break;
	}

	case RoutineId::SuperClassRoutineIdT: {
	  break;
	}
	break;
      }
    }

    case ParseNode::BindingT:  {
      break;
    }

    case ParseNode::BindingArgT:  {
      break;
    }
    
    case ParseNode::FieldT:  {
      break;
    }
    
    case ParseNode::SuperInfoT:  {
      break;
    }
    
    case ParseNode::IdT: {
      break;
    }
    
    default: {
      return NULL;
    }
  }
  
  return NULL;
}
