#ifndef _FE_CONFIG_H
#define _FE_CONFIG_H

/* cachesize is measured in bytes. */

#include "common/basic.h"
#include "common/bits.h"
#include "common/or_num.h"
#include <sys/types.h>
#include "client/handle.h"
#include "client/future.h"

#include "config/vdefs/FE_DEFAULT_CACHE_SIZE.h"

struct sockaddr_in;

typedef struct fe_config_s {
    size_t		cachesize;
    size_t		avg_obj;          
    int			FE_port; /* also used to specify shm key */
    bool		slave;
    char		*srcfile;
    char                *theta_srcfile;
    char		*veneer_srcfile;
    char		*veneer_language;
    struct sockaddr_in  *OR_spec;
    bool 		OR_spec_initialized;
    bool		runInBackground;
    bool                shm; /* use shared memory */
    long                shm_bufsize;
    int                 max_prefetch;
    bool                allow_sigio; /* Allow SIGIO to be delivered to FE */
    int                 debug_level;     /* Debugging info level */
    OR_num              initial_or_num;  /* # of OR we initially connect to */

    handle_table        *ht;
    future_table        *ft;

} *fe_config;

#define FE_DEFAULT_AVERAGE_OBJ_SIZE 60

extern fe_config FEConf;  /* The configuration of this FE */

bool config_process_options (int argc, char* argv[]);
  /* process command line options and set up FEConf accordingly.  
     Return TRUE if all goes well, FALSE if there were problems.
  */

#endif /* _FE_CONFIG_H */
