#include "init_fe.h"
#include "fe_config.h"
#include "cache/cache.h"
#include "cache/net.h"
#include "cache/gc_init.h"
#include "cache/gc_register.h"
#include "boot/wellknown.h"
#include "boot/specs.h"
#include "client/dump.h"
#include "client/invoke.h"
#include "types/str.h"
#include "types/dict.h"
#include "runtime/transinfo.h"
#include "runtime/commit.h"
#include "runtime/stats.h"
#include "common/fail.h"
extern "C" {
#include "types/stdlist.h"
}
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>


// Used to create local directory
extern "C" {
extern obj create_directory(obj dummy);
extern void simple_directory_insert_(obj, string, any);
}

bool normal_heap = TRUE; // see runtime/alloc.h for a description

// FE's local directory 
obj fe_local_directory;
static obj root;

// FE's type directory
obj fe_type_directory;

void copy_the_dict(void *env, string key) {
    dict d = (dict)env;
    any a = dict_fetch(d, key);
    simple_directory_insert_(fe_type_directory, key, a);
}

static void init_root () {
    if ((root = cache_fetch_root(FEConf->initial_or_num, 0)) != 0) {
	add_wellknown("root", &root);
    } else {
	warn("Couldn't find root object.\n");
	exit(EXIT_FAILURE);
    }
}

static void maybe_compile_exit (dict typeEnv) {
  int src;
  if (FEConf->srcfile != 0) {
    if ((src = open(FEConf->srcfile, O_RDONLY)) == -1) {
      perror("opening Theta source file");
      exit(EXIT_FAILURE);
    }
    fe_dump(src, typeEnv);
    exit(EXIT_SUCCESS);
  }
  if (FEConf->theta_srcfile != 0) {
    if ((src = open(FEConf->theta_srcfile, O_RDONLY)) == -1) {
      perror("opening Theta source file");
      exit(EXIT_FAILURE);
  }
#if 0
    theta_compile(src, typeEnv);
#endif    
    exit(EXIT_SUCCESS);
  }
  if (FEConf->veneer_srcfile != 0) {
    if (!veneer_dump(FEConf->veneer_srcfile, typeEnv, FEConf->veneer_language))
      exit(EXIT_FAILURE);
    exit(EXIT_SUCCESS);
  }
}

void init_fe(int argc, char *argv[]) {
    dict typeEnv;
    if (sizeof(fevalue) != sizeof(long)) {
	printf("Architectural assumptions violated\n");
	exit(-1);  
    }
    if (!config_process_options(argc, argv))
      exit(EXIT_FAILURE);
#if COLLECT_STATS
    zero_stats();
#endif
    cache_init();
    Fe_Trans = new Transinfo;
    initialize_exceptions();
    initEmptyList();
    initialize_wellknowns();
    gc_init();
    typeEnv = init_builtin_types();
    init_invocations();
    maybe_compile_exit(typeEnv);

    if (!FEConf->OR_spec_initialized) {
	warn("Could not find OR. Set environment "
	     "variable \"THOR\" and try again.");
	exit(EXIT_FAILURE);
    }

    FEConf->initial_or_num = init_locator(FEConf->OR_spec);
    if (FEConf->initial_or_num == 0)
    {
	warn("Couldn't find OR in locator file.  Check this file "
	     "and the THORNAMES environment variable.");
	exit(EXIT_FAILURE);
    }

    init_root();   // The initial root is fetched here.
    // No mutable persistent object is read here ??
    // Currently, this is true but will it be true always  XXX - Atul 

    // Commit an initial transaction so that the data structures modified
    // during the initialization phase are not considered part of the
    // first "real" transaction. This commit should never fail since
    // no persistent object has been modified. You should even need to go
    // to the server
    if (commit_trans() != COMMITTED) {
	fprintf(stderr, "Initial transaction that sets up various methods"
		"failed\n");
	exit(EXIT_FAILURE);
    }

    // Create FE's local directory
    fe_local_directory = create_directory(0);
    gc_register_root(&fe_local_directory);

    // Create FE's type directory
    fe_type_directory = create_directory(0);
    gc_register_root(&fe_type_directory);
    
    struct closure cl;
    cl.f = (ifunc)copy_the_dict;
    cl.env = typeEnv;
    dict_keys(typeEnv, cl);
    delete_dict(typeEnv);
}
