#include "common/basic.h"
#include "types/type.h"
#include "LabDate_class.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "types/int.h"
#include "labbase_types.h"


IMPL_GET_CLASS(LabDateC)

struct LabDatedv_s LabDate_methods =  
{
  {
    {0, 0, STD_FOFFSET, 0, 0,
       normal_get_address,
       &LabDateC_get_class
    },
    LabValue_equal_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_,
    LabValue_print_,
    LabValue_get_type_
  },
  LabDate_get_value_
};


IMPL_GET_CLASS(LabDateExtC)

struct LabDateExtdv_s LabDateExt_methods =  
{
  {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address,
     &LabDateExtC_get_class },
  LabDateExt_create
};

string LabDate_get_value(LabDate self) {
  return self->hdr.methods->get_value(self);
}

string LabDate_get_value_(LabDate self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->date, string);
  return self->date;
}

LabDate LabDateExt_create(LabDateExt self, string s) {
  LabDate new_date;
  new_date = NEW(struct LabDate_s);
  LabDate_create_maker(new_date, s);
  return new_date;
}

LabDate LabDate_create_maker(LabDate new_date, string s) {
  init_obj_hdr((obj)new_date, LabDateC);
  new_date->date = s;
  LabValue_new_maker(&new_date->hdr.inh, LAB_DATE);
  return;
}

#include "types/class_class.h"

DV LabDate_DH[] = {  (DV)&LabDate_methods };
void initLabDate()
{
  LabDateC->dh = LabDate_DH;
  LabDateC->dhsize = 1;
  LabDate_methods.super.super.c = LabDateC;
}

DV LabDateExt_DH[] = {  (DV)&LabDateExt_methods };
void initLabDateExt()
{
  LabDateExtC->dh = LabDateExt_DH;
  LabDateExtC->dhsize = 1;
  LabDateExt_methods.super.c = LabDateExtC;
}
    
     
     


























