#include "common/basic.h"
#include "types/type.h"
#include "LabValue_meth.h"
#include "LabInt_class.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "types/int.h"
#include "labbase_types.h"


IMPL_GET_CLASS(LabIntC)

struct LabIntdv_s LabInt_methods =  
{
  {
    { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &LabIntC_get_class
    },
    LabValue_equal_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_,
    LabValue_print_,
    LabValue_get_type_
  },
  LabInt_equal_,
  LabInt_lt_,
  LabInt_gt_,
  LabInt_le_,
  LabInt_ge_,
  LabInt_print_,
  LabInt_get_value_
};

IMPL_GET_CLASS(LabIntExtC)

struct LabIntExtdv_s LabIntExt_methods =  
{
  {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address,
     &LabIntExtC_get_class },
  LabIntExt_create
};

/*=================================================================*/

bool LabInt_equal(LabInt self, LabValue v) {
  return self->hdr.methods->equal(self, v);
}

bool LabInt_equal_(LabInt self, LabValue v) {
  LabInt ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, LabInt, LabIntC);
  if (ni != NULL)
     return(self->i == ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=================================================================*/

bool LabInt_lt(LabInt self, LabValue v) {
  return self->hdr.methods->lt(self, v);
}

bool LabInt_lt_(LabInt self, LabValue v) {
  LabInt ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, LabInt, LabIntC);
  if (ni != NULL)
     return(self->i < ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=================================================================*/

bool LabInt_gt(LabInt self, LabValue v) {
  return self->hdr.methods->gt(self, v);
}

bool LabInt_gt_(LabInt self, LabValue v) {
  LabInt ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, LabInt, LabIntC);
  if (ni != NULL)
     return(self->i > ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=================================================================*/

bool LabInt_le(LabInt self, LabValue v) {
  return self->hdr.methods->le(self, v);
}

bool LabInt_le_(LabInt self, LabValue v) {
  LabInt ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, LabInt, LabIntC);
  if (ni != NULL)
     return(self->i <= ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=================================================================*/

bool LabInt_ge(LabInt self, LabValue v) {
  return self->hdr.methods->ge(self, v);
}

bool LabInt_ge_(LabInt self, LabValue v) {
  LabInt ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, LabInt, LabIntC);
  if (ni != NULL)
     return(self->i >= ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=================================================================*/

void LabInt_print(LabInt self, wr w) {
   self->hdr.methods->print(self, w);
}

void LabInt_print_(LabInt self, wr w) {
  int x;
  string s;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  x = self->i;
  s = int_unparse(x);
  wr_putString(w, s);
}

/*=================================================================*/

int LabInt_get_value(LabInt self) {
  return self->hdr.methods->get_value(self);
}

int LabInt_get_value_(LabInt self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  return self->i;
}

/*=================================================================*/

LabInt LabIntExt_create(LabIntExt self, int x) {
  LabInt new_num;
  new_num = NEW(struct LabInt_s);
  LabInt_create_maker(new_num, x);
  return new_num;
}

LabInt LabInt_create_maker(LabInt new_num, int x) {
  init_obj_hdr((obj)new_num, LabIntC);
  new_num->i = x;
  LabValue_new_maker(&new_num->hdr.inh, LAB_INTEGER);
  return;
}

/*=================================================================*/

#include "types/class_class.h"

DV LabInt_DH[] = {  (DV)&LabInt_methods };
void initLabInt()
{
  LabIntC->dh = LabInt_DH;
  LabIntC->dhsize = 1;
  LabInt_methods.super.super.c = LabIntC;
}

DV LabIntExt_DH[] = {  (DV)&LabIntExt_methods };
void initLabIntExt()
{
  LabIntExtC->dh = LabIntExt_DH;
  LabIntExtC->dhsize = 1;
  LabIntExt_methods.super.c = LabIntExtC;
}
    
     
     


























