#ifndef _LABINT_H
#define _LABINT_H

#include "LabInt_def.h"
#include "LabValue_def.h"

#ifdef __cplusplus
extern "C" {
#endif

extern bool LabInt_equal(LabInt self, LabValue);
extern bool LabInt_lt(LabInt self, LabValue v);
extern bool LabInt_gt(LabInt self, LabValue v);
extern bool LabInt_le(LabInt self, LabValue v);
extern bool LabInt_ge(LabInt self, LabValue v);
extern void LabInt_print(LabInt self, wr w);
extern int LabInt_get_value(LabInt self);

extern LabInt LabIntExt_create(LabIntExt self, int x);
extern LabInt LabInt_create_maker(LabInt self, int x);
extern void initLabInt();
extern void initLabIntExt();

/* The following routines require a non-surrogate and should only be used by
   subclasses */

extern bool LabInt_equal_(LabInt self, LabValue);
extern bool LabInt_lt_(LabInt self, LabValue v);
extern bool LabInt_gt_(LabInt self, LabValue v);
extern bool LabInt_le_(LabInt self, LabValue v);
extern bool LabInt_ge_(LabInt self, LabValue v);
extern void LabInt_print_(LabInt self, wr w);
extern int LabInt_get_value_(LabInt self);

#ifdef __cplusplus
}
#endif

#endif /* _LABINT_H */






