#include "common/basic.h"
#include "types/type.h"
#include "LabString_meth.h"
#include "LabSequence_class.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "types/int.h"
#include "labbase_types.h"


IMPL_GET_CLASS(LabSequenceC)

struct LabSequencedv_s LabSequence_methods =  
{
  {
    {
      {0, 0, STD_FOFFSET, 0, 0,
       normal_get_address,
       &LabSequenceC_get_class
       },
      LabValue_equal_,
      LabValue_lt_,
      LabValue_gt_,
      LabValue_le_,
      LabValue_ge_,
      LabValue_print_,
      LabValue_get_type_
    },
    LabString_equal_, 
    LabString_get_value_   
  },
  LabSequence_get_value_
};

IMPL_GET_CLASS(LabSequenceExtC)

struct LabSequenceExtdv_s LabSequenceExt_methods =  
{
  {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address,
     &LabSequenceExtC_get_class },
  LabSequenceExt_create
};

LabString LabSequence_get_value(LabSequence self) {
  return self->hdr.methods->get_value(self);
}

LabString LabSequence_get_value_(LabSequence self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh.hdr.inh);
  DISCOVER(self->seq, LabString);
  return self->seq;
}

LabSequence LabSequenceExt_create(LabSequenceExt self, LabString s)
{
  LabSequence new_seq;
  new_seq = NEW(struct LabSequence_s);
  LabSequence_create_maker(new_seq, s);
  return new_seq;
}

LabSequence LabSequence_create_maker(LabSequence new_seq, LabString s)
{
  init_obj_hdr((obj)new_seq, LabSequenceC);
  new_seq->seq = s;
  LabValue_new_maker(&new_seq->hdr.inh.hdr.inh, LAB_DNA_SEQUENCE);
  return;
}

#include "types/class_class.h"

DV LabSequence_DH[] = {  (DV)&LabSequence_methods };
void initLabSequence()
{
  LabSequenceC->dh = LabSequence_DH;
  LabSequenceC->dhsize = 1;
  LabSequence_methods.super.super.super.c = LabSequenceC;
}

DV LabSequenceExt_DH[] = {  (DV)&LabSequenceExt_methods };
void initLabSequenceExt()
{
  LabSequenceExtC->dh = LabSequenceExt_DH;
  LabSequenceExtC->dhsize = 1;
  LabSequenceExt_methods.super.c = LabSequenceExtC;
}

     


























