#include "common/basic.h"
#include "types/type.h"
#include "LabString_class.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "types/int.h"
#include "labbase_types.h"


IMPL_GET_CLASS(LabStringC)

struct LabStringdv_s LabString_methods =  
{
  {
    {0, 0, STD_FOFFSET, 0, 0,
       normal_get_address,
       &LabStringC_get_class
    },
    LabValue_equal_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_,
    LabValue_print_,
    LabValue_get_type_
  },
  LabString_equal_,
  LabString_get_value_
};


IMPL_GET_CLASS(LabStringExtC)

struct LabStringExtdv_s LabStringExt_methods =  
{
  {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address,
     &LabStringExtC_get_class },
  LabStringExt_create
};

bool LabString_equal (LabString self, LabString s) {
  return self->hdr.methods->equal(self, s);
}

bool LabString_equal_ (LabString self, LabString s) {
  LabString ls;
  FIXUPREAD (&self->hdr.inh.hdr.inh);
  DISCOVER(self->str, string);
  ls = CAST(s, LabString, LabStringC);
  if (ls != NULL)
    return (self->str == ls->str);
  else
    SIGNAL_EXC(exc_type_error);
}

string LabString_get_value(LabString self) {
  return self->hdr.methods->get_value(self);
}

string LabString_get_value_(LabString self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->str, string);
  return self->str;
}

LabString LabStringExt_create(LabStringExt self, string s)
{
  LabString new_labstr;
  new_labstr = NEW(struct LabString_s);
  LabString_create_maker(new_labstr, s);
  return new_labstr;
}

LabString LabString_create_maker(LabString new_labstr, string s)
{
  init_obj_hdr((obj)new_labstr, LabStringC);
  new_labstr->str = s;
  LabValue_new_maker(&new_labstr->hdr.inh, LAB_STRING);
  return;
}

#include "types/class_class.h"

DV LabString_DH[] = {  (DV)&LabString_methods };
void initLabString()
{
  LabStringC->dh = LabString_DH;
  LabStringC->dhsize = 1;
  LabString_methods.super.super.c = LabStringC;
}

DV LabStringExt_DH[] = {  (DV)&LabStringExt_methods };
void initLabStringExt()
{
  LabStringExtC->dh = LabStringExt_DH;
  LabStringExtC->dhsize = 1;
  LabStringExt_methods.super.c = LabStringExtC;
}

     


























