/*ES_BEGIN*/
#include <stdio.h>  
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "labbase_types.h"
#include "LabValue_class.h"
#include "LabValue_meth.h"
#include "runtime/except.h"
#include "runtime/force.h"

/*ES_BEGIN: Temporary definition to avoid linkage failure.*/
#define FAILURE(s) fprintf(stderr, "%s", s); abort();  
/*ES_END*/


IMPL_GET_CLASS(LabValueC)
     
struct LabValuedv_s LabValue_methods =
{   
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &LabValueC_get_class
  },
  LabValue_equal_,
  LabValue_lt_,
  LabValue_gt_,
  LabValue_le_,
  LabValue_ge_,
  LabValue_print_,
  LabValue_get_type_
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

bool LabValue_lt (LabValue self, LabValue v) {
  return self->hdr.methods->lt(self, v);         /* same as self.lt(v) */
} 

bool LabValue_lt_ (LabValue self, LabValue v) {
  FIXUPREAD(&self->hdr.inh);
  FAILURE("abstract class, should not be called");
}

bool LabValue_equal (LabValue self, LabValue v) {
  return self->hdr.methods->equal(self, v);
}

bool LabValue_equal_ (LabValue self, LabValue v) {
  FIXUPREAD (&self->hdr.inh);
  FAILURE("abstract class, should not be called"); 
}

bool LabValue_gt (LabValue self, LabValue v) {
  return self->hdr.methods->gt(self, v);
}

bool LabValue_gt_ (LabValue self, LabValue v) {
  FIXUPREAD(&self->hdr.inh);
  return (!LabValue_lt(self, v) && !LabValue_equal(self, v));
  RESIGNAL_ANY_EXC;
} 

bool LabValue_ge (LabValue self, LabValue v) {
  return self->hdr.methods->ge(self, v);
}

bool LabValue_ge_ (LabValue self, LabValue v) {
  FIXUPREAD(&self->hdr.inh);
  return (!LabValue_lt(self, v));
  RESIGNAL_ANY_EXC;
}

bool LabValue_le (LabValue self, LabValue v) {
    return self->hdr.methods->le(self, v);
}

bool LabValue_le_ (LabValue self, LabValue v) {
  FIXUPREAD(&self->hdr.inh);
  return (LabValue_lt(self, v) || LabValue_equal(self, v));
  RESIGNAL_ANY_EXC;
}

void LabValue_print(LabValue self, wr w) {
    self->hdr.methods->print(self, w);
}

void LabValue_print_(LabValue self, wr w) {
/**ES: To be defined. Maybe.... */
}

int LabValue_get_type(LabValue self) {
  self->hdr.methods->get_type(self);
}

int LabValue_get_type_(LabValue self) {
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->type_, int);
  return self->type_;
}

void LabValue_new_maker(LabValue self, int t) {
  self->type_ = t;
}


#include "types/class_class.h"

DV LabValue_DH [] = {  (DV)&LabValue_methods };
void initLabValue()
{
  LabValueC->dh = LabValue_DH;
  LabValueC->dhsize =1;
  LabValue_methods.super.c = LabValueC;
}









