#ifndef _LABVALUE_H
#define _LABVALUE_H

#include "basic_def.h"
#include "LabValue_def.h"
#include "types/wr.h"
#include "common/iter.h"

#ifdef __cplusplus
extern "C" {
#endif


/*ES_BEGIN
  These are the Possible values for type_ in LabValue:
ES_END*/

enum lab_type_id {
  LAB_UNDEFINED,     /* DO NOT USE YET. */
  LAB_BOOLEAN,       /* DO NOT USE YET. */
  LAB_INTEGER,  
  LAB_FLOAT,         /* DO NOT USE YET. */
  LAB_DATE,  
  LAB_STRING,
  LAB_DNA_SEQUENCE,  
  LAB_LIST,          /* DO NOT USE YET. */
  LAB_SLIST,         /* DO NOT USE YET. */
  LAB_SET,           /* DO NOT USE YET. */
  LAB_MATERIAL_POINTER,  
  LAB_STEP_POINTER, /* DO NOT USE YET. */
  LAB_TERM,         /* DO NOT USE YET. */
  LAB_SLIST_ELEM    /* NOT FOR PUBLIC CONSUMPTION. */
};


extern bool LabValue_equal(LabValue self, LabValue v); /* signals type_error */
extern bool LabValue_lt(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_gt(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_le(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_ge(LabValue self, LabValue v); /* signals unsupported,type_error */
extern void LabValue_print(LabValue self, wr w);
extern int LabValue_get_type(LabValue self);

extern void LabValue_new_maker(LabValue self, int t);
extern void initLabValue (); 

/* The following routines require a non-surrogate
   and should be used only by subclasses */

extern bool LabValue_equal_(LabValue self, LabValue v); /* signals type_error */
extern bool LabValue_lt_(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_gt_(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_le_(LabValue self, LabValue v); /* signals unsupported,type_error */
extern bool LabValue_ge_(LabValue self, LabValue v); /* signals unsupported,type_error */
extern void LabValue_print_(LabValue self, wr w);
extern int LabValue_get_type_(LabValue self);

#ifdef __cplusplus
}
#endif

#endif /* _LABVALUE_H */






