/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "types/str.h"
#include "types/stdlist.h"
#include "map.h"
#include "runtime/except.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "LabValue_def.h"
#include "LabString_class.h"
#include "Material_class.h"
#include "Material_meth.h"
#include "Step.h"
#include "dd_id_tag_entry_def.h"
#include "dd_step_kind_entry_class.h"
#include "dd_material_kind_entry.h"
#include "labbase_types.h"
#include "basic_def.h"
/*ES_BEGIN : for test routines below.*/
#include "types/listProcs.h"
#include "dd_entry.h"
/*ES_END*/


/*=====================================================================*/

IMPL_GET_CLASS(MaterialC)

struct Materialdv_s Material_methods =
{
  {
    {0, 0, STD_FOFFSET, 0, 0,
       normal_get_address,
       &MaterialC_get_class
    },
    LabValue_equal_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_,
    LabValue_print_,
    LabValue_get_type_
  },
  Material_id_,
  Material_kind_,
  Material_add_,
  Material_first_Step_,
  Material_next_Step_,
  Material_lt_,
  Material_equal_
};

IMPL_GET_CLASS(MaterialExtC)

struct MaterialExtdv_s MaterialExt_methods = { 

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &MaterialExtC_get_class},
  MaterialExt_create
};

/*=====================================================================*/

#define CAST(VAL, CTYPE, TYPEOBJ)                                             \
        (isSubtype(class_as_type(get_obj_class((obj)VAL)),                    \
                   (type)TYPEOBJ) ? (CTYPE)VAL : (CTYPE) 0)

/*HC:
     CAST: Cast the value VAL to the C type CTYPE, which is represented
     by the Theta type object TYPEOBJ, returning NULL if VAL is not
     representable as a CTYPE.

     Passing a TYPEOBJ that does not correspond to CTYPE will have
     unpredictable results.
*/

string Material_id(Material self) {
  return self->hdr.methods->id(self);
}

string Material_id_(Material self) {
  list l;
  Step s;
  dd_step_kind_entry create_sk = 
    (dd_step_kind_entry) get_hardwired_entry("create");
  dd_id_tag_entry id_tag;
  LabValue id_value;
  LabString id_string;

  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->step_history_, list);
  DISCOVER(self->kind_, dd_material_kind_entry);

  l = self->step_history_;
  loop {
    s = (Step) first(l);
    CATCH {
      exc = EXC_NONE;
      SIGNAL_EXC(exc_not_possible);
    }

    if (Step_kind_(s) == create_sk) {
      id_tag = dd_material_kind_entry_primary_id_tag(self->kind_);
      id_value = Step_fetch(s, (dd_step_tag_entry) id_tag);
      break; /*HC: This breaks the loop if the condition hold */
    }
    
    l = rest(l);
  }
  
  id_string = CAST(id_value, LabString, LabStringC);
  if (id_string !=NULL)
     return (id_string->str);
  else
     SIGNAL_EXC(exc_type_failure);  
}

/*=====================================================================*/

dd_material_kind_entry Material_kind(Material self) {
  return self->hdr.methods->kind(self);
}

dd_material_kind_entry Material_kind_(Material self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->kind_, dd_material_kind_entry);
  return self->kind_;
}

/*=====================================================================*/

void Material_add(Material self, Step s) {
  self->hdr.methods->add(self, s);
}

void Material_add_(Material self, Step s)
{
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->step_history_, list);
  self->step_history_ = cons((any) s, self->step_history_);
  RESIGNAL_ANY_EXC;
}

/*=====================================================================*/

Step Material_first_Step(Material self) {
  return self->hdr.methods->first_Step(self);
}

Step Material_first_Step_(Material self) {
  Step s;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->step_history_, list);
  DISCOVER(self->cursor_, list);
  self->cursor_ = self->step_history_;
  s = (Step) first(self->cursor_);
  RESIGNAL_ANY_EXC;
  self->cursor_ = rest(self->cursor_);
  return s;
}

/*=====================================================================*/

Step Material_next_Step(Material self) {
  return self->hdr.methods->next_Step(self);
}

Step Material_next_Step_(Material self) {
  Step s;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->cursor_, list);
  s = (Step) first(self->cursor_);

/*ES_BEGIN
  CATCH {
    fprintf(stderr, "---Material_next_Step_: exception occurred...\n");
  }
ES_END*/
  
  RESIGNAL_ANY_EXC;
/*ES_BEGIN*/
  fprintf(stderr, "---Material_next_Step_: after RESIGNAL_ANY_EXC, i.e. no exc occurred...\n");
/*ES_END*/
  self->cursor_ = rest(self->cursor_);
  return s;
}

/*=====================================================================*/

bool Material_lt(Material self, LabValue v) {
  return self->hdr.methods->lt(self, v);
}

bool Material_lt_(Material self, LabValue v) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  SIGNAL_EXC(exc_unsupported);
}

/*=====================================================================*/

bool Material_equal(Material self, LabValue v) {
  return self->hdr.methods->equal(self, v); 
}

bool Material_equal_(Material self, LabValue v) {
  Material m;
  if (m = CAST(v, Material, MaterialC))
     return (m == self);
  else
    SIGNAL_EXC(exc_type_error);
}

/*=====================================================================*/

Material MaterialExt_create(MaterialExt self, dd_material_kind_entry kind, 
			    list create_step_info) 
{
  Material new_mat;
  Step new_step;
  StepExt sext;
  dd_id_tag_entry id_tag;
  LabValue id_value;
  list l;
  dd_step_tag_entry key;

/*ES_BEGIN : test */
  fprintf(stderr, "---kind(%d), kind_name(%s)\n", 
	  entry_kind((dd_entry)kind),
	  string_charp(dd_entry_identifier((dd_entry)kind)));
/*ES_END*/

/*------------------------------------------------------------------------
 * Check whether the id_tag is given in create_step_info. 
 */

  id_tag = dd_material_kind_entry_primary_id_tag(kind);
  l = create_step_info; 

  loop {
    key = (dd_step_tag_entry) first(l);
    CATCH {
      exc_missing_tag.name = string_new("the material id");
      SIGNAL_EXC(exc_missing_tag);
    }

    if (key == (dd_step_tag_entry) id_tag) {  /* Found */
/*ES_BEGIN*/
      fprintf(stderr, "---Found id_tag in the list.\n");
/*ES_END*/
      break;
    }
    else {
      l = rest(l);  /* pass the tag */
      l = rest(l);  /* pass the value */
    }
  }

/*-----------------------------------------------------------------------
 * Create a material, and initiate kind_ and step_history_.
 */

  new_mat = NEW(struct Material_s);
  init_obj_hdr((obj)new_mat, MaterialC);
  new_mat->kind_ = kind;
  new_mat->step_history_ = empty_list();

/*-----------------------------------------------------------------------
 * Then, add tag created_material into the created_step_info.
 */

  create_step_info = cons((any) new_mat, create_step_info);
  create_step_info = 
    cons((any) get_hardwired_entry("created_material"), create_step_info);

/*-----------------------------------------------------------------------
 * Create a step of step_kind "create", and pass the create_step_info.
 */

  new_step = StepExt_create(sext, (dd_step_kind_entry) get_hardwired_entry("create"), 
		      create_step_info);

/*-----------------------------------------------------------------------
 * Then, add the newly created step into the material's step_history_.
 */

  Material_add(new_mat, new_step);

/*-----------------------------------------------------------------------
 * Finally, register the id of the newly created material under id_tag for
 * that Material, and its type in LabValue.
 */

  dd_id_tag_entry_add(id_tag, Material_id(new_mat), new_mat);
  LabValue_new_maker(&new_mat->hdr.inh, LAB_MATERIAL_POINTER);

  return new_mat;
}

/*=====================================================================*/

#include "types/class_class.h"

DV Material_DH [] = { (DV)&Material_methods };
void initMaterial()
{
  MaterialC->dh = Material_DH;
  MaterialC->dhsize = 1;
  Material_methods.super.super.c = MaterialC;
}

DV MaterialExt_DH [] = { (DV)&MaterialExt_methods };
void initMaterialExt()
{
  MaterialExtC->dh = MaterialExt_DH;
  MaterialExtC->dhsize = 1;
  MaterialExt_methods.super.c = MaterialExtC;
}

/*=====================================================================*/
     







