#ifndef _MATERIAL_H
#define _MATERIAL_H

#include "basic_def.h"
#include "Material_def.h"
#include "Step_def.h"
#include "LabValue_def.h"
#include "map_def.h"
#include "types/list.h"
#include "dd_material_kind_entry_def.h"

#ifdef __cplusplus
extern "C" {
#endif
  
  extern string Material_id(Material self);
  extern dd_material_kind_entry Material_kind(Material self);
  extern void Material_add(Material self, Step s);
  extern Step Material_first_Step(Material self);
  extern Step Material_next_Step(Material self);

  extern bool Material_lt(Material self, LabValue v);
  extern bool Material_equal(Material self, LabValue v);

  extern Material MaterialExt_create(MaterialExt self, dd_material_kind_entry kind, 
				     list create_step_info);

  extern void initMaterial();
  extern void initMaterialExt();
  
  /* The following require a non-surrogate self and should onlu be used by 
     subclasses. */
  
  extern string Material_id_(Material self);
  extern dd_material_kind_entry Material_kind_(Material self);
  extern void Material_add_(Material self, Step s);
  extern Step Material_first_Step_(Material self);
  extern Step Material_next_Step_(Material self);

  extern bool Material_lt_(Material self, LabValue v);
  extern bool Material_equal_(Material self, LabValue v);
  
#ifdef __cplusplus
}
#endif

#endif /* _MATERIAL_H */


