#include "common/basic.h"
#include "types/type.h"
#include "Number_class.h"
#include "runtime/alloc.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "types/int.h"
#include "labbase_types.h"


IMPL_GET_CLASS(NumberC)

struct Numberdv_s Number_methods =  
{
  {
    {0, 0, STD_FOFFSET, 0, 0,
       normal_get_address,
       &NumberC_get_class },
    LabValue_equal_,
    LabValue_print_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_},
  Number_lt_,
  Number_equal_,
  Number_print_ 
};

IMPL_GET_CLASS(NumberExtC)

struct NumberExtdv_s NumberExt_methods =  
{
  {0, 0, STD_FOFFSET, 0, 0,
     normal_get_address,
     &NumberExtC_get_class },
  NumberExt_create
};

bool Number_lt(Number self, LabValue v) {
  return self->hdr.methods->lt(self, v);
}

bool Number_lt_(Number self, LabValue v) {
  Number ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, Number, NumberC);
  if (ni != NULL)
     return(self->i < ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

bool Number_equal(Number self, LabValue v) {
  return self->hdr.methods->equal(self, v);
}

bool Number_equal_(Number self, LabValue v) {
  Number ni;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  ni = CAST(v, Number, NumberC);
  if (ni != NULL)
     return(self->i == ni->i);
  else
    SIGNAL_EXC(exc_type_error);
}

void Number_print(Number self, wr w) {
   self->hdr.methods->print(self, w);
}

void Number_print_(Number self, wr w) {
  int x;
  string s;
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->i, int);
  x = self->i;
  s = int_unparse(x);
  wr_putString(w, s);
}


Number NumberExt_create(NumberExt self, int x) {
  Number new_num;
  new_num = NEW(struct Number_s);
  Number_create_maker(new_num, x);
  return new_num;
}

Number Number_create_maker(Number new_num, int x) {
  init_obj_hdr((obj)new_num, NumberC);
  new_num->i = x;
  return;
}

#include "types/class_class.h"

DV Number_DH[] = {  (DV)&Number_methods };
void initNumber()
{
  NumberC->dh = Number_DH;
  NumberC->dhsize = 1;
}

DV NumberExt_DH[] = {  (DV)&NumberExt_methods };
void initNumberExt()
{
  NumberExtC->dh = NumberExt_DH;
  NumberExtC->dhsize = 1;
}
    
     
     


























