/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "types/str.h"
#include "Step_class.h"
#include "Step_meth.h"
#include "map.h"
#include "runtime/force.h"
#include "runtime/except.h"
#include "Material_meth.h"
#include "runtime/alloc.h"
#include "labbase_types.h"

/*=====================================================================*/

IMPL_GET_CLASS(StepC)

struct Stepdv_s Step_methods =
{ 
  {
    { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &StepC_get_class
    },
    LabValue_equal_,
    LabValue_lt_,
    LabValue_gt_,
    LabValue_le_,
    LabValue_ge_,
    LabValue_print_,
/*ES_BEGIN*/
	LabValue_get_type_
/*ES_END*/
  },
  Step_fetch_,
  Step_when_,
  Step_kind_,
  Step_materials_
};

IMPL_GET_CLASS(StepExtC)

struct StepExtdv_s StepExt_methods = { 

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &StepExtC_get_class},
  StepExt_create
}; 

/*=====================================================================*/

struct sm_env {
  struct closure ccl;
};

struct new_env {
  Step *self;
  bool *flag;
};

/*=====================================================================*/

dd_step_kind_entry Step_kind (Step self) {
  return self->hdr.methods->kind(self);
}

dd_step_kind_entry Step_kind_ (Step self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->kind_, dd_step_kind_entry);
  return self->kind_;
}

/*=====================================================================*/

LabValue Step_fetch (Step self, dd_step_tag_entry a) {
  return self->hdr.methods->fetch(self, a);
} 

LabValue Step_fetch_ (Step self, dd_step_tag_entry a) 
{  
/* T[a,b] => DISCOVER(a->b, bTYPE); */
/*           t = a->b;              */
/* where b is a field               */
  map m;
  FIXUPREAD(&self->hdr.inh.hdr.inh);        
  DISCOVER(self->association, map);
  m = self->association;
  return UNPV(LabValue, map_lookup(m, PV(a)));
}

/*=====================================================================*/

LabDate Step_when (Step self) {
  return self->hdr.methods->when(self);
}

LabDate Step_when_ (Step self) {
  dd_step_tag_entry t = (dd_step_tag_entry)get_hardwired_entry("when"); 
  return (LabDate)Step_fetch(self, t);            
  UNHANDLED_EXC;
}

/*=====================================================================*/

void smbody (struct sm_env *env, dd_step_tag_entry t, LabValue v) {
  Material mat;
#if LABBASE
  mat = CAST(v, Material, MaterialC);
  if (mat != NULL) 
    (env->ccl.f(env->ccl.env, mat));
#endif
}

void Step_materials (Step self, struct closure cl) {
  self->hdr.methods->materials(self, cl);              
}

void Step_materials_ (Step self, struct closure cl) {
  dd_step_tag_entry t;
  LabValue v;
  Material mat;
  map m;
  struct closure smcl;
  struct sm_env env;

  env.ccl = cl;
  smcl.f = (ifunc)smbody;
  smcl.env = &env;
  
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER (self->association, map); 
  m = self->association;
 /* map_pairs (m, smcl); */
  
} 

void new(struct new_env *env, Material mat) {
  /*map_insert (m, *env->self)*/;
  *env->flag = FALSE;
}

/*=====================================================================*/

Step StepExt_create(StepExt self, dd_step_kind_entry sk, list step_info) {
  Step new_step;
/*ES_BEGIN
  dd_step_tag_entry t;
  bool flag;
  LabValue v;
  Material mat;
  struct closure cl;
  struct new_env env;
ES_END*/
  pval key;
  pval val;
  mapExt mext;
  dd_step_tag_entry material_tag = (dd_step_tag_entry) get_hardwired_entry("material");

  new_step = NEW(struct Step_s);
  init_obj_hdr((obj)new_step, StepC);
  new_step->kind_ = sk;
  new_step->association = mapExt_new(mext);


/*ES: step_info is a list. Convert it into a map. */
  loop {
    key = PV(first(step_info));
    CATCH {               /* if empty or so.. */
      exc = EXC_NONE;
      break;
    }
    step_info = rest(step_info); /* skip the key. */

    val = PV(first(step_info));
    map_insert(new_step->association, key, val);
    step_info = rest(step_info); /* skip the value. */

    if ((dd_step_tag_entry)key == material_tag) {  /* if it has a material tag */
/*ES_BEGIN*/
  fprintf(stderr, "-----Material_tag found in stepExt_create. Entering Material_add..\n");
/*ES_END*/
      Material_add( (Material) val, new_step);     /* insert the step into material*/
    }
  }

/*ES_BEGIN : Check for "when" tag. But, IGNORE THIS FOR NOW!
  t = get_tag(string_new("when"));
  new_step->when_tag = t;
  v = Step_fetch(new_step, t);
  CATCH_EXC(exc_not_found) {
    SIGNAL_EXC (missing_tag(string_new("when")));
  }
  UNHANDLED_EXC;
  new_step->when_value = v;
ES_END*/
    
/*ES_BEGIN : Check for "who" tag. But, IGNORE THIS FOR NOW!
  t = get_tag(string_new("who"));
  new_step->who_tag = t;
  v = Step_fetch(new_step, t);
  CATCH_EXC(exc_not_found) {
    SIGNAL_EXC (missing_tag(string_new("who")));
  }
  UNHANDLED_EXC;
  new_step->who_value = v;
ES_END*/

/*ES_BEGIN : What does the following code do?
  cl.f = (ifunc) new;
  cl.env = &env;
  flag = TRUE;
  env.self = &new_step;
  env.flag = &flag;
  Step_materials(new_step, cl);
ES_END*/
  
  return new_step;
}

/*=====================================================================*/

#include "types/class_class.h"

DV Step_DH [] = {  (DV)&Step_methods };
void initStep()
{
    StepC->dh = Step_DH;
    StepC->dhsize =1;
    Step_methods.super.super.c = StepC;
}


DV StepExt_DH [] = {  (DV)&StepExt_methods };
void initStepExt()
{
    StepExtC->dh = StepExt_DH;
    StepExtC->dhsize =1;
    StepExt_methods.super.c = StepExtC;
}













