#ifndef _STEP_H
#define _STEP_H

#include "basic_def.h"
#include "LabValue.h"
#include "LabDate.h"
#include "Step_def.h"
#include "runtime/except.h"
#include "Material.h"
#include "dd_step_kind_entry.h"

#ifdef __cplusplus
extern "C" {
#endif

extern dd_step_kind_entry Step_kind(Step self);           
extern LabValue Step_fetch(Step self, dd_step_tag_entry a); 
        /* signals not_found */
extern LabDate Step_when(Step self);         
extern void Step_materials(Step self, struct closure cl);

extern Step StepExt_create(StepExt self, dd_step_kind_entry kind, list step_info);

extern void initStep ();
extern void initStepExt ();

/* The following routines require a non-surrogate 
   and should be used only by subclasses */

extern dd_step_kind_entry Step_kind_(Step self);
extern LabValue  Step_fetch_(Step self, dd_step_tag_entry a); 
       /* signals not_found */
extern LabDate Step_when_(Step self);
extern void Step_materials_(Step self, struct closure cl);

#ifdef __cplusplus
}
#endif

#endif /* _Step_H */
