/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "basic_def.h"
#include "dd.h"
#include "types/str.h"
#include "types/stdlist.h"
#include "../boot/wellknown.h"

dd_entry get_hardwired_entry(char *name)
{
/*ES_BEGIN
  This works only with es-lb.or.
  The list of hardwired entries is the second element from the end of the list, 
  i.e. 21:st element. Persistents are stored in 22:nd element.
ES_END*/

  any root;
  static dd hardwireds;
  static dd persistents;
  dd_entry e;
  list l;
  int i;

  if (hardwireds == 0 || persistents == 0) {
    root = get_wellknown(string_new("root"));

    l = (list) root;
    for (i=1; i<=20; i++) /* This works only with es-lb.or */
      l = rest(l);        /* It is the 21:st element from the root object. */

    hardwireds = (dd) first(l);
    persistents = (dd) first(rest(l));
  }

  e = dd_lookup(hardwireds, string_new(name));
  CATCH {
    exc = EXC_NONE;
    e = dd_lookup(persistents, string_new(name));
    RESIGNAL_ANY_EXC;
  }

/*ES_BEGIN*/
  fprintf(stderr, "-----B: Searching(%s), Found(%s)\n", name, 
	  string_charp(dd_entry_identifier(e)));
/*ES_END*/

  return e;
}
