/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd_class.h"
#include "dd_entry_class.h"
#include "dd_tag_entry.h"
#include "map.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(ddC)


struct dddv_s dd_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &ddC_get_class},
  dd_lookup_,
  dd_add_,
  dd_empty_,
  dd_lookup_tag_
};


IMPL_GET_CLASS(ddExtC)

struct ddExtdv_s ddExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &ddExtC_get_class},
  ddExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

/*========================================================================*/

dd_entry dd_lookup (dd self, string identifier) {
   return self->hdr.methods->lookup(self, identifier);
}

dd_entry dd_lookup_(dd self, string identifier) {
   dd_entry ret;
   map m;
/*ES_BEGIN*/
  fprintf(stderr, "*****dd_lookup_: identifier(%s)\n", string_charp(identifier));
/*ES_END*/
   FIXUPREAD(&self->hdr.inh);
   DISCOVER (self->identifier_map, map);
   m = self->identifier_map;
   ret = UNPV(dd_entry, map_lookup(m, PV(identifier)));
   RESIGNAL_ANY_EXC;
/*ES_BEGIN*/
  if (!ret)
    fprintf(stderr, "*****dd_lookup_:found(%s)\n",
	    string_charp(dd_entry_identifier(ret)));
/*ES_END*/
   return ret;
}

/*========================================================================*/

void dd_add(dd self, dd_entry new_entry) {
   self->hdr.methods->add(self, new_entry);
}

void dd_add_(dd self, dd_entry new_entry) {
   map m;
   string id;
   FIXUPWRITE(&self->hdr.inh);
   DISCOVER (self->identifier_map, map);
   DISCOVER (new_entry->identifier_, string);
   m = self->identifier_map;
   id = new_entry->identifier_;
   map_insert(m, PV(dd_entry_identifier(new_entry)), PV(new_entry)); 
   RESIGNAL_ANY_EXC;
}

/*========================================================================*/

bool dd_empty(dd self) {
   return self->hdr.methods->empty(self);
}

bool dd_empty_(dd self) {
   map m;
/*ES_BEGIN*/
  int sss;
/*ES_END*/
   FIXUPREAD(&self->hdr.inh);
   DISCOVER (self->identifier_map, map);
/*ES_BEGIN*/
  fprintf(stderr, "---dd_empty_\n");
/*ES_END*/
   m = self->identifier_map;
/*ES_BEGIN*/
  sss = map_size(m);
  fprintf(stderr, "---map_size(%d)\n", sss);
/*ES_END*/

   return (map_size(m) == 0);
}

/*========================================================================*/

dd_tag_entry dd_lookup_tag(dd self, string tag_identifier) {
   return self->hdr.methods->lookup_tag(self, tag_identifier);
}

dd_tag_entry dd_lookup_tag_(dd self, string tag_identifier) {
   map m;
   dd_entry e;
   dd_tag_entry te;
/*ES_BEGIN*/
  fprintf(stderr, "*****dd_lookup_tag_: tag_id(%s)\n", string_charp(tag_identifier));
/*ES_END*/
   FIXUPREAD(&self->hdr.inh);
   DISCOVER (self->identifier_map, map);
   m = self->identifier_map;
   e = UNPV(dd_entry,  map_lookup(m, PV(tag_identifier)));
   if (exc != &exc_not_found) {
/*ES_BEGIN*/
  fprintf(stderr, "*****dd_lookup_tag_: tag found.\n");
/*ES_END*/
     te = CAST(e, dd_tag_entry, dd_tag_entryC);
     if (te != NULL)
       return te;
     else 
       SIGNAL_EXC(exc_not_a_tag);
   }
/*ES_BEGIN*/
  fprintf(stderr, "*****dd_lookup_tag_: tag not found.\n");
/*ES_END*/
   RESIGNAL_ANY_EXC;
}

/*========================================================================*/

dd ddExt_create(ddExt self) {
   dd new_dd;
   new_dd = NEW(struct dd_s);
   dd_create_maker(new_dd);
   return new_dd;
}

void dd_create_maker(dd new_dd) {
   mapExt self;
   init_obj_hdr((obj)new_dd, ddC);
   new_dd->identifier_map = mapExt_new(self); 
   return;
}
  
/*========================================================================*/

#include "types/class_class.h"

DV dd_DH [] = {  (DV)&dd_methods };
void initdd()
{
  ddC->dh = dd_DH;
  ddC->dhsize =1;
  dd_methods.super.c = ddC;
}

DV ddExt_DH [] = {  (DV)&ddExt_methods };
void initddExt()
{
  ddExtC->dh = ddExt_DH;
  ddExtC->dhsize =1;
  ddExt_methods.super.c = ddExtC;
}











