#ifndef _DD_H
#define _DD_H

#include "common/basic.h"
#include "basic_def.h"
#include "dd_def.h"
#include "dd_tag_entry_def.h"
#include "dd_entry_def.h"

#ifdef __cplusplus
extern "C" {
#endif  

/* The order of elements in "kind" must be the same as in "DD_Entry_Kind" 
 * in thor_dd.H in the client program 
 */

enum kind { 
  TYPE_CONSTRUCTOR,
  BUILTIN, 
  DATA_DICTIONARY_KIND,
  MATERIAL_KIND,
  STEP_KIND,
  DD_TAG,
  STEP_TAG,    /* ID_TAG is registered as a STEP_TAG. */
  MATERIAL_TAG /* Note: currently dd_material_tag_entry is not used in labbase */
};


extern dd_entry dd_lookup(dd self, string identifier);
extern void dd_add(dd self, dd_entry new_entry);
extern bool dd_empty(dd self);
extern dd_tag_entry dd_lookup_tag(dd self, string tag_identifier);

extern dd ddExt_create(ddExt self); 
extern void dd_create_maker(dd new_dd); 

extern void initdd();
extern void initddExt();

extern dd_entry dd_lookup_(dd self, string identifier);
extern void dd_add_(dd self, dd_entry new_entry);
extern bool dd_empty_(dd self);
extern dd_tag_entry dd_lookup_tag_(dd self, string tag_identifier);

#ifdef __cplusplus
}
#endif

#endif /* _DD_H */
