/*ES_BEGIN*/
#include <stdio.h>  
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_entry.h"
#include "dd_entry_with_update_meth.h"
#include "map.h"
#include "types/str.h"
#include "dd_builtin_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_builtin_entryC)

struct dd_builtin_entrydv_s dd_builtin_entry_methods = 
{ 
  { 
    { 
      { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_builtin_entryC_get_class
      },
      entry_kind_,
      dd_entry_identifier_
    }
  },
  dd_builtin_entry_lookup_insert_,
  dd_builtin_entry_lookup_delete_,
  dd_builtin_entry_lookup_,
  dd_builtin_entry_add_
};

IMPL_GET_CLASS(dd_builtin_entryExtC)

struct dd_builtin_entryExtdv_s dd_builtin_entryExt_methods = {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_builtin_entryExtC_get_class},
  dbeExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */


function_ptr dd_builtin_entry_lookup_insert(dd_builtin_entry self) {
  return self->hdr.methods->lookup_insert(self);
}

function_ptr dd_builtin_entry_lookup_insert_(dd_builtin_entry self) {
/*ES_BEGIN*/
  fprintf(stderr, ">>>>>dd_builtin_entry_lookup_insert_\n");
/*ES_END*/
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->insert_, function_ptr);
  return self->insert_;
}

function_ptr dd_builtin_entry_lookup_delete(dd_builtin_entry self) {
  return self->hdr.methods->lookup_delete(self);
}

function_ptr dd_builtin_entry_lookup_delete_(dd_builtin_entry self) {
/*ES_BEGIN*/
  fprintf(stderr, ">>>>>Inside dd_builtin_entry_lookup_delete_\n");
/*ES_END*/
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->delete_, function_ptr);
  return self->delete_;
}

lb_builtin_fn dd_builtin_entry_lookup(dd_builtin_entry self, adornment a) {
  return self->hdr.methods->lookup(self, a);
}

lb_builtin_fn dd_builtin_entry_lookup_(dd_builtin_entry self, adornment a) {
  lb_builtin_fn ret;
  map m;
/*ES_BEGIN*/
  fprintf(stderr, ">>>>>Inside dd_builtin_entry_lookup_\n");
/*ES_END*/
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->adorn_map, map);
  m = self->adorn_map;
  ret = UNPV(lb_builtin_fn, map_lookup(m, PV(a)));
  CATCH_EXC(exc_not_found) {
    ret = UNPV(lb_builtin_fn, map_lookup(m, PV(string_new("*"))));
  }  
  RESIGNAL_ANY_EXC;
  return ret;
}

void dd_builtin_entry_add (dd_builtin_entry self, adornment a, lb_builtin_fn i) {
  self->hdr.methods->add(self, a, i); 
}

void dd_builtin_entry_add_(dd_builtin_entry self, adornment a, lb_builtin_fn i) {
  map m;
/*ES_BEGIN*/
  fprintf(stderr, ">>>>>dd_builtin_entry_add_\n");
/*ES_END*/
  FIXUPWRITE(&self->hdr.inh.hdr.inh);
  DISCOVER (self->adorn_map, map);
  m = self->adorn_map;
  map_insert(m, PV(a), PV(i));
  RESIGNAL_ANY_EXC;
}

dd_builtin_entry dbeExt_create(dd_builtin_entryExt self, function_ptr insert,
                               function_ptr delete, string id_, dd dict) {
  dd_builtin_entry new_dbe;
  new_dbe = NEW(struct dd_builtin_entry_s);
  init_obj_hdr((obj)new_dbe, dd_builtin_entryC);
  dbe_create_maker(new_dbe, insert, delete, id_, dict);
  return new_dbe;
}

void dbe_create_maker(dd_builtin_entry self, function_ptr insert, 
                       function_ptr delete,  string id_, dd dict) {
  mapExt m;
  self->adorn_map = mapExt_new(m);
  self->insert_ = insert;
  self->delete_ = delete; 
  dd_entry_new_maker(&self->hdr.inh, id_, BUILTIN, dict);
  return;
}

#include "types/class_class.h"

DV dd_builtin_entry_DH [] = {  (DV)&dd_builtin_entry_methods };
void initdd_builtin_entry()
{
  dd_builtin_entryC->dh = dd_builtin_entry_DH;
  dd_builtin_entryC->dhsize =1;
  dd_builtin_entry_methods.super.super.super.c = dd_builtin_entryC;
}

DV dd_builtin_entryExt_DH [] = {  (DV)&dd_builtin_entryExt_methods };
void initdd_builtin_entryExt()
{
  dd_builtin_entryExtC->dh = dd_builtin_entryExt_DH;
  dd_builtin_entryExtC->dhsize =1;
  dd_builtin_entryExt_methods.super.c = dd_builtin_entryExtC;
}







