#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_entry_with_update_def.h"
#include "dd_data_dictionary_kind_entry_class.h"
#include "type_descriptor_def.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_data_dictionary_kind_entryC)

struct dd_data_dictionary_kind_entrydv_s dd_data_dictionary_kind_entry_methods = 
{
  {
    { 
      { 0, 0, STD_FOFFSET, 0, 0,
	 normal_get_address,
	 &dd_data_dictionary_kind_entryC_get_class
      },
      entry_kind_,
      dd_entry_identifier_
    }
  },
  dd_data_dictionary_kind_entry_lookup_insert_,
  dd_data_dictionary_kind_entry_lookup_delete_,
  dd_data_dictionary_kind_entry_name_
};

IMPL_GET_CLASS(dd_data_dictionary_kind_entryExtC)

struct dd_data_dictionary_kind_entryExtdv_s dd_data_dictionary_kind_entryExt_methods = {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_data_dictionary_kind_entryExtC_get_class},
  ddkeExt_create
};


/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

function_ptr dd_data_dictionary_kind_entry_lookup_insert(dd_data_dictionary_kind_entry self) {
  return self->hdr.methods->lookup_insert(self);
}

function_ptr dd_data_dictionary_kind_entry_lookup_insert_(dd_data_dictionary_kind_entry self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->insert_, function_ptr);
  return self->insert_;
}

function_ptr dd_data_dictionary_kind_entry_lookup_delete(dd_data_dictionary_kind_entry self) {
  return self->hdr.methods->lookup_delete(self);
}

function_ptr dd_data_dictionary_kind_entry_lookup_delete_(dd_data_dictionary_kind_entry self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->delete_, function_ptr);
  return self->delete_;
}

string dd_data_dictionary_kind_entry_name(dd_data_dictionary_kind_entry self) {
  return self->hdr.methods->name(self);
}

string dd_data_dictionary_kind_entry_name_(dd_data_dictionary_kind_entry self) {
  FIXUPREAD(&self->hdr.inh.hdr.inh);
  DISCOVER(self->kind_name_, function_ptr);
  return self->kind_name_;
}

dd_data_dictionary_kind_entry ddkeExt_create(dd_data_dictionary_kind_entryExt self, 
					     string kind_name, function_ptr insert, 
					     function_ptr delete, string id_, dd dict) {
   dd_data_dictionary_kind_entry new_ddke;
   new_ddke = NEW(struct dd_data_dictionary_kind_entry_s);
   init_obj_hdr((obj)new_ddke, dd_data_dictionary_kind_entryC);
   ddke_create_maker(new_ddke, kind_name, insert, delete, id_, dict);
   return new_ddke;
}

void ddke_create_maker(dd_data_dictionary_kind_entry self, string kind_name,
                         function_ptr insert, function_ptr delete, 
                         string id_, dd dict) {
   self->kind_name_ = kind_name;
   self->insert_ = insert;
   self->delete_ = delete;
   dd_entry_new_maker(&self->hdr.inh, id_, DATA_DICTIONARY_KIND, dict);
   return;
}

#include "types/class_class.h"

DV dd_data_dictionary_kind_entry_DH [] = {  (DV)&dd_data_dictionary_kind_entry_methods };
void initdd_data_dictionary_kind_entry()
{
  dd_data_dictionary_kind_entryC->dh = dd_data_dictionary_kind_entry_DH;
  dd_data_dictionary_kind_entryC->dhsize =1;
  dd_data_dictionary_kind_entry_methods.super.super.super.c = 
    dd_data_dictionary_kind_entryC;
}

DV dd_data_dictionary_kind_entryExt_DH [] = {  (DV)&dd_data_dictionary_kind_entryExt_methods };
void initdd_data_dictionary_kind_entryExt()
{
  dd_data_dictionary_kind_entryExtC->dh = dd_data_dictionary_kind_entryExt_DH;
  dd_data_dictionary_kind_entryExtC->dhsize =1;
  dd_data_dictionary_kind_entryExt_methods.super.c = dd_data_dictionary_kind_entryC;
}








