/*ES_BEGIN*/
#include <stdio.h>  
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd_dd_tag_entry_class.h"
#include "dd.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"

IMPL_GET_CLASS(dd_dd_tag_entryC)

struct dd_dd_tag_entrydv_s dd_dd_tag_entry_methods =
{
  {
    {
      { 0, 0, STD_FOFFSET, 0, 0,
	  normal_get_address,
	  &dd_dd_tag_entryC_get_class
      },
      entry_kind_,
      dd_entry_identifier_
    }
  },
  dd_dd_tag_entry_get_type_
};

IMPL_GET_CLASS(dd_dd_tag_entryExtC)

struct dd_dd_tag_entryExtdv_s dd_dd_tag_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_dd_tag_entryExtC_get_class},
  ddteExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

type_descriptor dd_dd_tag_entry_get_type(dd_dd_tag_entry self) {
   return self->hdr.methods->get_type(self);
}

type_descriptor dd_dd_tag_entry_get_type_(dd_dd_tag_entry self) {
/*ES_BEGIN*/
  fprintf(stderr, "*****Inside dd_dd_tag_entry_get_type_\n");
/*ES_END*/
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->get_type_, type_descriptor);
   return self->get_type_;
}

dd_dd_tag_entry ddteExt_create(dd_dd_tag_entryExt self, string dd_tag_name, 
			         type_descriptor td, string id_, dd dict) {
   dd_dd_tag_entry new_ddte;
   new_ddte = NEW(struct dd_dd_tag_entry_s);
   init_obj_hdr((obj)new_ddte, dd_dd_tag_entryC);
   ddte_create_maker(new_ddte, dd_tag_name, td, id_, dict);
   return new_ddte;
}

void ddte_create_maker(dd_dd_tag_entry self, string dd_tag_name, type_descriptor td,
                         string id_, dd dict) {
   self->get_type_ = td;
   self->dd_tag_ = dd_tag_name;
   dd_entry_new_maker(&self->hdr.inh, id_, DD_TAG, dict);
   return;
}

#include "types/class_class.h"

DV dd_dd_tag_entry_DH [] = {  (DV)&dd_dd_tag_entry_methods };
void initdd_dd_tag_entry()
{
  dd_dd_tag_entryC->dh = dd_dd_tag_entry_DH;
  dd_dd_tag_entryC->dhsize =1;
  dd_dd_tag_entry_methods.super.super.super.c = dd_dd_tag_entryC;
}

DV dd_dd_tag_entryExt_DH [] = {  (DV)&dd_dd_tag_entryExt_methods };
void initdd_dd_tag_entryExt()
{
  dd_dd_tag_entryExtC->dh = dd_dd_tag_entryExt_DH;
  dd_dd_tag_entryExtC->dhsize =1;
  dd_dd_tag_entryExt_methods.super.c = dd_dd_tag_entryExtC;
}
