#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd_class.h"
#include "dd_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_entryC)

struct dd_entrydv_s dd_entry_methods =
{
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_entryC_get_class
  },
  entry_kind_,
  dd_entry_identifier_,
};


/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

dd_entry_kind entry_kind (dd_entry self) {
   return self->hdr.methods->kind(self);
}

dd_entry_kind entry_kind_(dd_entry self) {
   FIXUPREAD(&self->hdr.inh);
   DISCOVER(self->kind_, dd_entry_kind);
   return self->kind_;
}
   
string dd_entry_identifier(dd_entry self) {
   return self->hdr.methods->identifier(self);
}

string dd_entry_identifier_(dd_entry self) {
   FIXUPREAD(&self->hdr.inh);
   DISCOVER(self->identifier_, string);
   return self->identifier_;
 }

void dd_entry_new_maker(dd_entry self, string id, dd_entry_kind k, dd dict) {
   self->identifier_ = id;
   self->kind_ = k;
   if (dict != 0) dd_add(dict, self);
}
   
#include "types/class_class.h"

DV dd_entry_DH [] = {  (DV)&dd_entry_methods };
void initdd_entry()
{
  dd_entryC->dh = dd_entry_DH;
  dd_entryC->dhsize =1;
  dd_entry_methods.super.c = dd_entryC;
}













