/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "map.h"
#include "string.h"
#include "dd_id_tag_entry_class.h"
#include "dd_step_tag_entry.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_id_tag_entryC)

struct dd_id_tag_entrydv_s dd_id_tag_entry_methods = 
{
  {
    {
      {
	{ 0, 0, STD_FOFFSET, 0, 0,
	    normal_get_address,
	    &dd_id_tag_entryC_get_class
	},
        entry_kind_,
        dd_entry_identifier_
      }
    },
    dd_step_tag_entry_get_type_,
    dd_step_tag_entry_create_only_
  },
  dd_id_tag_entry_lookup_,
  dd_id_tag_entry_add_,
  dd_id_tag_entry_first_Material_,
  dd_id_tag_entry_next_Material_
};

IMPL_GET_CLASS(dd_id_tag_entryExtC)

struct dd_id_tag_entryExtdv_s dd_id_tag_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_id_tag_entryExtC_get_class},
  diteExt_make
};

/*========================================================================*/

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

Material dd_id_tag_entry_lookup(dd_id_tag_entry self, string id) {
   return self->hdr.methods->lookup(self, id);
}

Material dd_id_tag_entry_lookup_(dd_id_tag_entry self, string id) {
   Material ret;
   map m;
   FIXUPREAD(&self->hdr.inh.hdr.inh.hdr.inh);
   DISCOVER(self->id_map, map);
   m = self->id_map;
   ret = UNPV(Material, map_lookup(m, PV(id)));
   RESIGNAL_ANY_EXC;
   return ret;
}

/*========================================================================*/

void dd_id_tag_entry_add (dd_id_tag_entry self, string id, Material mat) {
   self->hdr.methods->add(self, id, mat);
}

void dd_id_tag_entry_add_(dd_id_tag_entry self, string id, Material mat) {
   map m;
   FIXUPWRITE(&self->hdr.inh.hdr.inh.hdr.inh);
   DISCOVER (self->id_map, map);
   m = self->id_map;
   map_insert(m, PV(id), PV(mat));
   RESIGNAL_ANY_EXC;
}

/*========================================================================*/

Material dd_id_tag_entry_first_Material(dd_id_tag_entry self) {
   self->hdr.methods->first_Material(self);
}

Material dd_id_tag_entry_first_Material_(dd_id_tag_entry self) {
   Material ret;
   map m;
   FIXUPWRITE(&self->hdr.inh.hdr.inh.hdr.inh);
   DISCOVER (self->id_map, map);
   m = self->id_map;
   ret = UNPV(Material, map_first_val(m));
   RESIGNAL_ANY_EXC;
   return ret;
}

/*========================================================================*/

Material dd_id_tag_entry_next_Material(dd_id_tag_entry self) {
   self->hdr.methods->next_Material(self);
}

Material dd_id_tag_entry_next_Material_(dd_id_tag_entry self) {
   Material ret;
   map m;
   FIXUPWRITE(&self->hdr.inh.hdr.inh.hdr.inh);
   DISCOVER (self->id_map, map);
   m = self->id_map;
   ret = UNPV(Material, map_next_val(m));
   RESIGNAL_ANY_EXC;
   return ret;
}

/*========================================================================*/

dd_id_tag_entry diteExt_make(dd_id_tag_entryExt self, type_descriptor td, 
                              bool co, string id_, dd dict) {
   dd_id_tag_entry new_dite;
   new_dite = NEW(struct dd_id_tag_entry_s);
   init_obj_hdr((obj)new_dite, dd_id_tag_entryC);
/*ES_BEGIN*/
  fprintf(stderr, "***inside dd_id_tag_entryExt->make()...\n");
/*ES_END*/

   dite_make_maker(new_dite, td, co, id_, dict);
   return new_dite;
}

void dite_make_maker(dd_id_tag_entry self, type_descriptor td, bool co, 
                        string id_, dd dict) {
   mapExt m;
   self->id_map = mapExt_new(m);
   dste_create_maker(&self->hdr.inh, td, co, id_, dict);
   return;
}

/*========================================================================*/

#include "types/class_class.h"

DV dd_id_tag_entry_DH [] = {  (DV)&dd_id_tag_entry_methods };
void initdd_id_tag_entry()
{
  dd_id_tag_entryC->dh = dd_id_tag_entry_DH;
  dd_id_tag_entryC->dhsize =1;
  dd_id_tag_entry_methods.super.super.super.super.c = dd_id_tag_entryC;
}

DV dd_id_tag_entryExt_DH [] = {  (DV)&dd_id_tag_entryExt_methods };
void initdd_id_tag_entryExt()
{
  dd_id_tag_entryExtC->dh = dd_id_tag_entryExt_DH;
  dd_id_tag_entryExtC->dhsize =1;
  dd_id_tag_entryExt_methods.super.c = dd_id_tag_entryExtC;
}

/*========================================================================*/







