#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_material_kind_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_material_kind_entryC)

struct dd_material_kind_entrydv_s dd_material_kind_entry_methods =
{
  {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_material_kind_entryC_get_class
    },
    entry_kind_,
    dd_entry_identifier_
  },
  dd_material_kind_entry_primary_id_tag_
};

IMPL_GET_CLASS(dd_material_kind_entryExtC)

struct dd_material_kind_entryExtdv_s dd_material_kind_entryExt_methods = {
  {
    0, 0, STD_FOFFSET, 0, 0,
    normal_get_address,
    &dd_material_kind_entryExtC_get_class},
  dmkeExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

dd_id_tag_entry dd_material_kind_entry_primary_id_tag(dd_material_kind_entry self) {
   return self->hdr.methods->primary_id_tag(self);
}

dd_id_tag_entry dd_material_kind_entry_primary_id_tag_(dd_material_kind_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->prim_id_tag_, dd_id_tag_entry);
   return self->prim_id_tag_;
}

dd_material_kind_entry dmkeExt_create(dd_material_kind_entryExt self, 
                                      dd_id_tag_entry pidt, string id_, dd dict) {
   dd_material_kind_entry new_dmke;
   new_dmke = NEW(struct dd_material_kind_entry_s);
   init_obj_hdr((obj)new_dmke, dd_material_kind_entryC);
   dmke_create_maker(new_dmke, pidt, id_, dict);
   return new_dmke;
}

void dmke_create_maker(dd_material_kind_entry self, dd_id_tag_entry pidt, 
                         string id_, dd dict) {
   self->prim_id_tag_ = pidt;
   dd_entry_new_maker(&self->hdr.inh, id_, MATERIAL_KIND, dict);
   return;
}

#include "types/class_class.h"

DV dd_material_kind_entry_DH [] = {  (DV)&dd_material_kind_entry_methods };
void initdd_material_kind_entry()
{
  dd_material_kind_entryC->dh = dd_material_kind_entry_DH;
  dd_material_kind_entryC->dhsize =1;
  dd_material_kind_entry_methods.super.super.c = dd_material_kind_entryC;
}

DV dd_material_kind_entryExt_DH [] = {  (DV)&dd_material_kind_entryExt_methods };
void initdd_material_kind_entryExt()
{
  dd_material_kind_entryExtC->dh = dd_material_kind_entryExt_DH;
  dd_material_kind_entryExtC->dhsize =1;
  dd_material_kind_entryExt_methods.super.c = dd_material_kind_entryExtC;
}











