#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd_material_tag_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_material_tag_entryC)

struct dd_material_tag_entrydv_s dd_material_tag_entry_methods = {
  {
    {
      { 0, 0, STD_FOFFSET, 0, 0,
	  normal_get_address,
	  &dd_material_tag_entryC_get_class},
      entry_kind_,
      dd_entry_identifier_},},
  dd_material_tag_entry_get_type_,
  dd_material_tag_entry_id_material_
};

IMPL_GET_CLASS(dd_material_tag_entryExtC)

struct dd_material_tag_entryExtdv_s dd_material_tag_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_material_tag_entryExtC_get_class},
  dmteExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

type_descriptor dd_material_tag_entry_get_type(dd_material_tag_entry self) {
   return self->hdr.methods->get_type(self);
}

type_descriptor dd_material_tag_entry_get_type_(dd_material_tag_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->get_type_, type_descriptor);
   return self->get_type_;
}

bool dd_material_tag_entry_id_material(dd_material_tag_entry self) {
   return self->hdr.methods->id_material(self);
}

bool dd_material_tag_entry_id_material_(dd_material_tag_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->id_material_, bool);
   return self->id_material_;
}

dd_material_tag_entry dmteExt_create(dd_material_tag_entryExt self, 
		       type_descriptor td, bool id_mat, string id_, dd dict) {
   dd_material_tag_entry new_dmte;
   new_dmte = NEW(struct dd_material_tag_entry_s);
   init_obj_hdr((obj)new_dmte, dd_material_tag_entryC);
   dmte_create_maker(new_dmte, td, id_mat, id_, dict);
   return new_dmte;
}

void dmte_create_maker(dd_material_tag_entry self, type_descriptor td, bool id_mat, 
                         string id_, dd dict) {
   self->get_type_ = td;
   self->id_material_ = id_mat;
   dd_entry_new_maker(&self->hdr.inh, id_, MATERIAL_TAG, dict);
   return;
}

#include "types/class_class.h"

DV dd_material_tag_entry_DH [] = {  (DV)&dd_material_tag_entry_methods };
void initdd_material_tag_entry()
{
  dd_material_tag_entryC->dh = dd_material_tag_entry_DH;
  dd_material_tag_entryC->dhsize =1;
}

DV dd_material_tag_entryExt_DH [] = {  (DV)&dd_material_tag_entryExt_methods };
void initdd_material_tag_entryExt()
{
  dd_material_tag_entryExtC->dh = dd_material_tag_entry_DH;
  dd_material_tag_entryExtC->dhsize =1;
}









