#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_step_kind_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_step_kind_entryC)

struct dd_step_kind_entrydv_s dd_step_kind_entry_methods =
{
  {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_step_kind_entryC_get_class
    },
    entry_kind_,
    dd_entry_identifier_
  }
};

IMPL_GET_CLASS(dd_step_kind_entryExtC)

struct dd_step_kind_entryExtdv_s dd_step_kind_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_step_kind_entryExtC_get_class},
  dskeExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

dd_step_kind_entry dskeExt_create(dd_step_kind_entryExt self, string id_, dd dict) {
   dd_step_kind_entry new_dske;
   new_dske = NEW(struct dd_step_kind_entry_s);
   init_obj_hdr((obj)new_dske, dd_step_kind_entryC);
   dske_create_maker(new_dske, id_, dict);
   return new_dske;
}

void dske_create_maker(dd_step_kind_entry self, string id_, dd dict) {
   dd_entry_new_maker(&self->hdr.inh, id_, STEP_KIND, dict);
   return;
}

#include "types/class_class.h"

DV dd_step_kind_entry_DH [] = {  (DV)&dd_step_kind_entry_methods };
void initdd_step_kind_entry()
{
  dd_step_kind_entryC->dh = dd_step_kind_entry_DH;
  dd_step_kind_entryC->dhsize =1;
  dd_step_kind_entry_methods.super.super.c = dd_step_kind_entryC;
}

DV dd_step_kind_entryExt_DH [] = {  (DV)&dd_step_kind_entryExt_methods };
void initdd_step_kind_entryExt()
{
  dd_step_kind_entryExtC->dh = dd_step_kind_entryExt_DH;
  dd_step_kind_entryExtC->dhsize =1;
  dd_step_kind_entryExt_methods.super.c = dd_step_kind_entryExtC;

}








