#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_step_tag_entry_class.h"
#include "type_descriptor.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_step_tag_entryC)

struct dd_step_tag_entrydv_s dd_step_tag_entry_methods =
{
  {
    {
      { 0, 0, STD_FOFFSET, 0, 0,
	  normal_get_address,
	  &dd_step_tag_entryC_get_class
      },
      entry_kind_,
      dd_entry_identifier_
    }
  }, 
  dd_step_tag_entry_get_type_,
  dd_step_tag_entry_create_only_
};


IMPL_GET_CLASS(dd_step_tag_entryExtC)

struct dd_step_tag_entryExtdv_s dd_step_tag_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_step_tag_entryExtC_get_class},
  dsteExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

type_descriptor dd_step_tag_entry_get_type(dd_step_tag_entry self) {
   return self->hdr.methods->get_type(self);
}

type_descriptor dd_step_tag_entry_get_type_(dd_step_tag_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->get_type_, type_descriptor);
   return self->get_type_;
}

bool dd_step_tag_entry_create_only(dd_step_tag_entry self) {
   return self->hdr.methods->create_only(self);
}

bool dd_step_tag_entry_create_only_(dd_step_tag_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->create_only_, bool);
   return self->create_only_;
}

dd_step_tag_entry dsteExt_create(dd_step_tag_entryExt self, type_descriptor td,
				  bool co, string id_, dd dict) {
   dd_step_tag_entry new_dste;
   new_dste = NEW(struct dd_step_tag_entry_s);
   init_obj_hdr((obj)new_dste, dd_step_tag_entryC);
   dste_create_maker(new_dste, td, co, id_, dict);
   return new_dste;
}

void dste_create_maker(dd_step_tag_entry self, type_descriptor td, bool co, 
                         string id_, dd dict) {
   self->get_type_ = td;
   self->create_only_ = co;
   dd_entry_new_maker(&self->hdr.inh, id_, STEP_TAG, dict);
   return;
}

#include "types/class_class.h"

DV dd_step_tag_entry_DH [] = {  (DV)&dd_step_tag_entry_methods };
void initdd_step_tag_entry()
{
  dd_step_tag_entryC->dh = dd_step_tag_entry_DH;
  dd_step_tag_entryC->dhsize =1;
  dd_step_tag_entry_methods.super.super.super.c = dd_step_tag_entryC;
}

DV dd_step_tag_entryExt_DH [] = {  (DV)&dd_step_tag_entryExt_methods };
void initdd_step_tag_entryExt()
{
  dd_step_tag_entryExtC->dh = dd_step_tag_entryExt_DH;
  dd_step_tag_entryExtC->dhsize =1;
  dd_step_tag_entryExt_methods.super.c = dd_step_tag_entryExtC;
}




