/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "dd.h"
#include "dd_type_constructor_entry_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(dd_type_constructor_entryC)

struct dd_type_constructor_entrydv_s dd_type_constructor_entry_methods =
{
  {
    { 0, 0, STD_FOFFSET, 0, 0,
	normal_get_address,
	&dd_type_constructor_entryC_get_class
    },
    entry_kind_,
    dd_entry_identifier_
  },
  dd_type_constructor_entry_has_args_,
  dd_type_constructor_entry_constructor_
};

IMPL_GET_CLASS(dd_type_constructor_entryExtC)

struct dd_type_constructor_entryExtdv_s dd_type_constructor_entryExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &dd_type_constructor_entryExtC_get_class},
  dtceExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */


bool dd_type_constructor_entry_has_args(dd_type_constructor_entry self) {
   return self->hdr.methods->has_args(self);
}

bool dd_type_constructor_entry_has_args_(dd_type_constructor_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->has_args_, bool);
   return self->has_args_;
}

tv_type_id dd_type_constructor_entry_constructor(dd_type_constructor_entry self) {
   return self->hdr.methods->constructor(self);
}

tv_type_id dd_type_constructor_entry_constructor_(dd_type_constructor_entry self) {
   FIXUPREAD(&self->hdr.inh.hdr.inh);
   DISCOVER(self->constructor_, tv_type_id);
/*ES_BEGIN*/
  fprintf(stderr, "*****Inside dd_type_cons-entry_constructor_\n");
/*ES_END*/
   return self->constructor_;
}

dd_type_constructor_entry dtceExt_create(dd_type_constructor_entryExt self, bool has_args, 
					 tv_type_id constructor, string id_, dd dict) {
   dd_type_constructor_entry new_dtce;
   new_dtce = NEW(struct dd_type_constructor_entry_s);
   init_obj_hdr((obj)new_dtce, dd_type_constructor_entryC);
   dtce_create_maker(new_dtce, has_args, constructor, id_, dict);
   return new_dtce;
}

void dtce_create_maker(dd_type_constructor_entry self, 
                       bool has_args, tv_type_id constructor,
                         string id_, dd dict) {
   self->has_args_ = has_args;
   self->constructor_ = constructor;
   dd_entry_new_maker(&self->hdr.inh, id_, TYPE_CONSTRUCTOR, dict);
   return;
}

#include "types/class_class.h"

DV dd_type_constructor_entry_DH [] = {  (DV)&dd_type_constructor_entry_methods };
void initdd_type_constructor_entry()
{
  dd_type_constructor_entryC->dh = dd_type_constructor_entry_DH;
  dd_type_constructor_entryC->dhsize =1;
  dd_type_constructor_entry_methods.super.super.c = dd_type_constructor_entryC;
}

DV dd_type_constructor_entryExt_DH [] = {  (DV)&dd_type_constructor_entryExt_methods };
void initdd_type_constructor_entryExt()
{
  dd_type_constructor_entryExtC->dh = dd_type_constructor_entryExt_DH;
  dd_type_constructor_entryExtC->dhsize =1;
  dd_type_constructor_entryExt_methods.super.c = dd_type_constructor_entryExtC;
}










