#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "lb_builtin_fn_class.h"
#include "lb_builtin_fn.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"


IMPL_GET_CLASS(lb_builtin_fnC)


struct lb_builtin_fndv_s lb_builtin_fn_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &lb_builtin_fnC_get_class},
  lb_builtin_fn_first_function_,
  lb_builtin_fn_next_function_
};


IMPL_GET_CLASS(lb_builtin_fnExtC)

struct lb_builtin_fnExtdv_s lb_builtin_fnExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &lb_builtin_fnExtC_get_class},
  lb_builtin_fnExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

int lb_builtin_fn_first_function(lb_builtin_fn self)
{
  return self->hdr.methods->first_function(self);
}

int lb_builtin_fn_first_function_(lb_builtin_fn self)
{
  FIXUPREAD(&self->hdr.inh);
  DISCOVER (self->first_, int);
  return self->first_;
}

int lb_builtin_fn_next_function(lb_builtin_fn self)
{
  return self->hdr.methods->next_function(self);
}

int lb_builtin_fn_next_function_(lb_builtin_fn self)
{
  FIXUPREAD(&self->hdr.inh);
  DISCOVER (self->next_, int);
  return self->next_;
}

lb_builtin_fn lb_builtin_fnExt_create(lb_builtin_fnExt self, int f, int n)
{
  lb_builtin_fn new_lb_builtin_fn;
  new_lb_builtin_fn = NEW(struct lb_builtin_fn_s);
  lb_builtin_fn_create_maker(new_lb_builtin_fn, f, n);
  return new_lb_builtin_fn;
 }

void lb_builtin_fn_create_maker(lb_builtin_fn new_lb_builtin_fn, int f, int n)
{
  init_obj_hdr((obj)new_lb_builtin_fn, lb_builtin_fnC);
  new_lb_builtin_fn->first_ = f;
  new_lb_builtin_fn->next_ = n;
  return;
}

#include "types/class_class.h"

DV lb_builtin_fn_DH [] = {  (DV)&lb_builtin_fn_methods };
void initlb_builtin_fn()
{
  lb_builtin_fnC->dh = lb_builtin_fn_DH;
  lb_builtin_fnC->dhsize =1;
}

DV lb_builtin_fnExt_DH [] = {  (DV)&lb_builtin_fnExt_methods };
void initlb_builtin_fnExt()
{
  lb_builtin_fnExtC->dh = lb_builtin_fnExt_DH;
  lb_builtin_fnExtC->dhsize =1;
}











