/*ES_BEGIN*/
#include <stdio.h>
/*ES_END*/
#include "stdlib.h"
#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
#include "types/str.h"
#include "runtime/except.h"
#include "runtime/alloc.h"
#include "map_class.h"


struct entry_s {
  union {
    struct core_s inh;
    struct dv_s *methods;
  } hdr;
  pval key;
  pval val;
  entry next;
};

struct dv_s entry_methods = {
  0, 0, STD_FOFFSET, 0, 0,
  normal_get_address, 0
};

#define ENTRY_SLOTS 3
#define ENTRY_BITFIELD 0x7

struct mapdv_s map_methods_string = { 
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      normal_get_class
  },
  map_lookup_,
  map_insert_,
  map_contains_,
  map_pairs_,
  map_size_, 
  map_first_val_,
  map_next_val_,
  (bool (*)(pval, pval))string_equal
};

struct mapExtdv_s mapExt_methods = {
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      normal_get_class
   },
  mapExt_new
};

/*========================================================================*/

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */


pval map_lookup(map self, pval key) {
  return self->hdr.methods->lookup(self, key);
}

pval map_lookup_(map self, pval key) {
  entry e;
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->first, entry)
  e  = self->first;
  while (e) {
/*ES_BEGIN : dd_step_tag_entry can also be a key
    assert(get_obj_class(e->key) == String);
ES_END*/
    if (self->hdr.methods->k_equal(e->key, key)) 
      return e->val;
    e = e->next;
  }
  SIGNAL_EXC(exc_not_found);
}

/*========================================================================*/

bool map_contains(map self, pval key) {
  return self->hdr.methods->contains(self, key);
}

bool map_contains_(map self, pval key) {
  entry e;
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->first, entry);
  e = self->first;
  while (e) {
    if (self->hdr.methods->k_equal(e->key, key)) 
      return TRUE;
    e = e->next;
  }
  return FALSE;
}

/*========================================================================*/

void map_insert(map self, pval key, pval val) {
  self->hdr.methods->insert(self, key, val);
}

void map_insert_(map self, pval key, pval val) {
  if (!map_contains(self, key)) {
    entry new_entry;
    new_entry  = NEW(struct entry_s);
    init_obj_hdr_prim ((core)new_entry, ENTRY_SLOTS, ENTRY_BITFIELD, (DV)&entry_methods);
    new_entry->key = key;
    new_entry->val = val;
    new_entry->next = self->first;
    self->first = new_entry;
  } else {
     SIGNAL_EXC(exc_duplicate);
    }
}

/*========================================================================*/

void map_pairs(map self, struct closure cl) {
  self->hdr.methods->pairs(self, cl);
}

void map_pairs_(map self, struct closure cl) {
/* to be implemented */
}

/*========================================================================*/

int map_size(map self) {
/*ES_BEGIN*/
  fprintf(stderr, "---map_size()\n");
/*ES_END*/

  return self->hdr.methods->size(self);
}

int map_size_(map self) {
  int s = 0;
  entry e;
/*ES_BEGIN*/
  fprintf(stderr, "---map_size_:just got inside\n");
/*ES_END*/
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->first, entry);
/*ES_BEGIN*/
  fprintf(stderr, "---map_size_:after DISCOVER\n");
/*ES_END*/
  e = self->first;
  while (e) {
    s++;
    e = e->next;
  }
/*ES_BEGIN*/
  fprintf(stderr, "---map_size_:returning size(%d)\n", s);
/*ES_END*/
  return s;
}

/*========================================================================*/

pval map_first_val(map self) {
  return self->hdr.methods->first_val(self);
}

pval map_first_val_(map self)
{
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->first, entry);
  DISCOVER(self->cursor_, entry);
  self->cursor_ = self->first;
  if (self->cursor_ == 0)
    SIGNAL_EXC(exc_empty);
  else {
    self->cursor_ = self->cursor_->next;
    return self->first->val;
  }
}

/*========================================================================*/

pval map_next_val(map self) {
  return self->hdr.methods->next_val(self);
}

pval map_next_val_(map self)
{
  pval ret;
  FIXUPREAD(&self->hdr.inh);
  DISCOVER(self->cursor_, entry);
  if (self->cursor_ == 0)
    SIGNAL_EXC(exc_empty);
  else {
    ret = self->cursor_->val;
    self->cursor_ = self->cursor_->next;
    return ret;
  }
}

/*========================================================================*/

map mapExt_new(mapExt self) {
  map new_map;
  new_map = NEW(struct map_s);
  init_obj_hdr_prim ((core)new_map, MAP_SLOTS, MAP_BITFIELD, (DV)&map_methods_string);
  map_new_maker(new_map);
  return new_map;
}

void map_new_maker(map new_map) {
  new_map->first = 0;
  new_map->cursor_ = new_map->first;
}

/*========================================================================*/

#include "types/class_class.h"

DV map_DH [] = {  (DV)&map_methods_string };
void initmap()
{
#if 0
  mapC->dh = map_DH;
  mapC->dhsize =1;
#endif
}

DV mapExt_DH [] = {  (DV)&mapExt_methods };
void initmapExt()
{
#if 0
  mapExtC->dh = mapExt_DH;
  mapExtC->dhsize =1;
#endif
}

DV entry_DH [] = {  (DV)&entry_methods };
void initentry()
{
#if 0
  entryC->dh = entry_DH;
  entryC->dhsize =1;
#endif
}

/*========================================================================*/





