#include "common/basic.h"
#include "types/type.h"
#include "types/class.h"
/*ES_BEGIN
#include "types/vec.h"
ES_END*/
#include "types/vecOfAny.h"
#include "type_descriptor_class.h"
#include "runtime/except.h"
#include "runtime/force.h"
#include "runtime/alloc.h"
#include "labbase_types.h"

IMPL_GET_CLASS(type_descriptorC)

struct type_descriptordv_s type_descriptor_methods =
{
  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &type_descriptorC_get_class
  },
  type_descriptor_constructor_,
  type_descriptor_arg_number_,
  type_descriptor_ith_arg_
};

IMPL_GET_CLASS(type_descriptorExtC)

struct type_descriptorExtdv_s type_descriptorExt_methods = {

  { 0, 0, STD_FOFFSET, 0, 0,
      normal_get_address,
      &type_descriptorExtC_get_class},
  tdExt_create
};

/* The methods and their implementations.  Method foo is actually implemented
   by routine foo_, which requires self to be a non-surrogate */

dd_type_constructor_entry type_descriptor_constructor(type_descriptor self) {
   return self->hdr.methods->constructor(self);
}   

dd_type_constructor_entry type_descriptor_constructor_(type_descriptor self) {
   FIXUPREAD(&self->hdr.inh);
   DISCOVER(self->constructor_, dd_type_constructor_entry);
   return self->constructor_;
}

int type_descriptor_arg_number(type_descriptor self) {
   return self->hdr.methods->arg_number(self);
}

int type_descriptor_arg_number_(type_descriptor self) {
   vecOfAny aa;
   FIXUPREAD(&self->hdr.inh);
   DISCOVER(self->arg_vec_, vecOfAny);
   aa = self->arg_vec_;
   return vecOfAny_length(aa);   
}

type_descriptor type_descriptor_ith_arg(type_descriptor self, int i) {
   return self->hdr.methods->ith_arg(self, i);
}

type_descriptor type_descriptor_ith_arg_(type_descriptor self, int i) {
   type_descriptor ret;
   vecOfAny aa;
   FIXUPREAD(&self->hdr.inh);
   DISCOVER(self->arg_vec_, vecOfAny);
   aa = self->arg_vec_;
   ret = UNPV(type_descriptor, vecOfAny_fetch(aa, i));
   RESIGNAL_ANY_EXC;
   return ret;   
}

type_descriptor tdExt_create(type_descriptorExt self, 
			     dd_type_constructor_entry constructor, 
			     vecOfAny arg_vec) {
   type_descriptor new_td;
   new_td = NEW(struct type_descriptor_s);
   type_descriptor_create_maker(new_td, constructor, arg_vec);
   return new_td;
}

void type_descriptor_create_maker(type_descriptor new_td, 
				  dd_type_constructor_entry constructor, 
				  vecOfAny arg_vec) {
   init_obj_hdr((obj)new_td, type_descriptorC);
   new_td->constructor_ = constructor;
   new_td->arg_vec_ = arg_vec; 
   return;
}

#include "types/class_class.h"

DV type_descriptor_DH [] = {  (DV)&type_descriptor_methods };
void inittype_descriptor()
{
  type_descriptorC->dh = type_descriptor_DH;
  type_descriptorC->dhsize =1;
  type_descriptor_methods.super.c = type_descriptorC;
}

DV type_descriptorExt_DH [] = {  (DV)&type_descriptorExt_methods };
void inittype_descriptorExt()
{
  type_descriptorExtC->dh = type_descriptorExt_DH;
  type_descriptorExtC->dhsize =1;
  type_descriptorExt_methods.super.c = type_descriptorExtC;
}






